// Names from https://en.wikipedia.org/wiki/X11_color_names
#include "core/map.h"

static Map<String, Color> _named_colors;
static void _populate_named_colors() {
	if (!_named_colors.empty()) {
		return;
	}
	_named_colors.insert("aliceblue", Color(0.94, 0.97, 1.00));
	_named_colors.insert("antiquewhite", Color(0.98, 0.92, 0.84));
	_named_colors.insert("aqua", Color(0.00, 1.00, 1.00));
	_named_colors.insert("aquamarine", Color(0.50, 1.00, 0.83));
	_named_colors.insert("azure", Color(0.94, 1.00, 1.00));
	_named_colors.insert("beige", Color(0.96, 0.96, 0.86));
	_named_colors.insert("bisque", Color(1.00, 0.89, 0.77));
	_named_colors.insert("black", Color(0.00, 0.00, 0.00));
	_named_colors.insert("blanchedalmond", Color(1.00, 0.92, 0.80));
	_named_colors.insert("blue", Color(0.00, 0.00, 1.00));
	_named_colors.insert("blueviolet", Color(0.54, 0.17, 0.89));
	_named_colors.insert("brown", Color(0.65, 0.16, 0.16));
	_named_colors.insert("burlywood", Color(0.87, 0.72, 0.53));
	_named_colors.insert("cadetblue", Color(0.37, 0.62, 0.63));
	_named_colors.insert("chartreuse", Color(0.50, 1.00, 0.00));
	_named_colors.insert("chocolate", Color(0.82, 0.41, 0.12));
	_named_colors.insert("coral", Color(1.00, 0.50, 0.31));
	_named_colors.insert("cornflower", Color(0.39, 0.58, 0.93));
	_named_colors.insert("cornsilk", Color(1.00, 0.97, 0.86));
	_named_colors.insert("crimson", Color(0.86, 0.08, 0.24));
	_named_colors.insert("cyan", Color(0.00, 1.00, 1.00));
	_named_colors.insert("darkblue", Color(0.00, 0.00, 0.55));
	_named_colors.insert("darkcyan", Color(0.00, 0.55, 0.55));
	_named_colors.insert("darkgoldenrod", Color(0.72, 0.53, 0.04));
	_named_colors.insert("darkgray", Color(0.66, 0.66, 0.66));
	_named_colors.insert("darkgreen", Color(0.00, 0.39, 0.00));
	_named_colors.insert("darkkhaki", Color(0.74, 0.72, 0.42));
	_named_colors.insert("darkmagenta", Color(0.55, 0.00, 0.55));
	_named_colors.insert("darkolivegreen", Color(0.33, 0.42, 0.18));
	_named_colors.insert("darkorange", Color(1.00, 0.55, 0.00));
	_named_colors.insert("darkorchid", Color(0.60, 0.20, 0.80));
	_named_colors.insert("darkred", Color(0.55, 0.00, 0.00));
	_named_colors.insert("darksalmon", Color(0.91, 0.59, 0.48));
	_named_colors.insert("darkseagreen", Color(0.56, 0.74, 0.56));
	_named_colors.insert("darkslateblue", Color(0.28, 0.24, 0.55));
	_named_colors.insert("darkslategray", Color(0.18, 0.31, 0.31));
	_named_colors.insert("darkturquoise", Color(0.00, 0.81, 0.82));
	_named_colors.insert("darkviolet", Color(0.58, 0.00, 0.83));
	_named_colors.insert("deeppink", Color(1.00, 0.08, 0.58));
	_named_colors.insert("deepskyblue", Color(0.00, 0.75, 1.00));
	_named_colors.insert("dimgray", Color(0.41, 0.41, 0.41));
	_named_colors.insert("dodgerblue", Color(0.12, 0.56, 1.00));
	_named_colors.insert("firebrick", Color(0.70, 0.13, 0.13));
	_named_colors.insert("floralwhite", Color(1.00, 0.98, 0.94));
	_named_colors.insert("forestgreen", Color(0.13, 0.55, 0.13));
	_named_colors.insert("fuchsia", Color(1.00, 0.00, 1.00));
	_named_colors.insert("gainsboro", Color(0.86, 0.86, 0.86));
	_named_colors.insert("ghostwhite", Color(0.97, 0.97, 1.00));
	_named_colors.insert("gold", Color(1.00, 0.84, 0.00));
	_named_colors.insert("goldenrod", Color(0.85, 0.65, 0.13));
	_named_colors.insert("gray", Color(0.75, 0.75, 0.75));
	_named_colors.insert("webgray", Color(0.50, 0.50, 0.50));
	_named_colors.insert("green", Color(0.00, 1.00, 0.00));
	_named_colors.insert("webgreen", Color(0.00, 0.50, 0.00));
	_named_colors.insert("greenyellow", Color(0.68, 1.00, 0.18));
	_named_colors.insert("honeydew", Color(0.94, 1.00, 0.94));
	_named_colors.insert("hotpink", Color(1.00, 0.41, 0.71));
	_named_colors.insert("indianred", Color(0.80, 0.36, 0.36));
	_named_colors.insert("indigo", Color(0.29, 0.00, 0.51));
	_named_colors.insert("ivory", Color(1.00, 1.00, 0.94));
	_named_colors.insert("khaki", Color(0.94, 0.90, 0.55));
	_named_colors.insert("lavender", Color(0.90, 0.90, 0.98));
	_named_colors.insert("lavenderblush", Color(1.00, 0.94, 0.96));
	_named_colors.insert("lawngreen", Color(0.49, 0.99, 0.00));
	_named_colors.insert("lemonchiffon", Color(1.00, 0.98, 0.80));
	_named_colors.insert("lightblue", Color(0.68, 0.85, 0.90));
	_named_colors.insert("lightcoral", Color(0.94, 0.50, 0.50));
	_named_colors.insert("lightcyan", Color(0.88, 1.00, 1.00));
	_named_colors.insert("lightgoldenrod", Color(0.98, 0.98, 0.82));
	_named_colors.insert("lightgray", Color(0.83, 0.83, 0.83));
	_named_colors.insert("lightgreen", Color(0.56, 0.93, 0.56));
	_named_colors.insert("lightpink", Color(1.00, 0.71, 0.76));
	_named_colors.insert("lightsalmon", Color(1.00, 0.63, 0.48));
	_named_colors.insert("lightseagreen", Color(0.13, 0.70, 0.67));
	_named_colors.insert("lightskyblue", Color(0.53, 0.81, 0.98));
	_named_colors.insert("lightslategray", Color(0.47, 0.53, 0.60));
	_named_colors.insert("lightsteelblue", Color(0.69, 0.77, 0.87));
	_named_colors.insert("lightyellow", Color(1.00, 1.00, 0.88));
	_named_colors.insert("lime", Color(0.00, 1.00, 0.00));
	_named_colors.insert("limegreen", Color(0.20, 0.80, 0.20));
	_named_colors.insert("linen", Color(0.98, 0.94, 0.90));
	_named_colors.insert("magenta", Color(1.00, 0.00, 1.00));
	_named_colors.insert("maroon", Color(0.69, 0.19, 0.38));
	_named_colors.insert("webmaroon", Color(0.50, 0.00, 0.00));
	_named_colors.insert("mediumaquamarine", Color(0.40, 0.80, 0.67));
	_named_colors.insert("mediumblue", Color(0.00, 0.00, 0.80));
	_named_colors.insert("mediumorchid", Color(0.73, 0.33, 0.83));
	_named_colors.insert("mediumpurple", Color(0.58, 0.44, 0.86));
	_named_colors.insert("mediumseagreen", Color(0.24, 0.70, 0.44));
	_named_colors.insert("mediumslateblue", Color(0.48, 0.41, 0.93));
	_named_colors.insert("mediumspringgreen", Color(0.00, 0.98, 0.60));
	_named_colors.insert("mediumturquoise", Color(0.28, 0.82, 0.80));
	_named_colors.insert("mediumvioletred", Color(0.78, 0.08, 0.52));
	_named_colors.insert("midnightblue", Color(0.10, 0.10, 0.44));
	_named_colors.insert("mintcream", Color(0.96, 1.00, 0.98));
	_named_colors.insert("mistyrose", Color(1.00, 0.89, 0.88));
	_named_colors.insert("moccasin", Color(1.00, 0.89, 0.71));
	_named_colors.insert("navajowhite", Color(1.00, 0.87, 0.68));
	_named_colors.insert("navyblue", Color(0.00, 0.00, 0.50));
	_named_colors.insert("oldlace", Color(0.99, 0.96, 0.90));
	_named_colors.insert("olive", Color(0.50, 0.50, 0.00));
	_named_colors.insert("olivedrab", Color(0.42, 0.56, 0.14));
	_named_colors.insert("orange", Color(1.00, 0.65, 0.00));
	_named_colors.insert("orangered", Color(1.00, 0.27, 0.00));
	_named_colors.insert("orchid", Color(0.85, 0.44, 0.84));
	_named_colors.insert("palegoldenrod", Color(0.93, 0.91, 0.67));
	_named_colors.insert("palegreen", Color(0.60, 0.98, 0.60));
	_named_colors.insert("paleturquoise", Color(0.69, 0.93, 0.93));
	_named_colors.insert("palevioletred", Color(0.86, 0.44, 0.58));
	_named_colors.insert("papayawhip", Color(1.00, 0.94, 0.84));
	_named_colors.insert("peachpuff", Color(1.00, 0.85, 0.73));
	_named_colors.insert("peru", Color(0.80, 0.52, 0.25));
	_named_colors.insert("pink", Color(1.00, 0.75, 0.80));
	_named_colors.insert("plum", Color(0.87, 0.63, 0.87));
	_named_colors.insert("powderblue", Color(0.69, 0.88, 0.90));
	_named_colors.insert("purple", Color(0.63, 0.13, 0.94));
	_named_colors.insert("webpurple", Color(0.50, 0.00, 0.50));
	_named_colors.insert("rebeccapurple", Color(0.40, 0.20, 0.60));
	_named_colors.insert("red", Color(1.00, 0.00, 0.00));
	_named_colors.insert("rosybrown", Color(0.74, 0.56, 0.56));
	_named_colors.insert("royalblue", Color(0.25, 0.41, 0.88));
	_named_colors.insert("saddlebrown", Color(0.55, 0.27, 0.07));
	_named_colors.insert("salmon", Color(0.98, 0.50, 0.45));
	_named_colors.insert("sandybrown", Color(0.96, 0.64, 0.38));
	_named_colors.insert("seagreen", Color(0.18, 0.55, 0.34));
	_named_colors.insert("seashell", Color(1.00, 0.96, 0.93));
	_named_colors.insert("sienna", Color(0.63, 0.32, 0.18));
	_named_colors.insert("silver", Color(0.75, 0.75, 0.75));
	_named_colors.insert("skyblue", Color(0.53, 0.81, 0.92));
	_named_colors.insert("slateblue", Color(0.42, 0.35, 0.80));
	_named_colors.insert("slategray", Color(0.44, 0.50, 0.56));
	_named_colors.insert("snow", Color(1.00, 0.98, 0.98));
	_named_colors.insert("springgreen", Color(0.00, 1.00, 0.50));
	_named_colors.insert("steelblue", Color(0.27, 0.51, 0.71));
	_named_colors.insert("tan", Color(0.82, 0.71, 0.55));
	_named_colors.insert("teal", Color(0.00, 0.50, 0.50));
	_named_colors.insert("thistle", Color(0.85, 0.75, 0.85));
	_named_colors.insert("tomato", Color(1.00, 0.39, 0.28));
	_named_colors.insert("turquoise", Color(0.25, 0.88, 0.82));
	_named_colors.insert("transparent", Color(1.00, 1.00, 1.00, 0.00));
	_named_colors.insert("violet", Color(0.93, 0.51, 0.93));
	_named_colors.insert("wheat", Color(0.96, 0.87, 0.70));
	_named_colors.insert("white", Color(1.00, 1.00, 1.00));
	_named_colors.insert("whitesmoke", Color(0.96, 0.96, 0.96));
	_named_colors.insert("yellow", Color(1.00, 1.00, 0.00));
	_named_colors.insert("yellowgreen", Color(0.60, 0.80, 0.20));
}
