def can_build(env, platform):
    # Thirdparty dependency OpenImage Denoise includes oneDNN library
    # which only supports 64-bit architectures.
    # It's also only relevant for tools build and desktop platforms,
    # as doing lightmap generation and denoising on Android or HTML5
    # would be a bit far-fetched.
    # Note: oneDNN doesn't support ARM64, OIDN needs updating to the latest version
    supported_platform = platform in ["x11", "osx", "windows", "server"]
    supported_bits = env["bits"] == "64"
    supported_arch = env["arch"] != "arm64"
    return env["tools"] and supported_platform and supported_bits and supported_arch


def configure(env):
    pass
