/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.kaffe.java.util.AbstractMap;
import org.kaffe.java.util.AbstractMapEntry;
import org.kaffe.java.util.AbstractMapEntrySet;
import org.kaffe.java.util.ConcurrentModificationException;
import org.kaffe.java.util.Iterator;
import org.kaffe.java.util.Map;
import org.kaffe.java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    float loadFactor;
    Entry[] table;
    private int modCount;
    private int size;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0 || f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.table = new Entry[n];
        this.loadFactor = f;
    }

    public HashMap(Map map) {
        int n = map.size() * 2;
        if (n < 11) {
            n = 11;
        }
        this.table = new Entry[n];
        this.loadFactor = 0.75f;
        this.putAll(map);
    }

    private static final int bucket(Object object, int n) {
        int n2;
        int n3 = n2 = object == null ? 0 : object.hashCode();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    public void clear() {
        this.table = new Entry[11];
        ++this.modCount;
        this.size = 0;
    }

    public Object clone() {
        HashMap hashMap = (HashMap)super.clone();
        hashMap.table = new Entry[this.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry;
            Entry entry2 = this.table[i];
            if (entry2 == null) continue;
            hashMap.table[i] = entry = new Entry(entry2.key, entry2.value);
            Entry entry3 = entry2.next;
            while (entry3 != null) {
                entry.next = new Entry(entry3.key, entry3.value);
                entry = entry.next;
                entry3 = entry3.next;
            }
        }
        return hashMap;
    }

    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (object == null ? entry.value == null : object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractMapEntrySet(this){

            public Iterator iterator() {
                return new EntryIterator();
            }

            protected Map.Entry find(Map.Entry entry) {
                Entry entry2 = HashMap.this.find(entry.getKey());
                return ((Object)entry).equals(entry2) ? entry2 : null;
            }
        };
    }

    private Entry find(Object object) {
        return this.find(object, HashMap.bucket(object, this.table.length));
    }

    private Entry find(Object object, int n) {
        Entry entry = this.table[n];
        while (entry != null) {
            if (object == null ? entry.key == null : object.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object get(Object object) {
        Entry entry = this.find(object);
        return entry == null ? null : entry.value;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object put(Object object, Object object2) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.find(object, n);
        if (entry != null) {
            Object object3 = entry.value;
            entry.value = object2;
            return object3;
        }
        if ((float)this.size / (float)this.table.length >= this.loadFactor) {
            this.rehash();
            n = HashMap.bucket(object, this.table.length);
        }
        entry = new Entry(object, object2);
        entry.next = this.table[n];
        this.table[n] = entry;
        ++this.modCount;
        ++this.size;
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void rehash() {
        Entry[] entryArray = new Entry[this.table.length * 2];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n = HashMap.bucket(entry.key, entryArray.length);
                entry.next = entryArray[n];
                entryArray[n] = entry;
                entry = entry2;
            }
        }
        this.table = entryArray;
    }

    public Object remove(Object object) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.table[n];
        if (entry == null) {
            return null;
        }
        if (object == null ? entry.key == null : object.equals(entry.key)) {
            Object object2 = entry.value;
            this.table[n] = entry.next;
            ++this.modCount;
            --this.size;
            return object2;
        }
        Entry entry2 = entry;
        while (entry2.next != null) {
            if (object == null ? ((Entry)entry2).next.key == null : object.equals(((Entry)entry2).next.key)) {
                Object object3 = ((Entry)entry2).next.value;
                entry2.next = entry2.next.next;
                ++this.modCount;
                --this.size;
                return object3;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    private class EntryIterator
    implements Iterator {
        private int bucket;
        private int modCount;
        private Entry next;
        private Entry prev;

        EntryIterator() {
            this.modCount = HashMap.this.modCount;
            this.bucket = -1;
            this.nextBucket();
        }

        public boolean hasNext() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        public Object next() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = this.next.next;
            if (this.next == null) {
                this.nextBucket();
            }
            return this.prev;
        }

        public void remove() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.prev.key);
            ++this.modCount;
            this.prev = null;
        }

        private void nextBucket() {
            while (++this.bucket < HashMap.this.table.length && HashMap.this.table[this.bucket] == null) {
            }
            if (this.bucket < HashMap.this.table.length) {
                this.next = HashMap.this.table[this.bucket];
            }
        }
    }

    private class Entry
    extends AbstractMapEntry {
        private Entry next = null;

        Entry(Object object, Object object2) {
            super(object, object2);
        }

        public void changeValue(Object object) {
            HashMap.this.put(this.key, object);
        }
    }
}

