/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Arc;
import geonext.Circle;
import geonext.Coordinates;
import geonext.Element;
import geonext.Geonext;
import geonext.Graph;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import geonext.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

class Slider
extends Point {
    public Element e;
    public boolean free;
    public boolean animated;
    public double position = 0.0;
    public boolean direction = false;
    public int loop = 1;
    public double start = 0.0;
    public double stop = 1.0;
    public double speed = 1.0;
    public boolean back = false;
    public boolean onPolygon = false;

    public Slider() {
        this.initSlider();
        this.setChanged(false);
    }

    public Slider(String string, int n, int n2) {
        super(string, n, n2);
        this.initSlider();
        this.setChanged(false);
    }

    public Slider(String string, int n, Element element, int n2) {
        super(string, n, n2);
        this.e = element;
        this.setParent(this.e);
        if (this.e instanceof Circle) {
            this.speed = 5.0;
        }
        if (this.e instanceof Line) {
            this.speed = 20.0;
        }
        if (this.e instanceof Graph) {
            this.speed = 0.1;
        }
        this.initSlider();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            this.setUser();
            this.user2sphere();
        }
    }

    public Vector data() {
        Vector<Element> vector = new Vector<Element>();
        vector.addElement(this.getE());
        return vector;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("slider_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        super.draw(graphics2D, jBoardPane);
    }

    public boolean exists() {
        return this.e.exists();
    }

    public Element getE() {
        return this.e;
    }

    public int getLoop() {
        return this.loop;
    }

    public double getPosition() {
        return this.position;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getStart() {
        return this.start;
    }

    public double getStop() {
        return this.stop;
    }

    public void initSlider() {
        this.stroke = new Color(255, 150, 0);
        this.lighting = Color.green;
        this.label = Color.black;
        this.typeString = "slider";
        this.setElementName(Geonext.language.getString("slider_element_name"));
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public boolean isBack() {
        return this.back;
    }

    public boolean isDirection() {
        return this.direction;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            String string4 = this.tag(string3, "x")[1];
            String string5 = this.tag(string3, "y")[1];
            String string6 = this.tag(string3, "parent")[1];
            String string7 = this.tag(string3, "position")[1];
            Element element = jBoardPane.element.searchLoadID(this.tag(string3, "parent")[1]);
            if (string6.equals("")) {
                return false;
            }
            Coordinates coordinates = new Coordinates(Double.parseDouble(string4), Double.parseDouble(string5));
            jBoardPane.cursorPosition = jBoardPane.user2screen(coordinates);
            if (element instanceof Graph) {
                jBoardPane.createGraphSlider(element, string2, false);
            } else {
                jBoardPane.createSlider(element, string2, false);
            }
            Slider slider = (Slider)jBoardPane.element.point.lastElement();
            string = slider.parseProperties(jBoardPane, string);
            if (slider.isFree()) {
                slider.setUser(coordinates);
                jBoardPane.user2screen(slider);
                slider.user2sphere();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(JBoardPane jBoardPane, String string) {
        super.parseProperties(jBoardPane, string);
        this.setAnimated(this.tag(string, "animated")[1]);
        string = this.tag(string, "animated")[0];
        this.setBack(this.tag(string, "back")[1]);
        string = this.tag(string, "back")[0];
        this.setDirection(this.tag(string, "direction")[1]);
        string = this.tag(string, "direction")[0];
        this.setFree(this.tag(string, "free")[1]);
        string = this.tag(string, "free")[0];
        this.setLoop(this.tag(string, "loop")[1]);
        string = this.tag(string, "loop")[0];
        this.setSpeed(this.tag(string, "speed")[1]);
        string = this.tag(string, "speed")[0];
        this.setStart(this.tag(string, "start")[1]);
        string = this.tag(string, "start")[0];
        this.setStop(this.tag(string, "stop")[1]);
        string = this.tag(string, "stop")[0];
        this.setOnpolygon(this.tag(string, "onpolygon")[1]);
        string = this.tag(string, "onpolygon")[0];
        return string;
    }

    public void run() {
        if (this.e instanceof Circle) {
            if (!this.isDirection()) {
                this.position += this.getSpeed() / 180.0 * Math.PI;
                if (this.position > Math.PI * 2) {
                    this.position -= Math.PI * 2;
                }
            } else {
                this.position -= this.getSpeed() / 180.0 * Math.PI;
                if (this.position < Math.PI * -2) {
                    this.position += Math.PI * 2;
                }
            }
        } else if (this.e instanceof Line) {
            Line line = (Line)this.e;
            if (!this.isDirection()) {
                this.position += 1.0 / this.getSpeed();
                if (this.position > 1.0) {
                    this.position = 0.0;
                    if (this.isOnPolygon()) {
                        Polygon polygon = (Polygon)line.getParent();
                        for (int i = 0; i < polygon.border.length; ++i) {
                            if (line != polygon.border[i]) continue;
                            this.setE(polygon.border[(i + 1) % polygon.border.length]);
                        }
                    }
                }
            } else {
                this.position -= 1.0 / this.getSpeed();
                if (this.position < 0.0) {
                    this.position = 1.0;
                    if (this.isOnPolygon()) {
                        Polygon polygon = (Polygon)line.getParent();
                        for (int i = 0; i < polygon.border.length; ++i) {
                            if (line != polygon.border[i]) continue;
                            System.out.println(polygon.border[i].name + " " + i);
                            this.setE(polygon.border[(i - 1 + polygon.border.length) % polygon.border.length]);
                        }
                    }
                }
            }
        }
        this.setChanged(true);
    }

    public void setAnimated(String string) {
        this.setAnimated(new Boolean(string));
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public void setBack(String string) {
        this.setBack(new Boolean(string));
    }

    public void setBack(boolean bl) {
        this.back = bl;
    }

    public void setDirection(String string) {
        this.setDirection(new Boolean(string));
    }

    public void setDirection(boolean bl) {
        this.direction = bl;
    }

    public void setE(Element element) {
        this.e = element;
    }

    public void setFree(String string) {
        this.setFree(new Boolean(string));
    }

    public void setFree(boolean bl) {
        this.free = bl;
    }

    public void setLoop(int n) {
        this.loop = n;
    }

    public void setLoop(String string) {
        try {
            this.setLoop(new Integer(string));
        }
        catch (Exception exception) {
            this.setLoop(-1);
        }
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public void setPosition(Coordinates coordinates) {
        if (this.e instanceof Arc) {
            Arc arc = (Arc)this.e;
            Point point = new Point();
            point.setUser(coordinates);
            this.position = arc.getRAD(arc.getM(), point);
            double d = arc.getRAD(arc.getM(), arc.getP());
            double d2 = arc.getRAD(arc.getM(), arc.getA());
            Point point2 = new Point();
            point2.setUser(arc.user2circle(arc.getA().getUser()));
            if (!arc.isFullCircle()) {
                if (d < d2) {
                    if (this.position > d2 || this.position < d) {
                        this.position = point.userDistance(arc.getP()) > point.userDistance(point2) ? d2 : d;
                    }
                } else if (this.position > d2 && this.position < d) {
                    this.position = point.userDistance(arc.getP()) > point.userDistance(point2) ? d2 : d;
                }
            }
        } else if (this.e instanceof Circle) {
            Circle circle = (Circle)this.e;
            coordinates = circle.user2circle(coordinates);
            Coordinates coordinates2 = new Coordinates(coordinates.getWidth(), circle.getM().getUserY());
            double d = (coordinates.getWidth() - circle.getM().getUserX()) / coordinates.distance(circle.getM().getUser());
            double d3 = (coordinates.getHeight() - coordinates2.getHeight()) / coordinates.distance(circle.getM().getUser());
            this.position = Math.acos(d);
            if (d3 < 0.0) {
                this.position = Math.PI * 2 - this.position;
            }
        } else if (this.e instanceof Line) {
            Line line = (Line)this.e;
            if (this.isOnPolygon()) {
                Polygon polygon = (Polygon)line.getParent();
                Line line2 = polygon.border[0];
                double d = Double.MAX_VALUE;
                for (int i = 0; i < polygon.border.length; ++i) {
                    line2 = polygon.border[i];
                    double d4 = line2.user2line(coordinates).distance(coordinates);
                    double d5 = this.linePosition(line2, line2.user2line(coordinates));
                    if (!(d4 < d) || !(d5 >= -0.2) || !(d5 <= 1.2)) continue;
                    d = d4;
                    this.setE(line2);
                    this.setAncestor();
                    this.setParent(line2);
                }
                line = (Line)this.e;
            }
            coordinates = line.user2line(coordinates);
            this.position = this.linePosition(line, coordinates);
            if (this.isOnPolygon()) {
                if (this.position < 0.0) {
                    this.position = 0.0;
                } else if (this.position > 1.0) {
                    this.position = 1.0;
                }
            }
        }
    }

    public double linePosition(Line line, Coordinates coordinates) {
        this.position = Math.abs(line.getB().getUserX() - line.getA().getUserX()) != 0.0 ? (coordinates.getWidth() - line.getA().getUserX()) / (line.getB().getUserX() - line.getA().getUserX()) : (Math.abs(line.getB().getUserY() - line.getA().getUserY()) != 0.0 ? (coordinates.getHeight() - line.getA().getUserY()) / (line.getB().getUserY() - line.getA().getUserY()) : 0.0);
        return this.position;
    }

    public void setPosition(String string) {
        try {
            this.setPosition(new Double(string));
        }
        catch (Exception exception) {
            this.setPosition(0.0);
        }
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setSpeed(String string) {
        try {
            this.setSpeed(new Double(string));
        }
        catch (Exception exception) {
            this.setSpeed(1);
        }
    }

    public void setStart(double d) {
        this.start = d;
    }

    public void setStart(String string) {
        try {
            this.setStart(new Double(string));
        }
        catch (Exception exception) {
            this.setStart(1.0);
        }
    }

    public void setStop(double d) {
        this.stop = d;
    }

    public void setStop(String string) {
        try {
            this.setStop(new Double(string));
        }
        catch (Exception exception) {
            this.setStop(2.0);
        }
    }

    public void setUser() {
        this.setUser(this.user);
    }

    public void setUser(double d, double d2) {
        this.user.setSize(d, d2);
    }

    public void setUser(Coordinates coordinates) {
        if (!this.free) {
            if (this.e instanceof Line) {
                Line line = (Line)this.e;
                Coordinates coordinates2 = line.user2line(coordinates);
                this.user = new Coordinates(line.getA().getUserX() + this.position * (line.getB().getUserX() - line.getA().getUserX()), line.getA().getUserY() + this.position * (line.getB().getUserY() - line.getA().getUserY()));
                if (!((Line)this.e).isFirst() && ((Line)this.e).getB().getUser().distance(this.user) > ((Line)this.e).getA().getUser().distance(((Line)this.e).getB().getUser()) && ((Line)this.e).getA().getUser().distance(this.user) < ((Line)this.e).getB().getUser().distance(this.user)) {
                    this.user = new Coordinates(((Line)this.e).getA().getUserX(), ((Line)this.e).getA().getUserY());
                }
                if (!((Line)this.e).isLast() && ((Line)this.e).getA().getUser().distance(this.user) > ((Line)this.e).getA().getUser().distance(((Line)this.e).getB().getUser()) && ((Line)this.e).getA().getUser().distance(this.user) > ((Line)this.e).getB().getUser().distance(this.user)) {
                    this.user = new Coordinates(((Line)this.e).getB().getUserX(), ((Line)this.e).getB().getUserY());
                }
            } else if (this.e instanceof Arc) {
                this.user = ((Arc)this.e).user2circle(new Coordinates(((Arc)this.e).getM().getUserX() + Math.cos(this.position) * 10.0, ((Arc)this.e).getM().getUserY() + Math.sin(this.position) * 10.0));
                this.setPosition(this.user);
                this.user = ((Arc)this.e).user2circle(new Coordinates(((Arc)this.e).getM().getUserX() + Math.cos(this.position) * 10.0, ((Arc)this.e).getM().getUserY() + Math.sin(this.position) * 10.0));
            } else if (this.e instanceof Circle) {
                this.user = ((Circle)this.e).user2circle(new Coordinates(((Circle)this.e).getM().getUserX() + Math.cos(this.position) * 10.0, ((Circle)this.e).getM().getUserY() + Math.sin(this.position) * 10.0));
            }
        } else {
            this.user = coordinates;
        }
    }

    public void setUserX(double d) {
        this.user.setSize(d, this.user.getHeight());
    }

    public void setUserY(double d) {
        this.user.setSize(this.user.getWidth(), d);
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = super.writeData(string);
        string2 = string2 + string + "<parent>" + this.getParent().getId() + "</parent>\n ";
        string2 = string2 + string + "<position>" + this.getPosition() + "</position>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<free>" + this.isFree() + "</free>\n";
        string2 = string2 + string + "<animate>\n";
        string2 = string2 + string + "\t<animated>" + this.isAnimated() + "</animated>\n";
        string2 = string2 + string + "\t<back>" + this.isBack() + "</back>\n";
        string2 = string2 + string + "\t<speed>" + this.getSpeed() + "</speed>\n";
        string2 = string2 + string + "\t<start>" + this.getStart() + "</start>\n";
        string2 = string2 + string + "\t<stop>" + this.getStop() + "</stop>\n";
        string2 = string2 + string + "\t<loop>" + this.getLoop() + "</loop>\n";
        string2 = string2 + string + "\t<direction>" + this.isDirection() + "</direction>\n";
        string2 = string2 + string + "</animate>\n";
        string2 = string2 + string + "<onpolygon>" + this.isOnPolygon() + "</onpolygon>\n";
        return string2;
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("slider_short"));
    }

    public boolean isOnPolygon() {
        return this.onPolygon;
    }

    public void setOnPolygon(boolean bl) {
        this.onPolygon = bl;
    }

    public void setOnpolygon(String string) {
        this.setOnPolygon(new Boolean(string));
    }

    public boolean isOnpolygon() {
        return this.isOnPolygon();
    }
}

