/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Composition;
import geonext.Element;
import geonext.Geonext;
import geonext.Graph;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import geonext.JFrameDialog;
import geonext.JListRenderer;
import geonext.JViewPanel;
import geonext.ParameterCurve;
import geonext.Polygon;
import geonext.Text;
import geonext.TraceCurve;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class JContentText
extends JContentPanel
implements ActionListener,
CaretListener,
MouseListener {
    public JBoardPane board;
    public JTextField tInput;
    public String[] tags = new String[]{"value", "arc", "overline", "arrow", "sqrt"};
    public JTextField xInput;
    public JTextField cInput;
    public JTextField jsInput;
    public JTextField yInput;
    public JButton valueButton;
    public JButton arrowButton;
    public JViewPanel view;
    public JButton overlineButton;
    public JButton braceUpButton;
    public JButton braceDownButton;
    public JButton arcButton;
    public JButton viewButton;
    public JButton sqrtButton;
    public JComboBox elementCombo;
    public javax.swing.JCheckBox conditionBox;
    public int pos;
    public Vector vec;
    public Text text;
    public JComboBox greekCombo;

    public JContentText() {
    }

    public JContentText(JBoardPane jBoardPane) {
        this.initContentText(jBoardPane);
        this.validateTree();
    }

    public JContentText(JBoardPane jBoardPane, Text text) {
        this.initContentText(jBoardPane);
        this.setText(text);
        jBoardPane.getGeonextEditDialog().dispose();
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            if (!this.tInput.getText().equals("")) {
                this.setText();
            }
            this.board.getGeonextTextDialog().dispose();
        } else if (string.equals("apply")) {
            if (!this.tInput.getText().equals("")) {
                this.setText();
                if (this.text != null) {
                    this.changeDialog(this.board.element.elements.lastElement());
                    this.board.getGeonextTextDialog().dispose();
                } else {
                    this.reset();
                }
            }
        } else if (string.equals("cancel")) {
            if (this.text != null) {
                this.changeDialog(this.text);
            }
            this.board.getGeonextTextDialog().dispose();
        } else if (string.equals("preview")) {
            this.view.setTextString(this.tInput.getText());
            this.view.repaint();
            this.tInput.requestFocus();
        } else if (string.startsWith("tag")) {
            int n = this.pos;
            this.tInput.setText(this.insertTag(this.tags[Integer.parseInt(string.substring(3))], this.tInput.getText(), this.getPos()));
            this.tInput.setCaretPosition(n + this.tags[Integer.parseInt(string.substring(3))].length() + 2);
            this.tInput.requestFocus();
        } else if (string.startsWith("brace")) {
            int n = this.pos;
            this.tInput.setText(this.tInput.getText().substring(0, this.pos) + string.substring(5) + "{}" + this.tInput.getText().substring(this.pos));
            this.tInput.setCaretPosition(n + 2);
            this.tInput.requestFocus();
        } else if (string.equals("combo")) {
            if (this.elementCombo.getSelectedIndex() == 0) {
                this.xInput.setText("" + this.board.digits(this.board.screen2userX(this.board.getWidth() / 2), 0, true));
                this.yInput.setText("" + this.board.digits(this.board.screen2userY(this.board.getHeight() / 2), 0, true));
            } else if (this.vec.get(this.elementCombo.getSelectedIndex() - 1) instanceof Text) {
                this.xInput.setText("" + this.board.digits(0.0, 0, true));
                this.yInput.setText("" + this.board.digits(this.board.screen2userY(this.board.getOrigin().getHeight() + 20.0), 0, true));
            } else {
                this.xInput.setText("" + this.board.digits(this.board.screen2userX(this.board.getOrigin().getWidth() + 20.0), 0, true));
                this.yInput.setText("" + this.board.digits(this.board.screen2userY(this.board.getOrigin().getHeight() - 20.0), 0, true));
            }
        } else if (string.startsWith("condition")) {
            this.setCInput();
        } else if (string.startsWith("greek")) {
            int n = this.pos;
            if (this.greekCombo.getSelectedIndex() > 0) {
                this.tInput.setText(this.tInput.getText().substring(0, this.pos) + "&" + JBoardPane.greek[this.greekCombo.getSelectedIndex() - 1] + ";" + this.tInput.getText().substring(this.pos));
                this.tInput.setCaretPosition(n + JBoardPane.greek[this.greekCombo.getSelectedIndex() - 1].length() + 2);
            } else {
                this.tInput.setCaretPosition(n);
            }
            this.greekCombo.setSelectedIndex(0);
            this.greekCombo.repaint();
            this.tInput.requestFocus();
            this.board.getGeonextTextDialog().pack();
            this.board.getGeonextTextDialog().setVisible(true);
            this.board.getGeonextTextDialog().show();
            this.board.getGeonextTextDialog().requestFocus();
            this.board.getGeonextTextDialog().toFront();
        }
        this.board.repaint();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.setPos(caretEvent.getDot());
    }

    public void changeDialog(Object object) {
        this.board.geonextEditDialog = new JFrameDialog("", new Dimension(600, 500), 6, this.board, object, false, false, false, true);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        this.board.geonextEditDialog.jce.setPropertiesText(vector);
        this.board.geonextEditDialog.pack();
        this.board.geonextEditDialog.setVisible(true);
        this.board.geonextEditDialog.show();
        this.board.geonextEditDialog.requestFocus();
        this.board.geonextEditDialog.show();
    }

    public Vector generateElementVector() {
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 5; i < this.board.element.elements.size(); ++i) {
            int n;
            Element element;
            if (this.board.element.elements.get(i) instanceof Composition) {
                element = (Composition)this.board.element.elements.get(i);
                for (n = 0; n < ((Composition)element).elements.size(); ++n) {
                    vector.addElement(((Composition)element).elements.get(n));
                    vector2.addElement(((Element)((Composition)element).elements.get(n)).getElementName() + " " + this.board.changeChar(((Element)((Composition)element).elements.get(n)).getName()));
                }
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Intersection) {
                element = (Intersection)this.board.element.elements.get(i);
                if (((Intersection)element).getType() == 0) {
                    vector.addElement(((Intersection)element).getA());
                    vector2.addElement(((Intersection)element).getA().getElementName() + " " + this.board.changeChar(((Intersection)element).getA().getName()));
                    continue;
                }
                vector.addElement(((Intersection)element).getA());
                vector2.addElement(((Intersection)element).getA().getElementName() + " " + this.board.changeChar(((Intersection)element).getA().getName()));
                vector.addElement(((Intersection)element).getB());
                vector2.addElement(((Intersection)element).getB().getElementName() + " " + this.board.changeChar(((Intersection)element).getB().getName()));
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Polygon) {
                element = (Polygon)this.board.element.elements.get(i);
                vector.addElement(element);
                vector2.addElement(((Polygon)element).getElementName() + this.board.changeChar(element.getName()));
                for (n = 0; n < ((Polygon)element).border.length; ++n) {
                    vector.addElement(((Polygon)element).border[n]);
                    vector2.addElement(((Polygon)element).border[n].getElementName() + " " + this.board.changeChar(((Polygon)element).border[n].getName()));
                }
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Text || this.board.element.elements.get(i) instanceof Graph || this.board.element.elements.get(i) instanceof TraceCurve || this.board.element.elements.get(i) instanceof ParameterCurve) continue;
            vector.addElement(this.board.element.elements.get(i));
            vector2.addElement(((Element)this.board.element.elements.get(i)).getElementName() + " " + this.board.changeChar(((Element)this.board.element.elements.get(i)).getName()));
        }
        Vector vector3 = new Vector();
        vector3.addElement(vector);
        vector3.addElement(vector2);
        return vector3;
    }

    public JComboBox getGreekCombo() {
        return this.greekCombo;
    }

    public int getPos() {
        return this.pos;
    }

    public Text getText() {
        return this.text;
    }

    public Vector getVec() {
        return this.vec;
    }

    public void initContentText(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        this.valueButton = new JButton(Geonext.language.getString("jcontenttext_term"));
        this.valueButton.addActionListener(this);
        this.valueButton.setActionCommand("tag0");
        this.arcButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.drawLine(this.getWidth() / 2 - 3, this.getHeight() / 2, this.getWidth() / 2 + 4, this.getHeight() / 2 - 4);
                graphics.drawLine(this.getWidth() / 2 - 3, this.getHeight() / 2, this.getWidth() / 2 + 4, this.getHeight() / 2 + 4);
                graphics.drawLine(this.getWidth() / 2 + 1, this.getHeight() / 2 - 1, this.getWidth() / 2 + 1, this.getHeight() / 2 + 1);
            }
        };
        this.arcButton.addActionListener(this);
        this.arcButton.setActionCommand("tag1");
        this.overlineButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 12));
                graphics.setColor(Color.black);
                graphics.drawLine(this.getWidth() / 2 - 7, this.getHeight() / 2 - 7, this.getWidth() / 2 + 8, this.getHeight() / 2 - 7);
                graphics.setColor(Color.gray);
                graphics.drawString("AB", this.getWidth() / 2 - 6, this.getHeight() / 2 + 5);
            }
        };
        this.overlineButton.addActionListener(this);
        this.overlineButton.setActionCommand("tag2");
        this.arrowButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 12));
                graphics.setColor(Color.black);
                graphics.drawLine(this.getWidth() / 2 - 3, this.getHeight() / 2 - 7, this.getWidth() / 2 + 4, this.getHeight() / 2 - 7);
                graphics.drawLine(this.getWidth() / 2 + 4, this.getHeight() / 2 - 7, this.getWidth() / 2 + 2, this.getHeight() / 2 - 9);
                graphics.drawLine(this.getWidth() / 2 + 4, this.getHeight() / 2 - 7, this.getWidth() / 2 + 2, this.getHeight() / 2 - 5);
                graphics.setColor(Color.gray);
                graphics.drawString("a", this.getWidth() / 2 - 3, this.getHeight() / 2 + 5);
            }
        };
        this.arrowButton.addActionListener(this);
        this.arrowButton.setActionCommand("tag3");
        this.sqrtButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setColor(Color.black);
                graphics.drawLine(this.getWidth() / 2 - 8, this.getHeight() / 2 + 1, this.getWidth() / 2 - 7, this.getHeight() / 2 + 1);
                graphics.drawLine(this.getWidth() / 2 - 7, this.getHeight() / 2 + 1, this.getWidth() / 2 - 4, this.getHeight() / 2 + 4);
                graphics.drawLine(this.getWidth() / 2 - 4, this.getHeight() / 2 + 4, this.getWidth() / 2 - 4, this.getHeight() / 2 - 7);
                graphics.drawLine(this.getWidth() / 2 - 4, this.getHeight() / 2 - 7, this.getWidth() / 2 + 5, this.getHeight() / 2 - 7);
                graphics.setColor(Color.gray);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 12));
                graphics.drawString("x", this.getWidth() / 2 - 1, this.getHeight() / 2 + 5);
            }
        };
        this.sqrtButton.addActionListener(this);
        this.sqrtButton.setActionCommand("tag4");
        this.braceUpButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 10));
                graphics.setColor(Color.black);
                graphics.drawString("2", this.getWidth() / 2 + 3, this.getHeight() / 2);
                graphics.setColor(Color.gray);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 12));
                graphics.drawString("x", this.getWidth() / 2 - 3, this.getHeight() / 2 + 5);
            }
        };
        this.braceUpButton.addActionListener(this);
        this.braceUpButton.setActionCommand("brace^");
        this.braceDownButton = new JButton(" "){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 10));
                graphics.setColor(Color.black);
                graphics.drawString("2", this.getWidth() / 2 + 3, this.getHeight() / 2 + 9);
                graphics.setColor(Color.gray);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, 12));
                graphics.drawString("x", this.getWidth() / 2 - 3, this.getHeight() / 2 + 5);
            }
        };
        this.braceDownButton.addActionListener(this);
        this.braceDownButton.setActionCommand("brace_");
        Vector vector = new Vector();
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(" ");
        vector2.addElement(Color.black);
        vector.addElement(vector2);
        for (int i = 0; i < 25; ++i) {
            vector2 = new Vector();
            vector2.addElement(" " + (char)(945 + i));
            vector2.addElement(Color.black);
            vector.addElement(vector2);
        }
        this.greekCombo = new JComboBox(vector);
        this.greekCombo.setRenderer(new JListRenderer());
        this.greekCombo.setActionCommand("greek");
        this.greekCombo.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 7, 5, 5));
        jPanel.add(this.arcButton);
        jPanel.add(this.overlineButton);
        jPanel.add(this.arrowButton);
        jPanel.add(this.sqrtButton);
        jPanel.add(this.braceUpButton);
        jPanel.add(this.braceDownButton);
        jPanel.add(this.greekCombo);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add("Center", this.valueButton);
        jPanel2.add("East", jPanel);
        this.tInput = new JTextField(25);
        this.tInput.addActionListener(this);
        this.tInput.addCaretListener(this);
        this.tInput.setActionCommand("preview");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("Center", this.tInput);
        JButton jButton = new JButton(" " + Geonext.language.getString("jcontentedit_text_preview") + " ");
        jButton.setBorder(new EtchedBorder(1));
        jButton.addActionListener(this);
        jButton.setActionCommand("preview");
        jPanel3.add("East", jButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(15, 15));
        jPanel4.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel4.add("North", jPanel3);
        jPanel4.add("Center", jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontenttext_title") + " "));
        jPanel5.add("Center", jPanel4);
        this.view = new JViewPanel(this.board, "");
        this.view.addMouseListener(this);
        this.view.setLayout(new BorderLayout(15, 15));
        this.view.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentedit_text_preview") + " "));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel6.setBorder(new EmptyBorder(0, 15, 0, 0));
        jPanel6.add(new JLabel("x ="));
        jPanel6.add(new JLabel("y ="));
        this.xInput = new JTextField(25);
        this.xInput.setText("" + this.board.digits(this.board.screen2userX(this.board.getWidth() / 2), 0, true));
        this.yInput = new JTextField(25);
        this.yInput.setText("" + this.board.digits(this.board.screen2userY(this.board.getHeight() / 2), 0, true));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel7.setBorder(new EmptyBorder(0, 0, 0, 15));
        jPanel7.add(this.xInput);
        jPanel7.add(this.yInput);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(10, 10));
        jPanel8.setBorder(new EmptyBorder(15, 0, 15, 0));
        jPanel8.add("West", jPanel6);
        jPanel8.add("Center", jPanel7);
        Vector vector3 = (Vector)this.generateElementVector().get(1);
        this.vec = (Vector)this.generateElementVector().get(0);
        vector3.insertElementAt("frei", 0);
        this.elementCombo = new JComboBox(vector3);
        this.elementCombo.addActionListener(this);
        this.elementCombo.setActionCommand("combo");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(10, 10));
        jPanel9.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel9.add("North", new JLabel(Geonext.language.getString("jcontenttext_position")));
        jPanel9.add("Center", this.elementCombo);
        this.conditionBox = new JCheckBox(Geonext.language.getString("jcontenttext_condition"));
        this.conditionBox.addActionListener(this);
        this.conditionBox.setActionCommand("condition");
        this.cInput = new JTextField();
        this.cInput.addActionListener(this);
        this.cInput.setActionCommand("condition");
        this.setCInput();
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel10.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel10.add("North", this.conditionBox);
        jPanel10.add("South", this.cInput);
        this.jsInput = new JTextField();
        this.jsInput.addActionListener(this);
        this.jsInput.setActionCommand("jsfunction");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        jPanel11.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel11.add("North", new JLabel(Geonext.language.getString("jcontentedit_text_javascript")));
        jPanel11.add("South", this.jsInput);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayout(1, 3));
        jPanel12.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel12.add(jPanel8);
        jPanel12.add(jPanel9);
        jPanel12.add(jPanel11);
        this.add("North", jPanel5);
        this.add("Center", this.view);
        this.add("South", jPanel12);
    }

    public String insertTag(String string, String string2, int n) {
        if (n >= 0 && n < string2.length() + 1) {
            string2 = string.equals("arc") ? string2.substring(0, n) + "<" + string + ">" + string2.substring(n) : string2.substring(0, n) + "<" + string + "></" + string + ">" + string2.substring(n);
        }
        return string2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.actionPerformed(new ActionEvent(this, 0, "preview"));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void reset() {
        this.tInput.setText("");
        this.tInput.requestFocus();
        this.xInput.setText("" + this.board.digits(this.board.screen2userX(this.board.getWidth() / 2), 0, true));
        this.yInput.setText("" + this.board.digits(this.board.screen2userY(this.board.getHeight() / 2), 0, true));
        this.cInput.setText("");
        this.conditionBox.setSelected(false);
        this.setCInput();
        this.text = null;
        this.elementCombo.removeActionListener(this);
        this.elementCombo.removeAllItems();
        Vector vector = (Vector)this.generateElementVector().get(1);
        this.vec = (Vector)this.generateElementVector().get(0);
        vector.insertElementAt(Geonext.language.getString("jcontenttext_free"), 0);
        for (int i = 0; i < vector.size(); ++i) {
            this.elementCombo.addItem(vector.get(i));
        }
        this.elementCombo.setSelectedIndex(0);
        this.elementCombo.addActionListener(this);
        this.view.setTextString("");
        this.view.repaint();
    }

    public void setCInput() {
        if (this.conditionBox.isSelected()) {
            this.cInput.setForeground(Color.black);
            this.cInput.setEnabled(true);
            this.cInput.setEditable(true);
            this.cInput.setBorder(new JTextField().getBorder());
            C.boardName = this.board.internalName;
            try {
                new Double(C.NEV(new Scanner("If(" + this.cInput.getText() + ",1,0)", false).start()).toString());
            }
            catch (Throwable throwable) {
                this.cInput.setForeground(Color.red);
            }
        } else {
            this.cInput.setEnabled(false);
            this.cInput.setEditable(false);
            this.cInput.setBorder(new EtchedBorder(1));
        }
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void setText() {
        double d;
        double d2;
        try {
            d2 = Double.parseDouble(this.xInput.getText());
        }
        catch (Exception exception) {
            d2 = 0.0;
        }
        try {
            d = Double.parseDouble(this.yInput.getText());
        }
        catch (Exception exception) {
            d = 0.0;
        }
        Element element = this.elementCombo.getSelectedIndex() == 0 ? null : (Element)this.vec.get(this.elementCombo.getSelectedIndex() - 1);
        this.board.createText(d2, d, this.tInput.getText(), element);
        ((Text)this.board.element.elements.lastElement()).setJavaScriptFunction(this.jsInput.getText());
        if (this.getText() != null) {
            if (this.board.element.elements.lastElement() instanceof Text) {
                Text text = (Text)this.board.element.elements.lastElement();
                text.setLabel(this.text.getLabel());
                text.setFill(this.text.getFill());
                text.setStroke(this.text.getStroke());
                text.setLighting(this.text.getLighting());
                text.setShowInfo(this.text.isShowInfo());
                text.setTrace(this.text.isTrace());
                text.setVisible(this.text.isVisible());
                text.setDraft(this.text.isDraft());
                text.setAutoDigits(this.text.isAutoDigits());
                text.setDigits(this.text.getDigits());
                text.setFix(this.text.isFix());
            }
            this.board.element.remove(this.text);
        }
        this.board.repaint();
    }

    public void setText(Text text) {
        this.text = text;
        this.tInput.setText(this.text.getText());
        this.xInput.setText("x" + this.board.digits(this.text.getUser().getWidth(), 0, true));
        this.yInput.setText("y" + this.board.digits(this.text.getUser().getHeight(), 0, true));
        this.conditionBox.setSelected(this.text.isCondition());
        this.setCInput();
        this.cInput.setText(this.text.getCondString());
        this.jsInput.setText(this.text.getJavaScriptFunction());
        if (this.text.getE() == null) {
            this.elementCombo.setSelectedIndex(0);
        } else {
            this.elementCombo.setSelectedIndex(this.vec.indexOf(this.text.getE()) + 1);
        }
        this.text.parseHTML(this.board);
        this.text.evaluate(this.board);
        this.view.setTextString(this.tInput.getText());
        this.view.repaint();
        this.tInput.requestFocus();
        this.repaint();
    }

    public void setVec(Vector vector) {
        this.vec = vector;
    }
}

