/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.GeonetFileFilter;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JButton;
import geonext.JContentPanel;
import geonext.JFileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentBackground
extends JContentPanel
implements ActionListener,
ImageObserver {
    public JBoardPane board;
    public JTextField xImageInput;
    public JTextField yImageInput;
    public JTextField yImageSizeInput;
    public JTextField xImageSizeInput;
    public JTextField redField;
    public JTextField greenField;
    public JTextField blueField;
    public Color[][] col = new Color[][]{{Color.black, Color.gray, Color.lightGray, Color.white}, {new Color(0, 128, 192), Color.blue, Color.cyan, Color.yellow}, {Color.pink, Color.magenta, Color.red, new Color(255, 150, 0)}, {new Color(128, 0, 0), new Color(0, 128, 64), new Color(185, 219, 125), Color.green}};
    public javax.swing.JButton[][] backColor;
    public javax.swing.JButton backView;
    public javax.swing.JButton openImage;
    public javax.swing.JButton deleteImage;
    public JTextField imageField;
    public Image backImage = null;
    public javax.swing.JButton fileButton;

    public JContentBackground() {
    }

    public JContentBackground(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        this.backView = new javax.swing.JButton();
        this.backView.setBackground(jBoardPane.getBackground());
        this.redField = new JTextField(3);
        this.redField.addActionListener(this);
        this.redField.setActionCommand("rgb");
        this.redField.setFont(new Font(this.redField.getFont().getName(), 0, this.redField.getFont().getSize() - 2));
        this.greenField = new JTextField(3);
        this.greenField.addActionListener(this);
        this.greenField.setActionCommand("rgb");
        this.greenField.setFont(new Font(this.redField.getFont().getName(), 0, this.greenField.getFont().getSize() - 2));
        this.blueField = new JTextField(3);
        this.blueField.addActionListener(this);
        this.blueField.setActionCommand("rgb");
        this.blueField.setFont(new Font(this.redField.getFont().getName(), 0, this.blueField.getFont().getSize() - 2));
        this.setRGB();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel.add(new JLabel(Geonext.language.getString("color_red")));
        jPanel.add(new JLabel(Geonext.language.getString("color_green")));
        jPanel.add(new JLabel(Geonext.language.getString("color_blue")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel2.add(this.redField);
        jPanel2.add(this.greenField);
        jPanel2.add(this.blueField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("Center", jPanel);
        jPanel3.add("East", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(4, 4, 2, 2));
        jPanel4.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.backColor = new javax.swing.JButton[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.backColor[i][j] = new javax.swing.JButton();
                this.backColor[i][j].setPreferredSize(new Dimension(15, 15));
                this.backColor[i][j].setActionCommand(i + "" + j + "background");
                this.backColor[i][j].addActionListener(this);
                this.backColor[i][j].setBackground(this.col[i][j]);
                jPanel4.add(this.backColor[i][j]);
            }
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel5.add("West", jPanel4);
        jPanel5.add("Center", this.backView);
        jPanel5.add("East", jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("color_background") + " "));
        jPanel6.add("North", jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(15, 15));
        jPanel7.add("Center", jPanel6);
        this.xImageInput = new JTextField(4);
        this.xImageInput.setText("0");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(5, 5));
        jPanel8.add("West", new JLabel("x = "));
        jPanel8.add("Center", this.xImageInput);
        this.yImageInput = new JTextField(4);
        this.yImageInput.setText("0");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(5, 5));
        jPanel9.add("West", new JLabel("y = "));
        jPanel9.add("Center", this.yImageInput);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel10.add(new JLabel(Geonext.language.getString("common_position")));
        jPanel10.add(jPanel8);
        jPanel10.add(jPanel9);
        this.xImageSizeInput = new JTextField(4);
        this.xImageSizeInput.setText("0");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(5, 5));
        jPanel11.add("West", new JLabel(Geonext.language.getString("common_width")));
        jPanel11.add("East", this.xImageSizeInput);
        this.yImageSizeInput = new JTextField(4);
        this.yImageSizeInput.setText("0");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(5, 5));
        jPanel12.add("West", new JLabel(Geonext.language.getString("common_height")));
        jPanel12.add("East", this.yImageSizeInput);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel13.add(new JLabel(Geonext.language.getString("common_size")));
        jPanel13.add(jPanel11);
        jPanel13.add(jPanel12);
        this.fileButton = new javax.swing.JButton(Geonext.language.getString("jcontentbackground_load_image"));
        this.fileButton.addActionListener(this);
        this.fileButton.setActionCommand("load");
        this.imageField = new JTextField();
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(5, 5));
        jPanel14.add("West", new JLabel("URL"));
        jPanel14.add("Center", this.imageField);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout(10, 10));
        jPanel15.add("North", this.fileButton);
        jPanel15.add("West", jPanel10);
        jPanel15.add("Center", jPanel13);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel16.add(new JLabel(Geonext.language.getString("common_width")));
        jPanel16.add(new JLabel(Geonext.language.getString("common_height")));
        this.deleteImage = new javax.swing.JButton(Geonext.language.getString("jcontentedit_delete"));
        this.deleteImage.addActionListener(this);
        this.deleteImage.setActionCommand("delete");
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout(5, 5));
        jPanel17.add("West", jPanel15);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new BorderLayout(5, 5));
        jPanel18.add("North", jPanel17);
        jPanel18.add("Center", new JPanel());
        jPanel18.add("South", this.deleteImage);
        this.openImage = new javax.swing.JButton();
        this.openImage.addActionListener(this);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new BorderLayout(10, 10));
        jPanel19.add("Center", this.openImage);
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new BorderLayout(15, 15));
        jPanel20.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel20.add("Center", jPanel19);
        jPanel20.add("West", jPanel18);
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new BorderLayout());
        jPanel21.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("color_background_image") + " "));
        jPanel21.add("Center", jPanel20);
        this.add("North", jPanel7);
        this.add("Center", jPanel21);
        this.validateTree();
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.board.setSaved(false);
            this.setBack();
        } else if (string.equals("apply")) {
            this.board.setSaved(false);
            this.setBack();
        } else if (string.endsWith("background")) {
            int n = new Integer(string.substring(0, 1));
            int n2 = new Integer(string.substring(1, 2));
            this.backView.setBackground(this.col[n][n2]);
            this.setRGB();
        } else if (string.endsWith("rgb")) {
            this.setColor();
        } else if (string.endsWith("image")) {
            this.openImg();
        } else if (string.endsWith("load")) {
            this.loadImg();
        } else if (string.endsWith("delete")) {
            this.deleteImg();
        }
        this.board.repaint();
    }

    public Image getBackImage() {
        return this.backImage;
    }

    public JTextField getImageField() {
        return this.imageField;
    }

    public void loadImg() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setCurrentDirectory(new File(this.board.geonext.lastPath));
            jFileChooser.addChoosableFileFilter(new GeonetFileFilter("png", "PNG"));
            jFileChooser.addChoosableFileFilter(new GeonetFileFilter("jpg", "JPG"));
            jFileChooser.addChoosableFileFilter(new GeonetFileFilter("gif", "GIF"));
            int n = jFileChooser.showDialog(this, Geonext.language.getString("common_open"));
            if (n == 0) {
                this.backImage = this.board.getToolkit().createImage(jFileChooser.getSelectedFile().getPath());
                if (this.backImage != null) {
                    this.openImage.setIcon(new ImageIcon(this.backImage));
                    this.xImageSizeInput.setText(" " + this.board.screen2userX(this.board.getOrigin().getWidth() + (double)this.backImage.getWidth(this)));
                    this.yImageSizeInput.setText(" " + this.board.screen2userY(this.board.getOrigin().getHeight() - (double)this.backImage.getHeight(this)));
                    this.board.backgroundFile = new File(jFileChooser.getSelectedFile().getPath());
                    this.board.backgroundFileExtention = jFileChooser.getSelectedFile().getPath().substring(jFileChooser.getSelectedFile().getPath().lastIndexOf(46), jFileChooser.getSelectedFile().getPath().length());
                }
            }
        }
        catch (Exception exception) {
            this.imageField.setText(" ");
            this.backImage = null;
        }
    }

    public void openImg() {
        try {
            this.backImage = this.imageField.getText().toLowerCase().startsWith("http://") ? ((Geonext)this.board.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent()).getAppletContext().getImage(new URL(this.imageField.getText())) : this.board.getToolkit().createImage(this.imageField.getText());
            if (this.backImage != null && this.backImage.getWidth(this) > 0 && this.backImage.getHeight(this) > 0) {
                this.openImage.setIcon(new ImageIcon(this.backImage));
                this.xImageSizeInput.setText(" " + this.board.screen2userX(this.board.getOrigin().getWidth() + (double)this.backImage.getWidth(this)));
                this.yImageSizeInput.setText(" " + this.board.screen2userY(this.board.getOrigin().getHeight() - (double)this.backImage.getHeight(this)));
            }
        }
        catch (Exception exception) {
            this.imageField.setText(" ");
            this.openImage.setIcon(null);
            this.backImage = null;
        }
    }

    public void reset() {
        this.backView.setBackground(this.board.getBackground());
        this.setRGB();
        this.backImage = this.board.jep.getBackImage();
        if (this.backImage != null && this.board.jep.imageSize.getWidth() > 0.0 && this.board.jep.imageSize.getHeight() > 0.0) {
            this.openImage.setIcon(new ImageIcon(this.backImage));
            this.xImageInput.setText("" + this.board.jep.imageCoord.getWidth());
            this.yImageInput.setText("" + this.board.jep.imageCoord.getHeight());
            this.xImageSizeInput.setText("" + this.board.jep.imageSize.getWidth());
            this.yImageSizeInput.setText("" + this.board.jep.imageSize.getHeight());
        } else {
            this.xImageInput.setText("");
            this.yImageInput.setText("");
            this.xImageSizeInput.setText("");
            this.yImageSizeInput.setText("");
        }
        this.imageField.setText("");
    }

    public void deleteImg() {
        this.imageField.setText(" ");
        this.openImage.setIcon(null);
        this.backImage = null;
        this.board.backgroundFile = null;
        this.board.backgroundFileExtention = "";
        this.board.setBackImageFileName("");
    }

    public void setBack() {
        block6: {
            this.board.setBackground(this.backView.getBackground());
            this.board.jep.setImage(null);
            this.board.jep.setBackImage(this.backImage);
            try {
                this.board.jep.imageCoord = new Coordinates(Double.parseDouble(this.xImageInput.getText()), Double.parseDouble(this.yImageInput.getText()));
            }
            catch (Exception exception) {
                this.board.jep.imageCoord = new Coordinates(0.0, 0.0);
            }
            try {
                this.board.jep.imageSize = new Coordinates(Double.parseDouble(this.xImageSizeInput.getText()), Double.parseDouble(this.yImageSizeInput.getText()));
            }
            catch (Exception exception) {
                if (this.backImage == null) break block6;
                this.board.jep.imageSize = new Coordinates(this.board.screen2userX(this.board.getOrigin().getWidth() + (double)this.backImage.getWidth(this)), this.board.screen2userY(this.board.getOrigin().getHeight() - (double)this.backImage.getHeight(this)));
            }
        }
        try {
            this.board.geonextEditDialog.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.board.calculateElements();
    }

    public void setBackImage(Image image) {
        this.backImage = image;
    }

    public void setColor() {
        try {
            this.backView.setBackground(new Color(Integer.parseInt(this.redField.getText()), Integer.parseInt(this.greenField.getText()), Integer.parseInt(this.blueField.getText())));
        }
        catch (Exception exception) {
            this.setRGB();
        }
    }

    public void setImageField(JTextField jTextField) {
        this.imageField = jTextField;
    }

    public void setOpenImage(JButton jButton) {
        this.openImage = jButton;
    }

    public void setRGB() {
        this.redField.setText("" + this.backView.getBackground().getRed());
        this.greenField.setText("" + this.backView.getBackground().getGreen());
        this.blueField.setText("" + this.backView.getBackground().getBlue());
    }
}

