/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import com.hartmath.lib.SessionData;
import geonext.Angle;
import geonext.Arc;
import geonext.Arrow;
import geonext.BoardEvent;
import geonext.CASPoint;
import geonext.Circle;
import geonext.Composition;
import geonext.Condition;
import geonext.ConstructionData;
import geonext.Coordinates;
import geonext.DrawText;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.GeonextDesktopManager;
import geonext.GeonextDesktopPane;
import geonext.Graph;
import geonext.GraphSlider;
import geonext.Group;
import geonext.Intersection;
import geonext.JBoard;
import geonext.JElementPane;
import geonext.JFrameDialog;
import geonext.JPopupList;
import geonext.JZoomBox;
import geonext.Line;
import geonext.ParameterCurve;
import geonext.PathPoint;
import geonext.Point;
import geonext.Polygon;
import geonext.ScreenShot;
import geonext.Slider;
import geonext.Text;
import geonext.TraceCurve;
import geonext.UndoManager;
import geonext.UserData;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import netscape.javascript.JSObject;
import util.Base64;
import util.IO;

public class JBoardPane
extends JLayeredPane
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Runnable {
    Geonext geonext = null;
    JElementPane jep;
    public SessionData sd;
    public static final String[] greek = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    public boolean status;
    JScrollPane jsp;
    int modus = 210260;
    int previousModus = 210260;
    Point selectedPoint;
    Element selectedElement;
    Circle selectedCircle;
    Line selectedLine;
    Graph selectedGraph;
    Text selectedText;
    boolean listStatus = false;
    Image pointImage;
    ElementSet storedESet;
    public UndoManager undo;
    public JZoomBox zoomBox;
    public int[] nameCounter = new int[]{0, 0, 0, 0, 0};
    public boolean toCoord = false;
    public boolean coord = false;
    public String snaptogrid = "snaptogrid";
    public Vector selection;
    public int selectionCount = 0;
    public Vector selectionType;
    public int compositionType = 0;
    public ConstructionData data;
    public String internalName = "";
    public String coordXTerm = "";
    public boolean coordXObject = true;
    public boolean coordYObject = true;
    public String coordXMulti = "";
    public String coordYMulti = "";
    public String coordYTerm = "";
    public String coordXLabel = "x";
    public boolean coordXShowUnit = false;
    public boolean coordXContinuous = false;
    public boolean coordYContinuous = false;
    public boolean coordYMultiple = false;
    public boolean coordXMultiple = false;
    public boolean coordYShowUnit = false;
    public String coordYLabel = "y";
    public ElementSet element;
    public Coordinates unit;
    public Coordinates cursorPosition;
    public boolean firstRun = true;
    public Coordinates origin;
    public Coordinates grid;
    public Coordinates zoom;
    public Coordinates lastOrigin = new Coordinates();
    public Color bgcolor;
    public Color[][] col = new Color[][]{{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white}, {Color.pink, Color.red, Color.gray, Color.lightGray, Color.white}, {new Color(128, 128, 192), Color.magenta, Color.pink, new Color(255, 128, 0), Color.red}, {new Color(0, 100, 0), new Color(0, 150, 0), new Color(0, 200, 0), new Color(0, 255, 0), new Color(200, 255, 200)}, {Color.blue, Color.cyan, Color.green, new Color(185, 219, 125), Color.yellow}};
    public Vector usedNames;
    public String freeze = "";
    public boolean frozen = false;
    public Thread motion = null;
    public Coordinates textMove = new Coordinates();
    public boolean control = true;
    public boolean inLogo = false;
    public boolean coordGrid = false;
    public boolean statusBar = true;
    public JFrameDialog geonextDialog;
    public JFrameDialog geonextTextDialog;
    public JFrameDialog geonextCASDialog;
    public JFrameDialog geonextBoardDialog;
    public JFrameDialog geonextEditDialog;
    public JFrameDialog geonextCASPointDialog;
    public JFrameDialog geonextGraphDialog;
    public JFrameDialog geonextValueDialog;
    public JFrameDialog geonextParameterCurveDialog;
    public JFrameDialog geonextPrintDialog;
    public Coordinates subGrid = new Coordinates(2.0, 2.0);
    public boolean coordLabel = true;
    public boolean cross = false;
    public String title;
    public String comment = "";
    public String info = "";
    public String author = "";
    public Vector slideImage = new Vector();
    public String backImageFileName = "";
    public Vector graphHistoryString = new Vector();
    public Vector valueHistoryString = new Vector();
    public Vector casXHistoryString = new Vector();
    public Vector casYHistoryString = new Vector();
    public Vector pCurveXHistoryString = new Vector();
    public Vector pCurveYHistoryString = new Vector();
    public Vector pCurveMinHistoryString = new Vector();
    public Vector pCurveMaxHistoryString = new Vector();
    public File backgroundFile = null;
    public String backgroundFileExtention = "";
    public Point TLPoint;
    public Point TRPoint;
    public Point BLPoint;
    public Point BRPoint;
    public Point OOPoint;
    public Point XOPoint;
    public Point OYPoint;
    public Line TLine;
    public Line BLine;
    public Line RLine;
    public Line LLine;
    public Line XLine;
    public Line YLine;
    public boolean antiAlias = true;
    public float[][] dashArray;
    public JSObject jsWindow;
    public Color gridColor = Color.lightGray;
    public boolean gridDash = true;
    public boolean pointSnap = false;
    public Coordinates zoomMin = new Coordinates(0.01, 0.01);
    public Coordinates zoomMax = new Coordinates(1000.0, 1000.0);
    public ScreenShot screenshot = null;
    boolean saved = true;
    boolean active = true;
    boolean ckCond = true;
    int fontSize = 3;
    Vector conditions;

    public JBoardPane() {
    }

    public JBoardPane(String string, String string2, Geonext geonext) {
        this.geonext = geonext;
        this.internalName = string;
        this.initJBoardPane();
        this.sd = new SessionData(string, this.element);
        this.sd.put(string);
        this.sd.setNumericFlag(false);
        C.boardName = string;
        C.init();
        C.GEV(C.initRules);
        this.modus = 80;
        if (!string2.equals("")) {
            this.readSource(string2);
        }
        this.calculateElements();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.geonext.jnp.getElement() != null) {
            this.element.rename(this.geonext.jnp.getElement(), this.geonext.jnp.getTextContent(), this);
            for (int i = 0; i < this.element.text.size(); ++i) {
                ((Text)this.element.text.get(i)).evaluate(this);
            }
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().reset();
                this.getGeonextEditDialog().jce.refreshList();
            }
            this.geonext.jnp.setElement(null);
            this.setSaved(false);
            this.repaint();
        } else {
            this.geonext.set(this.geonext.jnp.getTextContent());
        }
    }

    public double[] angle(Point point, Point point2, Point point3) {
        return new double[]{0.0, 0.0};
    }

    public void calculateCalculatedElements(boolean bl) {
        int n;
        for (n = 0; n < this.element.point.size(); ++n) {
            if (!(this.element.point.get(n) instanceof CASPoint)) continue;
            ((CASPoint)this.element.point.get(n)).calculate(bl);
            this.user2screen((Point)this.element.point.get(n));
        }
        for (n = 0; n < this.element.parameterCurve.size(); ++n) {
            ((ParameterCurve)this.element.parameterCurve.get(n)).calculate(this, bl);
        }
        for (n = 0; n < this.element.graph.size(); ++n) {
            ((Graph)this.element.graph.get(n)).calculate(this, bl);
        }
        for (n = 0; n < this.element.traceCurve.size(); ++n) {
            ((TraceCurve)this.element.traceCurve.get(n)).calculate(this, bl);
        }
        for (n = 0; n < this.element.circle.size(); ++n) {
            Circle circle = (Circle)this.element.circle.get(n);
            if (circle.radius == null) continue;
            circle.calculate(this, bl);
        }
        this.element.setElementsChanged(false);
    }

    public void calculateElements() {
        this.calculateElements(false);
    }

    public void calculateTraceCrurve(TraceCurve traceCurve, boolean bl) {
        if (this.getSelectedPoint() == traceCurve.getSlider() && !bl) {
            traceCurve.setChanged(false);
        } else {
            traceCurve.calculateChanged(bl);
        }
        if (traceCurve.isChanged()) {
            double d;
            double d2;
            double d3;
            double d4;
            Object object;
            Object object2;
            boolean bl2;
            int n;
            int n2;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            C.boardName = this.internalName;
            Slider slider = traceCurve.getSlider();
            Point point = traceCurve.getTracePoint();
            traceCurve.path = new Vector();
            int n3 = 0;
            if (slider.getParent() instanceof Circle) {
                double d10 = slider.getPosition();
                d9 = 0.1;
                d8 = -d9;
                d7 = 0.0;
                d6 = 0.0;
                d5 = 0.04 / this.zoom.getWidth();
                n2 = point.ancestor.indexOf(slider);
                n = 0;
                bl2 = false;
                object2 = null;
                object = null;
                n3 = 0;
                d4 = 0.0;
                while (n == 0) {
                    ++n3;
                    if (d8 > Math.PI * 2 - d9) {
                        d4 = d8;
                        d8 = -d9;
                        n = 1;
                    }
                    slider.position = d8 += d9;
                    traceCurve.recalculate(n2, this);
                    this.user2screen(point);
                    try {
                        if (object2 != null && object != null) {
                            double d11 = 0.0;
                            d3 = 0.0;
                            double d12 = 0.0;
                            double d13 = 0.0;
                            try {
                                d7 = Math.sqrt(Math.pow((double)((PathPoint)object2).getScreenX() - point.getScreenX(), 2.0) + Math.pow((double)((PathPoint)object2).getScreenY() - point.getScreenY(), 2.0));
                                d11 = (object.getScreenY() - ((PathPoint)object2).getScreenY()) / (object.getScreenX() - ((PathPoint)object2).getScreenX());
                                d3 = ((double)((PathPoint)object2).getScreenY() - point.getScreenY()) / ((double)((PathPoint)object2).getScreenX() - point.getScreenX());
                                d12 = d3 / d11;
                                d13 = (d3 - d11) * this.zoom.getWidth();
                            }
                            catch (Exception exception) {
                                d12 = object.getScreenY() - ((PathPoint)object2).getScreenY() < 2 ? 0.5 : 0.1;
                            }
                            if (d9 < d5 | (Math.abs(d13) < 8.0 && d12 >= 0.3 && d12 <= 4.0) | ((PathPoint)object2).equals(point)) {
                                bl2 = false;
                                object = object2;
                                if (d7 - d6 > 50.0 * this.zoom.getWidth() && d7 / d6 > 0.9 || d9 <= d5 && d7 > 100.0 * this.zoom.getWidth()) {
                                    try {
                                        ((PathPoint)traceCurve.path.get(traceCurve.path.size() - 1)).setDrawtonext(false);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                object2 = new PathPoint(point.getUser(), point.getScreen(), d8, true);
                                traceCurve.path.addElement(object2);
                                if (d12 >= 0.8 && d12 <= 1.3) {
                                    d9 += d9 / 10.0;
                                }
                                d6 = d7;
                                continue;
                            }
                            bl2 = true;
                            d8 = n != 0 ? d4 : (d8 -= d9);
                            n = 0;
                            d9 -= d9 / 10.0;
                            continue;
                        }
                        object = object2;
                        object2 = new PathPoint(point.getUser(), point.getScreen(), d8, true);
                        traceCurve.path.addElement(object2);
                    }
                    catch (Exception exception) {}
                }
                slider.position = d10;
                traceCurve.recalculate(n2, this);
                this.user2screen(point);
            }
            if (slider.getParent() instanceof Line) {
                int n4;
                Line line = (Line)slider.getParent();
                Coordinates[] coordinatesArray = this.getLinesIntersectionWithViewport(line, 10);
                d9 = slider.getPosition();
                Coordinates coordinates = slider.user;
                double d14 = 50.0;
                double d15 = Math.PI / d14;
                double d16 = 0.0;
                double d17 = 0.0;
                n = point.ancestor.indexOf(slider);
                bl2 = false;
                boolean bl3 = false;
                object = point.normVector(point.cp(line.getA().getSphere(), line.getB().getSphere()));
                d4 = object[0];
                double d18 = object[1];
                d3 = Math.sqrt(d4 * d4 + d18 * d18);
                double[] dArray = point.normVector(new double[]{1.0 / d3 * d18, -(1.0 / d3) * d4, 0.0});
                double[] dArray2 = point.normVector(point.cp(dArray, (double[])object));
                PathPoint pathPoint = null;
                PathPoint pathPoint2 = null;
                n3 = 0;
                double d19 = 0.0;
                double d20 = 0.0;
                if (line.isFirst() && line.isLast()) {
                    d19 = 0.0;
                    d20 = Math.PI;
                }
                if (!line.isFirst() && !line.isLast() && (d19 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getA())) > (d20 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getB()))) {
                    d19 += d20;
                    d20 = d19 - d20;
                    d19 -= d20;
                }
                if (line.isFirst() && !line.isLast()) {
                    d19 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getA());
                    if (d19 < (d20 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getB()))) {
                        d19 = 0.0;
                    }
                    if (d19 > d20) {
                        d19 = d20;
                        d20 = Math.PI;
                    }
                }
                if (!line.isFirst() && line.isLast()) {
                    d19 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getA());
                    if (d19 < (d20 = this.getAngleOnShpericCircleSystem(dArray, dArray2, line.getB()))) {
                        d20 = Math.PI;
                    }
                    if (d19 > d20) {
                        d20 = d19;
                        d19 = 0.0;
                    }
                }
                double d21 = d19 - d15;
                while (!bl2) {
                    ++n3;
                    if (d21 > d20 - d15) {
                        d21 = d20 - d15;
                        bl2 = true;
                    }
                    try {
                        slider.setSphere(new double[]{dArray[0] * Math.cos(d21 += d15) + dArray2[0] * Math.sin(d21), dArray[1] * Math.cos(d21) + dArray2[1] * Math.sin(d21), dArray[2] * Math.cos(d21) + dArray2[2] * Math.sin(d21)});
                        slider.sphere2user();
                        traceCurve.recalculate(n + 1, this);
                        this.user2screen(point);
                        traceCurve.path.addElement(new PathPoint(point.getUser(), point.getScreen(), d21, true));
                    }
                    catch (Exception exception) {}
                }
                double[] dArray3 = new double[]{this.getAngleOnShpericCircleSystem(dArray, dArray2, coordinatesArray[0]), this.getAngleOnShpericCircleSystem(dArray, dArray2, coordinatesArray[1])};
                for (n4 = 0; n4 < 2; ++n4) {
                    d21 = dArray3[n4];
                    if (!(d21 >= d19) || !(d21 <= d20)) continue;
                    slider.setSphere(new double[]{dArray[0] * Math.cos(d21) + dArray2[0] * Math.sin(d21), dArray[1] * Math.cos(d21) + dArray2[1] * Math.sin(d21), dArray[2] * Math.cos(d21) + dArray2[2] * Math.sin(d21)});
                    slider.sphere2user();
                    traceCurve.recalculate(n + 1, this);
                    this.user2screen(point);
                    boolean bl4 = false;
                    if (((PathPoint)traceCurve.path.get(0)).getParameter() >= d21) {
                        if (((PathPoint)traceCurve.path.get(0)).getParameter() > d21) {
                            traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d21, true), 0);
                        }
                        bl4 = true;
                        continue;
                    }
                    for (int i = 0; i < traceCurve.path.size() - 1; ++i) {
                        if (!(((PathPoint)traceCurve.path.get(i)).getParameter() <= d21) || !(((PathPoint)traceCurve.path.get(i + 1)).getParameter() >= d21)) continue;
                        if (((PathPoint)traceCurve.path.get(i)).getParameter() != d21 && ((PathPoint)traceCurve.path.get(i + 1)).getParameter() != d21) {
                            traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d21, true), i + 1);
                        }
                        bl4 = true;
                    }
                    if (bl4 || !(((PathPoint)traceCurve.path.get(traceCurve.path.size() - 1)).getParameter() < d21)) continue;
                    traceCurve.path.addElement(new PathPoint(point.getUser(), point.getScreen(), d21, true));
                }
                for (n4 = 0; n4 < traceCurve.path.size() - 1; ++n4) {
                    if (((PathPoint)traceCurve.path.get(n4)).getParameter() != dArray3[0] && ((PathPoint)traceCurve.path.get(n4)).getParameter() != dArray3[1] && ((PathPoint)traceCurve.path.get(n4 + 1)).getParameter() != dArray3[0] && ((PathPoint)traceCurve.path.get(n4 + 1)).getParameter() != dArray3[1] && !((PathPoint)traceCurve.path.get(n4)).isinViewPort(0.0, this.getWidth(), 0.0, this.getHeight()) && !((PathPoint)traceCurve.path.get(n4 + 1)).isinViewPort(0.0, this.getWidth(), 0.0, this.getHeight())) continue;
                    d21 = ((PathPoint)traceCurve.path.get(n4)).getParameter();
                    double d22 = ((PathPoint)traceCurve.path.get(n4 + 1)).getParameter();
                    d15 = (d22 - d21) / (40.0 * Math.sqrt(this.zoom.getWidth()));
                    d21 += d15;
                    pathPoint = null;
                    pathPoint2 = null;
                    double d23 = d15 / (this.zoom.getWidth() * this.zoom.getWidth());
                    while (d21 < d22) {
                        slider.setSphere(new double[]{dArray[0] * Math.cos(d21) + dArray2[0] * Math.sin(d21), dArray[1] * Math.cos(d21) + dArray2[1] * Math.sin(d21), dArray[2] * Math.cos(d21) + dArray2[2] * Math.sin(d21)});
                        slider.sphere2user();
                        slider.position = d21;
                        traceCurve.recalculate(n + 1, this);
                        this.user2screen(point);
                        try {
                            if (pathPoint != null && pathPoint2 != null) {
                                double d24 = 0.0;
                                d2 = 0.0;
                                d = 0.0;
                                double d25 = 0.0;
                                try {
                                    d16 = Math.sqrt(Math.pow((double)pathPoint.getScreenX() - point.getScreenX(), 2.0) + Math.pow((double)pathPoint.getScreenY() - point.getScreenY(), 2.0));
                                    d24 = (pathPoint2.getScreenY() - pathPoint.getScreenY()) / (pathPoint2.getScreenX() - pathPoint.getScreenX());
                                    d2 = ((double)pathPoint.getScreenY() - point.getScreenY()) / ((double)pathPoint.getScreenX() - point.getScreenX());
                                    d = d2 / d24;
                                    d25 = (d2 - d24) * this.zoom.getWidth();
                                }
                                catch (Exception exception) {
                                    d = pathPoint2.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                                }
                                if (d15 < d23 | (Math.abs(d25) < 0.5 && d >= 0.3 && d <= 1.8) | pathPoint.equals(point)) {
                                    bl3 = false;
                                    if (Math.abs(d16 - d17) > 20.0 * this.zoom.getWidth() && d15 != d23) {
                                        bl3 = true;
                                        bl2 = false;
                                        d21 -= d15;
                                        if ((d15 -= d15 / 10.0) < d23) {
                                            d15 = d23;
                                        }
                                    }
                                    pathPoint2 = pathPoint;
                                    pathPoint = new PathPoint(point.getUser(), point.getScreen(), d21, true);
                                    traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d21, true), ++n4);
                                    if (d >= 0.9 && d <= 1.1 && Math.abs(d25) < 1.0) {
                                        d15 += d15 / 10.0;
                                    }
                                    d17 = d16;
                                } else {
                                    bl3 = true;
                                    bl2 = false;
                                    d21 -= d15;
                                    d15 -= d15 / 10.0;
                                }
                            } else {
                                pathPoint2 = pathPoint;
                                pathPoint = new PathPoint(point.getUser(), point.getScreen(), d21, true);
                                traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d21, true), ++n4);
                            }
                            d21 += d15;
                        }
                        catch (Exception exception) {}
                    }
                }
                slider.position = d9;
                traceCurve.recalculate(n, this);
                this.user2screen(point);
            }
            if (slider.getParent() instanceof Graph) {
                int n5;
                double d26;
                double d27;
                Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(this.screen2userX(0.0), 0.0), new Coordinates(this.screen2userX(this.getWidth()), 0.0)};
                double d28 = slider.getUserX();
                Coordinates coordinates = slider.user;
                d8 = 50.0;
                d7 = Math.PI / d8;
                d6 = 0.0;
                d5 = 0.0;
                n2 = point.ancestor.indexOf(slider);
                n = 0;
                bl2 = false;
                object2 = new double[]{0.0, 0.0, -1.0};
                object = new double[]{1.0, 0.0, 0.0};
                PathPoint pathPoint = null;
                PathPoint pathPoint3 = null;
                n3 = 0;
                double d29 = 0.0;
                d3 = Math.PI;
                double d30 = d29 - d7;
                Point point2 = new Point();
                double d31 = this.getAngleOnShpericCircleSystem((double[])object, (double[])object2, new Coordinates(this.screen2userX(0.0), 0.0));
                if (d31 > (d27 = this.getAngleOnShpericCircleSystem((double[])object, (double[])object2, new Coordinates(this.screen2userX(this.getWidth()), 0.0)))) {
                    d26 = d27;
                    d27 = d31;
                    d31 = d26;
                }
                while (n == 0) {
                    ++n3;
                    if (d30 > d3 - d7) {
                        d30 = d3 - d7;
                        n = 1;
                    }
                    d26 = d7;
                    if (d31 >= d30 && d30 < d27) {
                        d7 = (d27 - d31) / (double)(this.getWidth() / 35);
                        for (d30 = d31; d30 <= d27; d30 += d7) {
                            try {
                                point2.setSphere(new double[]{object[0] * Math.cos(d30) + object2[0] * Math.sin(d30), object[1] * Math.cos(d30) + object2[1] * Math.sin(d30), object[2] * Math.cos(d30) + object2[2] * Math.sin(d30)});
                                point2.sphere2user();
                                slider.setUser(point2.getUser());
                                traceCurve.recalculate(n2, this);
                                this.user2screen(point);
                                traceCurve.path.addElement(new PathPoint(point.getUser(), point.getScreen(), d30, true));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        d7 = d26;
                    }
                    try {
                        point2.setSphere(new double[]{object[0] * Math.cos(d30 += d7) + object2[0] * Math.sin(d30), object[1] * Math.cos(d30) + object2[1] * Math.sin(d30), object[2] * Math.cos(d30) + object2[2] * Math.sin(d30)});
                        point2.sphere2user();
                        slider.setUser(point2.getUser());
                        traceCurve.recalculate(n2, this);
                        this.user2screen(point);
                        traceCurve.path.addElement(new PathPoint(point.getUser(), point.getScreen(), d30, true));
                    }
                    catch (Exception exception) {}
                }
                double[] dArray = new double[]{this.getAngleOnShpericCircleSystem((double[])object, (double[])object2, coordinatesArray[0]), this.getAngleOnShpericCircleSystem((double[])object, (double[])object2, coordinatesArray[1])};
                for (n5 = 0; n5 < 2; ++n5) {
                    d30 = dArray[n5];
                    try {
                        if (!(d30 >= d29) || !(d30 <= d3)) continue;
                        point2.setSphere(new double[]{object[0] * Math.cos(d30) + object2[0] * Math.sin(d30), object[1] * Math.cos(d30) + object2[1] * Math.sin(d30), object[2] * Math.cos(d30) + object2[2] * Math.sin(d30)});
                        point2.sphere2user();
                        slider.setUser(point2.getUser());
                        traceCurve.recalculate(n2, this);
                        this.user2screen(point);
                        boolean bl5 = false;
                        if (((PathPoint)traceCurve.path.get(0)).getParameter() >= d30) {
                            if (((PathPoint)traceCurve.path.get(0)).getParameter() > d30) {
                                traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d30, true), 0);
                            }
                            bl5 = true;
                            continue;
                        }
                        for (int i = 0; i < traceCurve.path.size() - 1; ++i) {
                            if (!(((PathPoint)traceCurve.path.get(i)).getParameter() <= d30) || !(((PathPoint)traceCurve.path.get(i + 1)).getParameter() >= d30)) continue;
                            if (((PathPoint)traceCurve.path.get(i)).getParameter() != d30 && ((PathPoint)traceCurve.path.get(i + 1)).getParameter() != d30) {
                                traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d30, true), i + 1);
                            }
                            bl5 = true;
                        }
                        if (bl5 || !(((PathPoint)traceCurve.path.get(traceCurve.path.size() - 1)).getParameter() < d30)) continue;
                        traceCurve.path.addElement(new PathPoint(point.getUser(), point.getScreen(), d30, true));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (n5 = 0; n5 < traceCurve.path.size() - 1; ++n5) {
                    boolean bl6 = true;
                    try {
                        if (((PathPoint)traceCurve.path.get(n5)).getParameter() != dArray[0] && ((PathPoint)traceCurve.path.get(n5)).getParameter() != dArray[1] && ((PathPoint)traceCurve.path.get(n5 + 1)).getParameter() != dArray[0] && ((PathPoint)traceCurve.path.get(n5 + 1)).getParameter() != dArray[1] && !((PathPoint)traceCurve.path.get(n5)).isinViewPort(0.0, this.getWidth(), 0.0, this.getHeight()) && !((PathPoint)traceCurve.path.get(n5 + 1)).isinViewPort(0.0, this.getWidth(), 0.0, this.getHeight())) continue;
                        d30 = ((PathPoint)traceCurve.path.get(n5)).getParameter();
                        double d32 = ((PathPoint)traceCurve.path.get(n5 + 1)).getParameter();
                        d7 = (d32 - d30) / (50.0 * Math.sqrt(this.zoom.getWidth()));
                        d30 += d7;
                        pathPoint = n5 >= 1 ? (PathPoint)traceCurve.path.get(n5 - 1) : null;
                        pathPoint3 = n5 >= 2 ? (PathPoint)traceCurve.path.get(n5 - 2) : null;
                        double d33 = d7 / (this.zoom.getWidth() * this.zoom.getWidth());
                        while (d30 < d32) {
                            point2.setSphere(new double[]{object[0] * Math.cos(d30) + object2[0] * Math.sin(d30), object[1] * Math.cos(d30) + object2[1] * Math.sin(d30), object[2] * Math.cos(d30) + object2[2] * Math.sin(d30)});
                            point2.sphere2user();
                            slider.setUser(point2.getUser());
                            slider.position = d30;
                            traceCurve.recalculate(n2, this);
                            this.user2screen(point);
                            try {
                                if (pathPoint != null && pathPoint3 != null) {
                                    double d34 = 0.0;
                                    double d35 = 0.0;
                                    d2 = 0.0;
                                    d = 0.0;
                                    try {
                                        d6 = Math.sqrt(Math.pow((double)pathPoint.getScreenX() - point.getScreenX(), 2.0) + Math.pow((double)pathPoint.getScreenY() - point.getScreenY(), 2.0));
                                        d34 = (pathPoint3.getScreenY() - pathPoint.getScreenY()) / (pathPoint3.getScreenX() - pathPoint.getScreenX());
                                        d35 = ((double)pathPoint.getScreenY() - point.getScreenY()) / ((double)pathPoint.getScreenX() - point.getScreenX());
                                        d2 = d35 / d34;
                                        d = (d35 - d34) * this.zoom.getWidth();
                                    }
                                    catch (Exception exception) {
                                        d2 = pathPoint3.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                                    }
                                    if (d7 <= d33 | (Math.abs(d) < 0.5 && d2 >= 0.3 && d2 <= 1.8) | pathPoint.equals(point)) {
                                        bl2 = false;
                                        if (Math.abs(d6 - d5) > Math.abs(50.0 * this.zoom.getWidth())) {
                                            if (d7 <= d33) {
                                                try {
                                                    ((PathPoint)traceCurve.path.get(n5 - 1)).setDrawtonext(false);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                pathPoint3 = pathPoint;
                                                pathPoint = new PathPoint(point.getUser(), point.getScreen(), d30, true);
                                                traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d30, true), ++n5);
                                                bl6 = false;
                                                d5 = d6;
                                            } else {
                                                bl2 = true;
                                                n = 0;
                                                d30 -= d7;
                                                if ((d7 -= d7 / 10.0) < d33) {
                                                    d7 = d33;
                                                }
                                            }
                                        } else {
                                            pathPoint3 = pathPoint;
                                            pathPoint = new PathPoint(point.getUser(), point.getScreen(), d30, true);
                                            traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d30, true), ++n5);
                                            bl6 = false;
                                            if (d2 >= 0.9 && d2 <= 1.1 && Math.abs(d) < 1.0) {
                                                d7 += d7 / 10.0;
                                            }
                                            d5 = d6;
                                        }
                                    } else {
                                        bl2 = true;
                                        n = 0;
                                        d30 -= d7;
                                        if ((d7 -= d7 / 10.0) < d33) {
                                            d7 = d33;
                                        }
                                    }
                                } else {
                                    pathPoint3 = pathPoint;
                                    pathPoint = new PathPoint(point.getUser(), point.getScreen(), d30, true);
                                    traceCurve.path.insertElementAt(new PathPoint(point.getUser(), point.getScreen(), d30, true), ++n5);
                                    if (bl6) {
                                        ((PathPoint)traceCurve.path.get(n5 - 1)).setDrawtonext(false);
                                    }
                                }
                                d30 += d7;
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                slider.setUser(new Coordinates(d28, 0.0));
                traceCurve.recalculate(n2, this);
                try {
                    this.user2screen(point);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void calculateVisibleArea() {
        this.TLPoint.setScreen(0.0, 0.0);
        this.screen2user(this.TLPoint);
        this.TLPoint.user2sphere();
        this.BLPoint.setScreen(0.0, this.getHeight());
        this.screen2user(this.BLPoint);
        this.BLPoint.user2sphere();
        this.TRPoint.setScreen(this.getWidth(), 0.0);
        this.screen2user(this.TRPoint);
        this.TRPoint.user2sphere();
        this.BRPoint.setScreen(this.getWidth(), this.getHeight());
        this.screen2user(this.BRPoint);
        this.BRPoint.user2sphere();
    }

    public String changeChar(String string) {
        for (int i = 0; i < greek.length; ++i) {
            try {
                while (string.toLowerCase().indexOf("&" + greek[i] + ";") != -1) {
                    string = string.substring(0, string.toLowerCase().indexOf("&" + greek[i] + ";")) + (char)(945 + i) + string.substring(string.toLowerCase().indexOf("&" + greek[i] + ";") + greek[i].length() + 2, string.length());
                }
                continue;
            }
            catch (Exception exception) {
                return string;
            }
        }
        return string;
    }

    public void clearTrace() {
        this.jep.setImage(null);
    }

    public void close() {
        try {
            this.geonextDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextTextDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextBoardDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextEditDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextValueDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextCASDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextCASPointDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextGraphDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.geonextParameterCurveDialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ElementSet copyElementSet(ElementSet elementSet) {
        int n;
        ElementSet elementSet2 = new ElementSet();
        elementSet2.pointCounter = elementSet.pointCounter;
        for (n = 0; n < elementSet.point.size(); ++n) {
            elementSet2.point.addElement(elementSet.point.get(n));
        }
        elementSet2.sliderCounter = elementSet.sliderCounter;
        for (n = 0; n < elementSet.slider.size(); ++n) {
            elementSet2.slider.addElement(elementSet.slider.get(n));
        }
        elementSet2.lineCounter = elementSet.lineCounter;
        for (n = 0; n < elementSet.line.size(); ++n) {
            elementSet2.line.addElement(elementSet.line.get(n));
        }
        elementSet2.circleCounter = elementSet.circleCounter;
        for (n = 0; n < elementSet.circle.size(); ++n) {
            elementSet2.circle.addElement(elementSet.circle.get(n));
        }
        elementSet2.arrowCounter = elementSet.arrowCounter;
        for (n = 0; n < elementSet.arrow.size(); ++n) {
            elementSet2.arrow.addElement(elementSet.arrow.get(n));
        }
        elementSet2.intersectionCounter = elementSet.intersectionCounter;
        for (n = 0; n < elementSet.intersection.size(); ++n) {
            elementSet2.intersection.addElement(elementSet.intersection.get(n));
        }
        elementSet2.polygonCounter = elementSet.polygonCounter;
        for (n = 0; n < elementSet.polygon.size(); ++n) {
            elementSet2.polygon.addElement(elementSet.polygon.get(n));
        }
        elementSet2.graphCounter = elementSet.graphCounter;
        for (n = 0; n < elementSet.graph.size(); ++n) {
            elementSet2.graph.addElement(elementSet.graph.get(n));
        }
        elementSet2.groupCounter = elementSet.groupCounter;
        for (n = 0; n < elementSet.group.size(); ++n) {
            elementSet2.group.addElement(elementSet.group.get(n));
        }
        elementSet2.compositionCounter = elementSet.compositionCounter;
        for (n = 0; n < elementSet.composition.size(); ++n) {
            elementSet2.composition.addElement(elementSet.composition.get(n));
        }
        elementSet2.textCounter = elementSet.textCounter;
        for (n = 0; n < elementSet.text.size(); ++n) {
            elementSet2.text.addElement(elementSet.text.get(n));
        }
        elementSet2.traceCurveCounter = elementSet.traceCurveCounter;
        for (n = 0; n < elementSet.traceCurve.size(); ++n) {
            elementSet2.traceCurve.addElement(elementSet.traceCurve.get(n));
        }
        elementSet2.angleCounter = elementSet.angleCounter;
        for (n = 0; n < elementSet.angle.size(); ++n) {
            elementSet2.angle.addElement(elementSet.angle.get(n));
        }
        elementSet2.parameterCurveCounter = elementSet.parameterCurveCounter;
        for (n = 0; n < elementSet.parameterCurve.size(); ++n) {
            elementSet2.parameterCurve.addElement(elementSet.parameterCurve.get(n));
        }
        elementSet2.counter = elementSet.counter;
        for (n = 0; n < elementSet.elements.size(); ++n) {
            elementSet2.elements.addElement(elementSet.elements.get(n));
            elementSet2.elements2.addElement(elementSet.elements2.get(n));
        }
        return elementSet2;
    }

    public void createAngle(Point point, Point point2, Point point3, String string, boolean bl) {
        if (!(point.equals(point3) || point.equals(point2) || point3.equals(point2))) {
            this.setSaved(false);
            Angle angle = new Angle(this.internalName, this.element.counter, point, point2, point3, 210010);
            angle.setComposition(false);
            this.element.setName(angle, string);
            angle.initNameText(this);
            this.element.add(angle);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            angle.setAncestor();
        }
    }

    public void createArc(Point point, Point point2, Point point3, String string, boolean bl) {
        Arc arc = new Arc(this.internalName, this.element.counter, point2, point, point3, 210020);
        this.setSaved(false);
        arc.setTrace(bl);
        arc.setComposition(false);
        if (point2.isActive() && point.isActive() && point3.isActive()) {
            arc.setActive(true);
        } else {
            arc.setActive(false);
        }
        this.element.setName(arc, string);
        arc.initNameText(this);
        this.element.add(arc);
        this.jep.addMouseMotionListener(arc);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        arc.setAncestor();
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
    }

    public void createArrow(Point point, Point point2, String string, boolean bl) {
        if (!point.equals(point2)) {
            Arrow arrow = new Arrow(this.internalName, this.element.counter, point, point2, 210040);
            this.setSaved(false);
            arrow.setTrace(bl);
            arrow.setComposition(false);
            if (point.isActive() && point2.isActive()) {
                arrow.setActive(true);
            } else {
                arrow.setActive(false);
            }
            this.element.setName(arrow, string);
            arrow.initNameText(this);
            this.element.add(arrow);
            this.jep.addMouseMotionListener(arrow);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            arrow.setAncestor();
        }
        this.getSelectedLine().setA(null);
        this.getSelectedLine().setB(null);
    }

    public void createCASPoint(String string, String string2, String string3, boolean bl) {
        try {
            this.setSaved(false);
            CASPoint cASPoint = new CASPoint(this.internalName, this.element.counter, string, string2, 210050);
            cASPoint.setTrace(bl);
            cASPoint.setComposition(false);
            this.element.setName(cASPoint, string3);
            cASPoint.initNameText(this);
            this.element.add(cASPoint);
            this.calculateElements();
            this.jep.addMouseMotionListener(cASPoint);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            cASPoint.setAncestor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createCircle(Point point, Circle circle, String string, boolean bl) {
        this.setSaved(false);
        Circle circle2 = new Circle(this.internalName, this.element.counter, point, circle, 81);
        circle2.setTrace(bl);
        circle2.setComposition(false);
        if (point.isActive() && circle.isActive()) {
            circle2.setActive(true);
        } else {
            circle2.setActive(false);
        }
        this.element.setName(circle2, string);
        circle2.initNameText(this);
        this.element.add(circle2);
        this.jep.addMouseMotionListener(circle2);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        circle2.setAncestor();
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
    }

    public void createCircle(Point point, Line line, Line line2, String string, boolean bl) {
        this.setSaved(false);
        Circle circle = new Circle(this.internalName, this.element.counter, point, line, line2, 0);
        circle.setTrace(bl);
        circle.setComposition(false);
        if (point.isActive() && line.isActive() && line.isActive()) {
            circle.setActive(true);
        } else {
            circle.setActive(false);
        }
        this.element.setName(circle, string);
        circle.initNameText(this);
        this.element.add(circle);
        this.jep.addMouseMotionListener(circle);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        circle.setAncestor();
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
    }

    public void createCircle(Point point, Line line, String string, boolean bl) {
        this.setSaved(false);
        Circle circle = new Circle(this.internalName, this.element.counter, point, line, 81);
        circle.setTrace(bl);
        circle.setComposition(false);
        if (point.isActive() && line.isActive()) {
            circle.setActive(true);
        } else {
            circle.setActive(false);
        }
        this.element.setName(circle, string);
        circle.initNameText(this);
        this.element.add(circle);
        this.jep.addMouseMotionListener(circle);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        circle.setAncestor();
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
    }

    public void createCircle(Point point, Point point2, String string, boolean bl) {
        if (!point.equals(point2)) {
            this.setSaved(false);
            Circle circle = new Circle(this.internalName, this.element.counter, point, point2, 67);
            circle.setTrace(bl);
            circle.setComposition(false);
            if (point.isActive() && point2.isActive()) {
                circle.setActive(true);
            } else {
                circle.setActive(false);
            }
            this.element.setName(circle, string);
            circle.initNameText(this);
            this.element.add(circle);
            this.jep.addMouseMotionListener(circle);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            circle.setAncestor();
        }
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
    }

    public void createCircle(Point point, String string, String string2, boolean bl) {
        try {
            C.boardName = this.internalName;
            Circle circle = new Circle(this.internalName, this.element.counter, point, string, 210060);
            circle.calculate(this, true);
            if (circle.isActive()) {
                circle.setTrace(bl);
                circle.setComposition(false);
                if (point.isActive()) {
                    circle.setActive(true);
                } else {
                    circle.setActive(false);
                }
                this.element.setName(circle, string2);
                circle.initNameText(this);
                this.element.add(circle);
                this.jep.addMouseMotionListener(circle);
                this.undo.addEdit(this.copyElementSet(this.element));
                circle.setAncestor();
                circle.calculate(this, true);
                this.setSaved(false);
                if (this.getGeonextEditDialog() != null) {
                    this.getGeonextEditDialog().jce.refreshList();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createComposition(int n, Vector vector, String string, boolean bl) {
        Composition composition = new Composition(this.internalName, this.element.counter, n, vector);
        if (composition.elements.size() > 0) {
            int n2;
            for (n2 = 0; n2 < composition.elements.size(); ++n2) {
                if (!(composition.elements.get(n2) instanceof Point)) continue;
                ((Point)composition.elements.get(n2)).setMovable(false);
            }
            this.setSaved(false);
            for (n2 = 0; n2 < composition.elements.size(); ++n2) {
                Element element = (Element)composition.elements.get(n2);
                element.setParent(composition);
                element.setId(composition.getId() + "c" + n2);
                element.setComposition(true);
                this.element.add(element);
                this.element.setName(element, "");
                element.initNameText(this);
                this.jep.addMouseMotionListener(element);
            }
            composition.calculate(this, true);
            this.element.setName(composition, string);
            composition.initNameText(this);
            this.element.add(composition);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            composition.setAncestor();
            for (n2 = 0; n2 < composition.elements.size(); ++n2) {
                ((Element)composition.elements.get((int)n2)).ancestor = composition.getAncestor();
                ((Element)composition.elements.get(n2)).getAncestor().addElement(composition);
            }
        }
    }

    public void createElement(Vector vector, String string, boolean bl) {
        this.setSaved(false);
        this.data.setActive(false);
        this.selection = new Vector();
        this.setSelectedElement(null);
        switch (this.getModus()) {
            case 210030: 
            case 210060: {
                if (this.geonextValueDialog == null) {
                    this.geonextValueDialog = new JFrameDialog("", new Dimension(550, 150), 14, this, vector, false, false, true, true);
                }
                this.showGeonextDialog(this.geonextValueDialog);
                break;
            }
            case 210340: {
                if (vector.get(0) instanceof Slider) {
                    this.createTraceCurve((Slider)vector.get(0), (Point)vector.get(1), string, bl);
                    break;
                }
                this.createTraceCurve((Slider)vector.get(1), (Point)vector.get(0), string, bl);
                break;
            }
            case 210300: {
                this.createSlider((Element)vector.get(0), string, bl);
                break;
            }
            case 76: 
            case 210240: 
            case 210250: {
                this.createLine((Point)vector.get(0), (Point)vector.get(1), string, bl);
                break;
            }
            case 210330: {
                Point point;
                if (vector.get(0) instanceof Line) {
                    Line line = (Line)vector.get(0);
                    if (!line.isEditable()) break;
                    this.createText(0.0, 0.0, "<overline>" + line.getA().getName() + line.getB().getName() + "</overline>" + "" + " = <value>Dist(" + line.getA().getName() + "," + line.getB().getName() + ")</value>", line);
                    break;
                }
                Point point2 = (Point)vector.get(0);
                if (point2 == (point = (Point)vector.get(1))) break;
                Line line = new Line(point2, point, 0, 0);
                double d = line.getTextAnchor().getWidth() - point2.getUserX();
                double d2 = line.getTextAnchor().getHeight() - point2.getUserY();
                this.createText(d, d2, "<overline>" + point2.getName() + point.getName() + "</overline>" + "" + " = <value>Dist(" + point2.getName() + "," + point.getName() + ")</value>", point2);
                break;
            }
            case 210320: {
                Point point = (Point)vector.get(0);
                Point point3 = (Point)vector.get(1);
                Point point4 = (Point)vector.get(2);
                if (point == point3 || point4 == point3) break;
                double d = 0.25;
                double d3 = 0.25;
                this.createText(d, d3, "<arc><name>" + point.getName() + "</name><name>" + point3.getName() + "</name><name>" + point4.getName() + "</name> = <value>Deg(" + point.getName() + "," + point3.getName() + "," + point4.getName() + ")</value>" + "\u00b0", point3);
                break;
            }
            case 210010: {
                this.createAngle((Point)vector.get(0), (Point)vector.get(1), (Point)vector.get(2), string, bl);
                break;
            }
            case 210020: {
                this.createArc((Point)vector.get(0), (Point)vector.get(1), (Point)vector.get(2), string, bl);
                break;
            }
            case 67: {
                this.createCircle((Point)vector.get(0), (Point)vector.get(1), string, bl);
                break;
            }
            case 81: {
                if (vector.get(0) instanceof Point) {
                    if (vector.get(1) instanceof Line) {
                        this.createCircle((Point)vector.get(0), (Line)vector.get(1), string, bl);
                        break;
                    }
                    this.createCircle((Point)vector.get(0), (Circle)vector.get(1), string, bl);
                    break;
                }
                if (vector.get(0) instanceof Line) {
                    this.createCircle((Point)vector.get(1), (Line)vector.get(0), string, bl);
                    break;
                }
                this.createCircle((Point)vector.get(1), (Circle)vector.get(0), string, bl);
                break;
            }
            case 210040: {
                this.createArrow((Point)vector.get(0), (Point)vector.get(1), string, bl);
                break;
            }
            case 88: {
                this.createIntersection((Element)vector.get(0), (Element)vector.get(1), string, bl);
                ((Intersection)this.element.elements.lastElement()).getE().setMoved(true);
                this.calculateElements();
                break;
            }
            default: {
                this.createComposition(this.getModus(), vector, string, bl);
            }
        }
    }

    public void createGraph(String string, String string2, boolean bl) {
        try {
            C.boardName = this.internalName;
            Graph graph = new Graph(this.internalName, this.element.counter, string, this.element.graphCounter + 1, 210210);
            this.jep.redrawGraphs = true;
            this.element.add(graph);
            this.element.setName(graph, string2);
            graph.initNameText(this);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            graph.setAncestor();
            graph.calculate(this, true);
            this.jep.addMouseMotionListener(graph);
            this.setSaved(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createGraphSlider(Element element, String string, boolean bl) {
        try {
            GraphSlider graphSlider = new GraphSlider(this.internalName, this.element.counter, element, 210300);
            graphSlider.setTrace(bl);
            graphSlider.setComposition(false);
            double d = this.screen2userX(this.cursorPosition.getWidth());
            double d2 = ((Graph)element).calculate(d);
            if (!this.geonext.wot && this.user2screenY(d2) < 0.0 | this.user2screenY(d2) > (double)this.getHeight()) {
                for (int i = 0; i <= ((Graph)element).area && this.user2screenY(d2 = ((Graph)element).calculate(d = this.screen2userX((double)i + this.cursorPosition.getWidth()))) < 0.0 | this.user2screenY(d2) > (double)this.getHeight() && this.user2screenY(d2 = ((Graph)element).calculate(d = this.screen2userX(this.cursorPosition.getWidth() - (double)i))) < 0.0 | this.user2screenY(d2) > (double)this.getHeight(); ++i) {
                }
            }
            graphSlider.setAncestor();
            this.cursorPosition = this.user2screen(new Coordinates(d, d2));
            graphSlider.setUser(this.screen2user(this.cursorPosition));
            this.user2screen(graphSlider);
            graphSlider.user2sphere();
            graphSlider.storeUser();
            this.element.setName(graphSlider, string);
            graphSlider.initNameText(this);
            this.element.add(graphSlider);
            this.jep.addMouseMotionListener(graphSlider);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            this.setSaved(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createGroup(Vector vector, String string, boolean bl) {
        boolean bl2 = false;
        this.setSaved(false);
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) instanceof Point || ((Point)vector.get(i)).isIntersection()) continue;
            bl2 = true;
        }
        if (!bl2) {
            Group group = new Group(vector, this.element.groupCounter++, 71);
            group.setComposition(bl);
            for (int i = 0; i < group.group.size(); ++i) {
                ((Point)group.group.get(i)).getGroups().addElement(group);
                ((Point)group.group.get(i)).setGroup(true);
            }
            this.element.setName(group, string);
            group.initNameText(this);
            this.element.group.addElement(group);
            this.element.elements.addElement(group);
            this.element.elements2.addElement(group);
        }
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void createIntersection(Element element, Element element2, String string, boolean bl) {
        if (!element.equals(element2)) {
            this.setSaved(false);
            Element element3 = null;
            if (element instanceof Line && element2 instanceof Line) {
                element3 = new Intersection(this.internalName, this.element.counter, element, element2, 0, 88);
            } else if (element instanceof Line && element2 instanceof Circle) {
                element3 = new Intersection(this.internalName, this.element.counter, element, element2, 1, 88);
            } else if (element instanceof Circle && element2 instanceof Line) {
                element3 = new Intersection(this.internalName, this.element.counter, element2, element, 1, 88);
            } else if (element instanceof Circle && element2 instanceof Circle) {
                element3 = new Intersection(this.internalName, this.element.counter, element, element2, 2, 88);
            }
            if (element3 != null) {
                ((Intersection)element3).A.setParent(element3);
                ((Intersection)element3).B.setParent(element3);
                ((Intersection)element3).A.setId(element3.getId() + "i0");
                ((Intersection)element3).B.setId(element3.getId() + "i1");
                element3.setTrace(bl);
                ((Intersection)element3).A.setTrace(bl);
                ((Intersection)element3).B.setTrace(bl);
                element3.setComposition(false);
                ((Intersection)element3).A.setComposition(false);
                ((Intersection)element3).B.setComposition(false);
                ((Intersection)element3).A.setIntersection(true);
                ((Intersection)element3).B.setIntersection(true);
                ((Intersection)element3).A.stroke = ((Intersection)element3).B.stroke = ((Intersection)element3).stroke;
                ((Intersection)element3).A.fill = ((Intersection)element3).B.fill = ((Intersection)element3).fill;
                ((Intersection)element3).A.lighting = ((Intersection)element3).B.lighting = ((Intersection)element3).lighting;
                ((Intersection)element3).A.label = ((Intersection)element3).B.label = ((Intersection)element3).label;
                this.element.setName(element3, string);
                element3.initNameText(this);
                this.element.add(element3);
                this.element.add(((Intersection)element3).A);
                if (((Intersection)element3).getType() != 0) {
                    this.element.add(((Intersection)element3).B);
                }
                this.jep.addMouseMotionListener(((Intersection)element3).A);
                this.jep.addMouseMotionListener(((Intersection)element3).B);
                this.undo.addEdit(this.copyElementSet(this.element));
                if (this.getGeonextEditDialog() != null) {
                    this.getGeonextEditDialog().jce.refreshList();
                }
            }
            element3.setAncestor();
            ((Intersection)element3).A.ancestor = element3.getAncestor();
            ((Intersection)element3).A.ancestor.addElement(element3);
            ((Intersection)element3).B.ancestor = element3.getAncestor();
            ((Intersection)element3).B.ancestor.addElement(element3);
            boolean bl2 = ((Intersection)element3).getE().isMoved();
            ((Intersection)element3).getE().setMoved(true);
            ((Intersection)element3).calculate(true);
            ((Intersection)element3).getE().setMoved(bl2);
        }
        this.setSelectedElement(null);
    }

    public void createLine(Point point, Point point2, String string, boolean bl) {
        if (!point.equals(point2)) {
            this.setSaved(false);
            Line line = new Line(this.internalName, this.element.counter, point, point2, 210250);
            line.setTrace(bl);
            line.setComposition(false);
            switch (this.getModus()) {
                case 76: {
                    line.setFirst(false);
                    line.setLast(false);
                    break;
                }
                case 210240: {
                    line.setFirst(false);
                    line.setLast(true);
                    break;
                }
                case 210250: {
                    line.setFirst(true);
                    line.setLast(true);
                }
            }
            if (point.isActive() && point2.isActive()) {
                line.setActive(true);
            } else {
                line.setActive(false);
            }
            this.element.setName(line, string);
            line.initNameText(this);
            this.element.add(line);
            this.jep.addMouseMotionListener(line);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            line.setAncestor();
        }
        this.getSelectedLine().setA(null);
        this.getSelectedLine().setB(null);
    }

    public double[] createNormedVector(Point point, Point point2) {
        return new double[]{0.0, 0.0};
    }

    public void createParameterCurve(String string, String string2, String string3, String string4, String string5, boolean bl) {
        try {
            C.boardName = this.internalName;
            ParameterCurve parameterCurve = new ParameterCurve(this.internalName, this.element.counter, string, string2, string3, string4, this.element.parameterCurve.size(), 210270);
            this.jep.redrawGraphs = true;
            this.element.add(parameterCurve);
            this.element.setName(parameterCurve, string5);
            parameterCurve.initNameText(this);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            parameterCurve.setAncestor();
            parameterCurve.calculate(this, true);
            this.setSaved(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createPoint(double d, double d2, String string, boolean bl) {
        this.setSaved(false);
        Point point = new Point(this.internalName, this.element.counter, 80);
        point.setTrace(bl);
        point.setComposition(false);
        point.setScreen(d, d2);
        if (this.toCoord) {
            point.setUser(this.toCoordS2U(d, d2));
        } else {
            this.screen2user(point);
        }
        point.user2sphere();
        this.element.setName(point, string);
        point.initNameText(this);
        this.element.add(point);
        this.jep.addMouseMotionListener(point);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void createPolygon(Vector vector, String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) instanceof Point && !bl2) continue;
            if (!((Point)vector.get(i)).isActive()) {
                bl3 = false;
            }
            bl2 = true;
        }
        if (!bl2) {
            Polygon polygon = new Polygon(this.internalName, this.element.counter, vector, 77);
            polygon.setTrace(bl);
            polygon.setComposition(false);
            polygon.setActive(bl3);
            this.element.setName(polygon, string);
            polygon.initNameText(this);
            this.element.add(polygon);
            polygon.setAncestor();
            for (int i = 0; i < polygon.border.length; ++i) {
                Line line = polygon.border[i];
                line.setParent(polygon);
                line.setId(polygon.getId() + "P" + i);
                line.setComposition(true);
                line.setAncestor(polygon.getAncestor());
                this.element.add(line);
                this.element.setName(line, "");
                line.initNameText(this);
                this.jep.addMouseMotionListener(line);
                line.setLabel(new Color(line.getLabel().getRed(), line.getLabel().getGreen(), line.getLabel().getBlue(), 0));
            }
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            this.setSaved(false);
        }
    }

    public void createSlide() {
        Vector<Object> vector = new Vector<Object>();
        Image image = this.isStatusBar() ? this.createImage(this.jep.getWidth(), this.jep.getHeight() - this.jep.getGraphics().getFontMetrics().getHeight() - 3) : this.createImage(this.jep.getWidth(), this.jep.getHeight());
        this.jep.setScreenShot(true);
        this.jep.paint(image.getGraphics());
        this.jep.setScreenShot(false);
        vector.addElement(image);
        vector.addElement(null);
        vector.addElement(new Integer(this.jep.getWidth()));
        vector.addElement(new Integer(this.jep.getHeight()));
        this.slideImage.addElement(vector);
        this.screenshot = new ScreenShot(image);
    }

    public void createSlider(Element element, String string, boolean bl) {
        this.setSaved(false);
        if (element instanceof Graph) {
            this.createGraphSlider(element, string, bl);
        } else {
            Slider slider = new Slider(this.internalName, this.element.counter, element, 210300);
            slider.setTrace(bl);
            slider.setComposition(false);
            slider.setPosition(this.screen2user(this.cursorPosition));
            slider.setUser(this.screen2user(this.cursorPosition));
            this.user2screen(slider);
            slider.user2sphere();
            this.element.setName(slider, string);
            slider.initNameText(this);
            this.element.add(slider);
            this.jep.addMouseMotionListener(slider);
            this.undo.addEdit(this.copyElementSet(this.element));
            if (this.getGeonextEditDialog() != null) {
                this.getGeonextEditDialog().jce.refreshList();
            }
            slider.setAncestor();
        }
    }

    public void createText(double d, double d2, String string, Element element) {
        this.setSaved(false);
        Text text = new Text(this.internalName, this.element.counter, 210310);
        text.setName("T" + this.element.textCounter);
        text.setText(string);
        text.parseHTML(this);
        text.evaluate(this);
        text.setE(element);
        text.setTrace(false);
        text.setComposition(false);
        try {
            text.setUser(new Coordinates(d, d2));
        }
        catch (Exception exception) {
            text.setUser(new Coordinates(0.0, 0.0));
        }
        this.element.add(text);
        this.jep.addMouseMotionListener(text);
        this.undo.addEdit(this.copyElementSet(this.element));
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        text.setAncestor();
    }

    public void createTraceCurve(Slider slider, Point point, String string) {
        TraceCurve traceCurve = new TraceCurve(this.internalName, this.element.counter, slider, point, 210340);
        this.element.setName(traceCurve, string);
        traceCurve.initNameText(this);
        this.element.add(traceCurve);
        traceCurve.setStroke(point.getStroke());
        this.undo.addEdit(this.copyElementSet(this.element));
        traceCurve.setAncestor();
        traceCurve.calculate(this, true);
        this.setSaved(false);
    }

    public void createTraceCurve(Slider slider, Point point, String string, boolean bl) {
        TraceCurve traceCurve = new TraceCurve(this.internalName, this.element.counter, slider, point, 210340);
        traceCurve.setTrace(bl);
        this.element.setName(traceCurve, string);
        traceCurve.initNameText(this);
        this.element.add(traceCurve);
        traceCurve.setStroke(point.getStroke());
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        this.undo.addEdit(this.copyElementSet(this.element));
        traceCurve.setAncestor();
        this.setSaved(false);
        traceCurve.calculate(this, true);
    }

    public String deleteChar(String string, char c) {
        int n;
        while ((n = string.indexOf(c)) > -1) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        return string;
    }

    public void deleteElements(Vector vector) {
        int n;
        int n2;
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.get(i);
            if (element instanceof Polygon) {
                vector.addElement(((Polygon)element).border[0]);
            } else {
                vector2.addElement(element);
            }
            if (element instanceof Text) continue;
            object = this.element.getSubElements(element);
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                if (vector2.contains(((Vector)object).get(n2))) continue;
                vector2.addElement(((Vector)object).get(n2));
            }
        }
        Vector<Object> vector3 = new Vector<Object>();
        for (n = 0; n < vector2.size(); ++n) {
            object = ((Element)vector2.get(n)).getParent();
            if (object instanceof Text || !(object instanceof Intersection) && !(object instanceof Composition) && !(object instanceof Polygon)) continue;
            if (!vector3.contains(object)) {
                vector3.addElement(object);
            }
            if (vector2.contains(object)) continue;
            vector2.addElement(object);
        }
        for (n = 0; n < vector3.size(); ++n) {
            int n3;
            if (vector3.get(n) instanceof Intersection) {
                vector2.remove(((Intersection)vector3.get(n)).getA());
                vector2.remove(((Intersection)vector3.get(n)).getB());
            }
            if (vector3.get(n) instanceof Composition) {
                for (n3 = 0; n3 < ((Composition)vector3.get((int)n)).elements.size(); ++n3) {
                    vector2.remove(((Composition)vector3.get((int)n)).elements.get(n3));
                }
            }
            if (!(vector3.get(n) instanceof Polygon)) continue;
            for (n3 = 0; n3 < ((Polygon)vector3.get((int)n)).border.length; ++n3) {
                vector2.remove(((Polygon)vector3.get((int)n)).border[n3]);
            }
        }
        for (n = 0; n < this.element.text.size(); ++n) {
            if (((Text)this.element.text.get(n)).getE() == null || !vector2.contains(((Text)this.element.text.get(n)).getE())) continue;
            ((Text)this.element.text.get(n)).setUser(new Coordinates(((Text)this.element.text.get(n)).getUser().getWidth() + ((Text)this.element.text.get(n)).getE().getTextAnchor().getWidth(), ((Text)this.element.text.get(n)).getUser().getHeight() + ((Text)this.element.text.get(n)).getE().getTextAnchor().getHeight()));
            ((Text)this.element.text.get(n)).setE(null);
        }
        for (n = 0; n < vector2.size(); ++n) {
            this.element.remove((Element)vector2.get(n));
        }
        if (vector.size() > 0) {
            this.undo.addEdit(this.copyElementSet(this.element));
        }
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
        for (n = 0; n < this.conditions.size(); ++n) {
            Condition condition = (Condition)this.conditions.get(n);
            if (this.element.searchName(condition.el.getName()) == null) {
                this.conditions.setElementAt(null, n);
                continue;
            }
            n2 = 0;
            for (int i = 0; i < condition.dataEl.dataVector.size(); ++i) {
                if (this.element.searchName(((Element)condition.dataEl.dataVector.get(i)).getName()) != null) continue;
                n2 = 1;
            }
            if (n2 == 0) continue;
            this.conditions.setElementAt(null, n);
        }
        while (this.conditions.contains(null)) {
            this.conditions.remove(null);
        }
        if (this.getGeonextBoardDialog() != null) {
            this.getGeonextBoardDialog().reset();
        }
    }

    public String descImage(String string, boolean bl, boolean bl2) {
        if (!bl2) {
            return "";
        }
        String string2 = this.getClass().getResource("about.html").toString();
        string2 = string2.substring(0, string2.indexOf("about.html"));
        String string3 = "<img src=\"" + string2 + "" + string + "\"";
        if (bl) {
            string3 = string3 + "border=\"1\"";
        }
        string3 = string3 + " >";
        return string3;
    }

    public String description(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = string + "<html>\r\n";
            string = string + this.geonext.getHTMLHead();
            string = string + "\t<body>\r\n";
        }
        string = string + "\t\t<h2>" + Geonext.language.getString("jboardpane_description_header") + "</h2>\r\n";
        string = string + "\t\t<ol>\r\n";
        for (int i = 5; i < this.element.elements.size(); ++i) {
            Element element = (Element)this.element.elements.get(i);
            string = bl2 ? string + "\t\t\t<li><table><tr><td valign=\"top\">" + this.descImage("24/" + new BoardEvent().getKey(element.getElementKey()).toLowerCase() + ".gif", true, true) + "</td><td>" : string + "\t\t\t<li>";
            string = string + element.description();
            if (!element.isVisible()) {
                string = string + " [<i>" + Geonext.language.getString("jboardpane_description_hidden") + "</i>]";
            }
            string = bl2 ? string + "</td></tr></table><p>\r\n" : string + "<p>\r\n";
        }
        string = string + "\t\t</ol>\r\n";
        if (bl) {
            string = string + "\t</body>\r\n";
            string = string + "</html>\r\n";
        }
        return string;
    }

    public String digitString(double d, int n, boolean bl) {
        String string = "" + this.digits(d, n, bl);
        if (!bl && n == 0 && string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public double digits(double d, int n, boolean bl) {
        if (bl) {
            int n2 = this.round(this.user2screenX(1.0) - this.origin.getWidth());
            String string = "" + n2;
            n2 = string.length();
            n2 = this.round(Math.pow(10.0, n2));
            d = (double)Math.round(this.round(d * (double)n2)) / (double)n2;
            return d;
        }
        double d2 = this.round(Math.pow(10.0, n));
        return (double)Math.round(this.round(d * d2)) / d2;
    }

    public double distance(Point point, Point point2) {
        return 0.0;
    }

    public double distance2D(Point point, Point point2) {
        return 0.0;
    }

    public void drawCircle(Graphics2D graphics2D, Point point, int n, int n2, Color color) {
        try {
            Point point2 = point;
            double d = Math.sqrt((point2.getScreenX() - (double)n) * (point2.getScreenX() - (double)n) + (point2.getScreenY() - (double)n2) * (point2.getScreenY() - (double)n2));
            double d2 = Math.atan(1.0 / d) * 5.0;
            int n3 = this.round(Math.PI / (2.0 * d2)) + 1;
            graphics2D.setColor(color);
            double d3 = d;
            double d4 = 0.0;
            double d5 = point2.getScreenX();
            double d6 = point2.getScreenY();
            for (int i = 0; i <= n3; ++i) {
                double d7 = this.round(d * Math.cos((double)(i + 1) * d2));
                double d8 = this.round(d * Math.sin((double)(i + 1) * d2));
                graphics2D.drawLine(this.round(d5 + d3), this.round(d6 + d4), this.round(d5 + d7), this.round(d6 + d8));
                graphics2D.drawLine(this.round(d5 - d3), this.round(d6 + d4), this.round(d5 - d7), this.round(d6 + d8));
                graphics2D.drawLine(this.round(d5 - d3), this.round(d6 - d4), this.round(d5 - d7), this.round(d6 - d8));
                graphics2D.drawLine(this.round(d5 + d3), this.round(d6 - d4), this.round(d5 + d7), this.round(d6 - d8));
                d3 = d7;
                d4 = d8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawCircle(Graphics2D graphics2D, Point point, Point point2, Color color, Color color2, boolean bl, int n) {
        n = 0;
        try {
            double d;
            double d2;
            int n2;
            Point point3 = point;
            Point point4 = point2;
            double d3 = Math.sqrt((point3.getUserX() - point4.getUserX()) * (point3.getUserX() - point4.getUserX()) + (point3.getUserY() - point4.getUserY()) * (point3.getUserY() - point4.getUserY()));
            double d4 = Math.atan(1.0 / d3) * 0.1;
            int n3 = (int)(Math.PI * 2 / d4) + 1;
            double d5 = d3;
            double d6 = 0.0;
            double d7 = point3.getUserX();
            double d8 = point3.getUserY();
            java.awt.Polygon polygon = new java.awt.Polygon();
            for (int i = 0; i <= n3; ++i) {
                double d9 = d3 * Math.cos((double)(i + 1) * d4);
                double d10 = d3 * Math.sin((double)(i + 1) * d4);
                polygon.addPoint(this.round(this.user2screenX(d7 + d5)), this.round(this.user2screenY(d8 + d6)));
                d5 = d9;
                d6 = d10;
            }
            java.awt.Polygon polygon2 = new java.awt.Polygon();
            for (n2 = 0; n2 <= n3; ++n2) {
                d2 = (d3 + (double)n) * Math.cos((double)(n2 + 1) * d4);
                d = (d3 + (double)n) * Math.sin((double)(n2 + 1) * d4);
                polygon2.addPoint(this.round(this.user2screenX(d7 + d5)), this.round(this.user2screenY(d8 + d6)));
                d5 = d2;
                d6 = d;
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                d2 = (d3 - (double)n) * Math.cos((double)(n2 + 1) * d4);
                d = (d3 - (double)n) * Math.sin((double)(n2 + 1) * d4);
                polygon2.addPoint(this.round(this.user2screenX(d7 + d5)), this.round(this.user2screenY(d8 + d6)));
                d5 = d2;
                d6 = d;
            }
            if (!bl) {
                graphics2D.setColor(color2);
                graphics2D.fillPolygon(polygon);
            }
            graphics2D.setColor(color);
            graphics2D.drawPolygon(polygon2);
            graphics2D.fillPolygon(polygon2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawCoordinates(Graphics2D graphics2D) {
        int n;
        graphics2D.setStroke(this.setStroke(1, 0));
        graphics2D.setColor(Color.gray);
        Coordinates coordinates = this.screen2user(new Coordinates(0.0, 0.0));
        Coordinates coordinates2 = this.screen2user(new Coordinates(this.getWidth(), this.getHeight()));
        double d = coordinates.getWidth();
        double d2 = coordinates.getHeight();
        double d3 = coordinates2.getWidth();
        double d4 = coordinates2.getHeight();
        Coordinates coordinates3 = new Coordinates(Math.sqrt((d - d3) * (d - d3)), Math.sqrt((d2 - d4) * (d2 - d4)));
        int n2 = this.round(coordinates3.getWidth());
        int n3 = this.round(coordinates3.getHeight());
        if ((double)n2 > coordinates3.getWidth()) {
            --n2;
        }
        if ((double)n3 < coordinates3.getHeight()) {
            ++n3;
        }
        int n4 = this.round(d);
        int n5 = this.round(d2);
        if ((double)n4 < d) {
            ++n4;
        }
        if ((double)n5 > d2) {
            --n5;
        }
        String string = "";
        if (this.isCoordXMultiple()) {
            string = this.changeChar(this.coordXMulti);
        }
        int n6 = 1;
        while (true) {
            if (!((double)graphics2D.getFontMetrics().stringWidth(n4 + " " + string) > (double)n6 * (this.user2screenX(0.75) - this.origin.getWidth()))) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!((double)graphics2D.getFontMetrics().stringWidth(stringBuffer.append(n4 + n2).append(" ").append(string).toString()) > (double)n6 * (this.user2screenX(0.75) - this.origin.getWidth()))) break;
            }
            n6 = n6 == 1 ? 2 : (n6 == 2 ? 5 : (n6 == 5 ? 10 : (n6 == 10 ? 20 : (n6 == 20 ? 50 : (n6 == 50 ? 100 : 100 + n6)))));
        }
        for (int i = -1; i < n2 + 1; ++i) {
            coordinates = this.user2screen(new Coordinates(n4 + i, 0.0));
            if ((n4 + i) % n6 == 0) {
                graphics2D.drawLine(this.round(coordinates.getWidth()), this.round(coordinates.getHeight()), this.round(coordinates.getWidth()), this.round(coordinates.getHeight() + 4.0));
            } else if (this.user2screenX(1.0) - this.origin.getWidth() > 5.0) {
                graphics2D.drawLine(this.round(coordinates.getWidth()), this.round(coordinates.getHeight()), this.round(coordinates.getWidth()), this.round(coordinates.getHeight() + 2.0));
            }
            if (this.isCoordXContinuous()) continue;
            String string2 = "";
            string2 = n4 + i != 0 ? n4 + i + " " + string : "" + (n4 + i);
            if ((n4 + i) % n6 != 0) continue;
            n = graphics2D.getFontMetrics().stringWidth(string2);
            int n7 = graphics2D.getFontMetrics().getHeight();
            if (this.isCoordGrid() || n4 + i == 0) {
                graphics2D.drawString(string2, this.round(coordinates.getWidth() + 5.0), this.round(coordinates.getHeight()) + n7);
                continue;
            }
            graphics2D.drawString(string2, this.round(coordinates.getWidth() - (double)(n / 2)), this.round(coordinates.getHeight()) + n7);
        }
        String string3 = "";
        if (this.isCoordYMultiple()) {
            string3 = this.changeChar(this.coordYMulti);
        }
        int n8 = 1;
        while ((double)graphics2D.getFontMetrics().getHeight() > (double)n8 * (this.user2screenY(-0.5) - this.origin.getHeight())) {
            n8 = n8 == 1 ? 2 : (n8 == 2 ? 5 : (n8 == 5 ? 10 : (n8 == 10 ? 20 : (n8 == 20 ? 50 : (n8 == 50 ? 100 : 100 + n8)))));
        }
        for (n = 0; n < n3; ++n) {
            coordinates2 = this.user2screen(new Coordinates(0.0, n5 - n));
            if ((n5 - n) % n8 == 0) {
                graphics2D.drawLine(this.round(coordinates2.getWidth() - 4.0), this.round(coordinates2.getHeight()), this.round(coordinates2.getWidth()), this.round(coordinates2.getHeight()));
            } else if (this.user2screenY(-1.0) - this.origin.getHeight() > 5.0) {
                graphics2D.drawLine(this.round(coordinates2.getWidth() - 2.0), this.round(coordinates2.getHeight()), this.round(coordinates2.getWidth()), this.round(coordinates2.getHeight()));
            }
            if (this.isCoordYContinuous()) continue;
            String string4 = "";
            string4 = n5 - n != 0 ? n5 - n + " " + string3 : "" + (n5 - n);
            if ((n5 - n) % n8 != 0) continue;
            int n9 = graphics2D.getFontMetrics().stringWidth(string4);
            int n10 = graphics2D.getFontMetrics().getHeight();
            if (this.isCoordGrid() || n5 - n == 0) {
                graphics2D.drawString(string4, this.round(coordinates2.getWidth() - (double)n9 - 5.0), this.round(coordinates2.getHeight() - 2.0));
                continue;
            }
            graphics2D.drawString(string4, this.round(coordinates2.getWidth() - (double)n9 - 5.0), this.round(coordinates2.getHeight() + (double)(n10 / 2) - 2.0));
        }
        coordinates = this.user2screen(new Coordinates(0.0, 0.0));
        n = this.round(coordinates.getWidth());
        int n11 = this.round(coordinates.getHeight());
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(this.round(this.getWidth()) - 7, n11 - 6, 8, 13);
        graphics2D.fillRect(n - 6, 0, 13, 7);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(this.round(this.getWidth()) - 1, n11, this.round(this.getWidth()) - 6, n11 - 5);
        graphics2D.drawLine(this.round(this.getWidth()) - 1, n11, this.round(this.getWidth()) - 6, n11 + 5);
        graphics2D.drawLine(this.round(this.getWidth()) - 2, n11, this.round(this.getWidth()) - 6, n11 - 4);
        graphics2D.drawLine(this.round(this.getWidth()) - 2, n11, this.round(this.getWidth()) - 6, n11 + 4);
        graphics2D.drawLine(n, 0, n - 5, 5);
        graphics2D.drawLine(n, 0, n + 5, 5);
        graphics2D.drawLine(n, 1, n - 4, 5);
        graphics2D.drawLine(n, 1, n + 4, 5);
        graphics2D.drawLine(this.round(coordinates.getWidth()), 0, this.round(coordinates.getWidth()), this.getHeight());
        graphics2D.drawLine(0, this.round(coordinates.getHeight()), this.getWidth(), this.round(coordinates.getHeight()));
        graphics2D.drawString(this.coordXLabel, this.round(this.getWidth()) - graphics2D.getFontMetrics().stringWidth(this.coordXLabel) - 8, this.round(coordinates.getHeight()) - 5);
        graphics2D.drawString(this.coordYLabel, this.round(coordinates.getWidth()) + 7, graphics2D.getFontMetrics().getHeight());
    }

    public void drawGrid(Graphics2D graphics2D) {
        if (this.isGridDash()) {
            graphics2D.setStroke(this.setStroke(1, 1));
        } else {
            graphics2D.setStroke(this.setStroke(1, 0));
        }
        Color color = new Color(128, 128, 128);
        color = this.isToCoord() ? Color.pink : this.getGridColor();
        graphics2D.setColor(color);
        Coordinates coordinates = this.screen2user(new Coordinates(0.0, 0.0));
        Coordinates coordinates2 = this.screen2user(new Coordinates(this.getWidth(), this.getHeight()));
        double d = coordinates.getWidth();
        double d2 = coordinates.getHeight();
        double d3 = coordinates2.getWidth();
        double d4 = coordinates2.getHeight();
        Coordinates coordinates3 = new Coordinates(Math.sqrt((d - d3) * (d - d3)), Math.sqrt((d2 - d4) * (d2 - d4)));
        int n = this.round(coordinates3.getWidth());
        int n2 = this.round(coordinates3.getHeight());
        if ((double)n > coordinates3.getWidth()) {
            --n;
        }
        if ((double)n2 < coordinates3.getHeight()) {
            ++n2;
        }
        int n3 = this.round(d);
        int n4 = this.round(d2);
        if ((double)n3 < d) {
            ++n3;
        }
        if ((double)n4 > d2) {
            --n4;
        }
        double d5 = this.user2screen(new Coordinates(0.0, 0.0)).distance(this.user2screen(new Coordinates(1.0, 0.0)));
        double d6 = this.user2screen(new Coordinates(0.0, 0.0)).distance(this.user2screen(new Coordinates(0.0, 1.0)));
        String string = "";
        if (this.isCoordXMultiple()) {
            string = this.changeChar(this.coordXMulti);
        }
        String string2 = "";
        if (this.isCoordYMultiple()) {
            string2 = this.changeChar(this.coordYMulti);
        }
        if (this.isCross() && this.isCoordGrid()) {
            for (int i = -1; i < n + 1; ++i) {
                for (int j = -1; j < n2; ++j) {
                    coordinates = this.user2screen(new Coordinates(n3 + i, 0.0));
                    coordinates2 = this.user2screen(new Coordinates(0.0, n4 - j));
                    int n5 = 0;
                    while ((double)n5 < this.getSubGrid().getWidth()) {
                        int n6 = 0;
                        while ((double)n6 < this.getSubGrid().getHeight()) {
                            if (d5 > 10.0 * this.getSubGrid().getWidth()) {
                                graphics2D.drawLine(this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n5), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n6 - 3.0), this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n5), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n6 + 3.0));
                            }
                            if (d6 > 10.0 * this.getSubGrid().getHeight()) {
                                graphics2D.drawLine(this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n5 - 3.0), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n6), this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n5 + 3.0), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n6));
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                }
            }
        } else {
            String string3;
            int n7;
            int n8;
            if (d5 > 10.0 * this.getSubGrid().getWidth()) {
                if (this.isCoordGrid()) {
                    for (n8 = -1; n8 < n + 1; ++n8) {
                        coordinates = this.user2screen(new Coordinates(n3 + n8, 0.0));
                        n7 = 0;
                        while ((double)n7 < this.getSubGrid().getWidth()) {
                            graphics2D.drawLine(this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n7), 0, this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n7), this.getHeight());
                            ++n7;
                        }
                    }
                } else {
                    graphics2D.setColor(Color.lightGray);
                    for (n8 = -1; n8 < n + 1; ++n8) {
                        coordinates = this.user2screen(new Coordinates(n3 + n8, 0.0));
                        n7 = 0;
                        while ((double)n7 < this.getSubGrid().getWidth()) {
                            graphics2D.drawLine(this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n7), this.round(coordinates.getHeight()), this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n7), this.round(coordinates.getHeight()) + 3);
                            if (d5 > 100.0 && (double)n7 % this.getSubGrid().getWidth() != 0.0) {
                                string3 = this.digitString((double)(n3 + n8) + (double)n7 * (1.0 / this.getSubGrid().getWidth()), 0, true) + " " + string;
                                String string4 = "---" + Math.abs(this.digits((double)(n3 + n8) + (double)n7 * (1.0 / this.getSubGrid().getWidth()), 0, true)) + " " + string;
                                if ((double)graphics2D.getFontMetrics().stringWidth(string4) < d5 / this.getSubGrid().getWidth()) {
                                    graphics2D.drawString(string3, this.round(coordinates.getWidth() + d5 / this.getSubGrid().getWidth() * (double)n7 - (double)(graphics2D.getFontMetrics().stringWidth(string3) / 2)), graphics2D.getFontMetrics().getHeight() + this.round(coordinates.getHeight()));
                                }
                            }
                            ++n7;
                        }
                    }
                    graphics2D.setColor(color);
                }
            }
            if (d6 > 10.0 * this.getSubGrid().getHeight()) {
                if (this.isCoordGrid()) {
                    for (n8 = -1; n8 < n2; ++n8) {
                        coordinates2 = this.user2screen(new Coordinates(0.0, n4 - n8));
                        n7 = 0;
                        while ((double)n7 < this.getSubGrid().getHeight()) {
                            graphics2D.drawLine(0, this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n7), this.getWidth(), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n7));
                            ++n7;
                        }
                    }
                } else {
                    graphics2D.setColor(Color.lightGray);
                    for (n8 = -1; n8 < n2; ++n8) {
                        coordinates2 = this.user2screen(new Coordinates(0.0, n4 - n8));
                        n7 = 0;
                        while ((double)n7 < this.getSubGrid().getHeight()) {
                            graphics2D.drawLine(this.round(coordinates2.getWidth()) - 4, this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n7), this.round(coordinates2.getWidth()), this.round(coordinates2.getHeight() + d6 / this.getSubGrid().getHeight() * (double)n7));
                            if (d6 > 100.0 && (double)n7 % this.getSubGrid().getHeight() != 0.0) {
                                string3 = this.digitString((double)(n4 - n8) + (this.getSubGrid().getHeight() - (double)n7) * (1.0 / this.getSubGrid().getHeight()), 0, true) + " " + string2;
                                if ((double)graphics2D.getFontMetrics().getHeight() < d6 / this.getSubGrid().getHeight()) {
                                    graphics2D.drawString(string3, this.round(coordinates2.getWidth() - (double)graphics2D.getFontMetrics().stringWidth(string3) - 5.0), this.round(coordinates2.getHeight() - d6 + (double)n7 * d6 / this.getSubGrid().getHeight() + (double)(graphics2D.getFontMetrics().getHeight() / 2) - 2.0));
                                }
                            }
                            ++n7;
                        }
                    }
                    graphics2D.setColor(color);
                }
            }
        }
    }

    public void drawName(Graphics2D graphics2D, Text text, int n, int n2, Color color, int n3, int n4) {
        try {
            text.setLabel(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            text.draw(graphics2D, n, n2, this, n3, n4 + this.fontSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawName(Graphics2D graphics2D, String string, int n, int n2, Color color, int n3, int n4) {
        graphics2D.setStroke(this.setStroke(1, 0));
        graphics2D.setColor(color);
        string = this.changeChar(string);
        new DrawText(string).draw(graphics2D, n, n2, n3, n4 + this.fontSize);
    }

    public void drawNewArc(Graphics2D graphics2D) {
        Point point = new Point();
        point.setStroke(Color.lightGray);
        point.setScreen(this.cursorPosition);
        this.screen2user(point);
        if (this.selection.size() == 1) {
            Circle circle = new Circle("", 0, (Point)this.selection.get(0), point, 0);
            circle.setStroke(Color.lightGray);
            circle.draw(graphics2D, this);
            Line line = new Line("", 0, (Point)this.selection.get(0), point, 0);
            line.setStroke(Color.lightGray);
            line.draw(graphics2D, this);
            point.draw(graphics2D, this);
        } else {
            Arc arc = new Arc("", 0, (Point)this.selection.get(1), (Point)this.selection.get(0), point, 0);
            arc.setStroke(Color.lightGray);
            arc.draw(graphics2D, this);
            point.draw(graphics2D, this);
        }
    }

    public void drawNewArrow(Graphics2D graphics2D) {
        Point point = new Point();
        point.setStroke(Color.lightGray);
        point.setScreen(this.cursorPosition);
        this.screen2user(point);
        Arrow arrow = new Arrow("", 0, (Point)this.selection.get(0), point, 0);
        arrow.setStroke(Color.lightGray);
        arrow.draw(graphics2D, this);
        point.draw(graphics2D, this);
        if (this.isCoord()) {
            int n;
            int n2;
            String string = "l = " + this.digitString(point.userDistance((Point)this.getSelectedElement()), 0, true);
            double d = this.cursorPosition.getWidth() - ((Point)this.getSelectedElement()).getScreenX();
            double d2 = this.cursorPosition.getHeight() - ((Point)this.getSelectedElement()).getScreenY();
            double d3 = Math.sqrt(d * d + d2 * d2);
            Rectangle rectangle = new Rectangle(graphics2D.getFontMetrics().stringWidth(string), graphics2D.getFontMetrics().getHeight() - graphics2D.getFontMetrics().getDescent());
            if ((double)(rectangle.width + 15) < d3) {
                n2 = this.round(((Point)this.getSelectedElement()).getScreenX() + (d - (double)rectangle.width) / 2.0);
                n = this.round(((Point)this.getSelectedElement()).getScreenY() + (d2 - (double)rectangle.height) / 2.0);
            } else {
                n2 = this.round(this.cursorPosition.getWidth()) + 7;
                n = this.round(this.cursorPosition.getHeight()) + 7;
            }
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n2, n, rectangle.width + 4, rectangle.height);
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawRect(n2, n, rectangle.width + 4, rectangle.height);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n2 + 2, n - 2 + rectangle.height);
        }
    }

    public void drawNewCircle(Graphics2D graphics2D) {
        Point point = new Point();
        point.setStroke(Color.lightGray);
        point.setScreen(this.cursorPosition);
        this.screen2user(point);
        if (this.getModus() == 67) {
            Circle circle = new Circle("", 0, (Point)this.selection.get(0), point, 0);
            circle.setStroke(Color.lightGray);
            circle.draw(graphics2D, this);
            Line line = new Line("", 0, (Point)this.selection.get(0), point, 0);
            line.setStroke(Color.lightGray);
            line.draw(graphics2D, this);
            point.draw(graphics2D, this);
            if (this.isCoord()) {
                int n;
                int n2;
                String string = Geonext.language.getString("jboardpane_new_line_circle") + " = " + this.digitString(point.userDistance((Point)this.getSelectedElement()), 0, true);
                double d = this.cursorPosition.getWidth() - ((Point)this.getSelectedElement()).getScreenX();
                double d2 = this.cursorPosition.getHeight() - ((Point)this.getSelectedElement()).getScreenY();
                double d3 = Math.sqrt(d * d + d2 * d2);
                Rectangle rectangle = new Rectangle(graphics2D.getFontMetrics().stringWidth(string), graphics2D.getFontMetrics().getHeight() - graphics2D.getFontMetrics().getDescent());
                if ((double)(rectangle.width + 15) < d3) {
                    n2 = this.round(((Point)this.getSelectedElement()).getScreenX() + (d - (double)rectangle.width) / 2.0);
                    n = this.round(((Point)this.getSelectedElement()).getScreenY() + (d2 - (double)rectangle.height) / 2.0);
                } else {
                    n2 = this.round(this.cursorPosition.getWidth()) + 7;
                    n = this.round(this.cursorPosition.getHeight()) + 7;
                }
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(n2, n, rectangle.width + 4, rectangle.height);
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawRect(n2, n, rectangle.width + 4, rectangle.height);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n2 + 2, n - 2 + rectangle.height);
            }
        } else if (this.getSelectedElement() instanceof Line) {
            Circle circle = new Circle(this.internalName, -1, point, (Line)this.getSelectedElement(), 0);
            circle.setStroke(Color.lightGray);
            circle.draw(graphics2D, this);
            point.draw(graphics2D, this);
        } else if (this.getSelectedElement() instanceof Circle) {
            Circle circle = new Circle(this.internalName, -1, point, (Circle)this.getSelectedElement(), 0);
            circle.setStroke(Color.lightGray);
            circle.draw(graphics2D, this);
            point.draw(graphics2D, this);
        }
    }

    public void drawNewGroup(Graphics2D graphics2D) {
        graphics2D.setStroke(this.setStroke(1, 0));
        if (this.selection.size() > 0) {
            Group group = new Group(this.selection, 0, 0);
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(group.getX(), group.getY(), group.getWidth(), group.getHeight());
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(group.getX(), group.getY(), group.getWidth(), group.getHeight());
            for (int i = 0; i < this.selection.size(); ++i) {
                graphics2D.setColor(Color.darkGray);
                graphics2D.fillRect(this.round(((Point)this.selection.get(i)).getScreenX() - (double)group.getArea()), this.round(((Point)this.selection.get(i)).getScreenY() - (double)group.getArea()), group.getArea() * 2, group.getArea() * 2);
                graphics2D.setColor(Color.gray);
                graphics2D.drawRect(this.round(((Point)this.selection.get(i)).getScreenX() - (double)group.getArea()), this.round(((Point)this.selection.get(i)).getScreenY() - (double)group.getArea()), group.getArea() * 2, group.getArea() * 2);
            }
        }
    }

    public void drawNewLine(Graphics2D graphics2D) {
        Point point = new Point();
        point.setStroke(Color.lightGray);
        point.setScreen(this.cursorPosition);
        this.screen2user(point);
        Line line = new Line("", 0, (Point)this.selection.get(0), point, 0);
        line.setStroke(Color.lightGray);
        line.draw(graphics2D, this);
        point.draw(graphics2D, this);
        if (this.isCoord()) {
            int n;
            int n2;
            String string = Geonext.language.getString("jboardpane_new_line_circle") + " = " + this.digitString(point.userDistance((Point)this.getSelectedElement()), 0, true);
            double d = this.cursorPosition.getWidth() - ((Point)this.getSelectedElement()).getScreenX();
            double d2 = this.cursorPosition.getHeight() - ((Point)this.getSelectedElement()).getScreenY();
            double d3 = Math.sqrt(d * d + d2 * d2);
            Rectangle rectangle = new Rectangle(graphics2D.getFontMetrics().stringWidth(string), graphics2D.getFontMetrics().getHeight() - graphics2D.getFontMetrics().getDescent());
            if ((double)(rectangle.width + 15) < d3) {
                n2 = this.round(((Point)this.getSelectedElement()).getScreenX() + (d - (double)rectangle.width) / 2.0);
                n = this.round(((Point)this.getSelectedElement()).getScreenY() + (d2 - (double)rectangle.height) / 2.0);
            } else {
                n2 = this.round(this.cursorPosition.getWidth()) + 7;
                n = this.round(this.cursorPosition.getHeight()) + 7;
            }
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n2, n, rectangle.width + 4, rectangle.height);
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawRect(n2, n, rectangle.width + 4, rectangle.height);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n2 + 2, n - 2 + rectangle.height);
        }
    }

    public void drawNewPolygon(Graphics2D graphics2D) {
        if (this.selection.size() > 0) {
            Point point = new Point();
            point.setStroke(Color.lightGray);
            point.setScreen(this.cursorPosition);
            this.screen2user(point);
            this.selection.addElement(point);
            this.selection.addElement(this.selection.get(0));
            Polygon polygon = new Polygon(this.selection, this.selection.size(), 0);
            polygon.setFill(new Color(153, 153, 153, 50));
            for (int i = 0; i < polygon.border.length - 1; ++i) {
                polygon.border[i].setStroke(Color.lightGray);
            }
            polygon.draw(graphics2D, this);
            point.draw(graphics2D, this);
            Point point2 = (Point)this.selection.get(0);
            int n = point2.getStyle();
            point2.setStyle(20);
            point2.draw(graphics2D, this);
            point2.setStyle(n);
            this.selection.remove(this.selection.size() - 1);
            this.selection.remove(this.selection.size() - 1);
        }
    }

    public void drawUnit(Graphics2D graphics2D) {
        int n;
        graphics2D.setStroke(this.setStroke(1, 0));
        graphics2D.setColor(Color.gray);
        String string = "";
        if (this.isCoordXMultiple()) {
            string = this.changeChar(this.coordXMulti);
        }
        if (this.isCoordXShowUnit()) {
            int n2 = 0;
            n = this.round(this.user2screenX(1.0) - this.origin.getWidth());
            while ((double)n / Math.pow(10.0, n2) > (double)(this.getWidth() / 2)) {
                ++n2;
            }
            while ((double)n / Math.pow(10.0, n2) < 10.0) {
                --n2;
            }
            n = this.round((double)n / Math.pow(10.0, n2));
            graphics2D.drawLine(30, 10, 30 + n, 10);
            graphics2D.drawLine(30, 8, 30, 12);
            graphics2D.drawLine(30 + n, 8, 30 + n, 12);
            String string2 = 1.0 / Math.pow(10.0, n2) + " " + string;
            graphics2D.drawString(string2, 30 + (n - graphics2D.getFontMetrics().stringWidth(string2)) / 2, 25);
        }
        String string3 = "";
        if (this.isCoordYMultiple()) {
            string3 = this.changeChar(this.coordYMulti);
        }
        if (this.isCoordYShowUnit()) {
            n = 0;
            int n3 = this.round(this.user2screenY(-1.0) - this.origin.getHeight());
            while ((double)n3 / Math.pow(10.0, n) > (double)(this.getHeight() / 2)) {
                ++n;
            }
            n3 = this.round((double)n3 / Math.pow(10.0, n));
            graphics2D.drawLine(10, 30, 10, 30 + n3);
            graphics2D.drawLine(8, 30, 12, 30);
            graphics2D.drawLine(8, 30 + n3, 12, 30 + n3);
            String string4 = 1.0 / Math.pow(10.0, n) + " " + string3;
            graphics2D.drawString(string4, 15, 30 + this.round((n3 + graphics2D.getFontMetrics().getHeight()) / 2));
        }
    }

    public void freeze() {
        this.freeze = this.write();
    }

    public double getAngleOnShpericCircleSystem(double[] dArray, double[] dArray2, Coordinates coordinates) {
        Point point = new Point();
        point.setUser(coordinates);
        point.user2sphere();
        double[] dArray3 = point.getSphere();
        int n = 0;
        int n2 = 0;
        while (dArray[n] == 0.0) {
            ++n;
        }
        while (dArray2[n2] == 0.0) {
            ++n2;
        }
        if (n == n2) {
            ++n2;
            while (dArray2[n2] == 0.0) {
                ++n2;
            }
        }
        double d = (dArray3[n] * dArray2[n2] - dArray3[n2] * dArray2[n]) / (dArray[n] * dArray2[n2] - dArray[n2] * dArray2[n]);
        double d2 = Math.acos(d);
        double d3 = dArray[n] * Math.cos(d2) + dArray2[n] * Math.sin(d2) - point.getSphere()[n];
        double d4 = dArray[n2] * Math.cos(Math.PI * 2 - d2) + dArray2[n2] * Math.sin(Math.PI * 2 - d2) - point.getSphere()[n2];
        if (Math.abs(d3) < Math.abs(d4)) {
            return d2;
        }
        return Math.PI * 2 - d2;
    }

    public double getAngleOnShpericCircleSystem(double[] dArray, double[] dArray2, Point point) {
        point.user2sphere();
        double[] dArray3 = point.getSphere();
        int n = 0;
        int n2 = 0;
        while (dArray[n] == 0.0) {
            ++n;
        }
        while (dArray2[n2] == 0.0) {
            ++n2;
        }
        if (n == n2) {
            ++n2;
            while (dArray2[n2] == 0.0) {
                ++n2;
            }
        }
        double d = (dArray3[n] * dArray2[n2] - dArray3[n2] * dArray2[n]) / (dArray[n] * dArray2[n2] - dArray[n2] * dArray2[n]);
        double d2 = Math.acos(d);
        double d3 = dArray[n] * Math.cos(d2) + dArray2[n] * Math.sin(d2) - point.getSphere()[n];
        double d4 = dArray[n2] * Math.cos(Math.PI * 2 - d2) + dArray2[n2] * Math.sin(Math.PI * 2 - d2) - point.getSphere()[n2];
        if (Math.abs(d3) < Math.abs(d4)) {
            return d2;
        }
        return Math.PI * 2 - d2;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getBackImageFileName() {
        return this.backImageFileName;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public Line getBLine() {
        return this.BLine;
    }

    public Point getBLPoint() {
        return this.BLPoint;
    }

    public Point getBRPoint() {
        return this.BRPoint;
    }

    public String getComment() {
        return this.comment;
    }

    public int getCompositionType() {
        return this.compositionType;
    }

    public Coordinates getCursorPosition() {
        return this.cursorPosition;
    }

    public ConstructionData getData() {
        return this.data;
    }

    public ElementSet getElement() {
        return this.element;
    }

    public Vector getElementVector(String string) {
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            for (int j = 0; j < this.element.elements.size(); ++j) {
                if (this.element.elements.get(j) instanceof Intersection) {
                    if (((Intersection)this.element.elements.get(j)).getA().getName().equals(stringArray[i])) {
                        vector.addElement(((Intersection)this.element.elements.get(j)).getA());
                        j = this.element.elements.size();
                        bl = false;
                        continue;
                    }
                    if (!((Intersection)this.element.elements.get(j)).getB().getName().equals(stringArray[i]) || !((Intersection)this.element.elements.get(j)).getB().isActive()) continue;
                    vector.addElement(((Intersection)this.element.elements.get(j)).getB());
                    j = this.element.elements.size();
                    bl = false;
                    continue;
                }
                if (!((Element)this.element.elements.get(j)).getName().equals(stringArray[i])) continue;
                vector.addElement(this.element.elements.get(j));
                j = this.element.elements.size();
                bl = false;
            }
            if (!bl) continue;
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public String getFreeze() {
        return this.freeze;
    }

    public JFrameDialog getGeonextBoardDialog() {
        return this.geonextBoardDialog;
    }

    public JFrameDialog getGeonextCASDialog() {
        return this.geonextCASDialog;
    }

    public JFrameDialog getGeonextCASPointDialog() {
        return this.geonextCASPointDialog;
    }

    public JFrameDialog getGeonextDialog() {
        return this.geonextDialog;
    }

    public JFrameDialog getGeonextGraphDialog() {
        return this.geonextGraphDialog;
    }

    public JFrameDialog getGeonextParameterCurveDialog() {
        return this.geonextParameterCurveDialog;
    }

    public JFrameDialog getGeonextTextDialog() {
        return this.geonextTextDialog;
    }

    public JFrameDialog getGeonextValueDialog() {
        return this.geonextValueDialog;
    }

    public Vector getGraphHistoryString() {
        return this.graphHistoryString;
    }

    public Coordinates getGrid() {
        return this.grid;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public String getHex(int n) {
        String string = "";
        int n2 = n % 16;
        n = (n - n2) / 16 % 16;
        int n3 = 0;
        while (n3++ < 2) {
            switch (n) {
                case 10: {
                    string = string + "A";
                    break;
                }
                case 11: {
                    string = string + "B";
                    break;
                }
                case 12: {
                    string = string + "C";
                    break;
                }
                case 13: {
                    string = string + "D";
                    break;
                }
                case 14: {
                    string = string + "E";
                    break;
                }
                case 15: {
                    string = string + "F";
                    break;
                }
                default: {
                    string = string + "" + n;
                }
            }
            n = n2;
        }
        return string;
    }

    public String getHexColor(Color color) {
        return this.getHex(color.getRed()) + this.getHex(color.getGreen()) + this.getHex(color.getBlue()) + this.getHex(color.getAlpha());
    }

    public String getInfo() {
        return this.info;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public JElementPane getJep() {
        return this.jep;
    }

    public JScrollPane getJsp() {
        return this.jsp;
    }

    public JSObject getJsWindow() {
        return this.jsWindow;
    }

    public Coordinates getLastOrigin() {
        return this.lastOrigin;
    }

    public Coordinates[] getLinesIntersectionWithViewport(Coordinates[] coordinatesArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = coordinatesArray[0].getWidth();
        double d8 = coordinatesArray[0].getHeight();
        double d9 = coordinatesArray[1].getWidth();
        double d10 = coordinatesArray[1].getHeight();
        if (d7 > d9) {
            d6 = d7;
            d5 = d8;
            d7 = d9;
            d8 = d10;
            d9 = d6;
            d10 = d5;
        }
        double d11 = d9 - d7;
        double d12 = d10 - d8;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = this.getWidth();
        double d16 = this.getHeight();
        if (d11 == 0.0) {
            d6 = d7;
            d5 = d14;
            d4 = d7;
            d3 = d16;
        } else if (d12 == 0.0) {
            d6 = d13;
            d5 = d8;
            d4 = d15;
            d3 = d8;
        } else {
            d2 = d12 / d11;
            d = d8 - d2 * d7;
            double d17 = d2 * d13 + d;
            double d18 = d2 * d15 + d;
            double d19 = (d14 - d) / d2;
            double d20 = (d16 - d) / d2;
            if (d2 < 0.0) {
                if (d17 < d16) {
                    d6 = d13;
                    d5 = d17;
                    if (d15 > d19) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                } else {
                    d6 = d20;
                    d5 = d16;
                    if (d19 < d15) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                }
            } else if (d17 > d14) {
                d6 = d13;
                d5 = d17;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            } else {
                d6 = d19;
                d5 = d14;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            }
        }
        if (d6 > d4) {
            d2 = d6;
            d = d5;
            d6 = d4;
            d5 = d3;
            d4 = d2;
            d3 = d;
        }
        Coordinates[] coordinatesArray2 = new Coordinates[]{new Coordinates(d6, d5), new Coordinates(d4, d3)};
        return coordinatesArray2;
    }

    public Coordinates[] getLinesIntersectionWithViewport(Coordinates[] coordinatesArray, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = coordinatesArray[0].getWidth();
        double d8 = coordinatesArray[0].getHeight();
        double d9 = coordinatesArray[1].getWidth();
        double d10 = coordinatesArray[1].getHeight();
        if (d7 > d9) {
            d6 = d7;
            d5 = d8;
            d7 = d9;
            d8 = d10;
            d9 = d6;
            d10 = d5;
        }
        double d11 = d9 - d7;
        double d12 = d10 - d8;
        double d13 = 0 - n;
        double d14 = 0 - n;
        double d15 = this.getWidth() + n;
        double d16 = this.getHeight() + n;
        if (d11 == 0.0) {
            d6 = d7;
            d5 = d14;
            d4 = d7;
            d3 = d16;
        } else if (d12 == 0.0) {
            d6 = d13;
            d5 = d8;
            d4 = d15;
            d3 = d8;
        } else {
            d2 = d12 / d11;
            d = d8 - d2 * d7;
            double d17 = d2 * d13 + d;
            double d18 = d2 * d15 + d;
            double d19 = (d14 - d) / d2;
            double d20 = (d16 - d) / d2;
            if (d2 < 0.0) {
                if (d17 < d16) {
                    d6 = d13;
                    d5 = d17;
                    if (d15 > d19) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                } else {
                    d6 = d20;
                    d5 = d16;
                    if (d19 < d15) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                }
            } else if (d17 > d14) {
                d6 = d13;
                d5 = d17;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            } else {
                d6 = d19;
                d5 = d14;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            }
        }
        if (d6 > d4) {
            d2 = d6;
            d = d5;
            d6 = d4;
            d5 = d3;
            d4 = d2;
            d3 = d;
        }
        Coordinates[] coordinatesArray2 = new Coordinates[]{new Coordinates(d6, d5), new Coordinates(d4, d3)};
        return coordinatesArray2;
    }

    public Coordinates[] getLinesIntersectionWithViewport(Line line, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = line.getA().getUserX();
        double d8 = line.getA().getUserY();
        double d9 = line.getB().getUserX();
        double d10 = line.getB().getUserY();
        if (d7 > d9) {
            d6 = d7;
            d5 = d8;
            d7 = d9;
            d8 = d10;
            d9 = d6;
            d10 = d5;
        }
        double d11 = d9 - d7;
        double d12 = d10 - d8;
        double d13 = this.screen2userX(0 - n);
        double d14 = this.screen2userY(0 - n);
        double d15 = this.screen2userX(this.getWidth() + n);
        double d16 = this.screen2userY(this.getHeight() + n);
        if (d11 == 0.0) {
            d6 = d7;
            d5 = d14;
            d4 = d7;
            d3 = d16;
        } else if (d12 == 0.0) {
            d6 = d13;
            d5 = d8;
            d4 = d15;
            d3 = d8;
        } else {
            d2 = d12 / d11;
            d = d8 - d2 * d7;
            double d17 = d2 * d13 + d;
            double d18 = d2 * d15 + d;
            double d19 = (d14 - d) / d2;
            double d20 = (d16 - d) / d2;
            if (d2 > 0.0) {
                if (d17 > d16) {
                    d6 = d13;
                    d5 = d17;
                    if (d15 > d19) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                } else {
                    d6 = d20;
                    d5 = d16;
                    if (d19 < d15) {
                        d4 = d19;
                        d3 = d14;
                    } else {
                        d4 = d15;
                        d3 = d18;
                    }
                }
            } else if (d17 < d14) {
                d6 = d13;
                d5 = d17;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            } else {
                d6 = d19;
                d5 = d14;
                if (d20 < d15) {
                    d4 = d20;
                    d3 = d16;
                } else {
                    d4 = d15;
                    d3 = d18;
                }
            }
        }
        if (d6 > d4) {
            d2 = d6;
            d = d5;
            d6 = d4;
            d5 = d3;
            d4 = d2;
            d3 = d;
        }
        Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(d6, d5), new Coordinates(d4, d3)};
        return coordinatesArray;
    }

    public Coordinates[] getLineToDraw(Coordinates[] coordinatesArray, int n) {
        Coordinates[] coordinatesArray2;
        if (coordinatesArray[0].getWidth() > coordinatesArray[1].getWidth()) {
            double d = coordinatesArray[0].getWidth();
            double d2 = coordinatesArray[0].getHeight();
            coordinatesArray[0].setWidth(coordinatesArray[1].getWidth());
            coordinatesArray[0].setHeight(coordinatesArray[1].getHeight());
            coordinatesArray[1].setWidth(d);
            coordinatesArray[1].setHeight(d2);
        }
        if ((coordinatesArray2 = this.getLinesIntersectionWithViewport(coordinatesArray, n))[0].getWidth() < coordinatesArray[0].getWidth() && coordinatesArray[0].getWidth() < coordinatesArray2[1].getWidth()) {
            coordinatesArray2[0].setWidth(coordinatesArray[0].getWidth());
            coordinatesArray2[0].setHeight(coordinatesArray[0].getHeight());
        }
        if (coordinatesArray2[0].getWidth() < coordinatesArray[1].getWidth() && coordinatesArray[1].getWidth() < coordinatesArray2[1].getWidth()) {
            coordinatesArray2[1].setWidth(coordinatesArray[1].getWidth());
            coordinatesArray2[1].setHeight(coordinatesArray[1].getHeight());
        }
        return coordinatesArray2;
    }

    public Line getLLine() {
        return this.LLine;
    }

    public int getModus() {
        return this.modus;
    }

    public Thread getMotion() {
        return this.motion;
    }

    public Point getOOPoint() {
        return this.OOPoint;
    }

    public Coordinates getOrigin() {
        return this.origin;
    }

    public Point getOYPoint() {
        return this.OYPoint;
    }

    public Image getPointImage() {
        return this.pointImage;
    }

    public void getPointImage(String string) {
        try {
            this.pointImage = ((Applet)this.getTopLevelAncestor()).getImage(((Applet)this.getTopLevelAncestor()).getCodeBase(), string);
        }
        catch (Exception exception) {
            this.pointImage = null;
        }
    }

    public Line getRLine() {
        return this.RLine;
    }

    public Circle getSelectedCircle() {
        return this.selectedCircle;
    }

    public Vector getSelectedCircles() {
        Vector<Circle> vector = new Vector<Circle>();
        for (int i = 0; i < this.element.circle.size(); ++i) {
            if (!((Circle)this.element.circle.get(i)).exists() || !((Circle)this.element.circle.get(i)).isMode()) continue;
            vector.addElement((Circle)this.element.circle.get(i));
        }
        return vector;
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public Vector getSelectedElements(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken().toUpperCase());
        }
        int n = 16;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            int n2;
            if (((String)vector.get(i)).equals("POINT")) {
                for (n2 = 0; n2 < this.getSelectedPoints().size(); ++n2) {
                    if (vector2.contains(this.getSelectedPoints().get(n2))) continue;
                    vector2.addElement(this.getSelectedPoints().get(n2));
                }
                continue;
            }
            if (((String)vector.get(i)).equals("SLIDER")) {
                for (n2 = 0; n2 < this.getSelectedPoints().size(); ++n2) {
                    if (!(this.getSelectedPoints().get(n2) instanceof Slider) || vector2.contains(this.getSelectedPoints().get(n2))) continue;
                    vector2.addElement(this.getSelectedPoints().get(n2));
                }
                continue;
            }
            if (((String)vector.get(i)).equals("LINE")) {
                for (n2 = 0; n2 < this.getSelectedLines().size(); ++n2) {
                    if (vector2.contains(this.getSelectedLines().get(n2))) continue;
                    vector2.addElement(this.getSelectedLines().get(n2));
                }
                continue;
            }
            if (((String)vector.get(i)).equals("CIRCLE")) {
                for (n2 = 0; n2 < this.getSelectedCircles().size(); ++n2) {
                    if (vector2.contains(this.getSelectedCircles().get(n2))) continue;
                    vector2.addElement(this.getSelectedCircles().get(n2));
                }
                continue;
            }
            if (((String)vector.get(i)).equals("GRAPH")) {
                for (n2 = 0; n2 < this.getSelectedGraphs().size(); ++n2) {
                    if (vector2.contains(this.getSelectedGraphs().get(n2))) continue;
                    vector2.addElement(this.getSelectedGraphs().get(n2));
                }
                continue;
            }
            if (((String)vector.get(i)).equals("TEXT")) {
                for (n2 = 0; n2 < this.getSelectedTexts().size(); ++n2) {
                    if (vector2.contains(this.getSelectedTexts().get(n2))) continue;
                    vector2.addElement(this.getSelectedTexts().get(n2));
                }
                continue;
            }
            if (!((String)vector.get(i)).equals("TRACE")) continue;
        }
        return vector2;
    }

    public Vector getSelectedElementsOld(int n) {
        int n2 = 16;
        Vector vector = new Vector();
        while (n > 0) {
            if (n < (n2 /= 2)) continue;
            switch (n2) {
                case 8: {
                    int n3;
                    for (n3 = 0; n3 < this.getSelectedPoints().size(); ++n3) {
                        vector.addElement(this.getSelectedPoints().get(n3));
                    }
                    break;
                }
                case 4: {
                    int n3;
                    for (n3 = 0; n3 < this.getSelectedLines().size(); ++n3) {
                        vector.addElement(this.getSelectedLines().get(n3));
                    }
                    break;
                }
                case 2: {
                    int n3;
                    for (n3 = 0; n3 < this.getSelectedCircles().size(); ++n3) {
                        vector.addElement(this.getSelectedCircles().get(n3));
                    }
                    break;
                }
                case 1: {
                    int n3;
                    for (n3 = 0; n3 < this.getSelectedGraphs().size(); ++n3) {
                        vector.addElement(this.getSelectedGraphs().get(n3));
                    }
                    break;
                }
            }
            n -= n2;
        }
        return vector;
    }

    public Graph getSelectedGraph() {
        return this.selectedGraph;
    }

    public Vector getSelectedGraphs() {
        Vector<Graph> vector = new Vector<Graph>();
        for (int i = 0; i < this.element.graph.size(); ++i) {
            if (!((Graph)this.element.graph.get(i)).exists() || !((Graph)this.element.graph.get(i)).isMode()) continue;
            vector.addElement((Graph)this.element.graph.get(i));
        }
        return vector;
    }

    public Line getSelectedLine() {
        return this.selectedLine;
    }

    public Vector getSelectedLines() {
        Vector<Line> vector = new Vector<Line>();
        for (int i = 0; i < this.element.line.size(); ++i) {
            if (!((Line)this.element.line.get(i)).exists() || !((Line)this.element.line.get(i)).isMode()) continue;
            vector.addElement((Line)this.element.line.get(i));
        }
        return vector;
    }

    public Point getSelectedPoint() {
        return this.selectedPoint;
    }

    public Vector getSelectedPoints() {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < this.element.point.size(); ++i) {
            if (!((Point)this.element.point.get(i)).isMode()) continue;
            vector.addElement((Point)this.element.point.get(i));
        }
        return vector;
    }

    public boolean pointsMovable() {
        for (int i = 0; i < this.element.point.size(); ++i) {
            if (((Point)this.element.point.get(i)).isMovable()) continue;
            return false;
        }
        return true;
    }

    public Text getSelectedText() {
        return this.selectedText;
    }

    public Vector getSelectedTexts() {
        Vector<Text> vector = new Vector<Text>();
        for (int i = 0; i < this.element.text.size(); ++i) {
            if (!((Text)this.element.text.get(i)).isMode()) continue;
            vector.addElement((Text)this.element.text.get(i));
        }
        return vector;
    }

    public Vector getSelection() {
        return this.selection;
    }

    public int getSelectionCount() {
        return this.selectionCount;
    }

    public Vector getSelectionType() {
        return this.selectionType;
    }

    public String getSnaptogrid() {
        return this.snaptogrid;
    }

    public Coordinates getSubGrid() {
        return this.subGrid;
    }

    public Coordinates getTextMove() {
        return this.textMove;
    }

    public String getTitle() {
        return this.title;
    }

    public Line getTLine() {
        return this.TLine;
    }

    public Point getTLPoint() {
        return this.TLPoint;
    }

    public Point getTRPoint() {
        return this.TRPoint;
    }

    public Coordinates getUnit() {
        return this.unit;
    }

    public Vector getUsedNames() {
        return this.usedNames;
    }

    public Vector getValueHistoryString() {
        return this.valueHistoryString;
    }

    public Line getXLine() {
        return this.XLine;
    }

    public Point getXOPoint() {
        return this.XOPoint;
    }

    public Line getYLine() {
        return this.YLine;
    }

    public Coordinates getZoom() {
        return this.zoom;
    }

    public Coordinates getZoomMax() {
        return this.zoomMax;
    }

    public Coordinates getZoomMin() {
        return this.zoomMin;
    }

    public boolean in(double d, double d2, double d3) {
        return d > d2 && d < d3;
    }

    public void initJBoardPane() {
        this.setBackground(Color.white);
        this.usedNames = new Vector();
        this.bgcolor = Color.white;
        this.grid = new Coordinates(50.0, 50.0);
        this.unit = new Coordinates(50.0, 50.0);
        this.zoom = new Coordinates(1.0, 1.0);
        this.data = new ConstructionData();
        this.origin = new Coordinates(200.0, 200.0);
        this.zoomBox = new JZoomBox(0, 0, 100, 100);
        this.zoomBox.setActive(false);
        this.addKeyListener(this);
        this.element = new ElementSet();
        this.storedESet = new ElementSet();
        this.listStatus = false;
        this.cursorPosition = new Coordinates(-1.0, -1.0);
        this.modus = 80;
        this.status = false;
        this.selectedPoint = null;
        this.selectedLine = new Line();
        this.selectedLine.setA(null);
        this.selectedLine.setB(null);
        this.selectedCircle = new Circle();
        this.selectedCircle.setM(null);
        this.selectedCircle.setP(null);
        this.selectedElement = null;
        this.jep = new JElementPane(this);
        this.jep.setSize(500, 500);
        this.add((Component)this.jep, new Integer(5));
        this.jep.addMouseListener(this);
        this.jep.addMouseMotionListener(this);
        this.selection = new Vector();
        this.selectionCount = 0;
        this.freeze = "";
        this.motion = null;
        this.valueHistoryString.addElement("");
        this.graphHistoryString.addElement("");
        this.casXHistoryString.addElement("");
        this.casYHistoryString.addElement("");
        this.pCurveXHistoryString.addElement("");
        this.pCurveYHistoryString.addElement("");
        this.pCurveMinHistoryString.addElement("");
        this.pCurveMaxHistoryString.addElement("");
        this.author = UserData.NN.equals("") ? "" : (UserData.IN.equals("") ? UserData.VN + " " + UserData.NN : UserData.IN + " / " + UserData.OR);
        this.undo = new UndoManager();
        this.setCoordinateSystem();
        this.setVisibleArea();
        this.setDashArray();
        try {
            this.geonext.jnp.getRename().addActionListener(this);
            this.geonext.jnp.getText().addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.geonext.wot) {
            this.jep.addMouseWheelListener(this);
        }
        this.conditions = new Vector();
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public boolean isControl() {
        return this.control;
    }

    public boolean isCoord() {
        return this.coord;
    }

    public boolean isCoordGrid() {
        return this.coordGrid;
    }

    public boolean isCoordLabel() {
        return this.coordLabel;
    }

    public boolean isCoordXContinuous() {
        return this.coordXContinuous;
    }

    public void checkConditions() {
        this.ckCond = false;
        C.boardName = this.internalName;
        for (int i = 0; i < this.conditions.size(); ++i) {
            try {
                this.geonext.set(((Condition)this.conditions.get(i)).calculate());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ckCond = true;
    }

    public boolean isCoordXMultiple() {
        return this.coordXMultiple;
    }

    public boolean isCoordXShowUnit() {
        return this.coordXShowUnit;
    }

    public boolean isCoordYContinuous() {
        return this.coordYContinuous;
    }

    public boolean isCoordYMultiple() {
        return this.coordYMultiple;
    }

    public boolean isCoordYShowUnit() {
        return this.coordYShowUnit;
    }

    public boolean isCross() {
        return this.cross;
    }

    public boolean isGridDash() {
        return this.gridDash;
    }

    public boolean isInLogo() {
        return this.inLogo;
    }

    public boolean isListStatus() {
        return this.listStatus;
    }

    public boolean isStatus() {
        return this.status;
    }

    public boolean isStatusBar() {
        return this.statusBar;
    }

    public boolean isToCoord() {
        return this.toCoord;
    }

    public void javaScript() {
        Object object;
        try {
            Container container = this.getParent();
            while (!(container instanceof JApplet)) {
                container = container.getParent();
            }
            object = (JApplet)container;
            this.jsWindow = JSObject.getWindow((Applet)object);
        }
        catch (Exception exception) {
            this.jsWindow = null;
        }
        if (this.jsWindow != null) {
            for (int i = 0; i < this.element.text.size(); ++i) {
                object = (Text)this.element.text.get(i);
                if (((Text)object).getJavaScriptFunction().equals("")) continue;
                Object[] objectArray = new Object[]{""};
                for (int j = 0; j < ((Text)object).content.size(); ++j) {
                    objectArray[0] = (String)objectArray[0] + (String)((Text)object).values.get(j);
                }
                this.jsWindow.call(((Text)object).getJavaScriptFunction(), objectArray);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        this.stop();
        int n2 = this.modus;
        if (this.getPreviousModus() == 210350 & keyEvent.getKeyCode() != 210350) {
            for (n = 5; n < this.element.elements.size(); ++n) {
                ((Element)this.element.elements.get(n)).setEditVisible(false);
            }
        }
        if (new BoardEvent().getKey(keyEvent.getKeyCode()).startsWith("MODE")) {
            this.geonext.jnp.setVisible(false);
            this.geonext.topToolBar.showAllComponents();
            this.geonext.componentResized(new ComponentEvent(this.geonext, 101));
        }
        switch (keyEvent.getKeyCode()) {
            case 90: {
                if (this.element.counter <= 5 || keyEvent.getModifiers() != 2) break;
                this.clearTrace();
                try {
                    this.undo.undo();
                    this.element = new ElementSet();
                    this.element = this.copyElementSet((ElementSet)this.undo.returnConfiguration());
                    if (this.getGeonextEditDialog() != null) {
                        this.getGeonextEditDialog().jce.refreshList();
                    }
                    for (n = 0; n < this.element.point.size(); ++n) {
                        ((Point)this.element.point.get((int)n)).groups = new Vector();
                    }
                    for (n = 0; n < this.element.group.size(); ++n) {
                        for (int i = 0; i < ((Group)this.element.group.get((int)n)).group.size(); ++i) {
                            ((Point)((Group)this.element.group.get((int)n)).group.get((int)i)).groups.addElement(this.element.group.get(n));
                        }
                    }
                    this.setSaved(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                keyEvent = null;
                this.sd.setElementSet(this.element);
                this.reset();
                this.calculateElements();
                this.repaint();
                break;
            }
            case 89: {
                if (keyEvent.getModifiers() != 2) break;
                n = this.element.getCounter();
                this.clearTrace();
                try {
                    int n3;
                    int n4;
                    this.undo.redo();
                    this.element = new ElementSet();
                    this.element = this.copyElementSet((ElementSet)this.undo.returnConfiguration());
                    for (n4 = 0; n4 < this.element.point.size(); ++n4) {
                        ((Point)this.element.point.get((int)n4)).groups = new Vector();
                    }
                    for (n4 = 0; n4 < this.element.group.size(); ++n4) {
                        for (n3 = 0; n3 < ((Group)this.element.group.get((int)n4)).group.size(); ++n3) {
                            ((Point)((Group)this.element.group.get((int)n4)).group.get((int)n3)).groups.addElement(this.element.group.get(n4));
                        }
                    }
                    this.sd.setElementSet(this.element);
                    this.calculateElements();
                    Element element = (Element)this.element.elements.lastElement();
                    if (element instanceof Intersection) {
                        int n5;
                        Intersection intersection = (Intersection)element;
                        if (this.element.searchName(intersection.getA().getName(), 1) != null) {
                            n5 = 1;
                            while (this.element.searchName(intersection.getA().getName() + "[" + n5 + "]", 1) != null) {
                                ++n5;
                            }
                            intersection.getA().setName(intersection.getA().getName() + "[" + n5 + "]");
                        }
                        if (((Intersection)element).getType() != 0 && this.element.searchName(intersection.getB().getName(), 1) != null && !intersection.getB().getName().equals(intersection.getA().getName())) {
                            n5 = 1;
                            while (this.element.searchName(intersection.getB().getName() + "[" + n5 + "]", 1) != null && !intersection.getB().getName().equals(intersection.getA().getName())) {
                                ++n5;
                            }
                            intersection.getB().setName(intersection.getB().getName() + "[" + n5 + "]");
                        }
                    } else if (element instanceof Composition) {
                        Composition composition = (Composition)element;
                        for (int i = 0; i < composition.elements.size(); ++i) {
                            if (this.element.searchName(((Element)composition.elements.get(i)).getName(), 1) == null) continue;
                            int n6 = 1;
                            while (this.element.searchName(((Element)composition.elements.get(i)).getName() + "[" + n6 + "]", 1) != null) {
                                ++n6;
                            }
                            ((Element)composition.elements.get(i)).setName(((Element)composition.elements.get(i)).getName() + "[" + n6 + "]");
                        }
                    } else if (element instanceof Polygon) {
                        int n7;
                        Polygon polygon = (Polygon)element;
                        for (n7 = 0; n7 < polygon.border.length; ++n7) {
                            if (this.element.searchName(polygon.border[n7].getName(), 1) == null) continue;
                            int n8 = 1;
                            while (this.element.searchName(polygon.border[n7].getName() + "[" + n8 + "]", 1) != null) {
                                ++n8;
                            }
                            polygon.border[n7].setName(polygon.border[n7].getName() + "[" + n8 + "]");
                        }
                        if (this.element.searchName(((Element)this.element.elements.lastElement()).getName(), 1) != null) {
                            n7 = 1;
                            while (this.element.searchName(((Element)this.element.elements.lastElement()).getName() + "[" + n7 + "]", 1) != null) {
                                ++n7;
                            }
                            ((Element)this.element.elements.lastElement()).setName(((Element)this.element.elements.lastElement()).getName() + "[" + n7 + "]");
                        }
                    } else if (this.element.searchName(((Element)this.element.elements.lastElement()).getName(), 1) != null) {
                        n3 = 1;
                        while (this.element.searchName(((Element)this.element.elements.lastElement()).getName() + "[" + n3 + "]", 1) != null) {
                            ++n3;
                        }
                        ((Element)this.element.elements.lastElement()).setName(((Element)this.element.elements.lastElement()).getName() + "[" + n3 + "]");
                    }
                    if (this.getGeonextEditDialog() != null) {
                        this.getGeonextEditDialog().jce.refreshList();
                    }
                    this.setSaved(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                keyEvent = null;
                this.calculateElements(true);
                this.repaint();
                break;
            }
            case 70: {
                if (keyEvent.getModifiers() != 2) break;
                this.freeze();
                this.frozen = true;
                keyEvent = null;
                break;
            }
            case 82: {
                if (keyEvent.getModifiers() != 2 || this.freeze == "") break;
                this.clearTrace();
                this.restore();
                keyEvent = null;
                this.repaint();
                this.setSaved(false);
                break;
            }
            case 76: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 76;
                this.data.setDataTypes(this.getModus());
                this.selection = new Vector();
                keyEvent = null;
                break;
            }
            case 67: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 67;
                this.data.setDataTypes(this.getModus());
                this.selection = new Vector();
                keyEvent = null;
                break;
            }
            case 110005: {
                if (this.geonextBoardDialog == null) {
                    this.geonextBoardDialog = new JFrameDialog("", new Dimension(600, 500), 7, this, false, true, true, true);
                }
                this.showGeonextDialog(this.geonextBoardDialog);
                break;
            }
            case 86: {
                if (this.geonextEditDialog == null) {
                    this.geonextEditDialog = new JFrameDialog("", new Dimension(600, 500), 6, this, false, false, false, true);
                }
                this.showGeonextDialog(this.geonextEditDialog);
                break;
            }
            case 110115: {
                if (this.geonextPrintDialog == null) {
                    this.geonextPrintDialog = new JFrameDialog("", new Dimension(550, 400), 15, this, false, true, true, false);
                }
                this.showGeonextDialog(this.geonextPrintDialog);
                break;
            }
            case 80: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 80;
                keyEvent = null;
                break;
            }
            case 210050: {
                if (keyEvent.getModifiers() == 2) {
                    this.modus = 210050;
                    keyEvent = null;
                }
                if (this.geonextCASPointDialog == null) {
                    this.geonextCASPointDialog = new JFrameDialog("", new Dimension(550, 400), 0, this, false, true, true, true);
                }
                this.showGeonextDialog(this.geonextCASPointDialog);
                break;
            }
            case 210270: {
                if (keyEvent.getModifiers() == 2) {
                    this.modus = 210270;
                    keyEvent = null;
                }
                if (this.geonextParameterCurveDialog == null) {
                    this.geonextParameterCurveDialog = new JFrameDialog("", new Dimension(550, 400), 13, this, false, true, true, true);
                }
                this.showGeonextDialog(this.geonextParameterCurveDialog);
                break;
            }
            case 210210: {
                if (keyEvent.getModifiers() == 2) {
                    this.modus = 210210;
                    keyEvent = null;
                }
                if (this.geonextGraphDialog == null) {
                    this.geonextGraphDialog = new JFrameDialog("", new Dimension(550, 150), 1, this, false, true, true, true);
                }
                this.showGeonextDialog(this.geonextGraphDialog);
                break;
            }
            case 210310: {
                if (this.geonextTextDialog == null) {
                    this.geonextTextDialog = new JFrameDialog("", new Dimension(550, 400), 2, this, false, true, true, true);
                }
                this.showGeonextDialog(this.geonextTextDialog);
                break;
            }
            case 88: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 88;
                this.data.setDataTypes(this.getModus());
                this.selection = new Vector();
                keyEvent = null;
                break;
            }
            case 68: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 68;
                keyEvent = null;
                break;
            }
            case 71: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 71;
                keyEvent = null;
                break;
            }
            case 85: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 85;
                keyEvent = null;
                break;
            }
            case 210220: {
                break;
            }
            case 79: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 79;
                keyEvent = null;
                break;
            }
            case 87: {
                if (keyEvent.getModifiers() != 2) break;
                if (this.isCoordGrid()) {
                    this.setCoordGrid(false);
                } else {
                    this.setCoordGrid(true);
                }
                keyEvent = null;
                this.jep.setResized(true);
                this.repaint();
                break;
            }
            case 310010: {
                if (keyEvent.getModifiers() != 2) break;
                this.XLine.setVisible(false);
                this.YLine.setVisible(false);
                if (this.isCoord()) {
                    this.setCoord(false);
                } else {
                    this.setCoord(true);
                    if (this.coordXObject) {
                        this.XLine.setVisible(true);
                    }
                    if (this.coordYObject) {
                        this.YLine.setVisible(true);
                    }
                }
                keyEvent = null;
                this.jep.setResized(true);
                this.repaint();
                break;
            }
            case 69: {
                if (keyEvent.getModifiers() != 2) break;
                if (this.isToCoord()) {
                    this.setToCoord(false);
                } else {
                    this.setToCoord(true);
                }
                keyEvent = null;
                this.jep.setResized(true);
                this.repaint();
                break;
            }
            case 66: {
                if (keyEvent.getModifiers() != 2) break;
                this.modus = 66;
                keyEvent = null;
                break;
            }
            case 210275: {
                this.modus = 210275;
                this.geonext.jnp.setVisible(true);
                this.geonext.topToolBar.showAllComponents();
                this.geonext.componentResized(new ComponentEvent(this.geonext, 101));
                this.repaint();
                break;
            }
            case 521: {
                this.zoomIn();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 45: {
                this.zoomOut();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 53: {
                if (keyEvent.getModifiers() == 2) {
                    this.zoom100();
                    keyEvent = null;
                }
                this.repaint();
                break;
            }
            case 65: {
                if (keyEvent.getModifiers() == 2) {
                    this.zoomAll();
                    keyEvent = null;
                }
                this.repaint();
                break;
            }
            case 110100: {
                this.start();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 110140: {
                this.stop();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 110030: {
                this.clearTrace();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 110130: {
                this.createSlide();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 37: {
                this.stepLeft();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 39: {
                this.stepRight();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 38: {
                this.stepUp();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 40: {
                this.stepDown();
                keyEvent = null;
                this.repaint();
                break;
            }
            case 210350: {
                if (this.getPreviousModus() == 210350) break;
                for (n = 5; n < this.element.elements.size(); ++n) {
                    ((Element)this.element.elements.get(n)).setEditVisible(true);
                }
                break;
            }
        }
        if (keyEvent != null) {
            switch (keyEvent.getKeyChar()) {
                case '+': {
                    keyEvent = null;
                    this.repaint();
                    break;
                }
                case '-': {
                    keyEvent = null;
                    this.repaint();
                }
            }
        }
        if (this.modus != n2) {
            try {
                ((Geonext)this.getTopLevelAncestor()).leftToolBar.changeMode(((Geonext)this.getTopLevelAncestor()).activeBoard);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.jep.paint(this.jep.getGraphics());
    }

    public double min(double d, double d2) {
        if (d < d2) {
            return d;
        }
        return d2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            this.getSelectedPoint().setMoved(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isListStatus()) {
            if (this.getSelectedPoints().size() > 0) {
                this.setSaved(false);
            }
            switch (this.getModus()) {
                case 66: {
                    this.jep.setCursor(new Cursor(5));
                    double d = ((double)mouseEvent.getX() - (double)this.zoomBox.x) / (double)this.jep.getWidth();
                    double d2 = ((double)mouseEvent.getY() - (double)this.zoomBox.y) / (double)this.jep.getHeight();
                    if (d > d2) {
                        d2 = d;
                    }
                    this.zoomBox.width = (int)((double)this.jep.getWidth() * d2);
                    this.zoomBox.height = (int)((double)this.jep.getHeight() * d2);
                    break;
                }
                case 210220: {
                    this.jep.setCursor(new Cursor(1));
                    if (this.getSelectedPoints().size() <= 0 || this.getSelectedPoint().getGroups().size() <= 0) break;
                    if (this.isToCoord()) {
                        this.cursorPosition = this.toCoord(mouseEvent.getX(), mouseEvent.getY());
                    }
                    this.cursorPosition.setSize(mouseEvent.getX(), mouseEvent.getY());
                    Coordinates coordinates = ((Group)this.getSelectedPoint().getGroups().lastElement()).getCenter().getScreen();
                    Coordinates coordinates2 = new Coordinates(this.getSelectedPoint().getScreenX() - coordinates.getWidth(), this.getSelectedPoint().getScreenY() - coordinates.getHeight());
                    Coordinates coordinates3 = new Coordinates(this.cursorPosition.getWidth() - coordinates.getWidth(), this.cursorPosition.getHeight() - coordinates.getHeight());
                    if (!(coordinates3.distance(coordinates2) > 0.0) || !(coordinates3.distance() > 10.0) || !(coordinates2.distance() > 10.0)) break;
                    double d = Math.acos(this.sp(coordinates2, coordinates3));
                    coordinates3.rotate(d);
                    double d3 = this.sp(coordinates2, coordinates3);
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    if (Math.acos(d3) > 1.0E-4) {
                        d = -d;
                        coordinates3.rotate(d);
                    }
                    this.rotateGroup(d);
                    break;
                }
                case 80: 
                case 210260: {
                    if (!(this.getSelectedPoint() == null || this.getSelectedPoint().isFix() || this.getSelectedPoint().isComposition() || this.getSelectedPoint().isIntersection())) {
                        this.setChangedElements(this.getSelectedPoint());
                        this.jep.setCursor(new Cursor(0));
                        double d = this.getSelectedPoint().getScreenX();
                        double d4 = this.getSelectedPoint().getScreenY();
                        if (this.getSelectedPoint() instanceof Slider || this.getSelectedPoint() instanceof GraphSlider) {
                            this.getSelectedPoint().getParent().setMoved(true);
                            this.getSelectedPoint().setScreen(mouseEvent.getX(), mouseEvent.getY());
                            if (this.isToCoord()) {
                                ((Slider)this.getSelectedPoint()).setPosition(this.toCoordS2U(mouseEvent.getX(), mouseEvent.getY()));
                                this.user2screen(this.getSelectedPoint());
                            } else {
                                ((Slider)this.getSelectedPoint()).setPosition(this.screen2user(new Coordinates(mouseEvent.getX(), mouseEvent.getY())));
                                this.screen2user(this.getSelectedPoint());
                            }
                            this.getSelectedPoint().user2sphere();
                        } else if (this.isToCoord()) {
                            this.getSelectedPoint().setUser(this.toCoordS2U(mouseEvent.getX(), mouseEvent.getY()));
                            this.user2screen(this.getSelectedPoint());
                            this.getSelectedPoint().user2sphere();
                            this.cursorPosition = this.toCoord(mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            this.getSelectedPoint().setScreen(mouseEvent.getX(), mouseEvent.getY());
                            this.screen2user(this.getSelectedPoint());
                            this.getSelectedPoint().user2sphere();
                            this.cursorPosition.setSize(mouseEvent.getX(), mouseEvent.getY());
                        }
                        if (this.getGeonextEditDialog() != null && this.getGeonextEditDialog().jce.selectedElements.size() > 0 && this.getGeonextEditDialog().jce.selectedElements.lastElement() == this.getSelectedPoint()) {
                            this.getGeonextEditDialog().jce.pointPosXField.setText("" + this.getSelectedPoint().getUserX());
                            this.getGeonextEditDialog().jce.pointPosYField.setText("" + this.getSelectedPoint().getUserY());
                        }
                        if (this.getSelectedPoint().getGroups().size() > 0) {
                            this.moveGroup(d - this.cursorPosition.getWidth(), d4 - this.cursorPosition.getHeight());
                        }
                        this.calculateElements(false);
                        break;
                    }
                    if (this.getSelectedText() == null || this.getSelectedText().isFix()) break;
                    this.jep.setCursor(new Cursor(12));
                    if (this.isToCoord()) {
                        this.getSelectedText().setUser(this.toCoordS2U((double)mouseEvent.getX() - this.textMove.getWidth(), (double)mouseEvent.getY() - this.textMove.getHeight()));
                        this.getSelectedText().setScreen(this.user2screen(this.getSelectedText().getUser()));
                        if (this.getSelectedText().getE() != null) {
                            Coordinates coordinates = this.getSelectedText().getE().getTextAnchor();
                            this.getSelectedText().setUser(new Coordinates(this.getSelectedText().getUser().getWidth() - coordinates.getWidth(), this.getSelectedText().getUser().getHeight() - coordinates.getHeight()));
                        }
                        this.cursorPosition = this.toCoord(mouseEvent.getX(), mouseEvent.getY());
                        break;
                    }
                    this.getSelectedText().setScreen((double)mouseEvent.getX() - this.textMove.getWidth(), (double)mouseEvent.getY() - this.textMove.getHeight());
                    this.getSelectedText().setUser(this.screen2user(this.getSelectedText().getScreen()));
                    if (this.getSelectedText().getE() != null) {
                        Coordinates coordinates = this.getSelectedText().getE().getTextAnchor();
                        this.getSelectedText().setUser(new Coordinates(this.getSelectedText().getUser().getWidth() - coordinates.getWidth(), this.getSelectedText().getUser().getHeight() - coordinates.getHeight()));
                    }
                    this.cursorPosition.setSize(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 79: {
                    this.clearTrace();
                    this.jep.setCursor(new Cursor(13));
                    this.origin.setSize(this.lastOrigin.getWidth() + (double)mouseEvent.getX() - this.cursorPosition.getWidth(), this.lastOrigin.getHeight() + (double)mouseEvent.getY() - this.cursorPosition.getHeight());
                    this.element.setElementsChanged(true);
                    this.calculateCalculatedElements(true);
                    this.points2screen(true);
                    break;
                }
            }
        }
        if (this.getModus() != 66) {
            this.calculateElements(false);
        }
        try {
            this.getSelectedPoint().setMoved(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.javaScript();
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        switch (this.getModus()) {
            case 66: {
                this.jep.setCursor(new Cursor(5));
                break;
            }
            case 210220: {
                this.jep.setCursor(new Cursor(1));
            }
            case 210260: {
                this.jep.setCursor(new Cursor(0));
                break;
            }
            case 80: {
                this.jep.setCursor(new Cursor(1));
                break;
            }
            case 79: {
                this.jep.setCursor(new Cursor(13));
                break;
            }
        }
        this.setInLogo(false);
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setInLogo(false);
        this.repaint();
        this.jep.setCursor(new Cursor(0));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setInLogo(false);
        if (!this.isListStatus()) {
            if (this.getModus() == 79) {
                this.jep.setCursor(new Cursor(13));
            } else if (this.getModus() == 210260) {
                if (this.pointsMovable() && this.getSelectedPoints().size() != 0 || !this.isControl() && mouseEvent.getX() < 60 && mouseEvent.getY() < 16) {
                    this.jep.setCursor(new Cursor(12));
                    if (!this.isControl() && mouseEvent.getX() < 60 && mouseEvent.getY() < 16) {
                        this.setInLogo(true);
                    } else {
                        this.setInLogo(false);
                    }
                } else {
                    this.jep.setCursor(new Cursor(0));
                    this.setInLogo(false);
                }
            } else if (this.getSelectedPoints().size() + this.getSelectedLines().size() + this.getSelectedCircles().size() + this.getSelectedTexts().size() + this.getSelectedGraphs().size() != 0) {
                if (this.getSelectedPoints().size() > 0 && this.getModus() == 80) {
                    this.jep.setCursor(new Cursor(12));
                } else {
                    this.jep.setCursor(new Cursor(0));
                }
            } else {
                this.jep.setCursor(new Cursor(1));
            }
            switch (this.getSelectedPoints().size()) {
                case 0: {
                    if (this.isToCoord()) {
                        this.cursorPosition = this.toCoord(mouseEvent.getX(), mouseEvent.getY());
                        break;
                    }
                    this.cursorPosition.setSize(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 1: {
                    if (this.getSelectedPoints().size() != 1) break;
                    this.cursorPosition.setSize(((Point)this.getSelectedPoints().lastElement()).getScreenX(), ((Point)this.getSelectedPoints().lastElement()).getScreenY());
                }
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        if (!this.element.hasAnimatedElements() || !this.isStatusBar() || mouseEvent.getX() <= this.jep.getWidth() - 18) {
            if (this.isStatusBar() && mouseEvent.getY() > this.jep.getHeight() - this.jep.getGraphics().getFontMetrics().getHeight() - 2) {
                if (this.getModus() == 210260) {
                    this.setStatusBar(false);
                }
                bl = true;
            } else if (mouseEvent.getX() + mouseEvent.getY() > this.jep.getWidth() + this.jep.getHeight() - this.jep.getGraphics().getFontMetrics().getHeight() - 2) {
                if (this.getModus() == 210260) {
                    this.setStatusBar(true);
                }
                bl = true;
            }
        }
        if (!bl) {
            switch (this.getModus()) {
                case 110005: {
                    this.stop();
                    if (this.geonextBoardDialog == null) {
                        this.geonextBoardDialog = new JFrameDialog("", new Dimension(600, 500), 7, this, false, true, true, true);
                    }
                    this.showGeonextDialog(this.geonextBoardDialog);
                    break;
                }
                case 86: {
                    this.stop();
                    if (this.geonextEditDialog == null) {
                        this.geonextEditDialog = new JFrameDialog("", new Dimension(600, 500), 6, this, false, false, false, true);
                    }
                    this.showGeonextDialog(this.geonextEditDialog);
                    if (this.getSelectedElements("Point;Line;Circle;Graph;Text").size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(this.getSelectedElements("Point;Line;Circle;Graph;Text"), this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                        break;
                    }
                    this.getGeonextEditDialog().jce.selectList(this.getSelectedElements("Point;Line;Circle;Graph;Text"));
                    this.getGeonextEditDialog().requestFocus();
                    break;
                }
                case 210310: {
                    this.jep.setCursor(new Cursor(2));
                    this.textMove.setSize(this.origin.getWidth(), this.origin.getHeight());
                    if (this.geonextTextDialog == null) {
                        this.geonextTextDialog = new JFrameDialog("", new Dimension(550, 400), 2, this, false, true, true, true);
                    }
                    this.showGeonextDialog(this.geonextTextDialog);
                    break;
                }
                case 79: {
                    this.jep.setCursor(new Cursor(13));
                    this.lastOrigin.setSize(this.origin.getWidth(), this.origin.getHeight());
                    this.repaint();
                    break;
                }
                case 66: {
                    this.zoomBox.setBounds(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
                    this.zoomBox.setActive(true);
                    this.repaint();
                    break;
                }
                case 77: {
                    switch (this.getSelectedPoints().size()) {
                        case 0: {
                            this.selectPoint(mouseEvent.getX(), mouseEvent.getY());
                            this.selection.addElement(this.getSelectedPoint());
                            break;
                        }
                        case 1: {
                            this.selection.addElement(this.getSelectedPoints().lastElement());
                            break;
                        }
                        default: {
                            this.jep.removeMouseMotionListener(this);
                            JPopupList jPopupList = new JPopupList(this.getSelectedPoints(), this);
                            this.add(jPopupList);
                            jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                            jPopupList.requestFocus();
                        }
                    }
                    if (this.selection.get(0) == this.selection.lastElement() && this.selection.size() > 3) {
                        this.createPolygon(this.selection, null, false);
                        this.selection = new Vector();
                    }
                    this.repaint();
                    break;
                }
                case 71: {
                    if (this.getSelectedPoints().size() > 0) {
                        this.setSelectedPoint((Point)this.getSelectedPoints().lastElement());
                        if (!this.selection.contains(this.getSelectedPoint())) {
                            if (this.getSelectedPoint().getParent() == null) {
                                this.selection.addElement(this.getSelectedPoint());
                                if (this.getSelectedPoint().getGroups().size() > 0) {
                                    for (int i = 0; i < ((Group)this.getSelectedPoint().getGroups().lastElement()).getGroup().size(); ++i) {
                                        if (this.selection.contains(((Group)this.getSelectedPoint().getGroups().lastElement()).getGroup().get(i))) continue;
                                        this.selection.addElement(((Group)this.getSelectedPoint().getGroups().lastElement()).getGroup().get(i));
                                    }
                                }
                            }
                        } else if (this.selection.size() > 1) {
                            this.createGroup(this.selection, "", false);
                            this.selection = new Vector();
                        }
                    }
                    this.repaint();
                    break;
                }
                case 85: {
                    if (this.getSelectedPoints().size() > 0) {
                        this.setSelectedPoint((Point)this.getSelectedPoints().lastElement());
                        if (this.getSelectedPoint().groups.size() > 0) {
                            Group group = (Group)this.getSelectedPoint().groups.lastElement();
                            for (int i = 0; i < group.group.size(); ++i) {
                                ((Point)group.group.get((int)i)).groups.remove(group);
                            }
                            this.element.remove(group);
                        }
                    }
                    if (this.getGeonextEditDialog() != null) {
                        this.getGeonextEditDialog().jce.refreshList();
                    }
                    this.repaint();
                    break;
                }
                case 210220: {
                    if (this.getSelectedPoints().size() <= 0) break;
                    this.setSelectedPoint((Point)this.getSelectedPoints().lastElement());
                    break;
                }
                case 210260: {
                    if (this.getSelectedPoints().size() > 0) {
                        for (int i = 0; i < this.getSelectedPoints().size(); ++i) {
                            if (((Point)this.getSelectedPoints().get(i)).getParent() != null && !((Point)this.getSelectedPoints().get(i) instanceof Slider) || this.getSelectedPoints().get(i) instanceof CASPoint) continue;
                            this.setSelectedPoint((Point)this.getSelectedPoints().get(i));
                        }
                    }
                    if (this.getSelectedTexts().size() > 0 && this.getSelectedPoint() == null) {
                        this.setSelectedText((Text)this.getSelectedTexts().lastElement());
                        this.textMove = new Coordinates((double)mouseEvent.getX() - this.getSelectedText().getScreen().getWidth(), (double)mouseEvent.getY() - this.getSelectedText().getScreen().getHeight());
                    }
                    if (!this.isControl() && mouseEvent.getX() < 60 && mouseEvent.getY() < 16) {
                        this.clearTrace();
                        this.restore();
                        this.repaint();
                    }
                    if (mouseEvent.getX() <= this.getWidth() - 18 || mouseEvent.getY() <= this.getHeight() - 17 || !this.element.hasAnimatedElements()) break;
                    if (this.motion == null) {
                        this.start();
                        break;
                    }
                    this.stop();
                    break;
                }
                case 80: {
                    this.selectPoint(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 210050: {
                    if (this.geonextCASPointDialog == null) {
                        this.geonextCASPointDialog = new JFrameDialog("", new Dimension(550, 400), 0, this, false, true, true, true);
                    }
                    this.showGeonextDialog(this.geonextCASPointDialog);
                    break;
                }
                case 210210: {
                    if (this.geonextGraphDialog == null) {
                        this.geonextGraphDialog = new JFrameDialog("", new Dimension(550, 150), 1, this, false, true, true, true);
                    }
                    this.showGeonextDialog(this.geonextGraphDialog);
                    break;
                }
                case 210270: {
                    if (this.geonextParameterCurveDialog == null) {
                        this.geonextParameterCurveDialog = new JFrameDialog("", new Dimension(550, 400), 13, this, false, true, true, true);
                    }
                    this.showGeonextDialog(this.geonextParameterCurveDialog);
                    break;
                }
                case 68: {
                    Vector vector = this.getSelectedElements("Point;Line;Circle;Graph;Text");
                    vector = this.cleanupSelectedElements(vector);
                    if (vector.size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(vector, this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else {
                        this.deleteElements(vector);
                    }
                    this.reset();
                    break;
                }
                case 210275: {
                    Vector vector = this.cleanupSelectedElements(this.getSelectedElements("Point;Line;Circle;Graph;Text"));
                    if (vector.size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(vector, this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else if (vector.size() == 1) {
                        this.geonext.jnp.setElement((Element)vector.get(0));
                    }
                    mouseEvent = null;
                    break;
                }
                case 210350: {
                    Vector vector = this.cleanupSelectedElements(this.getSelectedElements("Point;Line;Circle;Graph;Text"));
                    if (vector.size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(vector, this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else {
                        this.setElementsInvisible(vector);
                    }
                    this.reset();
                    break;
                }
                case 210200: {
                    Vector vector = this.cleanupSelectedElements(this.getSelectedElements("Point;Line;Circle;Graph;Text"));
                    if (vector.size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(vector, this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else {
                        this.setElementsDraft(vector);
                    }
                    this.reset();
                    break;
                }
                case 210290: {
                    if (this.getSelectedElements("Point;Line;Circle;Graph;Text").size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(this.getSelectedElements("Point;Line;Circle;Graph;Text"), this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else {
                        this.setElementsNameVisible(this.getSelectedElements("Point;Line;Circle;Graph"));
                    }
                    this.reset();
                    break;
                }
                case 210280: {
                    if (this.getSelectedElements("Point;Line;Circle;Graph").size() > 1) {
                        this.jep.removeMouseMotionListener(this);
                        JPopupList jPopupList = new JPopupList(this.getSelectedElements("Point;Line;Circle;Graph"), this);
                        this.add(jPopupList);
                        jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                        jPopupList.requestFocus();
                    } else {
                        this.setElementsTrace(this.getSelectedElements("Point;Line;Circle;Graph"));
                    }
                    this.reset();
                    break;
                }
                default: {
                    if (this.geonextValueDialog != null) {
                        this.geonextValueDialog.dispose();
                    }
                    this.geonextValueDialog = null;
                    this.cursorPosition = new Coordinates(mouseEvent.getX(), mouseEvent.getY());
                    if (!this.data.isActive()) {
                        this.data.setDataTypes(this.getModus());
                        this.selection = new Vector();
                    }
                    switch (this.getSelectedElements(this.data.getDataTypes()).size()) {
                        case 0: {
                            if (!this.data.inDataTypes("POINT") || this.getModus() == 210330 || this.getModus() == 210320 || this.getModus() == 210340 || this.getModus() == 210010) break;
                            this.selectPoint(mouseEvent.getX(), mouseEvent.getY());
                            this.selection.addElement(this.getSelectedPoint());
                            this.setSelectedElement(this.getSelectedPoint());
                            this.data.refreshDataTypes((Element)this.getSelectedElements(this.data.getDataTypes()).lastElement());
                            if (!this.data.getDataTypes().equals("")) break;
                            this.createElement(this.selection, null, false);
                            break;
                        }
                        case 1: {
                            this.selection.addElement(this.getSelectedElements(this.data.getDataTypes()).lastElement());
                            this.setSelectedElement((Element)this.getSelectedElements(this.data.getDataTypes()).lastElement());
                            this.data.refreshDataTypes((Element)this.getSelectedElements(this.data.getDataTypes()).lastElement());
                            if (!this.data.getDataTypes().equals("")) break;
                            this.createElement(this.selection, null, false);
                            break;
                        }
                        default: {
                            this.jep.removeMouseMotionListener(this);
                            JPopupList jPopupList = new JPopupList(this.getSelectedElements(this.data.getDataTypes()), this);
                            this.add(jPopupList);
                            jPopupList.show(this, mouseEvent.getX() + 10, mouseEvent.getY() + 10);
                            jPopupList.requestFocus();
                        }
                    }
                    this.jep.redrawGraphs = false;
                }
            }
        }
        this.repaint();
    }

    public Vector cleanupSelectedElements(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.get(i);
            int n = this.element.elements.indexOf(element);
            if (n >= 5 || n <= -1) continue;
            vector.removeElement(element);
            --i;
        }
        return vector;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isListStatus()) {
            this.setSelectedPoint(null);
            this.setSelectedText(null);
        }
        if (this.getModus() == 66) {
            this.zoomBox.setActive(false);
            if ((double)this.jep.getWidth() / (double)this.zoomBox.width < 10.0 && this.zoomBox.width > 0 && this.zoomBox.height > 0) {
                this.setOrigin(new Coordinates((int)((this.origin.getWidth() - (double)this.zoomBox.x) * (double)this.jep.getWidth() / (double)this.zoomBox.width), (int)((this.origin.getHeight() - (double)this.zoomBox.y) * (double)this.jep.getHeight() / (double)this.zoomBox.height)));
                this.setZoom(new Coordinates(this.getZoom().getWidth() * (double)this.jep.getWidth() / (double)this.zoomBox.width, this.getZoom().getHeight() * (double)this.jep.getHeight() / (double)this.zoomBox.height));
                this.setGrid(new Coordinates((int)(50.0 * this.getZoom().getWidth()), (int)(50.0 * this.getZoom().getHeight())));
            }
            this.calculateElements(true);
            this.points2screen();
            this.jep.setCursor(new Cursor(0));
            this.jep.setResized(true);
        }
        this.repaint();
        if (this.geonextValueDialog != null && this.geonextValueDialog.isVisible()) {
            this.showGeonextDialog(this.geonextValueDialog);
        }
    }

    public void moveGroup(double d, double d2) {
        Point point;
        int n;
        Vector vector = new Vector();
        for (n = 0; n < ((Group)this.getSelectedPoint().getGroups().lastElement()).getGroup().size(); ++n) {
            point = (Point)((Group)this.getSelectedPoint().getGroups().lastElement()).getGroup().get(n);
            for (int i = 0; i < point.getGroups().size(); ++i) {
                if (vector.contains(point.getGroups().get(i))) continue;
                vector.addElement(point.getGroups().get(i));
            }
            if (point != this.getSelectedPoint()) {
                point.setScreen(point.getScreenX() - d, point.getScreenY() - d2);
                this.screen2user(point);
                point.user2sphere();
            }
            point.setChanged(true);
        }
        for (n = 0; n < vector.size(); ++n) {
            point = ((Group)vector.get(n)).getCenter();
            point.setScreen(point.getScreenX() - d, point.getScreenY() - d2);
            this.screen2user(point);
            point.user2sphere();
        }
    }

    public String[] parse(String string, String string2) {
        String string3 = string;
        if (string != "") {
            string = string3.toLowerCase();
            try {
                String[] stringArray = new String[2];
                String string4 = "<" + string2.toLowerCase() + ">";
                stringArray[0] = string3.substring(0, string.indexOf(string4));
                string3 = string3.substring(string.indexOf(string4) + string4.length());
                string = string.substring(string.indexOf(string4) + string4.length());
                string4 = "</" + string2.toLowerCase() + ">";
                stringArray[0] = stringArray[0] + string3.substring(string.indexOf(string4) + string4.length(), string3.length());
                string3 = string3.substring(0, string.indexOf(string4));
                string = string.substring(0, string.indexOf(string4));
                stringArray[1] = string3;
                return stringArray;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{string3, ""};
                return stringArray;
            }
        }
        String[] stringArray = new String[]{string3, ""};
        return stringArray;
    }

    public Color parseColor(String string) {
        string = this.deleteChar(string, '#');
        boolean bl = true;
        int n = string.length();
        int[] nArray = new int[n];
        if (n == 6 || n == 8) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.parseHex(string.charAt(i));
                if (nArray[i] >= 0) continue;
                bl = false;
            }
            if (bl) {
                switch (n) {
                    case 6: {
                        return new Color(nArray[0] * 16 + nArray[1], nArray[2] * 16 + nArray[3], nArray[4] * 16 + nArray[5]);
                    }
                    case 8: {
                        return new Color(nArray[0] * 16 + nArray[1], nArray[2] * 16 + nArray[3], nArray[4] * 16 + nArray[5], nArray[6] * 16 + nArray[7]);
                    }
                }
            }
            return null;
        }
        return null;
    }

    public int parseHex(char c) {
        c = Character.toLowerCase(c);
        try {
            int n = Integer.parseInt("" + c);
            return n;
        }
        catch (Exception exception) {
            switch (c) {
                case 'a': {
                    return 10;
                }
                case 'b': {
                    return 11;
                }
                case 'c': {
                    return 12;
                }
                case 'd': {
                    return 13;
                }
                case 'e': {
                    return 14;
                }
                case 'f': {
                    return 15;
                }
            }
            return -1;
        }
    }

    public void points2screen() {
        this.points2screen(false);
    }

    public void points2screen(boolean bl) {
        for (int i = 0; i < this.element.point.size(); ++i) {
            this.user2screen((Point)this.element.point.get(i));
        }
        this.calculateVisibleArea();
        this.calculateCalculatedElements(bl);
    }

    public Vector readSource(String string) {
        Object object;
        Object[] objectArray;
        Object object2;
        Boolean bl;
        Rectangle rectangle;
        block64: {
            Object object3;
            String string2;
            String string3;
            rectangle = new Rectangle(0, 0, 400, 350);
            bl = Boolean.FALSE;
            try {
                string3 = this.parse(string, "size")[1];
                rectangle = new Rectangle((int)Double.parseDouble(this.parse(string3, "x")[1]), (int)Double.parseDouble(this.parse(string3, "y")[1]), (int)Double.parseDouble(this.parse(string3, "width")[1]), (int)Double.parseDouble(this.parse(string3, "height")[1]));
                bl = new Boolean(this.parse(string3, "maximized")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setFontSize(Integer.parseInt(this.parse(string, "fontsize")[1]) - 12);
            }
            catch (Exception exception) {
                if (Geonext.fileVersion.equals("1.05") | Geonext.fileVersion.equals("1.08") | Geonext.fileVersion.equals("1.10")) {
                    this.setFontSize(3);
                }
                this.setFontSize(0);
            }
            string = this.parse(string, "size")[0];
            string3 = this.parse(string, "coordinates")[1];
            string = this.parse(string, "coordinates")[0];
            try {
                this.setCoord(new Boolean(this.parse(string3, "coord")[1]));
                this.setCoordGrid(new Boolean(this.parse(string3, "grid")[1]));
                this.setToCoord(new Boolean(this.parse(string3, "snap")[1]));
                this.origin = new Coordinates();
                try {
                    string2 = this.parse(string3, "origin")[1];
                    this.origin.setSize(Double.parseDouble(this.parse(string2, "x")[1]), Double.parseDouble(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    this.origin = new Coordinates(200.0, 200.0);
                }
                this.zoom = new Coordinates();
                try {
                    string2 = this.parse(string3, "zoom")[1];
                    this.zoom.setSize(Double.parseDouble(this.parse(string2, "x")[1]), Double.parseDouble(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    this.zoom = new Coordinates(1.0, 1.0);
                }
                this.unit = new Coordinates();
                try {
                    string2 = this.parse(string3, "unit")[1];
                    this.unit.setSize(Double.parseDouble(this.parse(string2, "x")[1]), Double.parseDouble(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    this.unit = new Coordinates(50.0, 50.0);
                }
                this.coordXTerm = "";
                this.coordYTerm = "";
                try {
                    string2 = this.parse(string3, "term")[1];
                    this.coordXTerm = this.parse(string2, "x")[1];
                    this.coordYTerm = this.parse(string2, "y")[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.coordXLabel = "";
                this.coordYLabel = "";
                try {
                    string2 = this.parse(string3, "label")[1];
                    this.coordXLabel = this.parse(string2, "x")[1];
                    this.coordYLabel = this.parse(string2, "y")[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.coordXMulti = "";
                this.coordYMulti = "";
                try {
                    string2 = this.parse(string3, "multi")[1];
                    this.coordXMulti = this.parse(string2, "x")[1];
                    this.setCoordXMultiple(new Boolean(this.parse(string2, "showx")[1]));
                    this.coordYMulti = this.parse(string2, "y")[1];
                    this.setCoordYMultiple(new Boolean(this.parse(string2, "showy")[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = this.parse(string3, "continuous")[1];
                    this.setCoordXContinuous(new Boolean(this.parse(string2, "x")[1]));
                    this.setCoordYContinuous(new Boolean(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = this.parse(string3, "showunit")[1];
                    this.setCoordXShowUnit(new Boolean(this.parse(string2, "x")[1]));
                    this.setCoordYShowUnit(new Boolean(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = this.parse(string3, "axis")[1];
                    this.XLine.setVisible(false);
                    this.YLine.setVisible(false);
                    this.coordXObject = new Boolean(this.parse(string2, "x")[1]);
                    this.coordYObject = new Boolean(this.parse(string2, "y")[1]);
                    if (this.isCoord()) {
                        this.XLine.setVisible(true);
                        this.YLine.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = this.parse(string3, "xooy")[1];
                    this.XLine.setLoadID(this.parse(string2, "x")[1]);
                    this.YLine.setLoadID(this.parse(string2, "y")[1]);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = this.parse(string, "grid")[1];
            string = this.parse(string, "grid")[0];
            try {
                this.setCross(new Boolean(this.parse(string2, "cross")[1]));
                this.setGridDash(new Boolean(this.parse(string2, "dash")[1]));
                this.setPointSnap(new Boolean(this.parse(string2, "pointsnap")[1]));
                this.subGrid = new Coordinates();
                try {
                    this.subGrid.setSize(Double.parseDouble(this.parse(string2, "x")[1]), Double.parseDouble(this.parse(string2, "y")[1]));
                }
                catch (Exception exception) {
                    this.subGrid = new Coordinates(2.0, 2.0);
                }
                try {
                    object3 = this.parseColor(this.parse(string2, "color")[1]);
                    if (object3 == null) {
                        object3 = Color.lightGray;
                    }
                }
                catch (Exception exception) {
                    object3 = Color.white;
                }
                this.setGridColor((Color)object3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.grid = new Coordinates(50.0, 50.0);
            object3 = this.parse(string, "background")[1];
            string = this.parse(string, "background")[0];
            try {
                this.bgcolor = this.parseColor(this.parse((String)object3, "color")[1]);
                if (this.bgcolor == null) {
                    this.bgcolor = Color.white;
                }
            }
            catch (Exception exception) {
                this.bgcolor = Color.white;
            }
            this.setBackground(this.bgcolor);
            String string4 = this.parse((String)object3, "file")[1];
            try {
                block65: {
                    Image image = this.getImage(this.parse(string4, "name")[1]);
                    if (this.parse(string4, "src")[1].length() > 0) {
                        image = this.getToolkit().createImage(Base64.decode(this.parse(string4, "src")[1]));
                    }
                    if (image == null) break block64;
                    object2 = new MediaTracker(this);
                    ((MediaTracker)object2).addImage(image, 1);
                    try {
                        ((MediaTracker)object2).waitForAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.backgroundFile = this.getFile(this.parse(string4, "name")[1]);
                        this.backgroundFileExtention = this.parse(string4, "name")[1].substring(this.parse(string4, "name")[1].lastIndexOf(46), this.parse(string4, "name")[1].length());
                        this.setBackImageFileName(this.parse(string4, "name")[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.jep.setImage(null);
                    this.jep.setBackImage(image);
                    try {
                        this.jep.imageCoord = new Coordinates(Double.parseDouble(this.parse(string4, "x")[1]), Double.parseDouble(this.parse(string4, "y")[1]));
                    }
                    catch (Exception exception) {
                        this.jep.imageCoord = new Coordinates(0.0, 0.0);
                    }
                    try {
                        this.jep.imageSize = new Coordinates(Double.parseDouble(this.parse(string4, "width")[1]), Double.parseDouble(this.parse(string4, "height")[1]));
                    }
                    catch (Exception exception) {
                        if (image == null) break block65;
                        this.jep.imageSize = new Coordinates(this.screen2userX(this.getOrigin().getWidth() + (double)image.getWidth(this)), this.screen2userY(this.getOrigin().getHeight() - (double)image.getHeight(this)));
                    }
                }
                this.jep.setResized(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl2 = true;
        object2 = this.parse(string, "elements")[1];
        string = this.parse(string, "elements")[0];
        Class<?> clazz = new Element().getClass();
        Class[] classArray = new Class[]{new JBoardPane().getClass(), new String().getClass()};
        try {
            objectArray = new Object[2];
            objectArray[0] = this;
            while (bl2) {
                object = ((String)object2).substring(((String)object2).indexOf("<") + 1, ((String)object2).indexOf(">")).toLowerCase();
                objectArray[1] = this.parse((String)object2, (String)object)[1];
                object2 = this.parse((String)object2, (String)object)[0];
                if (((String)(object = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1, ((String)object).length()))).equals("Cas")) {
                    object = "CASPoint";
                } else if (((String)object).equals("Tracecurve")) {
                    object = "TraceCurve";
                }
                if (((String)object).equals("Parametercurve")) {
                    object = "ParameterCurve";
                }
                try {
                    clazz = Class.forName("geonext." + (String)object);
                    Method method = clazz.getMethod("parse", classArray);
                    bl2 = (Boolean)method.invoke(clazz.getConstructor(null).newInstance(null), objectArray);
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle(this.parse(string, "name")[1]);
        try {
            ((JBoard)this.getParent().getParent().getParent().getParent()).setTitle(" " + this.getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInfo(this.parse(string, "information")[1]);
        this.setAuthor(this.parse(string, "author")[1]);
        this.setComment(this.parse(string, "comment")[1]);
        objectArray = this.parse(string, "conditions")[1];
        string = this.parse(string, "conditions")[0];
        this.conditions = new Vector();
        try {
            while (!this.parse((String)objectArray, "data")[1].equals("")) {
                object = this.createCondition(this.parse((String)objectArray, "data")[1]);
                if (object != null) {
                    this.conditions.addElement(object);
                }
                objectArray = this.parse((String)objectArray, "data")[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.element.setElementsChanged(true);
        this.calculateElements();
        this.element.setElementsChanged(false);
        this.freeze();
        object = new Vector<Serializable>();
        ((Vector)object).add(rectangle);
        ((Vector)object).add(bl);
        this.setSaved(true);
        return object;
    }

    public void reset() {
        this.setSelectedPoint(null);
        this.setSelectedText(null);
        this.getSelectedLine().setA(null);
        this.getSelectedLine().setB(null);
        this.getSelectedCircle().setM(null);
        this.getSelectedCircle().setP(null);
        this.data.setActive(false);
        this.selection = new Vector();
        this.setSelectedElement(null);
        this.selectedGraph = new Graph();
        this.repaint();
    }

    public void resetSelectedElements() {
        this.setSelectedPoint(null);
        this.setSelectedLine(null);
        this.setSelectedCircle(null);
    }

    public void restore() {
        SessionData.remove(this.internalName);
        this.usedNames = new Vector();
        ElementSet elementSet = this.copyElementSet(this.element);
        this.element = new ElementSet();
        this.selectedPoint = null;
        this.selectedLine = new Line();
        this.selectedLine.setA(null);
        this.selectedLine.setB(null);
        this.selectedCircle = new Circle();
        this.selectedCircle.setM(null);
        this.selectedCircle.setP(null);
        this.selectedElement = null;
        this.selection = new Vector();
        this.selectionCount = 0;
        this.sd = new SessionData(this.internalName, this.element);
        this.sd.put(this.internalName);
        C.boardName = this.internalName;
        this.undo.addEdit(this.copyElementSet(this.element));
        this.setCoordinateSystem();
        this.setVisibleArea();
        this.readSource(this.freeze);
        this.undo.addEdit(this.copyElementSet(elementSet));
        this.undo.addEdit(this.copyElementSet(elementSet));
    }

    public String rgb2svgrgb(Color color) {
        if (color != null) {
            String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            return string;
        }
        return null;
    }

    public String rgb2svgrgb(Color color, boolean bl) {
        if (bl) {
            if (color != null) {
                String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                return string;
            }
            return null;
        }
        return null;
    }

    public void rotateGroup(double d) {
        Point point;
        int n;
        Vector vector = new Vector();
        Group group = (Group)this.getSelectedPoint().getGroups().lastElement();
        for (n = 0; n < group.getGroup().size(); ++n) {
            point = (Point)group.getGroup().get(n);
            for (int i = 0; i < point.getGroups().size(); ++i) {
                if (vector.contains(point.getGroups().get(i))) continue;
                vector.addElement(point.getGroups().get(i));
            }
        }
        this.screen2user(group.center);
        for (n = 0; n < group.getGroup().size(); ++n) {
            point = (Point)group.getGroup().get(n);
            point.rotate(d, group.center);
            this.user2screen(point);
            point.user2sphere();
        }
        for (n = 0; n < vector.size(); ++n) {
            point = ((Group)vector.get(n)).getCenter();
            point.rotate(d, group.center);
            this.user2screen(point);
            point.user2sphere();
        }
    }

    public int round(double d) {
        return (int)Math.round(d);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.motion == thread) {
            for (int i = 0; i < this.element.slider.size(); ++i) {
                if (!((Slider)this.element.slider.get(i)).isAnimated()) continue;
                ((Slider)this.element.slider.get(i)).run();
            }
            this.calculateElements();
            this.points2screen();
            this.repaint();
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {}
        }
    }

    public Image getImage(String string) {
        if (!string.equals("")) {
            Image image = null;
            Container container = this;
            MediaTracker mediaTracker = new MediaTracker(this);
            if (Geonext.applicationMode) {
                while (container != null) {
                    if (container instanceof JBoard) {
                        try {
                            String string2 = ((JBoard)container).filename;
                            string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1) + string;
                            image = this.getToolkit().createImage(string2);
                            mediaTracker.addImage(image, 0);
                            mediaTracker.waitForID(0);
                            if ((double)image.getWidth(null) < 0.1 | (double)image.getHeight(null) < 0.1) {
                                return null;
                            }
                            return image;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    container = ((Component)container).getParent();
                }
            }
            try {
                String string3 = "" + this.geonext.getDocumentBase();
                string3 = string3.substring(0, string3.lastIndexOf("/") + 1) + string;
                image = this.geonext.getImage(new URL(string3));
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                if ((double)image.getWidth(null) < 0.1 | (double)image.getHeight(null) < 0.1) {
                    return null;
                }
                return image;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public File getFile(String string) {
        if (!string.equals("")) {
            Container container = this;
            while (container != null) {
                if (container instanceof JBoard) {
                    try {
                        String string2 = ((JBoard)container).filename;
                        string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1) + string;
                        return new File(string2);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                container = ((Component)container).getParent();
            }
            try {
                String string3 = "" + this.geonext.getDocumentBase();
                string3 = string3.substring(0, string3.lastIndexOf("/") + 1) + string;
                return new File(string3);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public Coordinates screen2user(Coordinates coordinates) {
        return new Coordinates((coordinates.getWidth() - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth()), (this.origin.getHeight() - coordinates.getHeight()) / (this.unit.getHeight() * this.zoom.getHeight()));
    }

    public void screen2user(Point point) {
        point.setUser(this.screen2user(point.getScreen()));
    }

    public double screen2userX(double d) {
        return (d - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth());
    }

    public double screen2userY(double d) {
        return (this.origin.getHeight() - d) / (this.unit.getHeight() * this.zoom.getHeight());
    }

    public void select(Element element) {
        this.setSelectedElement(element);
        this.selection.addElement(element);
        if (this.selection.size() == this.getSelectionCount()) {
            switch (this.getModus()) {
                case 80: {
                    break;
                }
                case 76: {
                    break;
                }
                case 67: {
                    break;
                }
                case 88: {
                    this.createIntersection((Element)this.selection.get(0), (Element)this.selection.get(1), null, false);
                    this.selection = new Vector();
                    this.setSelectedElement(null);
                    this.repaint();
                    break;
                }
                case 75: {
                    if (this.selection.size() != this.getSelectionCount()) break;
                    this.createComposition(this.getCompositionType(), this.getSelection(), null, false);
                    this.selection = new Vector();
                    this.setSelectedElement(null);
                    break;
                }
            }
        }
    }

    public Point selectPoint(int n, int n2) {
        if (this.getSelectedPoints().size() > 1) {
            for (int i = 0; i < this.getSelectedPoints().size(); ++i) {
                if (((Point)this.getSelectedPoints().get(i)).getParent() != null && !((Point)this.getSelectedPoints().get(i) instanceof Slider) || this.getSelectedPoints().get(i) instanceof CASPoint) continue;
                this.setSelectedPoint((Point)this.getSelectedPoints().get(i));
            }
        } else {
            int n3 = 0;
            if (this.getSelectedElements("Line;Circle").size() == 2 && this.getSelectedPoints().size() == 0) {
                n3 = this.getModus();
                this.setModus(88);
                this.createIntersection((Element)this.getSelectedElements("Line;Circle").get(0), (Element)this.getSelectedElements("Line;Circle").get(1), "", false);
                this.calculateElements();
                this.setModus(n3);
                Intersection intersection = (Intersection)this.element.elements.lastElement();
                if (intersection.getType() == 0) {
                    this.setSelectedPoint(intersection.getA());
                    intersection.getA().setMode(true);
                } else {
                    Coordinates coordinates = new Coordinates(n, n2);
                    if (intersection.getA().getScreen().distance(coordinates) < (double)intersection.getA().getArea()) {
                        this.setSelectedPoint(intersection.getA());
                        intersection.getA().setMode(true);
                    } else {
                        this.setSelectedPoint(intersection.getB());
                        intersection.getB().setMode(true);
                    }
                }
            } else if (this.getSelectedElements("Line;Circle;Graph").size() == 1 && this.getSelectedPoints().size() == 0) {
                n3 = this.getModus();
                this.setModus(210300);
                this.createSlider((Element)this.getSelectedElements("Line;Circle;Graph").get(0), "", false);
                this.setModus(n3);
                this.setSelectedPoint((Point)this.element.elements.lastElement());
                ((Point)this.element.elements.lastElement()).setMode(true);
            } else if (this.getSelectedPoints().size() > 0 || this.getSelectedElements("Point;Line;Circle;Graph").size() == 0) {
                Point point;
                Coordinates coordinates = this.toCoord(n, n2);
                double d = 0.0;
                double d2 = 0.0;
                if (this.isToCoord()) {
                    d = this.round(coordinates.getWidth());
                    d2 = this.round(coordinates.getHeight());
                } else {
                    d = n;
                    d2 = n2;
                }
                if (this.getSelectedPoints().size() == 0) {
                    this.createPoint(d, d2, null, false);
                    point = (Point)this.element.point.lastElement();
                    point.setMode(true);
                } else {
                    point = this.getSelectedPoints().size() == 1 ? (Point)this.getSelectedPoints().lastElement() : null;
                }
                this.setSelectedPoint(point);
            }
        }
        return null;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setBackImageFileName(String string) {
        this.backImageFileName = string;
    }

    public void setBgcolor(Color color) {
        this.bgcolor = color;
    }

    public void setBLine(Line line) {
        this.BLine = line;
    }

    public void setBLPoint(Point point) {
        this.BLPoint = point;
    }

    public void setBRPoint(Point point) {
        this.BRPoint = point;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setCompositionType(int n) {
        this.compositionType = n;
    }

    public void setControl(boolean bl) {
        this.control = bl;
    }

    public void setCoord(boolean bl) {
        this.coord = bl;
    }

    public void setCoordGrid(boolean bl) {
        this.coordGrid = bl;
    }

    public void setCoordinateSystem() {
        this.OOPoint = new Point("OO", 0, 0);
        this.OOPoint.setUser(0.0, 0.0);
        this.user2screen(this.OOPoint);
        this.OOPoint.user2sphere();
        this.OOPoint.setComposition(false);
        this.OOPoint.setActive(true);
        this.OOPoint.setVisible(false);
        this.OOPoint.setMoved(true);
        this.OOPoint.setLoadID("OO");
        this.element.add(this.OOPoint);
        this.XOPoint = new Point("XO", 0, 0);
        this.XOPoint.setUser(1.0, 0.0);
        this.user2screen(this.XOPoint);
        this.XOPoint.user2sphere();
        this.XOPoint.setComposition(false);
        this.XOPoint.setActive(true);
        this.XOPoint.setVisible(false);
        this.XOPoint.setMoved(true);
        this.XOPoint.setLoadID("XO");
        this.element.add(this.XOPoint);
        this.OYPoint = new Point("OY", 0, 0);
        this.OYPoint.setUser(0.0, 1.0);
        this.user2screen(this.OYPoint);
        this.OYPoint.user2sphere();
        this.OYPoint.setComposition(false);
        this.OYPoint.setActive(true);
        this.OYPoint.setVisible(false);
        this.OYPoint.setMoved(true);
        this.OYPoint.setLoadID("OY");
        this.element.add(this.OYPoint);
        this.XLine = new Line("XL", 0, this.OOPoint, this.XOPoint, 0);
        this.XLine.setTrace(false);
        this.XLine.setComposition(false);
        this.XLine.setFirst(true);
        this.XLine.setLast(true);
        this.XLine.setActive(true);
        this.XLine.setVisible(false);
        this.XLine.setStroke(Color.gray);
        this.XLine.setLighting(Color.black);
        this.XLine.setLoadID("XL");
        this.XLine.setEditable(false);
        this.element.setName(this.XLine, Geonext.language.getString("jboardpane_axis_x"));
        this.element.add(this.XLine);
        this.jep.addMouseMotionListener(this.XLine);
        this.YLine = new Line("YL", 0, this.OOPoint, this.OYPoint, 0);
        this.YLine.setTrace(false);
        this.YLine.setComposition(false);
        this.YLine.setFirst(true);
        this.YLine.setLast(true);
        this.YLine.setActive(true);
        this.YLine.setVisible(false);
        this.YLine.setStroke(Color.gray);
        this.YLine.setLighting(Color.black);
        this.YLine.setLoadID("YL");
        this.YLine.setEditable(false);
        this.element.setName(this.YLine, Geonext.language.getString("jboardpane_axis_y"));
        this.element.add(this.YLine);
        this.jep.addMouseMotionListener(this.YLine);
        this.undo.addEdit(this.copyElementSet(this.element));
    }

    public void setCoordLabel(boolean bl) {
        this.coordLabel = bl;
    }

    public void setCoordXContinuous(boolean bl) {
        this.coordXContinuous = bl;
    }

    public void setCoordXMultiple(boolean bl) {
        this.coordXMultiple = bl;
    }

    public void setCoordXShowUnit(boolean bl) {
        this.coordXShowUnit = bl;
    }

    public void setCoordYContinuous(boolean bl) {
        this.coordYContinuous = bl;
    }

    public void setCoordYMultiple(boolean bl) {
        this.coordYMultiple = bl;
    }

    public void setCoordYShowUnit(boolean bl) {
        this.coordYShowUnit = bl;
    }

    public void setCross(boolean bl) {
        this.cross = bl;
    }

    public void setCursorPosition(Coordinates coordinates) {
        this.cursorPosition = coordinates;
    }

    public void setDashArray() {
        this.dashArray = new float[][]{{2.0f, 2.0f}, {5.0f, 5.0f}, {10.0f, 10.0f}, {20.0f, 20.0f}, {20.0f, 10.0f, 10.0f, 10.0f}, {20.0f, 5.0f, 10.0f, 5.0f}, {20.0f, 1.0f, 16.0f, 2.0f, 12.0f, 3.0f, 8.0f, 4.0f, 4.0f, 5.0f, 2.0f, 6.0f, 1.0f, 6.0f, 2.0f, 5.0f, 4.0f, 4.0f, 8.0f, 3.0f, 12.0f, 2.0f, 16.0f, 1.0f}};
    }

    public void setData(ConstructionData constructionData) {
        this.data = constructionData;
    }

    public void setElement(ElementSet elementSet) {
        this.element = elementSet;
    }

    public void setElementsDraft(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (((Element)vector.get(i)).isDraft()) {
                ((Element)vector.get(i)).setDraft(false);
                continue;
            }
            ((Element)vector.get(i)).setDraft(true);
        }
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void setElementsInvisible(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ((Element)vector.get(i)).setVisible(!((Element)vector.get((int)i)).visible);
        }
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void setElementsNameVisible(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (((Element)vector.get(i)).getLabel().getAlpha() == 0) {
                ((Element)vector.get(i)).setLabel(new Color(((Element)vector.get(i)).getLabel().getRed(), ((Element)vector.get(i)).getLabel().getGreen(), ((Element)vector.get(i)).getLabel().getBlue(), 255));
                continue;
            }
            ((Element)vector.get(i)).setLabel(new Color(((Element)vector.get(i)).getLabel().getRed(), ((Element)vector.get(i)).getLabel().getGreen(), ((Element)vector.get(i)).getLabel().getBlue(), 0));
        }
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void setElementsTrace(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (((Element)vector.get(i)).isTrace()) {
                ((Element)vector.get(i)).setTrace(false);
                continue;
            }
            ((Element)vector.get(i)).setTrace(true);
        }
        if (this.getGeonextEditDialog() != null) {
            this.getGeonextEditDialog().jce.refreshList();
        }
    }

    public void setFreeze(String string) {
        this.freeze = string;
    }

    public void setGeonextBoardDialog(JFrameDialog jFrameDialog) {
        this.geonextBoardDialog = jFrameDialog;
    }

    public void setGeonextCASDialog(JFrameDialog jFrameDialog) {
        this.geonextCASDialog = jFrameDialog;
    }

    public void setGeonextCASPointDialog(JFrameDialog jFrameDialog) {
        this.geonextCASPointDialog = jFrameDialog;
    }

    public void setGeonextDialog(JFrameDialog jFrameDialog) {
        this.geonextDialog = jFrameDialog;
    }

    public void setGeonextGraphDialog(JFrameDialog jFrameDialog) {
        this.geonextGraphDialog = jFrameDialog;
    }

    public void setGeonextParameterCurveDialog(JFrameDialog jFrameDialog) {
        this.geonextParameterCurveDialog = jFrameDialog;
    }

    public void setGeonextTextDialog(JFrameDialog jFrameDialog) {
        this.geonextTextDialog = jFrameDialog;
    }

    public void setGeonextValueDialog(JFrameDialog jFrameDialog) {
        this.geonextValueDialog = jFrameDialog;
    }

    public void setGraphHistoryString(Vector vector) {
        this.graphHistoryString = vector;
    }

    public void setGrid(Coordinates coordinates) {
        this.grid = coordinates;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setGridDash(boolean bl) {
        this.gridDash = bl;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public void setInLogo(boolean bl) {
        this.inLogo = bl;
    }

    public void setInternalName(String string) {
        this.internalName = string;
    }

    public void setJep(JElementPane jElementPane) {
        this.jep = jElementPane;
    }

    public void setJsp(JScrollPane jScrollPane) {
        this.jsp = jScrollPane;
    }

    public void setJsWindow(JSObject jSObject) {
        this.jsWindow = jSObject;
    }

    public void setLastOrigin(Coordinates coordinates) {
        this.lastOrigin = coordinates;
    }

    public void setListStatus(boolean bl) {
        this.listStatus = bl;
    }

    public void setLLine(Line line) {
        this.LLine = line;
    }

    public void setModus(int n) {
        this.setPreviousModus(this.getModus());
        if (this.modus == 210300 || this.modus == 88) {
            for (int i = 0; i < this.element.graph.size(); ++i) {
                Graph graph = (Graph)this.element.graph.elementAt(i);
                this.jep.removeMouseMotionListener(graph);
                graph.setMode(false);
            }
        }
        this.modus = n;
        if (this.modus == 210300 || this.modus == 88) {
            for (int i = 0; i < this.element.graph.size(); ++i) {
                this.jep.addMouseMotionListener((Graph)this.element.graph.elementAt(i));
            }
        }
    }

    public void setMotion(Thread thread) {
        this.motion = thread;
    }

    public void setOOPoint(Point point) {
        this.OOPoint = point;
    }

    public void setOrigin(Coordinates coordinates) {
        this.origin = coordinates;
    }

    public void setOYPoint(Point point) {
        this.OYPoint = point;
    }

    public void setPointImage(Image image) {
        this.pointImage = image;
    }

    public void setRLine(Line line) {
        this.RLine = line;
    }

    public void setSelectedCircle(Circle circle) {
        this.selectedCircle = circle;
    }

    public void setSelectedElement(Element element) {
        this.selectedElement = element;
    }

    public void setSelectedGraph(Graph graph) {
        this.selectedGraph = graph;
    }

    public void setSelectedLine(Line line) {
        this.selectedLine = line;
    }

    public void setSelectedPoint(Point point) {
        this.selectedPoint = point;
    }

    public void setSelectedText(Text text) {
        this.selectedText = text;
    }

    public void setSelection(Vector vector) {
        this.selection = vector;
    }

    public void setSelectionCount(int n) {
        this.selectionCount = n;
    }

    public void setSelectionType(Vector vector) {
        this.selectionType = vector;
    }

    public void setSnaptogrid(String string) {
        this.snaptogrid = string;
    }

    public void setStatus(boolean bl) {
        this.status = bl;
    }

    public void setStatusBar(boolean bl) {
        this.statusBar = bl;
    }

    public Stroke setStroke(int n, int n2) {
        if (this.isAntiAlias()) {
            if (n2 > 0) {
                return new BasicStroke((float)n * 0.7f, 0, 2, 8.0f, this.dashArray[n2 - 1], 0.0f);
            }
            return new BasicStroke((float)n * 0.7f);
        }
        return new BasicStroke(1.0f);
    }

    public void setSubGrid(Coordinates coordinates) {
        this.subGrid = coordinates;
    }

    public void setTextMove(Coordinates coordinates) {
        this.textMove = coordinates;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTLine(Line line) {
        this.TLine = line;
    }

    public void setTLPoint(Point point) {
        this.TLPoint = point;
    }

    public void setToCoord(boolean bl) {
        this.toCoord = bl;
    }

    public void setTRPoint(Point point) {
        this.TRPoint = point;
    }

    public void setUnit(Coordinates coordinates) {
        this.unit = coordinates;
    }

    public void setUsedNames(Vector vector) {
        this.usedNames = vector;
    }

    public void setValueHistoryString(Vector vector) {
        this.valueHistoryString = vector;
    }

    public void setVisibleArea() {
        this.TLPoint = new Point("TLP", 0, 0);
        this.TLPoint.setScreen(0.0, 0.0);
        this.screen2user(this.TLPoint);
        this.TLPoint.user2sphere();
        this.BLPoint = new Point("BLP", 0, 0);
        this.BLPoint.setScreen(0.0, 2000.0);
        this.screen2user(this.BLPoint);
        this.BLPoint.user2sphere();
        this.TRPoint = new Point("TRP", 0, 0);
        this.TRPoint.setScreen(2000.0, 0.0);
        this.screen2user(this.TRPoint);
        this.TRPoint.user2sphere();
        this.BRPoint = new Point("BRP", 0, 0);
        this.BRPoint.setScreen(2000.0, 2000.0);
        this.screen2user(this.BRPoint);
        this.BRPoint.user2sphere();
        this.TLine = new Line("TL", 0, this.TLPoint, this.TRPoint, 0);
        this.TLine.setFirst(false);
        this.TLine.setLast(false);
        this.BLine = new Line("BL", 0, this.BLPoint, this.BRPoint, 0);
        this.BLine.setFirst(false);
        this.BLine.setLast(false);
        this.LLine = new Line("LL", 0, this.TLPoint, this.BLPoint, 0);
        this.LLine.setFirst(false);
        this.LLine.setLast(false);
        this.RLine = new Line("RL", 0, this.TRPoint, this.BRPoint, 0);
        this.RLine.setFirst(false);
        this.RLine.setLast(false);
    }

    public void setXLine(Line line) {
        this.XLine = line;
    }

    public void setXOPoint(Point point) {
        this.XOPoint = point;
    }

    public void setYLine(Line line) {
        this.YLine = line;
    }

    public void setZoom(Coordinates coordinates) {
        this.zoom = coordinates;
    }

    public void setZoomMax(Coordinates coordinates) {
        this.zoomMax = coordinates;
    }

    public void setZoomMin(Coordinates coordinates) {
        this.zoomMin = coordinates;
    }

    public void showGeonextDialog(JFrameDialog jFrameDialog) {
        jFrameDialog.reset();
        jFrameDialog.pack();
        jFrameDialog.setExtendedState(0);
        jFrameDialog.setVisible(true);
        jFrameDialog.show();
        jFrameDialog.requestFocus();
        jFrameDialog.toFront();
    }

    public double sp(Coordinates coordinates, Coordinates coordinates2) {
        return (coordinates.getWidth() * coordinates2.getWidth() + coordinates.getHeight() * coordinates2.getHeight()) / (coordinates.distance() * coordinates2.distance());
    }

    public void start() {
        this.motion = null;
        this.motion = new Thread(this);
        boolean bl = false;
        for (int i = 0; i < this.element.slider.size(); ++i) {
            if (!((Slider)this.element.slider.get(i)).isAnimated()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.motion.start();
        } else {
            this.motion = null;
        }
    }

    public void stepDown() {
        this.clearTrace();
        this.origin.setSize(this.round(this.origin.getWidth()), this.round(this.origin.getHeight() - this.getSize().getHeight() / 4.0));
        this.points2screen();
    }

    public void stepLeft() {
        this.clearTrace();
        this.origin.setSize(this.round(this.origin.getWidth() + this.getSize().getWidth() / 4.0), this.round(this.origin.getHeight()));
        this.points2screen();
    }

    public void stepRight() {
        this.clearTrace();
        this.origin.setSize(this.round(this.origin.getWidth() - this.getSize().getWidth() / 4.0), this.round(this.origin.getHeight()));
        this.points2screen();
    }

    public void stepUp() {
        this.clearTrace();
        this.origin.setSize(this.round(this.origin.getWidth()), this.round(this.origin.getHeight() + this.getSize().getHeight() / 4.0));
        this.points2screen();
    }

    public void stop() {
        if (this.motion != null) {
            this.motion = null;
            this.calculateElements();
        }
    }

    public double svgX(int n) {
        return (double)n / (this.unit.getWidth() * this.zoom.getWidth());
    }

    public double svgY(int n) {
        return (double)n / (this.unit.getHeight() * this.zoom.getHeight());
    }

    public Coordinates toCoord(double d, double d2) {
        return this.user2screen(this.toCoordS2U(d, d2));
    }

    public Coordinates toCoordS2U(double d, double d2) {
        Coordinates coordinates = new Coordinates(d, d2);
        Coordinates coordinates2 = this.screen2user(coordinates);
        if (!this.isPointSnap()) {
            int n = 10;
            int n2 = 20;
            Coordinates coordinates3 = new Coordinates(1.0, 1.0);
            Coordinates coordinates4 = this.user2screen(coordinates3);
            coordinates4.setSize(coordinates4.getWidth() - this.origin.getWidth(), -coordinates4.getHeight() + this.origin.getHeight());
            Coordinates coordinates5 = new Coordinates(-1.0, -1.0);
            if ((double)((int)coordinates4.getWidth()) / this.getSubGrid().getWidth() > (double)n) {
                coordinates4.setWidth(coordinates4.getWidth() / this.getSubGrid().getWidth());
                coordinates5.setWidth(this.getSubGrid().getWidth());
                while ((int)coordinates4.getWidth() > n2) {
                    coordinates5.setWidth(coordinates5.getWidth() * 2.0);
                    coordinates4.setWidth(coordinates4.getWidth() / 2.0);
                }
            }
            if ((double)((int)coordinates4.getHeight()) / this.getSubGrid().getHeight() > (double)n) {
                coordinates4.setHeight(coordinates4.getHeight() / this.getSubGrid().getHeight());
                coordinates5.setHeight(this.getSubGrid().getHeight());
                while ((int)coordinates4.getHeight() > n2) {
                    coordinates5.setHeight(coordinates5.getHeight() * 2.0);
                    coordinates4.setHeight(coordinates4.getHeight() / 2.0);
                }
            }
            if (coordinates5.getWidth() < 0.0) {
                coordinates5.setWidth(0.0);
            }
            if (coordinates5.getHeight() < 0.0) {
                coordinates5.setHeight(0.0);
            }
            coordinates3 = new Coordinates(coordinates3.getWidth() / coordinates5.getWidth(), coordinates3.getHeight() / coordinates5.getHeight());
            Coordinates coordinates6 = new Coordinates(this.round(coordinates2.getWidth()), this.round(coordinates2.getHeight()));
            Coordinates coordinates7 = new Coordinates(coordinates2.getWidth() - coordinates6.getWidth(), coordinates2.getHeight() - coordinates6.getHeight());
            if (Math.abs(coordinates7.getWidth() % coordinates3.getWidth()) < coordinates3.getWidth() / 2.0) {
                coordinates2.setWidth(coordinates6.getWidth() + coordinates7.getWidth() - coordinates7.getWidth() % coordinates3.getWidth());
            } else if (coordinates7.getWidth() % coordinates3.getWidth() < 0.0) {
                coordinates2.setWidth(coordinates6.getWidth() + coordinates7.getWidth() - coordinates7.getWidth() % coordinates3.getWidth() - coordinates3.getWidth());
            } else {
                coordinates2.setWidth(coordinates6.getWidth() + coordinates7.getWidth() - coordinates7.getWidth() % coordinates3.getWidth() + coordinates3.getWidth());
            }
            if (Math.abs(coordinates7.getHeight() % coordinates3.getHeight()) < coordinates3.getHeight() / 2.0) {
                coordinates2.setHeight(coordinates6.getHeight() + coordinates7.getHeight() - coordinates7.getHeight() % coordinates3.getHeight());
            } else if (coordinates7.getHeight() % coordinates3.getHeight() < 0.0) {
                coordinates2.setHeight(coordinates6.getHeight() + coordinates7.getHeight() - coordinates7.getHeight() % coordinates3.getHeight() - coordinates3.getHeight());
            } else {
                coordinates2.setHeight(coordinates6.getHeight() + coordinates7.getHeight() - coordinates7.getHeight() % coordinates3.getHeight() + coordinates3.getHeight());
            }
        }
        Vector vector = this.getSelectedPoints();
        vector.remove(this.getSelectedPoint());
        if (vector.size() > 0 && ((Point)vector.get(0)).isActive()) {
            coordinates2.setWidth(((Point)vector.get(0)).getUserX());
            coordinates2.setHeight(((Point)vector.get(0)).getUserY());
        }
        return coordinates2;
    }

    public void toSVG(String string, double d, boolean bl) {
        double d2 = d;
        double d3 = d;
        if (!string.toLowerCase().endsWith(".svg")) {
            string = string + ".svg";
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.toSVGSource(d, bl);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toSVGSource(double d, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        Object object2;
        double d2;
        double d3;
        double d4;
        Object object3;
        double d5 = d;
        double d6 = d;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
        stringBuffer.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000303 Stylable//EN\" \"http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd\">\n");
        if (!bl) {
            stringBuffer.append("<svg width=\"" + this.getSize().width + "\" height=\"" + this.getSize().height + " \">\n");
        } else {
            stringBuffer.append("<svg width=\"" + this.svgX(this.getSize().width) * d5 + "cm\" height=\"" + this.svgY(this.getSize().height) * d6 + "cm\" viewBox=\"0 0 " + this.getSize().width + " " + this.getSize().height + "\">\n");
        }
        if (this.isCoord() || this.isCoordGrid()) {
            int n6;
            Coordinates coordinates = this.screen2user(new Coordinates(0.0, 0.0));
            object3 = this.screen2user(new Coordinates(this.getWidth(), this.getHeight()));
            double d7 = coordinates.getWidth();
            d4 = coordinates.getHeight();
            d3 = ((Coordinates)object3).getWidth();
            d2 = ((Coordinates)object3).getHeight();
            object2 = new Coordinates(Math.sqrt((d7 - d3) * (d7 - d3)), Math.sqrt((d4 - d2) * (d4 - d2)));
            int n7 = this.round(((Coordinates)object2).getWidth());
            int n8 = this.round(((Coordinates)object2).getHeight());
            if ((double)n7 > ((Coordinates)object2).getWidth()) {
                --n7;
            }
            if ((double)n8 < ((Coordinates)object2).getHeight()) {
                ++n8;
            }
            int n9 = this.round(d7);
            int n10 = this.round(d4);
            if ((double)n9 < d7) {
                ++n9;
            }
            if ((double)n10 > d4) {
                --n10;
            }
            for (n6 = 0; n6 < n7 + 1; ++n6) {
                coordinates = this.user2screen(new Coordinates(n9 + n6, 0.0));
                if (this.isCoordGrid()) {
                    stringBuffer.append("<line x1=\"" + this.round(coordinates.getWidth()) + "\" y1=\"0\" x2=\"" + this.round(coordinates.getWidth()) + "\" y2=\"" + this.getHeight() + "\" style=\"stroke:gray; stroke-width:1\" />\n");
                }
                if (this.isCoord()) {
                    stringBuffer.append("<line x1=\"" + this.round(coordinates.getWidth()) + "\" y1=\"" + this.round(coordinates.getHeight() + 5.0) + "\" x2=\"" + this.round(coordinates.getWidth()) + "\" y2=\"" + this.round(coordinates.getHeight() - 5.0) + "\" style=\"stroke:black; stroke-width:1\" />\n");
                    if (n9 + n6 == 0) {
                        stringBuffer.append("<line x1=\"" + this.round(coordinates.getWidth()) + "\" y1=\"0\" x2=\"" + this.round(coordinates.getWidth()) + "\" y2=\"" + this.getHeight() + "\" style=\"stroke:black; stroke-width:1\" />\n");
                    }
                }
                if (n9 + n6 == 0 || !this.isCoord()) continue;
                object = "" + (n9 + n6);
                stringBuffer.append("<text x=\"" + this.round(coordinates.getWidth() - 4.0) + "\" y=\"" + this.round(coordinates.getHeight() + 15.0) + "\" style=\"font-family: Arial; font-size: 12 pt; font-weight:bold; stroke:white; stroke-width:3\">" + (String)object + "</text>\n");
                stringBuffer.append("<text x=\"" + this.round(coordinates.getWidth() - 4.0) + "\" y=\"" + this.round(coordinates.getHeight() + 15.0) + "\" style=\"font-family: Arial; font-size:12; font-weight:bold; fill:black;\">" + (String)object + "</text>\n");
            }
            for (n6 = 0; n6 < n8; ++n6) {
                object3 = this.user2screen(new Coordinates(0.0, n10 - n6));
                if (this.isCoordGrid()) {
                    stringBuffer.append("<line x1=\"0\" y1=\"" + this.round(((Coordinates)object3).getHeight()) + "\" x2=\"" + this.getWidth() + "\" y2=\"" + this.round(((Coordinates)object3).getHeight()) + "\" style=\"stroke:gray; stroke-width:1\" />\n");
                }
                if (this.isCoord()) {
                    stringBuffer.append("<line x1=\"" + this.round(((Coordinates)object3).getWidth() - 5.0) + "\" y1=\"" + this.round(((Coordinates)object3).getHeight()) + "\" x2=\"" + this.round(((Coordinates)object3).getWidth() + 5.0) + "\" y2=\"" + this.round(((Coordinates)object3).getHeight()) + "\" style=\"stroke:black; stroke-width:1\" />\n");
                    if (n10 - n6 == 0) {
                        stringBuffer.append("<line x1=\"0\" y1=\"" + this.round(((Coordinates)object3).getHeight()) + "\" x2=\"" + this.getWidth() + "\" y2=\"" + this.round(((Coordinates)object3).getHeight()) + "\" style=\"stroke:black; stroke-width:1\" />\n");
                    }
                }
                if (!this.isCoord()) continue;
                object = "" + (n10 - n6);
                stringBuffer.append("<text x=\"" + this.round(((Coordinates)object3).getWidth() - 15.0) + "\" y=\"" + this.round(((Coordinates)object3).getHeight() + 4.0) + "\" style=\"font-family: Arial; font-size: 12 pt; font-weight:bold; stroke:white; stroke-width:3\">" + (String)object + "</text>\n");
                stringBuffer.append("<text x=\"" + this.round(((Coordinates)object3).getWidth() - 15.0) + "\" y=\"" + this.round(((Coordinates)object3).getHeight() + 4.0) + "\" style=\"font-family: Arial; font-size:12; font-weight:bold; fill:black;\">" + (String)object + "</text>\n");
            }
        }
        for (n5 = 0; n5 < this.element.polygon.size(); ++n5) {
            stringBuffer.append(((Polygon)this.element.polygon.get(n5)).svg());
        }
        for (n5 = 0; n5 < this.element.circle.size(); ++n5) {
            stringBuffer.append(((Circle)this.element.circle.get(n5)).svg());
        }
        for (n5 = 0; n5 < this.element.line.size(); ++n5) {
            double d8;
            double d9;
            double d10;
            int n11;
            String string;
            String string2;
            String string3;
            String string4;
            object3 = (Line)this.element.line.get(n5);
            if (!((Line)object3).exists() || !((Element)object3).isVisible()) continue;
            if (!((Element)object3).isDraft()) {
                string4 = this.rgb2svgrgb(((Element)object3).getStroke());
                string3 = new String() + (double)((Element)object3).getStroke().getAlpha() / 255.0;
                string2 = ((Element)object3).rgb2svgrgb(((Element)object3).getLabel());
                string = new String() + (double)((Element)object3).getLabel().getAlpha() / 255.0;
            } else {
                string4 = this.rgb2svgrgb(((Element)object3).getDraftColor());
                string3 = new String() + (double)((Element)object3).getDraftColor().getAlpha() / 255.0;
                string2 = ((Element)object3).rgb2svgrgb(((Element)object3).getDraftColor());
                string = new String() + (double)((Element)object3).getDraftColor().getAlpha() / 255.0;
            }
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = new Point();
            Point point4 = new Point();
            point.setScreen(-10.0, -10.0);
            point2.setScreen(this.getWidth() + 10, -10.0);
            point3.setScreen(-10.0, this.getHeight() + 10);
            point4.setScreen(this.getWidth() + 10, this.getHeight() + 10);
            this.screen2user(point);
            this.screen2user(point2);
            this.screen2user(point3);
            this.screen2user(point4);
            point.user2sphere();
            point2.user2sphere();
            point3.user2sphere();
            point4.user2sphere();
            object2 = new Line(point, point2, 0, 0);
            Line line = new Line(point3, point4, 0, 0);
            Line line2 = new Line(point, point3, 0, 0);
            Line line3 = new Line(point2, point4, 0, 0);
            Intersection intersection = new Intersection("", 0, (Element)object3, (Element)object2, 0, 0);
            Intersection intersection2 = new Intersection("", 0, (Element)object3, line, 0, 0);
            object = new Intersection("", 0, (Element)object3, line2, 0, 0);
            Intersection intersection3 = new Intersection("", 0, (Element)object3, line3, 0, 0);
            intersection.calculate(true);
            intersection2.calculate(true);
            ((Intersection)object).calculate(true);
            intersection3.calculate(true);
            this.user2screen(intersection.getA());
            this.user2screen(intersection2.getA());
            this.user2screen(((Intersection)object).getA());
            this.user2screen(intersection3.getA());
            double d11 = ((Line)object3).getB().getScreenX() - ((Line)object3).getA().getScreenX();
            double d12 = ((Line)object3).getB().getScreenY() - ((Line)object3).getA().getScreenY();
            if (this.in(d12 / d11, -1.0, 1.0)) {
                if (((Line)object3).getA().getScreenX() < ((Line)object3).getB().getScreenX()) {
                    if (((Line)object3).isFirst() || ((Line)object3).getA().getScreenX() < 0.0) {
                        n4 = this.round(((Intersection)object).getA().getScreenX());
                        n3 = this.round(((Intersection)object).getA().getScreenY());
                    } else {
                        n4 = this.round(((Line)object3).getA().getScreenX());
                        n3 = this.round(((Line)object3).getA().getScreenY());
                    }
                    if (((Line)object3).isLast() || ((Line)object3).getB().getScreenX() > (double)this.getWidth()) {
                        n2 = this.round(intersection3.getA().getScreenX());
                        n11 = this.round(intersection3.getA().getScreenY());
                    } else {
                        n2 = this.round(((Line)object3).getB().getScreenX());
                        n11 = this.round(((Line)object3).getB().getScreenY());
                    }
                    d10 = n2 - n4;
                    d9 = n11 - n3;
                    d8 = Math.sqrt(d10 * d10 + d9 * d9);
                    stringBuffer.append("<line x1=\"" + n4 + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n11 + "\" style=\"stroke-width:" + ((Element)object3).getStrokeWidth() + "; stroke:" + string4 + "; fill:" + string4 + "; stroke-opacity:" + string3 + "; fill-opacity:" + string3 + "\" />\n");
                } else {
                    if (((Line)object3).isLast() || ((Line)object3).getB().getScreenX() < 0.0) {
                        n4 = this.round(((Intersection)object).getA().getScreenX());
                        n3 = this.round(((Intersection)object).getA().getScreenY());
                    } else {
                        n4 = this.round(((Line)object3).getB().getScreenX());
                        n3 = this.round(((Line)object3).getB().getScreenY());
                    }
                    if (((Line)object3).isFirst() || ((Line)object3).getA().getScreenX() > (double)this.getWidth()) {
                        n2 = this.round(intersection3.getA().getScreenX());
                        n11 = this.round(intersection3.getA().getScreenY());
                    } else {
                        n2 = this.round(((Line)object3).getA().getScreenX());
                        n11 = this.round(((Line)object3).getA().getScreenY());
                    }
                    d10 = n2 - n4;
                    d9 = n11 - n3;
                    d8 = Math.sqrt(d10 * d10 + d9 * d9);
                    stringBuffer.append("<line x1=\"" + n4 + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n11 + "\" style=\"stroke-width:" + ((Element)object3).getStrokeWidth() + "; stroke:" + string4 + "; fill:" + string4 + "; stroke-opacity:" + string3 + "; fill-opacity:" + string3 + "\" />\n");
                }
            } else if (((Line)object3).getA().getScreenY() < ((Line)object3).getB().getScreenY()) {
                if (((Line)object3).isFirst() || ((Line)object3).getA().getScreenY() < 0.0) {
                    n4 = this.round(intersection.getA().getScreenX());
                    n3 = this.round(intersection.getA().getScreenY());
                } else {
                    n4 = this.round(((Line)object3).getA().getScreenX());
                    n3 = this.round(((Line)object3).getA().getScreenY());
                }
                if (((Line)object3).isLast() || ((Line)object3).getB().getScreenY() > (double)this.getHeight()) {
                    n2 = this.round(intersection2.getA().getScreenX());
                    n11 = this.round(intersection2.getA().getScreenY());
                } else {
                    n2 = this.round(((Line)object3).getB().getScreenX());
                    n11 = this.round(((Line)object3).getB().getScreenY());
                }
                d10 = n2 - n4;
                d9 = n11 - n3;
                d8 = Math.sqrt(d10 * d10 + d9 * d9);
                stringBuffer.append("<line x1=\"" + n4 + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n11 + "\" style=\"stroke-width:" + ((Element)object3).getStrokeWidth() + "; stroke:" + string4 + "; fill:" + string4 + "; stroke-opacity:" + string3 + "; fill-opacity:" + string3 + "\" />\n");
            } else {
                if (((Line)object3).isLast() || ((Line)object3).getB().getScreenY() < 0.0) {
                    n4 = this.round(intersection.getA().getScreenX());
                    n3 = this.round(intersection.getA().getScreenY());
                } else {
                    n4 = this.round(((Line)object3).getB().getScreenX());
                    n3 = this.round(((Line)object3).getB().getScreenY());
                }
                if (((Line)object3).isFirst() || ((Line)object3).getA().getScreenY() > (double)this.getHeight()) {
                    n2 = this.round(intersection2.getA().getScreenX());
                    n11 = this.round(intersection2.getA().getScreenY());
                } else {
                    n2 = this.round(((Line)object3).getA().getScreenX());
                    n11 = this.round(((Line)object3).getA().getScreenY());
                }
                d10 = n2 - n4;
                d9 = n11 - n3;
                d8 = Math.sqrt(d10 * d10 + d9 * d9);
                stringBuffer.append("<line x1=\"" + n4 + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n11 + "\" style=\"stroke-width:" + ((Element)object3).getStrokeWidth() + "; stroke:" + string4 + "; fill:" + string4 + "; stroke-opacity:" + string3 + "; fill-opacity:" + string3 + "\" />\n");
            }
            stringBuffer.append("<text x=\"" + (int)((Line)object3).getTextAnchorScreen().getWidth() + "\" y=\"" + (int)((Line)object3).getTextAnchorScreen().getHeight() + "\" style=\"font-family: Arial; font-size: 12 pt; fill:");
            stringBuffer.append(string2);
            stringBuffer.append("; fill-opacity:" + string);
            stringBuffer.append("\">" + ((Element)object3).generateSVGName(((Element)object3).getName(), 12) + "</text>\n");
        }
        for (n = 0; n < this.element.graph.size(); ++n) {
            Graph graph = (Graph)this.element.graph.get(n);
            if (!graph.exists() || !graph.isVisible()) continue;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            int n12 = 0;
            int n13 = 0;
            n4 = 10;
            n2 = 0;
            try {
                int n14;
                try {
                    d4 = graph.calculate((0.0 - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth()));
                    n12 = this.round(this.origin.getHeight() - d4 * this.unit.getHeight() * this.zoom.getHeight());
                    d2 = (0.0 - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n15 = 0;
                for (n14 = n4; n14 < this.getWidth(); n14 += n4) {
                    ++n15;
                    d13 = ((double)n14 - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth());
                    try {
                        d3 = graph.calculate(((double)n14 - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth()));
                        n13 = this.round(this.origin.getHeight() - d3 * this.unit.getHeight() * this.zoom.getHeight());
                    }
                    catch (Exception exception) {
                        bl3 = false;
                        bl2 = false;
                        bl5 = true;
                    }
                    if (bl2) {
                        d15 = (d3 - d4) / (d13 - d2);
                        if ((n12 >= 0 && n12 <= this.getHeight()) | (n13 >= 0 && n13 <= this.getHeight())) {
                            double d16 = d15 / d14;
                            double d17 = Math.abs(d15 - d14);
                            if (bl4 | bl5) {
                                if (bl4) {
                                    n14 -= n4;
                                    n4 = 1;
                                    bl3 = false;
                                    bl2 = true;
                                    bl4 = false;
                                } else {
                                    n14 -= n4;
                                    n4 = 1;
                                    bl3 = true;
                                    bl2 = true;
                                    bl5 = false;
                                }
                            } else {
                                if ((d17 * (d13 - d2) <= 2.0 && d16 >= 0.8 && d16 <= 1.2) | n4 == 1) {
                                    stringBuffer.append("<line x1=\"" + (n14 - n4) + "\" y1=\"" + n12 + "\" x2=\"" + n14 + "\" y2=\"" + n13 + "\" style=\"stroke:" + this.rgb2svgrgb(graph.getStroke()) + "; stroke-width:1\" />\n");
                                    if (d17 * (d13 - d2) <= 2.5 && d16 >= 0.8 && d16 <= 1.3) {
                                        n4 += 2;
                                    }
                                } else {
                                    n14 -= n4;
                                    ++n2;
                                    n3 = n4;
                                    if (n3 == (n4 = this.round(n4 - 4))) {
                                        n4 = this.round(n4 / 2);
                                    }
                                    if (n4 < 1) {
                                        n4 = 1;
                                    }
                                    bl3 = false;
                                    bl2 = false;
                                }
                                bl4 = false;
                            }
                        } else {
                            ++n4;
                            bl4 = true;
                        }
                        if (bl2) {
                            d14 = d15;
                        }
                    }
                    if (bl3) {
                        d4 = d3;
                        n12 = n13;
                        d2 = d13;
                    }
                    bl3 = true;
                    bl2 = true;
                }
                d3 = graph.calculate(((double)this.getWidth() - this.origin.getWidth()) / (this.unit.getWidth() * this.zoom.getWidth()));
                n13 = this.round(this.origin.getHeight() - d3 * this.unit.getHeight() * this.zoom.getHeight());
                stringBuffer.append("<line x1=\"" + (n14 - n4) + "\" y1=\"" + n12 + "\" x2=\"" + this.getWidth() + "\" y2=\"" + n13 + "\" style=\"stroke:" + this.rgb2svgrgb(graph.getStroke()) + "; stroke-width:1\" />\n");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < this.element.point.size(); ++n) {
            stringBuffer.append(((Point)this.element.point.get(n)).svg());
        }
        stringBuffer.append("<text x=\"10\" y=\"" + (this.getSize().height - 10) + "\" style=\"font-family: Arial; font-size: 8 pt; font-weight:bold; stroke:" + this.rgb2svgrgb(new Color(185, 219, 125)) + "; stroke-width=20\">http://geonext.de</text>\n");
        stringBuffer.append("<text x=\"10\" y=\"" + (this.getSize().height - 10) + "\" style=\"font-family: Arial; font-size:8; font-weight:bold; fill:white;\">http://geonext.de</text>\n");
        if (bl) {
            stringBuffer.append("<text x=\"10\" y=\"25\" style=\"font-family: Arial; font-size:10; font-weight:bold; fill:black;\">unit=" + d5 + "cm</text>\n");
        }
        stringBuffer.append("</svg>");
        return stringBuffer.toString();
    }

    public double[] toVector(double d, double d2) {
        double[] dArray = new double[3];
        double d3 = Math.sqrt((d /= 100.0) * d + (d2 /= 100.0) * d2 + 1.0);
        dArray[0] = d / d3;
        dArray[1] = d2 / d3;
        dArray[2] = -1.0 / d3;
        return dArray;
    }

    public void user2screen(Composition composition) {
        for (int i = 0; i < composition.elements.size(); ++i) {
            Element element = (Element)composition.elements.get(i);
            if (element instanceof Line) {
                this.user2screen(((Line)element).getA());
                this.user2screen(((Line)element).getB());
            }
            if (element instanceof Circle) {
                this.user2screen(((Circle)element).getM());
                this.user2screen(((Circle)element).getP());
            }
            if (!(element instanceof Intersection)) continue;
            this.user2screen(((Intersection)element).getA());
            this.user2screen(((Intersection)element).getB());
        }
    }

    public Coordinates user2screen(Coordinates coordinates) {
        return new Coordinates(this.origin.getWidth() + coordinates.getWidth() * this.unit.getWidth() * this.zoom.getWidth(), this.origin.getHeight() - coordinates.getHeight() * this.unit.getHeight() * this.zoom.getHeight());
    }

    public void user2screen(Point point) {
        point.setScreen(this.user2screen(point.getUser()));
    }

    public double user2screenX(double d) {
        return this.origin.getWidth() + d * this.unit.getWidth() * this.zoom.getWidth();
    }

    public double user2screenY(double d) {
        return this.origin.getHeight() - d * this.unit.getHeight() * this.zoom.getHeight();
    }

    public String write() {
        int n;
        String string = "";
        string = string + "<board>\n";
        string = string + "\t<name>" + this.getTitle() + "</name>\n";
        string = string + "\t<information>" + this.getInfo() + "</information>\n";
        string = string + "\t<author>" + this.getAuthor() + "</author>\n";
        string = string + "\t<comment>" + this.getComment() + "</comment>\n";
        string = string + "\t<fontsize>" + (this.getFontSize() + 12) + "</fontsize>\n";
        string = string + "\t<id>" + this.internalName + "</id>\n";
        string = string + "\t<size>\n";
        try {
            Rectangle rectangle;
            if (((JInternalFrame)this.getParent().getParent().getParent().getParent()).isMaximum()) {
                rectangle = ((GeonextDesktopManager)((GeonextDesktopPane)this.getParent().getParent().getParent().getParent().getParent()).getDesktopManager()).getPreviousBounds((JInternalFrame)this.getParent().getParent().getParent().getParent());
                string = string + "\t\t<maximized>true</maximized>\n";
            } else {
                rectangle = this.getParent().getParent().getParent().getParent().getBounds();
                string = string + "\t\t<maximized>false</maximized>\n";
            }
            string = string + "\t\t<x>" + rectangle.getX() + "</x>\n";
            string = string + "\t\t<y>" + rectangle.getY() + "</y>\n";
            string = string + "\t\t<width>" + rectangle.getWidth() + "</width>\n";
            string = string + "\t\t<height>" + rectangle.getHeight() + "</height>\n";
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + "\t</size>\n ";
        string = string + " \t<modus>" + this.getModus() + "</modus>\n";
        string = string + "\t<coordinates>\n";
        string = string + " \t\t<coord>" + this.isCoord() + "</coord>\n";
        string = string + " \t\t<grid>" + this.isCoordGrid() + "</grid>\n";
        string = string + " \t\t<snap>" + this.isToCoord() + "</snap>\n";
        string = string + "\t\t<origin>\n";
        string = string + "\t\t\t<x>" + this.origin.getWidth() + "</x>\n";
        string = string + "\t\t\t<y>" + this.origin.getHeight() + "</y>\n";
        string = string + "\t\t</origin>\n ";
        string = string + "\t\t<zoom>\n";
        string = string + "\t\t\t<x>" + this.zoom.getWidth() + "</x>\n";
        string = string + "\t\t\t<y>" + this.zoom.getHeight() + "</y>\n";
        string = string + "\t\t</zoom>\n ";
        string = string + "\t\t<unit>\n";
        string = string + "\t\t\t<x>" + this.unit.getWidth() + "</x>\n";
        string = string + "\t\t\t<y>" + this.unit.getHeight() + "</y>\n";
        string = string + "\t\t</unit>\n ";
        string = string + "\t\t<term>\n";
        string = string + "\t\t\t<x>" + this.coordXTerm + "</x>\n";
        string = string + "\t\t\t<y>" + this.coordYTerm + "</y>\n";
        string = string + "\t\t</term>\n ";
        string = string + "\t\t<label>\n";
        string = string + "\t\t\t<x>" + this.coordXLabel + "</x>\n";
        string = string + "\t\t\t<y>" + this.coordYLabel + "</y>\n";
        string = string + "\t\t</label>\n ";
        string = string + "\t\t<multi>\n";
        string = string + "\t\t\t<x>" + this.coordXMulti + "</x>\n";
        string = string + "\t\t\t<y>" + this.coordYMulti + "</y>\n";
        string = string + "\t\t\t<showx>" + this.isCoordXMultiple() + "</showx>\n";
        string = string + "\t\t\t<showy>" + this.isCoordYMultiple() + "</showy>\n";
        string = string + "\t\t</multi>\n ";
        string = string + "\t\t<continuous>\n";
        string = string + "\t\t\t<x>" + this.isCoordXContinuous() + "</x>\n";
        string = string + "\t\t\t<y>" + this.isCoordYContinuous() + "</y>\n";
        string = string + "\t\t</continuous>\n ";
        string = string + "\t\t<showunit>\n";
        string = string + "\t\t\t<x>" + this.isCoordXShowUnit() + "</x>\n";
        string = string + "\t\t\t<y>" + this.isCoordYShowUnit() + "</y>\n";
        string = string + "\t\t</showunit>\n ";
        string = string + "\t\t<axis>\n";
        string = string + "\t\t\t<x>" + this.coordXObject + "</x>\n";
        string = string + "\t\t\t<y>" + this.coordYObject + "</y>\n";
        string = string + "\t\t</axis>\n ";
        string = string + "\t\t<xooy>\n";
        string = string + "\t\t\t<x>" + this.XLine.getId() + "</x>\n";
        string = string + "\t\t\t<y>" + this.YLine.getId() + "</y>\n";
        string = string + "\t\t</xooy>\n ";
        string = string + "\t\t<viewport>\n";
        string = string + "\t\t\t<top>" + this.screen2user(new Coordinates(0.0, 0.0)).getHeight() + "</top>\n";
        string = string + "\t\t\t<left>" + this.screen2user(new Coordinates(0.0, 0.0)).getWidth() + "</left>\n";
        string = string + "\t\t\t<bottom>" + this.screen2user(new Coordinates(this.getWidth() - 1, this.getHeight() - 1)).getHeight() + "</bottom>\n";
        string = string + "\t\t\t<right>" + this.screen2user(new Coordinates(this.getWidth() - 1, this.getHeight() - 1)).getWidth() + "</right>\n";
        string = string + "\t\t</viewport>\n ";
        string = string + "\t</coordinates>\n ";
        string = string + "\t<grid>\n";
        string = string + " \t\t<x>" + (int)this.subGrid.getWidth() + "</x>\n";
        string = string + " \t\t<y>" + (int)this.subGrid.getHeight() + "</y>\n";
        string = string + " \t\t<cross>" + this.isCross() + "</cross>\n";
        string = string + " \t\t<color>#" + this.getHexColor(this.getGridColor()) + "</color>\n";
        string = string + " \t\t<dash>" + this.isGridDash() + "</dash>\n";
        string = string + " \t\t<pointsnap>" + this.isPointSnap() + "</pointsnap>\n";
        string = string + "\t</grid>\n ";
        string = string + "\t<background>\n";
        string = string + "\t\t<color>#" + this.getHexColor(this.getBackground()) + "</color>\n";
        string = string + "\t\t<file>\n";
        string = string + "\t\t\t<src>";
        if (this.jep.backImage != null) {
            string = string + Base64.encodeBytes(IO.image2byteArray(this.jep.backImage));
        }
        string = string + "</src>\n";
        string = string + "\t\t\t<x>" + this.jep.imageCoord.getWidth() + "</x>\n";
        string = string + "\t\t\t<y>" + this.jep.imageCoord.getHeight() + "</y>\n";
        string = string + "\t\t\t<width>" + this.jep.imageSize.getWidth() + "</width>\n";
        string = string + "\t\t\t<height>" + this.jep.imageSize.getHeight() + "</height>\n";
        string = string + "\t\t</file>\n";
        string = string + "\t\t<image>...</image>\n";
        string = string + "    </background>\n ";
        string = string + "    <conditions>\n ";
        for (n = 0; n < this.conditions.size(); ++n) {
            string = string + "        <data>" + this.conditions.get(n).toString() + "</data>\n";
        }
        string = string + "    </conditions>    \n ";
        string = string + "\t<elements>\n ";
        string = string + "\t\t<text>\n\t\t\t<id>oldVersion1.51</id>\n\t\t\t<data>\n\t\t\t\t<content>^{^{This construction was created with GEONExT 1.51.}}</content>\n\t\t\t\t<mp></mp>\n\t\t\t\t<mpx></mpx>\n\t\t\t\t<x>" + this.screen2userX(10.0) + "</x>\n\t\t\t\t<y>" + this.screen2userY(this.getHeight() - 35) + "</y>\n\t\t\t\t<parent></parent>\n\t\t\t</data>\n\t\t\t<active>true</active>\n\t\t\t<area>5</area>\n\t\t\t<dash>0</dash>\n\t\t\t<draft>false</draft>\n\t\t\t<info></info>\n\t\t\t<visible>true</visible>\n\t\t\t<trace>false</trace>\n\t\t\t<strokewidth>2</strokewidth>\n\t\t\t<color>\n\t\t\t<stroke>#0000FF00</stroke>\n\t\t\t<lighting>#00FFFF00</lighting>\n\t\t\t<fill>#B9DB7D64</fill>\n\t\t\t<label>#FF0000FF</label>\n\t\t\t<draft>#C8C8C864</draft>\n\t\t\t</color>\n\t\t\t<showinfo>false</showinfo>\n\t\t\t<label>\n\t\t\t\t<x>...</x>\n\t\t\t\t<y>...</y>\n\t\t\t</label>\n\t\t\t<condition>false</condition>\n\t\t\t<cs>null</cs>\n\t\t\t<jsf></jsf>\n\t\t\t<fix>true</fix>\n\t\t\t<digits>2</digits>\n\t\t\t<autodigits>false</autodigits>\n\t\t</text>\n";
        string = string + "\t\t<text>\n\t\t\t<id>oldVersion1.51</id>\n\t\t\t<data>\n\t\t\t\t<content>^{^{You are running an older version of GEONExT.}}</content>\n\t\t\t\t<mp></mp>\n\t\t\t\t<mpx></mpx>\n\t\t\t\t<x>" + this.screen2userX(10.0) + "</x>\n\t\t\t\t<y>" + this.screen2userY(this.getHeight() - 20) + "</y>\n\t\t\t\t<parent></parent>\n\t\t\t</data>\n\t\t\t<active>true</active>\n\t\t\t<area>5</area>\n\t\t\t<dash>0</dash>\n\t\t\t<draft>false</draft>\n\t\t\t<info></info>\n\t\t\t<visible>true</visible>\n\t\t\t<trace>false</trace>\n\t\t\t<strokewidth>2</strokewidth>\n\t\t\t<color>\n\t\t\t<stroke>#0000FF00</stroke>\n\t\t\t<lighting>#00FFFF00</lighting>\n\t\t\t<fill>#B9DB7D64</fill>\n\t\t\t<label>#FF0000FF</label>\n\t\t\t<draft>#C8C8C864</draft>\n\t\t\t</color>\n\t\t\t<showinfo>false</showinfo>\n\t\t\t<label>\n\t\t\t\t<x>...</x>\n\t\t\t\t<y>...</y>\n\t\t\t</label>\n\t\t\t<condition>false</condition>\n\t\t\t<cs>null</cs>\n\t\t\t<jsf></jsf>\n\t\t\t<fix>true</fix>\n\t\t\t<digits>2</digits>\n\t\t\t<autodigits>false</autodigits>\n\t\t</text>\n";
        for (n = 5; n < this.element.elements.size(); ++n) {
            Element element = (Element)this.element.elements.get(n);
            string = string + "\t   <" + element.typeString + ">\n ";
            string = string + "\t\t\t<name>" + element.getName() + "</name>\n ";
            string = string + "\t\t\t<id>" + element.getId() + "</id>\n ";
            string = string + "\t\t\t<data>\n ";
            string = string + element.writeData("\t\t\t\t");
            string = string + "\t\t\t</data>\n ";
            string = string + element.writeProperties("\t\t\t");
            string = string + "\t\t</" + element.typeString + ">\n ";
        }
        string = string + "\t</elements>\n ";
        string = string + "</board>\n ";
        return string;
    }

    public void zoom100() {
        this.clearTrace();
        this.zoom.setSize(1.0, 1.0);
        this.origin = new Coordinates(this.getWidth() / 2, this.getHeight() / 2);
        this.calculateCalculatedElements(true);
        this.points2screen();
    }

    public void zoomAll() {
        this.clearTrace();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.element.point.size() > 1) {
            d = d3 = ((Point)this.element.point.get(0)).getUserX();
            d2 = d4 = ((Point)this.element.point.get(0)).getUserY();
            for (int i = 0; i < this.element.point.size(); ++i) {
                if (((Point)this.element.point.get(i)).getUserX() < d) {
                    d = ((Point)this.element.point.get(i)).getUserX();
                }
                if (((Point)this.element.point.get(i)).getUserX() > d3) {
                    d3 = ((Point)this.element.point.get(i)).getUserX();
                }
                if (((Point)this.element.point.get(i)).getUserY() > d2) {
                    d2 = ((Point)this.element.point.get(i)).getUserY();
                }
                if (!(((Point)this.element.point.get(i)).getUserY() < d4)) continue;
                d4 = ((Point)this.element.point.get(i)).getUserY();
            }
            Coordinates coordinates = new Coordinates(d, d2);
            Coordinates coordinates2 = new Coordinates(d3, d2);
            Coordinates coordinates3 = new Coordinates(d, d4);
            Coordinates coordinates4 = new Coordinates(coordinates.distance(coordinates2) * 1.25, coordinates.distance(coordinates3) * 1.25);
            Coordinates coordinates5 = new Coordinates((coordinates.getWidth() + coordinates2.getWidth()) / 2.0, (coordinates.getHeight() + coordinates3.getHeight()) / 2.0);
            Coordinates coordinates6 = this.screen2user(new Coordinates(this.origin.getWidth() + (double)this.getWidth(), this.origin.getHeight() - (double)this.getHeight()));
            double d5 = 1.0;
            d5 = coordinates4.getWidth() / coordinates6.getWidth() < coordinates4.getHeight() / coordinates6.getHeight() ? coordinates6.getHeight() / coordinates4.getHeight() : coordinates6.getWidth() / coordinates4.getWidth();
            Coordinates coordinates7 = new Coordinates(this.zoom.getWidth() * d5, this.zoom.getHeight() * d5);
            if (coordinates7.distance() < this.zoomMax.distance() && coordinates7.distance() > this.zoomMin.distance()) {
                this.zoom = coordinates7;
            }
            coordinates5 = this.user2screen(coordinates5);
            this.origin = new Coordinates(this.origin.getWidth() + (double)(this.getWidth() / 2) - coordinates5.getWidth(), this.origin.getHeight() - coordinates5.getHeight() + (double)(this.getHeight() / 2));
            this.calculateCalculatedElements(true);
            this.points2screen();
        }
    }

    public void zoomIn() {
        if (this.zoom.distance() < this.zoomMax.distance()) {
            this.clearTrace();
            this.zoom.setSize(this.zoom.getWidth() * 1.25, this.zoom.getHeight() * 1.25);
            this.origin = new Coordinates(this.origin.getWidth() * 1.25 - (double)this.getWidth() * 0.125, this.origin.getHeight() * 1.25 - (double)this.getHeight() * 0.125);
            this.calculateCalculatedElements(true);
            this.points2screen();
        }
    }

    public void zoomOut() {
        if (this.zoom.distance() > this.zoomMin.distance()) {
            this.clearTrace();
            this.zoom.setSize(this.zoom.getWidth() * 0.8, this.zoom.getHeight() * 0.8);
            this.origin = new Coordinates(this.origin.getWidth() * 0.8 + (double)this.getWidth() * 0.1, this.origin.getHeight() * 0.8 + (double)this.getHeight() * 0.1);
            this.calculateCalculatedElements(true);
            this.points2screen();
        }
    }

    public Condition createCondition(String string) {
        try {
            String string2 = string.substring(string.indexOf("=") + 1, string.length());
            String string3 = string.substring(0, string.indexOf("."));
            String string4 = string.substring(string.indexOf(".") + 1, string.indexOf("="));
            Element element = this.element.searchName(string3);
            if (element != null) {
                Element element2 = new Element();
                SessionData sessionData = SessionData.currentSessionData();
                sessionData.currentElement = element2;
                HObject hObject = new Scanner(string2, true).start();
                return new Condition(element, string4, hObject, element2);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void calculateElements(boolean bl) {
        int n;
        C.boardName = this.internalName;
        for (n = 0; n < this.element.elements.size(); ++n) {
            Element element = (Element)this.element.elements.get(n);
            if (element instanceof ParameterCurve) {
                ((ParameterCurve)element).calculate(this, bl);
                continue;
            }
            if (element instanceof Graph) {
                ((Graph)element).calculate(this, bl);
                continue;
            }
            if (element instanceof TraceCurve) {
                ((TraceCurve)element).calculate(this, bl);
                continue;
            }
            if (element instanceof Circle) {
                ((Circle)element).calculate(this, bl);
                continue;
            }
            if (element instanceof GraphSlider) {
                ((GraphSlider)element).calculate(this, bl);
                continue;
            }
            ((Element)this.element.elements.get(n)).calculate(bl);
        }
        for (n = 0; n < this.element.point.size(); ++n) {
            if (!((Point)this.element.point.get(n)).exists()) continue;
            this.user2screen((Point)this.element.point.get(n));
        }
        for (n = 0; n < this.element.group.size(); ++n) {
            this.user2screen(((Group)this.element.group.get(n)).getCenter());
        }
        for (n = 0; n < this.element.composition.size(); ++n) {
            if (!((Composition)this.element.composition.get(n)).exists()) continue;
            this.user2screen((Composition)this.element.composition.get(n));
        }
        for (n = 0; n < this.element.text.size(); ++n) {
            ((Text)this.element.text.get(n)).evaluate(this);
        }
        this.element.setElementsChanged(false);
        if (this.getGeonextEditDialog() != null && this.getGeonextEditDialog().isVisible()) {
            this.getGeonextEditDialog().jce.objectList.repaint();
        }
        if (this.ckCond) {
            this.checkConditions();
        }
    }

    public JFrameDialog getGeonextPrintDialog() {
        return this.geonextPrintDialog;
    }

    public void setGeonextPrintDialog(JFrameDialog jFrameDialog) {
        this.geonextPrintDialog = jFrameDialog;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean bl) {
        this.saved = bl;
        Container container = this;
        JBoard jBoard = null;
        while (container != null) {
            if (container instanceof JBoard) {
                jBoard = (JBoard)container;
            }
            container = ((Component)container).getParent();
        }
        String string = "*";
        if (jBoard != null) {
            if (!bl) {
                if (!jBoard.getTitle().startsWith(string)) {
                    jBoard.setTitle(string + jBoard.getTitle());
                }
            } else if (jBoard.getTitle().startsWith(string)) {
                jBoard.setTitle(jBoard.getTitle().substring(1, jBoard.getTitle().length()));
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setChangedElements(Point point) {
        point.setChanged(true);
        if (point.getGroups().size() > 0) {
            Vector vector = point.getGroups();
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = ((Group)vector.get(i)).getGroup();
                for (int j = 0; j < vector2.size(); ++j) {
                    ((Point)vector2.get(i)).setChanged(true);
                }
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getUnitsToScroll() < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
        this.repaint();
    }

    public boolean isPointSnap() {
        return this.pointSnap;
    }

    public void setPointSnap(boolean bl) {
        this.pointSnap = bl;
    }

    public JFrameDialog getGeonextEditDialog() {
        return this.geonextEditDialog;
    }

    public void setGeonextEditDialog(JFrameDialog jFrameDialog) {
        this.geonextEditDialog = jFrameDialog;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public int getPreviousModus() {
        return this.previousModus;
    }

    public void setPreviousModus(int n) {
        this.previousModus = n;
    }
}

