/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.ComplexTridiagonalMatrix;
import com.hartmath.util.DimensionException;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.DoubleSquareMatrix;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.MathNumber;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public class DoubleTridiagonalMatrix
extends DoubleSquareMatrix {
    protected DoubleTridiagonalMatrix() {
    }

    public DoubleTridiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        int n;
        if (dArray.length == dArray[0].length) {
            this.matrix[1][0] = dArray[0][0];
            this.matrix[2][0] = dArray[0][1];
            for (n = 1; n < dArray.length - 1; ++n) {
                this.matrix[0][n] = dArray[n][n - 1];
                this.matrix[1][n] = dArray[n][n];
                this.matrix[2][n] = dArray[n][n + 1];
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.matrix[0][n] = dArray[n][n - 1];
        this.matrix[1][n] = dArray[n][n];
    }

    public DoubleTridiagonalMatrix(int n) {
        this();
        this.matrix = new double[3][n];
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawAdd((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawAdd(doubleMatrix);
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawAdd(doubleSquareMatrix);
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] + doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.matrix[0][i] = this.matrix[0][i] + doubleTridiagonalMatrix.getElement(i, i - 1);
                doubleTridiagonalMatrix2.matrix[1][i] = this.matrix[1][i] + doubleTridiagonalMatrix.getElement(i, i);
                doubleTridiagonalMatrix2.matrix[2][i] = this.matrix[2][i] + doubleTridiagonalMatrix.getElement(i, i + 1);
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] + doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawAdd((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawAdd((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        for (n = 1; n < this.matrix[1].length; ++n) {
            double d2 = this.getElement(n, 0) / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
        }
        for (int i = 1; i < this.matrix[1].length; ++i) {
            double d3 = this.getElement(i, i);
            for (n = 0; n < i; ++n) {
                d3 -= dArray[0][i][n] * dArray[0][i][n];
            }
            double d4 = Math.sqrt(d3);
            dArray[1][i][i] = d4;
            dArray[0][i][i] = d4;
            for (n = i + 1; n < this.matrix[1].length; ++n) {
                d3 = this.getElement(n, i);
                for (int j = 0; j < n; ++j) {
                    d3 -= dArray[0][i][j] * dArray[1][j][n];
                }
                double d5 = d3 / dArray[1][i][i];
                dArray[1][i][n] = d5;
                dArray[0][n][i] = d5;
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public int columns() {
        return this.matrix[1].length;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleTridiagonalMatrix && this.matrix[1].length == ((DoubleTridiagonalMatrix)object).rows()) {
            int n;
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = (DoubleTridiagonalMatrix)object;
            if (Math.abs(this.matrix[1][0] - doubleTridiagonalMatrix.getElement(0, 0)) > MathNumber.ZERO_TOL) {
                return false;
            }
            if (Math.abs(this.matrix[2][0] - doubleTridiagonalMatrix.getElement(0, 1)) > MathNumber.ZERO_TOL) {
                return false;
            }
            for (n = 1; n < this.matrix[1].length - 1; ++n) {
                if (Math.abs(this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > MathNumber.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n)) > MathNumber.ZERO_TOL) {
                    return false;
                }
                if (!(Math.abs(this.matrix[2][n] - doubleTridiagonalMatrix.getElement(n, n + 1)) > MathNumber.ZERO_TOL)) continue;
                return false;
            }
            if (Math.abs(this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > MathNumber.ZERO_TOL) {
                return false;
            }
            return !(Math.abs(this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n)) > MathNumber.ZERO_TOL);
        }
        return false;
    }

    public double frobeniusNorm() {
        int n;
        double d = this.matrix[1][0] * this.matrix[1][0] + this.matrix[2][0] * this.matrix[2][0];
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            d += this.matrix[0][n] * this.matrix[0][n] + this.matrix[1][n] * this.matrix[1][n] + this.matrix[2][n] * this.matrix[2][n];
        }
        return Math.sqrt(d += this.matrix[0][n] * this.matrix[0][n] + this.matrix[1][n] * this.matrix[1][n]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                return this.matrix[0][n];
            }
            if (n2 == n) {
                return this.matrix[1][n];
            }
            if (n2 == n + 1) {
                return this.matrix[2][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public double infNorm() {
        double d;
        int n;
        double d2 = Math.abs(this.matrix[1][0]) + Math.abs(this.matrix[2][0]);
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            d = Math.abs(this.matrix[0][n]) + Math.abs(this.matrix[1][n]) + Math.abs(this.matrix[2][n]);
            if (!(d > d2)) continue;
            d2 = d;
        }
        d = Math.abs(this.matrix[0][n]) + Math.abs(this.matrix[1][n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public boolean isSymmetric() {
        if (this.matrix[0][1] != this.matrix[2][0]) {
            return false;
        }
        for (int i = 1; i < this.matrix[1].length - 1; ++i) {
            if (this.matrix[0][i + 1] == this.matrix[2][i]) continue;
            return false;
        }
        return true;
    }

    public DoubleSquareMatrix[] luDecompose() {
        int n;
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        dArray[0][0][0] = 1.0;
        for (n = 1; n < this.matrix[1].length; ++n) {
            dArray[0][n][n] = 1.0;
        }
        for (int i = 0; i < this.matrix[1].length; ++i) {
            int n2;
            double d;
            for (n = 0; n <= i; ++n) {
                d = this.getElement(n, i);
                for (n2 = 0; n2 < n; ++n2) {
                    d -= dArray[0][n][n2] * dArray[1][n2][i];
                }
                dArray[1][n][i] = d;
            }
            for (n = i + 1; n < this.matrix[1].length; ++n) {
                d = this.getElement(n, i);
                for (n2 = 0; n2 < i; ++n2) {
                    d -= dArray[0][n][n2] * dArray[1][n2][i];
                }
                dArray[0][n][i] = d / dArray[1][i][i];
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        int n = this.matrix[1].length;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.matrix[1][0] = hUnaryNumerical.map(this.matrix[1][0]);
        doubleTridiagonalMatrix.matrix[2][0] = hUnaryNumerical.map(this.matrix[2][0]);
        --n;
        for (int i = 1; i < n; ++i) {
            doubleTridiagonalMatrix.matrix[0][i] = hUnaryNumerical.map(this.matrix[0][i]);
            doubleTridiagonalMatrix.matrix[1][i] = hUnaryNumerical.map(this.matrix[1][i]);
            doubleTridiagonalMatrix.matrix[2][i] = hUnaryNumerical.map(this.matrix[2][i]);
        }
        doubleTridiagonalMatrix.matrix[0][n] = hUnaryNumerical.map(this.matrix[0][n]);
        doubleTridiagonalMatrix.matrix[1][n] = hUnaryNumerical.map(this.matrix[1][n]);
        return doubleTridiagonalMatrix;
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawMultiply((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawMultiply(doubleMatrix);
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawMultiply(doubleSquareMatrix);
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.matrix[1][0] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 0);
            dArray[0][1] = this.matrix[1][0] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 1);
            dArray[0][2] = this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 2);
            if (n > 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 2);
                dArray[1][3] = this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 3);
            }
            if (n == 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 2);
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    dArray[i][i - 2] = this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i - 1, i - 2);
                    dArray[i][i - 1] = this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i - 1, i - 1) + this.matrix[1][i] * doubleTridiagonalMatrix.getElement(i, i - 1);
                    dArray[i][i] = this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i - 1, i) + this.matrix[1][i] * doubleTridiagonalMatrix.getElement(i, i) + this.matrix[2][i] * doubleTridiagonalMatrix.getElement(i + 1, i);
                    dArray[i][i + 1] = this.matrix[1][i] * doubleTridiagonalMatrix.getElement(i, i + 1) + this.matrix[2][i] * doubleTridiagonalMatrix.getElement(i + 1, i + 1);
                    dArray[i][i + 2] = this.matrix[2][i] * doubleTridiagonalMatrix.getElement(i + 1, i + 2);
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 3] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 3) + this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 2] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 2) + this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 2) + this.matrix[2][n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 1] = this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 1) + this.matrix[2][n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 1);
            }
            dArray[n][--n - 2] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
            dArray[n][n - 1] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n - 1) + this.matrix[1][n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            dArray[n][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n) + this.matrix[1][n] * doubleTridiagonalMatrix.getElement(n, n);
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        int n = this.matrix[1].length;
        if (n == doubleVector.dimension()) {
            double[] dArray = new double[n];
            dArray[0] = this.matrix[1][0] * doubleVector.getComponent(0) + this.matrix[2][0] * doubleVector.getComponent(1);
            --n;
            for (int i = 1; i < n; ++i) {
                dArray[i] = this.matrix[0][i] * doubleVector.getComponent(i - 1) + this.matrix[1][i] * doubleVector.getComponent(i) + this.matrix[2][i] * doubleVector.getComponent(i + 1);
            }
            dArray[n] = this.matrix[0][n] * doubleVector.getComponent(n - 1) + this.matrix[1][n] * doubleVector.getComponent(n);
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawMultiply((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawMultiply((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.rows() && this.matrix[1].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.getElement(i, 0) + doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.getElement(i, j) + doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.getElement(i, 0) + doubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.getElement(i, j) + doubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][doubleMatrix.columns()];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.getElement(i, 0) * doubleMatrix.getElement(0, j);
                    for (int k = 1; k < this.matrix[1].length; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.getElement(i, k) * doubleMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[i][j] = this.getElement(i, 0) * doubleSquareMatrix.getElement(0, j);
                    for (int k = 1; k < dArray.length; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.getElement(i, k) * doubleSquareMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.rows() && this.matrix[1].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.getElement(i, 0) - doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.getElement(i, j) - doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.getElement(i, 0) - doubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.getElement(i, j) - doubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int rows() {
        return this.matrix[1].length;
    }

    public DoubleMatrix scalarMultiply(double d) {
        int n = this.matrix[1].length;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.matrix[1][0] = d * this.matrix[1][0];
        doubleTridiagonalMatrix.matrix[2][0] = d * this.matrix[2][0];
        --n;
        for (int i = 1; i < n; ++i) {
            doubleTridiagonalMatrix.matrix[0][i] = d * this.matrix[0][i];
            doubleTridiagonalMatrix.matrix[1][i] = d * this.matrix[1][i];
            doubleTridiagonalMatrix.matrix[2][i] = d * this.matrix[2][i];
        }
        doubleTridiagonalMatrix.matrix[0][n] = d * this.matrix[0][n];
        doubleTridiagonalMatrix.matrix[1][n] = d * this.matrix[1][n];
        return doubleTridiagonalMatrix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.matrix[1].length || n2 < 0 || n2 >= this.matrix[1].length) throw new MatrixDimensionException("Invalid element.");
        if (n2 == n - 1) {
            this.matrix[0][n] = d;
            return;
        } else if (n2 == n) {
            this.matrix[1][n] = d;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException("Invalid element.");
            this.matrix[2][n] = d;
        }
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawSubtract((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawSubtract(doubleMatrix);
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawSubtract(doubleSquareMatrix);
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] - doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.matrix[0][i] = this.matrix[0][i] - doubleTridiagonalMatrix.getElement(i, i - 1);
                doubleTridiagonalMatrix2.matrix[1][i] = this.matrix[1][i] - doubleTridiagonalMatrix.getElement(i, i);
                doubleTridiagonalMatrix2.matrix[2][i] = this.matrix[2][i] - doubleTridiagonalMatrix.getElement(i, i + 1);
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawSubtract((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawSubtract((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix toComplexMatrix() {
        int n;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.matrix[1].length);
        complexTridiagonalMatrix.matrix[1][0] = new HDoubleComplex(this.matrix[1][0], 0.0);
        complexTridiagonalMatrix.matrix[2][0] = new HDoubleComplex(this.matrix[2][0], 0.0);
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            complexTridiagonalMatrix.matrix[0][n] = new HDoubleComplex(this.matrix[0][n], 0.0);
            complexTridiagonalMatrix.matrix[1][n] = new HDoubleComplex(this.matrix[1][n], 0.0);
            complexTridiagonalMatrix.matrix[2][n] = new HDoubleComplex(this.matrix[2][n], 0.0);
        }
        complexTridiagonalMatrix.matrix[0][n] = new HDoubleComplex(this.matrix[0][n], 0.0);
        complexTridiagonalMatrix.matrix[1][n] = new HDoubleComplex(this.matrix[1][n], 0.0);
        return complexTridiagonalMatrix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[1].length);
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public double trace() {
        double d = this.matrix[1][0];
        for (int i = 1; i < this.matrix[1].length; ++i) {
            d += this.matrix[1][i];
        }
        return d;
    }

    public Matrix transpose() {
        int n = this.matrix[1].length;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0];
        doubleTridiagonalMatrix.setElement(1, 0, this.matrix[2][0]);
        --n;
        for (int i = 1; i < n; ++i) {
            doubleTridiagonalMatrix.setElement(i - 1, i, this.matrix[0][i]);
            doubleTridiagonalMatrix.matrix[1][i] = this.matrix[1][i];
            doubleTridiagonalMatrix.setElement(i + 1, i, this.matrix[2][i]);
        }
        doubleTridiagonalMatrix.setElement(n - 1, n, this.matrix[0][n]);
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n];
        return doubleTridiagonalMatrix;
    }
}

