/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.SessionData;
import com.hartmath.mapping.FunctionEvaluator;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class EWriteObject
implements FunctionEvaluator {
    DataOutputStream os;
    SessionData sd;

    public synchronized void e1ComArg(HComplex hComplex) throws IOException {
        this.os.writeByte(6);
        this.writeTo(hComplex.re());
        this.writeTo(hComplex.im());
    }

    public synchronized void e1DblArg(HDouble hDouble) throws IOException {
        this.os.writeByte(2);
        this.os.writeDouble(hDouble.doubleValue());
    }

    public synchronized void e1DblComArg(HDoubleComplex hDoubleComplex) throws IOException {
        this.os.writeByte(3);
        this.os.writeDouble(hDoubleComplex.real());
        this.os.writeDouble(hDoubleComplex.imag());
    }

    public synchronized void e1FraArg(HFraction hFraction) throws IOException {
        BigInteger bigInteger = hFraction.toBigIntegerNumerator();
        BigInteger bigInteger2 = hFraction.toBigIntegerDenominator();
        if (bigInteger.equals(HInteger.B1) && bigInteger2.compareTo(HInteger.B2) >= 0 && bigInteger2.compareTo(HInteger.B10) <= 0) {
            int n = (bigInteger2.intValue() + 62) * -1;
            this.os.writeByte((byte)n);
        } else {
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = bigInteger2.toByteArray();
            if (byArray.length <= 8 && byArray2.length <= 8) {
                if (byArray.length <= 4 && byArray2.length <= 4) {
                    if (byArray.length <= 2 && byArray2.length <= 2) {
                        if (byArray.length == 1 && byArray2.length == 1) {
                            this.os.writeByte(27);
                            this.os.writeByte(byArray[0]);
                            this.os.writeByte(byArray2[0]);
                        } else {
                            this.os.writeByte(26);
                            this.os.writeShort((short)bigInteger.intValue());
                            this.os.writeShort((short)bigInteger2.intValue());
                        }
                    } else {
                        this.os.writeByte(25);
                        this.os.writeInt(bigInteger.intValue());
                        this.os.writeInt(bigInteger2.intValue());
                    }
                } else {
                    this.os.writeByte(24);
                    this.os.writeLong(bigInteger.longValue());
                    this.os.writeLong(bigInteger2.longValue());
                }
            } else {
                this.os.writeByte(5);
                this.os.writeInt(byArray.length);
                this.os.write(byArray);
                this.os.writeInt(byArray2.length);
                this.os.write(byArray2);
            }
        }
    }

    public synchronized void e1FunArg(HFunction hFunction) throws IOException {
        int n = hFunction.size();
        int n2 = -1;
        if (n <= 5) {
            int n3;
            for (n3 = 0; n3 < C.IOSymbolTable.length; ++n3) {
                if (!hFunction.head().equals(C.IOSymbolTable[n3])) continue;
                n2 = n3;
                break;
            }
            if (n2 != -1) {
                this.os.writeByte((byte)(80 + n));
                this.os.writeByte((byte)n2);
                for (n3 = 0; n3 < n; ++n3) {
                    this.writeTo(hFunction.get(n3));
                }
            } else {
                this.os.writeByte((byte)(64 - n - 1));
                this.e1SymArg(hFunction.head());
                for (n3 = 0; n3 < n; ++n3) {
                    this.writeTo(hFunction.get(n3));
                }
            }
        } else {
            this.os.writeByte(64);
            this.os.writeInt(n);
            this.e1SymArg(hFunction.head());
            for (int i = 0; i < n; ++i) {
                this.writeTo(hFunction.get(i));
            }
        }
    }

    public synchronized void e1IntArg(HInteger hInteger) throws IOException {
        byte[] byArray = hInteger.toByteArray();
        if (byArray.length <= 8) {
            if (byArray.length <= 4) {
                if (byArray.length <= 2) {
                    if (-5 <= hInteger.intValue() && hInteger.intValue() <= 5) {
                        int n = (hInteger.intValue() + 58) * -1;
                        this.os.writeByte((byte)n);
                    } else if (byArray.length == 1) {
                        this.os.writeByte(23);
                        this.os.writeByte(byArray[0]);
                    } else {
                        this.os.writeByte(22);
                        this.os.writeShort((short)hInteger.intValue());
                    }
                } else {
                    this.os.writeByte(21);
                    this.os.writeInt(hInteger.intValue());
                }
            } else {
                this.os.writeByte(20);
                this.os.writeLong(hInteger.longValue());
            }
        } else {
            this.os.writeByte(4);
            this.os.writeInt(byArray.length);
            this.os.write(byArray);
        }
    }

    public synchronized void e1PatArg(HPattern hPattern) throws IOException {
        HSymbol hSymbol = hPattern.getSymbol();
        HObject hObject = hPattern.getCheckFunction();
        if (hObject != null) {
            this.os.writeByte(65);
            this.e1SymArg(hSymbol);
            this.writeTo(hObject);
        } else {
            String string = hSymbol.toString();
            if (string.length() == 1 && string.charAt(0) >= 'a' && string.charAt(0) <= 'z') {
                int n = (string.charAt(0) - 97 + 26 + 1) * -1;
                this.os.writeByte((byte)n);
            } else {
                this.os.writeByte(66);
                this.e1SymArg(hSymbol);
            }
        }
    }

    public synchronized void e1StrArg(HString hString) throws IOException {
        this.os.writeByte(16);
        this.os.writeUTF(hString.toString());
    }

    public synchronized void e1SymArg(HSymbol hSymbol) throws IOException {
        String string = hSymbol.toString();
        if (string.length() == 1 && string.charAt(0) >= 'a' && string.charAt(0) <= 'z') {
            int n = (string.charAt(0) - 97 + 1) * -1;
            this.os.writeByte((byte)n);
        } else {
            Short s = this.sd.getIOOut(string);
            if (s != null) {
                this.os.writeByte(33);
                this.os.writeShort(s.shortValue());
            } else {
                int n;
                int n2 = -1;
                for (n = 0; n < C.IOConstantTable.length; ++n) {
                    if (!hSymbol.equals(C.IOConstantTable[n])) continue;
                    n2 = n;
                    break;
                }
                if (n2 != -1) {
                    this.os.writeByte(34);
                    this.os.writeByte((byte)n2);
                    return;
                }
                for (n = 0; n < C.IOSymbolTable.length; ++n) {
                    if (!hSymbol.equals(C.IOSymbolTable[n])) continue;
                    n2 = n;
                    break;
                }
                if (n2 != -1) {
                    this.os.writeByte(35);
                    this.os.writeByte((byte)n2);
                    return;
                }
                this.os.writeByte(32);
                this.os.writeUTF(string);
                this.os.writeInt(hSymbol.getAttributes());
                s = new Short((short)this.sd.getIOCounter());
                this.sd.putIOOut(string, s);
                this.sd.incIOCounter();
            }
        }
    }

    public synchronized HObject evaluate(HFunction hFunction) {
        if (hFunction.size() == 2 && hFunction.get(0) instanceof HString) {
            try {
                this.sd = SessionData.currentSessionData();
                this.sd.setIOCounter(0);
                this.sd.clearIOIn();
                this.sd.clearIOOut();
                FileOutputStream fileOutputStream = new FileOutputStream(hFunction.get(0).toString());
                this.os = new DataOutputStream(fileOutputStream);
                HObject hObject = hFunction.get(1);
                this.writeTo(hObject);
                this.os.close();
                return C.Null;
            }
            catch (Exception exception) {
                SessionData.appendCurrentErrorOut(exception.toString());
                return null;
            }
        }
        return null;
    }

    public synchronized void writeTo(HObject hObject) throws IOException {
        int n = hObject.hierarchy();
        if (n <= 4) {
            if (n <= 2) {
                if (n == 1) {
                    this.e1DblArg((HDouble)hObject);
                    return;
                }
                this.e1DblComArg((HDoubleComplex)hObject);
                return;
            }
            this.e1IntArg((HInteger)hObject);
            return;
        }
        if (n <= 16) {
            if (n == 8) {
                this.e1FraArg((HFraction)hObject);
                return;
            }
            this.e1ComArg((HComplex)hObject);
            return;
        }
        if (n <= 64) {
            if (n == 32) {
                this.e1StrArg((HString)hObject);
                return;
            }
            this.e1SymArg((HSymbol)hObject);
            return;
        }
        if (n == 128) {
            this.e1FunArg((HFunction)hObject);
            return;
        }
        this.e1PatArg((HPattern)hObject);
    }
}

