/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.mapping.E1Arg;
import java.math.BigInteger;

public class EToJava
extends E1Arg {
    public static void convert(StringBuffer stringBuffer, HObject hObject) {
        int n = hObject.hierarchy();
        switch (n) {
            case 1: {
                EToJava.convertDouble(stringBuffer, (HDouble)hObject);
                break;
            }
            case 2: {
                EToJava.convertDoubleComplex(stringBuffer, (HDoubleComplex)hObject);
                break;
            }
            case 4: {
                EToJava.convertInteger(stringBuffer, (HInteger)hObject);
                break;
            }
            case 8: {
                EToJava.convertFraction(stringBuffer, (HFraction)hObject);
                break;
            }
            case 16: {
                EToJava.convertComplex(stringBuffer, (HComplex)hObject);
                break;
            }
            case 32: {
                EToJava.convertString(stringBuffer, (HString)hObject);
                break;
            }
            case 64: {
                EToJava.convertSymbol(stringBuffer, (HSymbol)hObject);
                break;
            }
            case 256: {
                EToJava.convertPattern(stringBuffer, (HPattern)hObject);
                break;
            }
            case 128: {
                HFunction hFunction = (HFunction)hObject;
                String string = hFunction.head().toString();
                if (string.charAt(0) >= 'A' && string.charAt(0) <= 'Z' && hFunction.size() <= 4) {
                    EToJava.convert(stringBuffer, hFunction.head());
                    stringBuffer.append(".f(");
                    for (int i = 0; i < hFunction.size(); ++i) {
                        EToJava.convert(stringBuffer, hFunction.get(i));
                        if (i >= hFunction.size() - 1) continue;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(")");
                    return;
                }
                stringBuffer.append("new HFunction(");
                EToJava.convert(stringBuffer, hFunction.head());
                if (hFunction.size() > 0) {
                    stringBuffer.append(",");
                }
                for (int i = 0; i < hFunction.size(); ++i) {
                    EToJava.convert(stringBuffer, hFunction.get(i));
                    if (i >= hFunction.size() - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                break;
            }
            default: {
                stringBuffer.append(hObject.toString());
            }
        }
    }

    public static void convertComplex(StringBuffer stringBuffer, HComplex hComplex) {
        stringBuffer.append("new HComplex(");
        EToJava.convertFraction(stringBuffer, (HFraction)hComplex.re());
        stringBuffer.append(",");
        EToJava.convertFraction(stringBuffer, (HFraction)hComplex.im());
        stringBuffer.append(")");
    }

    public static void convertDouble(StringBuffer stringBuffer, HDouble hDouble) {
        stringBuffer.append("new HDouble(");
        stringBuffer.append(hDouble.toString());
        stringBuffer.append(")");
    }

    public static void convertDoubleComplex(StringBuffer stringBuffer, HDoubleComplex hDoubleComplex) {
        stringBuffer.append("new HDoubleComplex(");
        stringBuffer.append(String.valueOf(hDoubleComplex.real()));
        stringBuffer.append(",");
        stringBuffer.append(String.valueOf(hDoubleComplex.imag()));
        stringBuffer.append(")");
    }

    public static void convertFraction(StringBuffer stringBuffer, HFraction hFraction) {
        BigInteger bigInteger = hFraction.toBigIntegerNumerator();
        BigInteger bigInteger2 = hFraction.toBigIntegerDenominator();
        if (bigInteger.equals(HInteger.B1) && bigInteger2.compareTo(HInteger.B2) >= 0 && bigInteger2.compareTo(HInteger.B10) <= 0) {
            stringBuffer.append("C.C1D");
            stringBuffer.append(bigInteger2.toString());
            return;
        }
        if (bigInteger.equals(HInteger.BN1) && bigInteger2.compareTo(HInteger.B2) >= 0 && bigInteger2.compareTo(HInteger.B10) <= 0) {
            stringBuffer.append("C.CN1D");
            stringBuffer.append(bigInteger2.toString());
            return;
        }
        stringBuffer.append("new HFraction(\"");
        stringBuffer.append(hFraction.numer().toString());
        stringBuffer.append("\", \"");
        stringBuffer.append(hFraction.denom().toString());
        stringBuffer.append("\")");
    }

    public static void convertInteger(StringBuffer stringBuffer, HInteger hInteger) {
        byte[] byArray = hInteger.toByteArray();
        if (byArray.length <= 2) {
            if (-5 <= hInteger.intValue() && hInteger.intValue() <= -1) {
                Integer n = new Integer(hInteger.intValue() * -1);
                stringBuffer.append("C.CN");
                stringBuffer.append(n.toString());
                return;
            }
            if (0 <= hInteger.intValue() && hInteger.intValue() <= 5) {
                stringBuffer.append("C.C");
                stringBuffer.append(hInteger.toString());
                return;
            }
            switch (hInteger.intValue()) {
                case 10: {
                    stringBuffer.append("C.C10");
                    return;
                }
                case 100: {
                    stringBuffer.append("C.C100");
                    return;
                }
            }
        }
        stringBuffer.append("new HInteger(\"");
        stringBuffer.append(hInteger.toString());
        stringBuffer.append("\")");
    }

    public static void convertPattern(StringBuffer stringBuffer, HPattern hPattern) {
        HSymbol hSymbol = hPattern.getSymbol();
        String string = hSymbol.toString();
        if (string.length() == 1 && string.charAt(0) >= 'a' && string.charAt(0) <= 'z') {
            stringBuffer.append("C._");
            stringBuffer.append(string);
            return;
        }
        stringBuffer.append("new HPattern(");
        EToJava.convertSymbol(stringBuffer, hSymbol);
        stringBuffer.append(")");
    }

    public static void convertString(StringBuffer stringBuffer, HString hString) {
        stringBuffer.append("new HString(\"");
        stringBuffer.append(hString.toString());
        stringBuffer.append("\")");
    }

    public static void convertSymbol(StringBuffer stringBuffer, HSymbol hSymbol) {
        String string = hSymbol.toString();
        if (string.charAt(0) >= 'A' && string.charAt(0) <= 'Z') {
            stringBuffer.append("C.");
            stringBuffer.append(string);
            return;
        }
        if (string.length() == 1 && string.charAt(0) >= 'a' && string.charAt(0) <= 'z') {
            stringBuffer.append("C.");
            stringBuffer.append(string);
            return;
        }
        stringBuffer.append("new HSymbol(\"");
        stringBuffer.append(string);
        stringBuffer.append("\")");
    }

    public HObject e1ObjArg(HObject hObject) {
        StringBuffer stringBuffer = new StringBuffer();
        EToJava.convert(stringBuffer, hObject);
        return new HString(stringBuffer);
    }
}

