/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.loadable.EIdentityMatrix;
import com.hartmath.mapping.FunctionEvaluator;

public class EMatrixPow
implements FunctionEvaluator {
    public HObject evaluate(HFunction hFunction) {
        if (hFunction.size() == 2 && hFunction.get(0) instanceof HFunction && (hFunction.get(1) instanceof HInteger || hFunction.get(1) instanceof HDouble)) {
            HFunction hFunction2 = (HFunction)hFunction.get(0);
            int[] nArray = hFunction2.isMatrix();
            if (nArray == null) {
                return null;
            }
            int n = nArray[0];
            if (n != nArray[1]) {
                return null;
            }
            if (n == 0) {
                return null;
            }
            int n2 = 0;
            n2 = hFunction.get(1) instanceof HInteger ? ((HInteger)hFunction.get(1)).intValue() : ((HDouble)hFunction.get(1)).intValue();
            HObject hObject = EIdentityMatrix.fInt(n);
            HObject hObject2 = n2 < 0 ? C.EV(C.Inverse.f(hFunction2)) : hFunction2;
            while (n2 != 0) {
                if ((n2 & 1) == 1) {
                    hObject = C.EV(C.Dot.f(hObject, hObject2));
                }
                if ((n2 >>= 1) == 0) continue;
                hObject2 = C.EV(C.Dot.f(hObject2, hObject2));
            }
            return hObject;
        }
        return null;
    }
}

