/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HNumber;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import com.hartmath.util.ExtraMath;
import com.hartmath.util.MathNumber;
import java.util.Vector;

public class HDoubleComplex
extends MathNumber
implements HObject,
HNumber {
    private double re;
    private double im;
    public static final HDoubleComplex DC0 = new HDoubleComplex(0.0, 0.0);
    public static final HDoubleComplex DC1 = new HDoubleComplex(1.0, 0.0);
    public static final HDoubleComplex DCN1 = new HDoubleComplex(-1.0, 0.0);
    public static final HDoubleComplex DCI = new HDoubleComplex(0.0, 1.0);
    public static final HDoubleComplex DCNI = new HDoubleComplex(0.0, -1.0);
    private static final HDoubleComplex PI = new HDoubleComplex(Math.PI, 0.0);
    private static final HDoubleComplex PI_I = new HDoubleComplex(0.0, Math.PI);
    private static final HDoubleComplex PI_2 = new HDoubleComplex(1.5707963267948966, 0.0);
    private static final HDoubleComplex MINUS_PI_2 = new HDoubleComplex(-1.5707963267948966, 0.0);
    private static final HDoubleComplex PI_2_I = new HDoubleComplex(0.0, 1.5707963267948966);
    private static final HDoubleComplex MINUS_PI_2_I = new HDoubleComplex(0.0, -1.5707963267948966);
    public Vector geonextElements = new Vector();

    public HDoubleComplex(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public HDoubleComplex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public HDoubleComplex(HDouble hDouble) {
        this.re = hDouble.doubleValue();
        this.im = 0.0;
    }

    public HDoubleComplex(HDouble hDouble, HDouble hDouble2) {
        this.re = hDouble.doubleValue();
        this.im = hDouble2.doubleValue();
    }

    public HObject abs() {
        double d;
        if (this.im == 0.0) {
            return new HDouble(Math.abs(this.re));
        }
        if (this.re == 0.0) {
            return new HDouble(Math.abs(this.im));
        }
        double d2 = Math.abs(this.re);
        return d2 >= (d = Math.abs(this.im)) ? new HDouble(d2 * Math.sqrt(1.0 + this.im / this.re * (this.im / this.re))) : new HDouble(d * Math.sqrt(1.0 + this.re / this.im * (this.re / this.im)));
    }

    public double absReal() {
        double d;
        if (this.im == 0.0) {
            return Math.abs(this.re);
        }
        if (this.re == 0.0) {
            return Math.abs(this.im);
        }
        double d2 = Math.abs(this.re);
        return d2 >= (d = Math.abs(this.im)) ? d2 * Math.sqrt(1.0 + this.im / this.re * (this.im / this.re)) : d * Math.sqrt(1.0 + this.re / this.im * (this.re / this.im));
    }

    public HDoubleComplex acos() {
        if (this.equals(DC1)) {
            return DC0;
        }
        if (this.equals(DCN1)) {
            return PI;
        }
        double d = 1.0 - this.re * this.re + this.im * this.im;
        double d2 = -2.0 * this.re * this.im;
        return this.negate().divide(new HDoubleComplex(d, d2).sqrt()).atan().addReal(1.5707963267948966);
    }

    public HDoubleComplex acosh() {
        if (this.equals(DC1)) {
            return DC0;
        }
        if (this.equals(DCN1)) {
            return PI_I;
        }
        double d = this.re * this.re - this.im * this.im - 1.0;
        double d2 = 2.0 * this.re * this.im;
        return this.add(new HDoubleComplex(d, d2).sqrt()).log();
    }

    public HDoubleComplex add(double d) {
        return new HDoubleComplex(this.re + d, this.im);
    }

    public HDoubleComplex add(HDoubleComplex hDoubleComplex) throws ArithmeticException {
        return new HDoubleComplex(this.re + hDoubleComplex.re, this.im + hDoubleComplex.im);
    }

    public MathNumber add(MathNumber mathNumber) {
        if (mathNumber instanceof HDoubleComplex) {
            return this.add((HDoubleComplex)mathNumber);
        }
        if (mathNumber instanceof HDouble) {
            return this.addReal(((HDouble)mathNumber).value());
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDoubleComplex addReal(double d) {
        return new HDoubleComplex(this.re + d, this.im);
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.add(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    public HDouble arg() {
        return new HDouble(this.argReal());
    }

    public double argReal() {
        if (this.re == 0.0) {
            if (this.im > 0.0) {
                return 1.5707963267948966;
            }
            if (this.im < 0.0) {
                return -1.5707963267948966;
            }
            return 0.0;
        }
        if (this.re < 0.0) {
            if (this.im >= 0.0) {
                return Math.atan(this.im / this.re) + Math.PI;
            }
            return Math.atan(this.im / this.re) - Math.PI;
        }
        return Math.atan(this.im / this.re);
    }

    public HDoubleComplex asin() {
        if (this.equals(DC1)) {
            return PI_2;
        }
        if (this.equals(DCN1)) {
            return MINUS_PI_2;
        }
        double d = 1.0 - this.re * this.re + this.im * this.im;
        double d2 = -2.0 * this.re * this.im;
        return this.divide(new HDoubleComplex(d, d2).sqrt()).atan();
    }

    public HDoubleComplex asinh() {
        if (this.equals(DCI)) {
            return PI_2_I;
        }
        if (this.equals(DCNI)) {
            return MINUS_PI_2_I;
        }
        double d = this.re * this.re - this.im * this.im + 1.0;
        double d2 = 2.0 * this.re * this.im;
        return this.add(new HDoubleComplex(d, d2).sqrt()).log();
    }

    public HDoubleComplex atan() {
        return this.multiply(DCI).atanh().multiply(DCNI);
    }

    public HDoubleComplex atanh() {
        double d = this.im * this.im + this.re * this.re - 2.0 * this.re + 1.0;
        return new HDoubleComplex((1.0 - this.re * this.re - this.im * this.im) / d, 2.0 * this.im / d).log().divide(2.0);
    }

    public int compSignum() {
        int n = new HDouble(this.re).signum();
        if (n == 0) {
            return new HDouble(this.im).signum();
        }
        return n;
    }

    public HDoubleComplex conj() {
        if (this.im != 0.0) {
            return new HDoubleComplex(this.re, -this.im);
        }
        return new HDoubleComplex(this.re, this.im);
    }

    public HObject conjugate() {
        return this.conj();
    }

    public HDoubleComplex cos() {
        return new HDoubleComplex(Math.cos(this.re) * ExtraMath.cosh(this.im), -Math.sin(this.re) * ExtraMath.sinh(this.im));
    }

    public HDoubleComplex cosh() {
        return new HDoubleComplex(ExtraMath.cosh(this.re) * Math.cos(this.im), ExtraMath.sinh(this.re) * Math.sin(this.im));
    }

    public HDoubleComplex divide(double d) {
        return new HDoubleComplex(this.re / d, this.im / d);
    }

    public HDoubleComplex divide(HDoubleComplex hDoubleComplex) {
        double d;
        double d2;
        double d3;
        if (Math.abs(hDoubleComplex.re) < Math.abs(hDoubleComplex.im)) {
            double d4 = hDoubleComplex.re / hDoubleComplex.im;
            d3 = hDoubleComplex.re * d4 + hDoubleComplex.im;
            d2 = this.re * d4 + this.im;
            d = this.im * d4 - this.re;
        } else {
            double d5 = hDoubleComplex.im / hDoubleComplex.re;
            d3 = hDoubleComplex.re + hDoubleComplex.im * d5;
            d2 = this.re + this.im * d5;
            d = this.im - this.re * d5;
        }
        return new HDoubleComplex(d2 / d3, d / d3);
    }

    public MathNumber divide(MathNumber mathNumber) {
        if (mathNumber instanceof HDoubleComplex) {
            return this.divide((HDoubleComplex)mathNumber);
        }
        if (mathNumber instanceof HDouble) {
            return this.divide(((HDouble)mathNumber).value());
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public boolean equals(Object object) {
        return object instanceof HDoubleComplex && Double.doubleToLongBits(((HDoubleComplex)object).re) == Double.doubleToLongBits(this.re) && Double.doubleToLongBits(((HDoubleComplex)object).im) == Double.doubleToLongBits(this.im);
    }

    public HObject evaluate() {
        SessionData sessionData = SessionData.currentSessionData();
        if (!sessionData.getNumericFlag()) {
            sessionData.setNumericFlag(true);
            if (this.im == 0.0) {
                return new HDouble(this.re);
            }
            return this;
        }
        if (this.im == 0.0) {
            return new HDouble(this.re);
        }
        return null;
    }

    public HDoubleComplex exp() {
        double d = Math.exp(this.re);
        return new HDoubleComplex(d * Math.cos(this.im), d * Math.sin(this.im));
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.re ^ (int)this.im;
    }

    public HSymbol head() {
        return C.DoubleComplex;
    }

    public final int hierarchy() {
        return 2;
    }

    public HObject im() {
        return new HDouble(this.im);
    }

    public double imag() {
        return this.im;
    }

    public boolean isEqual(HDoubleComplex hDoubleComplex) {
        return this.re == hDoubleComplex.re && this.im == hDoubleComplex.im;
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        return C.DoubleComplex.equals(hSymbol);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isList() {
        return false;
    }

    public boolean isMember(HObject hObject) {
        return this.equals(hObject);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean isNonZero() {
        return this.re != 0.0 || this.im != 0.0;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isUnequal(HDoubleComplex hDoubleComplex) {
        return !this.isEqual(hDoubleComplex);
    }

    public boolean isZero() {
        return this.re == 0.0 && this.im == 0.0;
    }

    public boolean less(Object object) {
        if (object instanceof HDoubleComplex) {
            if (this.re == ((HDoubleComplex)object).re) {
                return this.im < ((HDoubleComplex)object).im;
            }
            return this.re < ((HDoubleComplex)object).re;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public HDoubleComplex log() {
        return new HDoubleComplex(Math.log(this.mod()), this.argReal());
    }

    public boolean matches(HObject hObject) {
        return this.equals(hObject);
    }

    public double mod() {
        double d;
        if (this.re == 0.0 && this.im == 0.0) {
            return 0.0;
        }
        double d2 = Math.abs(this.re);
        if (d2 < (d = Math.abs(this.im))) {
            return d * Math.sqrt(1.0 + this.re / this.im * (this.re / this.im));
        }
        return d2 * Math.sqrt(1.0 + this.im / this.re * (this.im / this.re));
    }

    public HDoubleComplex multiply(double d) {
        return new HDoubleComplex(d * this.re, d * this.im);
    }

    public HDoubleComplex multiply(HDoubleComplex hDoubleComplex) {
        return new HDoubleComplex(this.re * hDoubleComplex.re - this.im * hDoubleComplex.im, this.im * hDoubleComplex.re + this.re * hDoubleComplex.im);
    }

    public MathNumber multiply(MathNumber mathNumber) {
        if (mathNumber instanceof HDoubleComplex) {
            return this.multiply((HDoubleComplex)mathNumber);
        }
        if (mathNumber instanceof HDouble) {
            return this.multiply(((HDouble)mathNumber).value());
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDoubleComplex negate() {
        return new HDoubleComplex(-this.re, -this.im);
    }

    public static HDoubleComplex polarToComplex(double d, double d2) {
        if (d < 0.0) {
            d2 += Math.PI;
            d = -d;
        } else if (d == 0.0) {
            return DC0;
        }
        return new HDoubleComplex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public HDoubleComplex pow(double d) {
        return HDoubleComplex.polarToComplex(Math.pow(this.mod(), d), this.argReal() * d);
    }

    public HDoubleComplex pow(HDoubleComplex hDoubleComplex) {
        double d = this.mod();
        double d2 = this.argReal();
        double d3 = Math.pow(d, hDoubleComplex.re) / Math.exp(d2 * hDoubleComplex.im);
        double d4 = d2 * hDoubleComplex.re + Math.log(d) * hDoubleComplex.im;
        return HDoubleComplex.polarToComplex(d3, d4);
    }

    public int precedence() {
        if (this.re == 0.0) {
            if (this.im == 1.0) {
                return 999999;
            }
            return 200;
        }
        if (this.re < 0.0) {
            return 99;
        }
        return 100;
    }

    public HObject re() {
        return new HDouble(this.re);
    }

    public double real() {
        return this.re;
    }

    public HDoubleComplex sin() {
        return new HDoubleComplex(Math.sin(this.re) * ExtraMath.cosh(this.im), Math.cos(this.re) * ExtraMath.sinh(this.im));
    }

    public HDoubleComplex sinh() {
        return new HDoubleComplex(ExtraMath.sinh(this.re) * Math.cos(this.im), ExtraMath.cosh(this.re) * Math.sin(this.im));
    }

    public HDoubleComplex sqr() {
        return new HDoubleComplex(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    public HDoubleComplex sqrt() {
        return HDoubleComplex.polarToComplex(Math.pow(this.mod(), 0.5), this.argReal() * 0.5);
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        if (this.equals(hObject)) {
            return hObject2;
        }
        return this;
    }

    public HObject substitutePattern() {
        return this;
    }

    public HDoubleComplex subtract(double d) {
        return new HDoubleComplex(this.re - d, this.im);
    }

    public HDoubleComplex subtract(HDoubleComplex hDoubleComplex) {
        return new HDoubleComplex(this.re - hDoubleComplex.re, this.im - hDoubleComplex.im);
    }

    public MathNumber subtract(MathNumber mathNumber) {
        if (mathNumber instanceof HDoubleComplex) {
            return this.subtract((HDoubleComplex)mathNumber);
        }
        if (mathNumber instanceof HDouble) {
            return this.subtractReal(((HDouble)mathNumber).value());
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDoubleComplex subtractReal(double d) {
        return new HDoubleComplex(this.re - d, this.im);
    }

    public HDoubleComplex tan() {
        double d = Math.sin(this.re);
        double d2 = Math.cos(this.re);
        double d3 = ExtraMath.sinh(this.im);
        double d4 = ExtraMath.cosh(this.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new HDoubleComplex(d * d2 / d5, d3 * d4 / d5);
    }

    public HDoubleComplex tanh() {
        double d = ExtraMath.sinh(this.re);
        double d2 = ExtraMath.cosh(this.re);
        double d3 = Math.sin(this.im);
        double d4 = Math.cos(this.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new HDoubleComplex(d * d2 / d5, d3 * d4 / d5);
    }

    public String toString() {
        if (this.re == 0.0) {
            if (this.im == 1.0) {
                return "I";
            }
            if (this.im < 0.0) {
                return "I*(" + String.valueOf(this.im) + ")";
            }
            return "I*" + String.valueOf(this.im);
        }
        if (this.im == 1.0) {
            return Double.toString(this.re) + "+I";
        }
        if (this.im == -1.0) {
            return String.valueOf(this.re) + "-I";
        }
        if (this.im < 0.0) {
            return String.valueOf(this.re) + String.valueOf(this.im) + "*I";
        }
        return String.valueOf(this.re) + "+" + String.valueOf(this.im) + "*I";
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.toString());
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }
}

