/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.FrontendElement;
import geonext.Geonext;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import util.BrowserControl;

class JContentHelpDesk
extends JContentPanel
implements ActionListener,
HyperlinkListener,
TreeSelectionListener {
    DefaultMutableTreeNode topNode = new DefaultMutableTreeNode("GEONExT");
    public JTree tree;
    public JEditorPane helpText;
    public Vector treeNodes = new Vector();
    public Hashtable treePath = new Hashtable();
    public Geonext geonext;
    public DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
    public DefaultMutableTreeNode item = new DefaultMutableTreeNode();
    public JScrollPane scrollHelpText;

    public JContentHelpDesk() {
    }

    public JContentHelpDesk(Geonext geonext) {
        this.geonext = geonext;
        this.setLayout(new BorderLayout(15, 15));
        this.helpText = new JEditorPane("text/html", ""){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.fillRect(10, 10, 100, 100);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(graphics2D);
            }
        };
        this.helpText.setDocument(this.helpText.getEditorKit().createDefaultDocument());
        this.helpText.setEditable(false);
        this.helpText.addHyperlinkListener(this);
        this.scrollHelpText = new JScrollPane(this.helpText);
        this.scrollHelpText.setHorizontalScrollBarPolicy(30);
        this.scrollHelpText.setVerticalScrollBarPolicy(20);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel.add("Center", this.scrollHelpText);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("GEONExT");
        this.generateNode();
        this.tree = new JTree(this.topNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(this);
        this.tree.scrollPathToVisible(this.tree.getLeadSelectionPath());
        this.tree.setLargeModel(true);
        this.tree.setRootVisible(false);
        this.selectPathElement(this.geonext.getHelpString());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(15, 15));
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 5));
        jPanel2.add("Center", jScrollPane);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel);
        jSplitPane.setBorder(new EmptyBorder(15, 15, 15, 15));
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOneTouchExpandable(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(15, 15));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontenthelpdesk_header") + " "));
        jPanel3.add("Center", jSplitPane);
        this.add("Center", jPanel3);
        this.helpText.setContentType("text/html");
        this.helpText.setText("<html>" + this.geonext.getHTMLHead() + "<body>...</body>  </html>");
        if (!this.geonext.getHelpString().equals("xxx")) {
            this.setHelpText(this.geonext.getHelpString());
        } else if (this.selectPathElement("OVERVIEW")) {
            this.setHelpText("OVERVIEW");
        } else {
            this.helpText.setText("<html>" + this.geonext.getHTMLHead() + "<body>" + Geonext.language.getString("jcontenthelpdesk_choose") + "</body>  </html>");
        }
        geonext.getHelpThread.interrupt();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.reset();
            this.geonext.getGeonextHelpDesk().dispose();
        } else if (!string.equals("apply") && string.equals("cancel")) {
            this.goInternet();
            this.geonext.getGeonextHelpDesk().dispose();
        }
    }

    public String parseImages(String string, String string2) {
        String string3 = new String(string.toLowerCase());
        int n = 0;
        while (true) {
            int n2 = string3.indexOf("img ");
            n += n2;
            if (n2 < 0) break;
            int n3 = (string3 = string3.substring(n2)).indexOf("src=\"");
            if (n3 < 0) continue;
            string3 = string3.substring(n3);
            string = string.substring(0, n + n3 + 5) + string2 + "../24/" + string.substring(n + n3 + 5);
            n = n + string2.length() + 7;
        }
        return string;
    }

    public void reset() {
    }

    public void goInternet() {
        String string = Geonext.getGeonextHomepage() + "/?ID=" + "1.51" + "&DT=" + "20051028" + "&KEY=" + this.geonext.getHelpString() + "&LG=" + Geonext.currentLanguage + "&CT=" + Geonext.currentCountry;
        try {
            if (Geonext.applicationMode) {
                BrowserControl.displayURL(string);
            } else {
                this.geonext.getAppletContext().showDocument(new URL(string), "_blank");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void item(String string) {
        if (!string.equals("")) {
            this.item = new DefaultMutableTreeNode(new HelpDeskItem((FrontendElement)Geonext.frontendElements.get(string)));
        }
        this.treeNode.add(this.item);
        this.treePath.put(string, new TreePath(this.item.getPath()));
    }

    public void begin(String string) {
        this.treeNodes.addElement(new DefaultMutableTreeNode(string));
        this.treeNode = (DefaultMutableTreeNode)this.treeNodes.lastElement();
        if (this.treeNodes.size() > 1) {
            ((DefaultMutableTreeNode)this.treeNodes.get(this.treeNodes.size() - 2)).add(this.treeNode);
        } else {
            this.topNode.add(this.treeNode);
        }
    }

    public void topitem(String string) {
        if (!string.equals("")) {
            String string2 = "[xxx]";
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string3 = this.getHelpJarPath() + "doc/" + string.toLowerCase() + ".html";
                URL uRL = new URL(string3);
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                JarEntry jarEntry = jarURLConnection.getJarEntry();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                }
                string2 = stringBuffer.toString();
                try {
                    string2 = string2.substring(string2.indexOf("<h2>") + 4, string2.indexOf("</h2>"));
                    string2 = string2.substring(string2.indexOf(">") + 1, string2.lastIndexOf("<")).trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.item = new DefaultMutableTreeNode(new HelpDeskItem(string2, string));
                this.topNode.add(this.item);
                this.treePath.put(string, new TreePath(this.item.getPath()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void end() {
        this.treeNodes.remove(this.treeNodes.lastElement());
        if (this.treeNodes.size() > 0) {
            this.treeNode = (DefaultMutableTreeNode)this.treeNodes.lastElement();
        }
    }

    public String getHelpJarPath() {
        String string = "help.jar";
        String string2 = "";
        String string3 = this.geonext.getCodeBase().toString();
        string3 = string3.endsWith("geonext.jar!/") ? string3.substring(0, string3.indexOf("geonext.jar!/")) : "jar:" + string3;
        string2 = Geonext.helpjar.equals("") ? "help_" + Geonext.currentLanguage + Geonext.currentCountry + ".jar" : "help_" + Geonext.helpjar + ".jar";
        if (string2.endsWith("_.jar")) {
            string2 = string;
        }
        try {
            URL uRL = new URL(string3 + string2 + "!/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            jarURLConnection.connect();
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string3 + string2 + "!/";
    }

    public void item(String string, String string2) {
        this.item = new DefaultMutableTreeNode(new HelpDeskItem(string, string2));
        this.treeNode.add(this.item);
    }

    public void generateNode() {
        this.topitem("OVERVIEW");
        this.begin(Geonext.language.getString("menu_file"));
        this.item("FUNCTION_NEW");
        this.item("FUNCTION_OPEN");
        this.item("FUNCTION_SAVE");
        this.item(Geonext.language.getString("FUNCTION_SAVE_AS"), "FUNCTION_SAVE_AS");
        this.item(Geonext.language.getString("FUNCTION_SOURCE"), "FUNCTION_SOURCE");
        this.item(Geonext.language.getString("FUNCTION_IMPORT"), "FUNCTION_IMPORT");
        this.item(Geonext.language.getString("FUNCTION_EXPORT"), "FUNCTION_EXPORT");
        this.item("FUNCTION_PRINT");
        this.end();
        this.begin(Geonext.language.getString("menu_edit"));
        this.item("FUNCTION_UNDO");
        this.item("FUNCTION_REDO");
        this.item("MODE_DELETE");
        this.item("FUNCTION_CLEARTRACE");
        this.item("FUNCTION_PREFERENCES");
        this.end();
        this.begin(Geonext.language.getString("menu_view"));
        this.item("FUNCTION_ZOOM_IN");
        this.item("FUNCTION_ZOOM_OUT");
        this.item("FUNCTION_ZOOM_100");
        this.item("FUNCTION_ZOOM_ALL");
        this.item("MODE_ZOOM_BOX");
        this.item("MODE_ORIGIN");
        this.end();
        this.begin(Geonext.language.getString("menu_board"));
        this.item("FUNCTION_BOARD");
        this.item("STATUS_COORDINATES");
        this.item("MODE_ORIGIN");
        this.item("STATUS_GRID");
        this.item("STATUS_SNAP");
        this.item("STATUS_SET");
        this.item("FUNCTION_GET");
        this.item("FUNCTION_DESCRIPTION");
        this.item("FUNCTION_SCREENSHOT");
        this.end();
        this.begin(Geonext.language.getString("menu_objects"));
        this.item("MODE_MOVE");
        this.begin(Geonext.language.getString("menu_points"));
        this.item("MODE_POINT");
        this.item("MODE_COMPOSITION_MIDPOINT");
        this.item("MODE_COMPOSITION_PERPENDICULAR_POINT");
        this.item("MODE_COMPOSITION_CIRCUMCIRCLE_CENTER");
        this.item("MODE_COMPOSITION_PARALLELOGRAM_POINT");
        this.item("MODE_CASPOINT");
        this.item("MODE_INTERSECTION");
        this.item("MODE_SLIDER");
        this.item("MODE_COMPOSITION_MIRROR_LINE");
        this.item("MODE_COMPOSITION_MIRROR_POINT");
        this.end();
        this.begin(Geonext.language.getString("menu_lines"));
        this.item("MODE_LINE_STRAIGHT");
        this.item("MODE_LINE_SEGMENT");
        this.item("MODE_LINE_RAY");
        this.item("MODE_COMPOSITION_BISECTOR");
        this.item("MODE_COMPOSITION_PERPENDICULAR");
        this.item("MODE_COMPOSITION_NORMAL");
        this.item("MODE_COMPOSITION_PARALLEL");
        this.end();
        this.begin(Geonext.language.getString("menu_circle"));
        this.item("MODE_CIRCLE");
        this.item("MODE_CIRCLE_RADIUS");
        this.item("MODE_CIRCLE_CALC");
        this.item("MODE_COMPOSITION_CIRCUMCIRCLE");
        this.item("MODE_ARC");
        this.item("MODE_COMPOSITION_SECTOR");
        this.end();
        this.begin(Geonext.language.getString("menu_arrows"));
        this.item("MODE_ARROW");
        this.item("MODE_COMPOSITION_ARROW_PARALLEL");
        this.end();
        this.item("MODE_POLYGON");
        this.begin(Geonext.language.getString("menu_graphs"));
        this.item("MODE_GRAPH");
        this.item("MODE_PARAMETERCURVE");
        this.item("MODE_TRACECURVE");
        this.end();
        this.begin(Geonext.language.getString("menu_texts"));
        this.item("MODE_TEXT");
        this.item("MODE_TEXT_ANGLE");
        this.item("MODE_TEXT_DISTANCE");
        this.end();
        this.begin(Geonext.language.getString("menu_angles"));
        this.item("MODE_ANGLE");
        this.item("MODE_ARC_CALC");
        this.item("MODE_TEXT_ANGLE");
        this.end();
        this.begin(Geonext.language.getString("menu_groups"));
        this.item("MODE_GROUP_ON");
        this.item("MODE_GROUP_OFF");
        this.end();
        this.item("MODE_EDIT");
        this.begin(Geonext.language.getString("menu_special"));
        this.item("MODE_RENAME");
        this.item("MODE_SHOWNAME");
        this.item("MODE_VISIBLE");
        this.item("MODE_DRAFT");
        this.item("MODE_SETTRACE");
        this.end();
        this.begin(Geonext.language.getString("menu_animation"));
        this.item("FUNCTION_PLAY");
        this.item("FUNCTION_STOP");
        this.end();
        this.end();
        this.begin(Geonext.language.getString("menu_windows"));
        this.item("FUNCTION_CASCADE");
        this.item("FUNCTION_TILE");
        this.item("FUNCTION_COPY");
        this.end();
        this.begin(Geonext.language.getString("menu_info"));
        this.item("FUNCTION_UPDATE");
        this.item("FUNCTION_INFO");
        this.end();
        this.topitem("CONSTRUCT_CAS");
        this.topitem("CONSTRUCT_CAS_SHORT");
        this.topitem("ITEMS");
        this.topitem("INDEX");
    }

    public void setHelpText(String string) {
        String string2 = "";
        String string3 = "help.jar";
        String string4 = "";
        String string5 = this.geonext.getCodeBase().toString();
        string5 = string5.endsWith("geonext.jar!/") ? string5.substring(0, string5.indexOf("geonext.jar!/")) : "jar:" + string5;
        try {
            this.helpText.setDocument(this.helpText.getEditorKit().createDefaultDocument());
            string4 = Geonext.helpjar.equals("") ? "help_" + Geonext.currentLanguage + Geonext.currentCountry + ".jar" : "help_" + Geonext.helpjar + ".jar";
            if (string4.endsWith("_.jar")) {
                string4 = string3;
            }
            try {
                URL uRL = new URL(new URL(string5 + string4 + "!/"), "doc/" + string.toLowerCase() + ".html");
                this.helpText.setPage(uRL);
            }
            catch (Exception exception) {
                string4 = string3;
                URL uRL = new URL(new URL(string5 + string4 + "!/"), "doc/" + string.toLowerCase() + ".html");
                this.helpText.setPage(uRL);
            }
        }
        catch (Exception exception) {
            this.helpText.setContentType("text/html");
            this.helpText.setText("<html>" + this.geonext.getHTMLHead() + "<body>" + Geonext.language.getString("jcontenthelpdesk_no_help") + "</body>\t</html>");
        }
        this.helpText.setCaretPosition(0);
        this.geonext.setHelpString(string.toLowerCase());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            try {
                this.setHelpText(((HelpDeskItem)object).getId());
            }
            catch (Exception exception) {
                this.setHelpText("");
            }
        } else {
            String string = "";
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                try {
                    HelpDeskItem helpDeskItem = (HelpDeskItem)defaultMutableTreeNode2.getUserObject();
                    string = string + "<a href=\"" + helpDeskItem.id.toLowerCase() + "\">" + helpDeskItem.name + "</a><p>";
                    continue;
                }
                catch (Exception exception) {
                    string = string + defaultMutableTreeNode2.toString() + "<p>";
                }
            }
            this.helpText.setDocument(this.helpText.getEditorKit().createDefaultDocument());
            this.helpText.setContentType("text/html");
            this.helpText.setText("<head><title>function_board</title><style type=\"text/css\">body {font-size:12px; font-family:sans-serif;}a {color:#0080c0; text-decoration:none;}.none{color:#000000; text-decoration:none;}.small{font-size:10px; font-family:sans-serif;}.gray{color:#8080bb}</style></head><body><table border=\"0\"><tr><td valign=\"middle\">&nbsp;</td><td valign=\"middle\"><h2>" + Geonext.language.getString("jcontenthelpdesk_choose") + "</h2><ul>" + string + "</ul></td></tr></table></body></html>");
            this.helpText.setCaretPosition(0);
        }
    }

    public boolean selectPathElement(String string) {
        string = string.toUpperCase();
        try {
            TreePath treePath = (TreePath)this.treePath.get(string);
            if (treePath == null) {
                return false;
            }
            this.tree.setSelectionPath(treePath);
            this.tree.makeVisible(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL == null) {
                this.selectPathElement(hyperlinkEvent.getDescription());
                this.setHelpText(hyperlinkEvent.getDescription());
            } else if (!uRL.toString().startsWith("http")) {
                this.helpText.setDocument(this.helpText.getEditorKit().createDefaultDocument());
                try {
                    this.helpText.setPage(uRL);
                }
                catch (Exception exception) {
                    this.selectPathElement(hyperlinkEvent.getDescription());
                    this.setHelpText(hyperlinkEvent.getDescription());
                }
            } else {
                try {
                    if (Geonext.applicationMode) {
                        BrowserControl.displayURL(uRL.toString());
                    } else {
                        this.geonext.getAppletContext().showDocument(new URL(uRL.toString()), "_blank");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class HelpDeskItem {
        public String id;
        public String name;

        public HelpDeskItem(String string, String string2) {
            this.id = string2;
            this.name = string;
        }

        public HelpDeskItem(FrontendElement frontendElement) {
            this.id = frontendElement.getActionName();
            this.name = frontendElement.getDescription();
        }

        public String toString() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

