/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.SessionData;
import geonext.Coordinates;
import geonext.DrawText;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Point;
import geonext.Text;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class Element
implements MouseMotionListener {
    public String id;
    public String name;
    public String info;
    public int elementKey = 0;
    public boolean showInfo;
    public boolean mode;
    public boolean active;
    public Color stroke;
    public Color fill;
    public Color lighting;
    public Color label;
    public boolean visible;
    public boolean draft;
    public boolean composition;
    public boolean trace;
    public Color draftColor;
    public Color editVisibleColor;
    public Color editUnvisibleColor;
    public String loadID;
    public Element parent;
    public Vector dataVector;
    public String elementName = "";
    public Coordinates textAnchor;
    public Vector ancestor = new Vector();
    public boolean editVisible = false;
    public boolean changed = true;
    public DrawText drawName;
    public boolean moved;
    public int strokeWidth = 2;
    public int dash = 0;
    public int area = 5;
    public String typeString = "";
    public boolean nameDrawed = true;
    public boolean textName = false;
    public Text nameText;

    public Element() {
        this.id = "-1";
        this.initElement();
    }

    public Element(String string, int n, int n2) {
        this.id = "g" + string + "e" + n;
        this.initElement();
        this.setElementKey(n2);
    }

    public void addToAncestor() {
    }

    public void addToAncestor(Element element) {
        for (int i = 0; i < element.ancestor.size(); ++i) {
            if (this.ancestor.contains(element.ancestor.get(i))) continue;
            this.ancestor.addElement(element.ancestor.get(i));
        }
        if (!this.ancestor.contains(element)) {
            this.ancestor.addElement(element);
        }
    }

    public void calculate(boolean bl) {
    }

    public double[] cp(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public double orientation(Point point, Point point2) {
        double d = point.getUserX() * point2.getUserY() - point.getUserY() * point2.getUserX();
        return d;
    }

    public Point vect(Point point, Point point2) {
        Point point3 = new Point();
        point3.setUser(point2.getUserX() - point.getUserX(), point2.getUserY() - point.getUserY());
        return point3;
    }

    public Vector data() {
        return new Vector();
    }

    public String substSupSub(String string) {
        int n;
        DrawText drawText = new DrawText(string);
        string = "";
        Vector vector = drawText.parse();
        Object[] objectArray = vector.toArray();
        String[] stringArray = new String[objectArray.length];
        boolean bl = false;
        for (n = 0; n < objectArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        block1: for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("_")) {
                string = string + "<sub>";
                continue;
            }
            if (stringArray[n].equals("^")) {
                string = string + "<sup>";
                continue;
            }
            if (stringArray[n].equals("{")) continue;
            if (stringArray[n].equals("}")) {
                stringArray[n] = "";
                for (int i = 1; i < n; ++i) {
                    if (!stringArray[n - i].equals("{")) continue;
                    if (stringArray[n - i - 1].equals("_")) {
                        string = string + "</sub>";
                    } else if (stringArray[n - i - 1].equals("^")) {
                        string = string + "</sup>";
                    }
                    stringArray[n - i] = "";
                    continue block1;
                }
                continue;
            }
            string = string + stringArray[n];
            if (n <= 0) continue;
            if (stringArray[n - 1].equals("_")) {
                string = string + "</sub>";
                continue;
            }
            if (!stringArray[n - 1].equals("^")) continue;
            string = string + "</sup>";
        }
        return string;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("element_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
    }

    public void drawTrace(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.isTrace()) {
            this.setNameDrawed(false);
            this.draw(graphics2D, jBoardPane);
            this.setNameDrawed(true);
        }
    }

    public Element getTHIS() {
        return this;
    }

    public boolean exists() {
        return true;
    }

    public String generateDesc(String string) {
        return this.generateDesc(string, true);
    }

    public String generateShort(String string) {
        return this.generateDesc(string, false);
    }

    public String generateDesc(String string, boolean bl) {
        try {
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2;
                block13: {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.indexOf("}") < 0) {
                        string2 = string2 + string3;
                        continue;
                    }
                    stringTokenizer2 = new StringTokenizer(string3, "}");
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string4 = stringTokenizer2.nextToken();
                    try {
                        Element element = null;
                        String string5 = null;
                        if (string4.indexOf("#") == -1) {
                            element = (Element)this.getClass().getMethod("get" + string4, null).invoke((Object)this, null);
                        } else {
                            Class[] classArray;
                            StringTokenizer stringTokenizer3 = new StringTokenizer(string4, "#");
                            String string6 = stringTokenizer3.nextToken();
                            String string7 = stringTokenizer3.nextToken();
                            if (string7.indexOf(".") != -1) {
                                classArray = new StringTokenizer(string7, ".");
                                string7 = classArray.nextToken();
                                string5 = classArray.nextToken();
                            }
                            classArray = new Class[]{"".getClass()};
                            Object[] objectArray = new String[]{string7};
                            element = (Element)this.getClass().getMethod("get" + string6, classArray).invoke((Object)this, objectArray);
                        }
                        if (string5 == null) {
                            if (element.getName() != "") {
                                string2 = bl ? string2 + this.substSupSub(element.getName()) : string2 + element.getName();
                            }
                        } else {
                            string2 = string2 + element.generateDesc("{" + string5 + "}");
                        }
                    }
                    catch (Exception exception) {
                        string4 = this.get(string4);
                        if (string4 == "") break block13;
                        string2 = string4.startsWith("#") && string4.length() == 9 ? string2 + string4.substring(0, 7) : string2 + string4;
                    }
                }
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = string2 + stringTokenizer2.nextToken();
                }
            }
            return new JBoardPane().changeChar(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void generateName(ElementSet elementSet) {
    }

    public String generateSVGName(String string) {
        String string2 = "";
        if (string != "") {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            string2 = string3 = stringTokenizer.nextToken();
            string3 = "";
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = string2 + "<tspan style=\"baseline-shift:sub\">" + string3;
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "</tspan>";
            }
        }
        return string2;
    }

    public String generateSVGName(String string, int n) {
        String string2 = "";
        if (string != "") {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            string2 = string3 = stringTokenizer.nextToken();
            string3 = "";
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = string2 + "<tspan style=\"baseline-shift:sub; font-size:" + (n - 2) + " pt\">" + string3;
                ++n2;
            }
            for (int i = 0; i < n2; ++i) {
                string2 = string2 + "</tspan>";
            }
        }
        return string2;
    }

    public String get(String string) {
        Class[] classArray = new Class[]{new String().getClass()};
        Object[] objectArray = new String[]{};
        try {
            string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
            Method method = null;
            try {
                method = this.getClass().getMethod("is" + string, null);
            }
            catch (Exception exception) {
                method = this.getClass().getMethod("get" + string, null);
            }
            Object object = method.invoke((Object)this, objectArray);
            if (object instanceof Color) {
                return "#" + new JBoardPane().getHexColor((Color)object);
            }
            return "" + method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Vector getAncestor() {
        return this.ancestor;
    }

    public String insertJS(String string) {
        try {
            String string2 = string.substring(0, string.indexOf("{THIS}"));
            String string3 = string.substring(string.indexOf("{THIS}") + 6, string.length() - 1);
            string = string2 + "<a href=\"javascript:;\" onMouseOver=\"document.xxx.set('{THIS}.strokewidth='+parseInt(document.xxx.get('{THIS}.strokewidth')*1+3));\" onMouseOut=\"document.xxx.set('{THIS}.strokewidth='+parseInt(document.xxx.get('{THIS}.strokewidth')*1-3));\">{THIS}</a>" + string3;
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public int getArea() {
        return this.area;
    }

    public int getDash() {
        return this.dash;
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public double getDEG(Point point, Point point2) {
        double d = (point2.getUserX() - point.getUserX()) / point2.userDistance(point);
        double d2 = (point2.getUserY() - point.getUserY()) / point2.userDistance(point);
        if (d2 >= 0.0) {
            return 180.0 * Math.acos(d) / Math.PI;
        }
        return 360.0 - 180.0 * Math.acos(d) / Math.PI;
    }

    public Color getDraftcolor() {
        return this.draftColor;
    }

    public Color getDraftColor() {
        return this.draftColor;
    }

    public DrawText getDrawName() {
        return this.drawName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public Color getFill() {
        return this.fill;
    }

    public String getHex(int n) {
        String string = "";
        int n2 = n % 16;
        n = (n - n2) / 16 % 16;
        int n3 = 0;
        while (n3++ < 2) {
            switch (n) {
                case 10: {
                    string = string + "A";
                    break;
                }
                case 11: {
                    string = string + "B";
                    break;
                }
                case 12: {
                    string = string + "C";
                    break;
                }
                case 13: {
                    string = string + "D";
                    break;
                }
                case 14: {
                    string = string + "E";
                    break;
                }
                case 15: {
                    string = string + "F";
                    break;
                }
                default: {
                    string = string + "" + n;
                }
            }
            n = n2;
        }
        return string;
    }

    public String getHexColor(Color color) {
        return this.getHex(color.getRed()) + this.getHex(color.getGreen()) + this.getHex(color.getBlue()) + this.getHex(color.getAlpha());
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public Color getLabel() {
        return this.label;
    }

    public Color getLighting() {
        return this.lighting;
    }

    public String getLoadID() {
        return this.loadID;
    }

    public String getName() {
        return this.name;
    }

    public Element getParent() {
        return this.parent;
    }

    public double getRAD(Point point, Point point2) {
        double d = (point2.getUserX() - point.getUserX()) / point2.userDistance(point);
        double d2 = (point2.getUserY() - point.getUserY()) / point2.userDistance(point);
        if (d2 >= 0.0) {
            return Math.acos(d);
        }
        return Math.PI * 2 - Math.acos(d);
    }

    public Color getStroke() {
        return this.stroke;
    }

    public int getStrokewidth() {
        return this.strokeWidth;
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public Coordinates getTextAnchor() {
        return this.textAnchor;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public void initElement() {
        this.name = "";
        this.info = "";
        this.showInfo = false;
        this.mode = false;
        this.active = true;
        this.stroke = new Color(0, 0, 255);
        this.fill = new Color(0, 255, 0, 50);
        this.lighting = new Color(0, 0, 0);
        this.label = new Color(0, 0, 0);
        this.visible = true;
        this.draft = false;
        this.composition = false;
        this.draftColor = new Color(200, 200, 200, 100);
        this.editUnvisibleColor = new Color(240, 175, 175, 150);
        this.editVisibleColor = this.draftColor;
        this.drawName = new DrawText();
        this.dataVector = new Vector();
        this.setElementName(Geonext.language.getString("element_element_name"));
        this.textAnchor = new Coordinates(0.0, 0.0);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isComposition() {
        return this.composition;
    }

    public boolean isDraft() {
        if (this.isEditVisible()) {
            if (this.visible) {
                if (!this.draft) {
                    return false;
                }
            } else {
                this.draftColor = this.editUnvisibleColor;
            }
            return true;
        }
        this.draftColor = this.editVisibleColor;
        return this.draft;
    }

    public boolean isMode() {
        return this.mode;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public boolean isNameDrawed() {
        return this.nameDrawed;
    }

    public boolean isShowInfo() {
        return this.showInfo;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public boolean isExists() {
        return this.exists();
    }

    public boolean isVisible() {
        return this.visible | this.isEditVisible();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public double[] normVector(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        return new double[]{dArray[0] / d, dArray[1] / d, dArray[2] / d};
    }

    public String parseProperties(JBoardPane jBoardPane, String string) {
        return this.parseProperties(string);
    }

    public String parseProperties(String string) {
        this.setLoadID(this.tag(string, "id")[1]);
        string = this.tag(string, "id")[0];
        String string2 = this.tag(string, "color")[1];
        string = this.tag(string, "color")[0];
        this.setStroke(this.tag(string2, "stroke")[1]);
        this.setFill(this.tag(string2, "fill")[1]);
        this.setLabel(this.tag(string2, "label")[1]);
        this.setDraftcolor(this.tag(string2, "draftcolor")[1]);
        this.setLighting(this.tag(string2, "lighting")[1]);
        this.setTrace(this.tag(string, "trace")[1]);
        string = this.tag(string, "trace")[0];
        this.setVisible(this.tag(string, "visible")[1]);
        string = this.tag(string, "visible")[0];
        this.setDraft(this.tag(string, "draft")[1]);
        string = this.tag(string, "draft")[0];
        this.setInfo(this.tag(string, "info")[1]);
        string = this.tag(string, "info")[0];
        this.setShowinfo(this.tag(string, "showinfo")[1]);
        string = this.tag(string, "showinfo")[0];
        this.setDash(this.tag(string, "dash")[1]);
        string = this.tag(string, "dash")[0];
        this.setStrokewidth(this.tag(string, "strokewidth")[1]);
        string = this.tag(string, "strokewidth")[0];
        this.setArea(this.tag(string, "area")[1]);
        string = this.tag(string, "area")[0];
        return string;
    }

    public String rgb2svgrgb(Color color) {
        if (color != null) {
            String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            return string;
        }
        return "none";
    }

    public Element searchLoadID(String string) {
        if (this.getLoadID().equals(string)) {
            return this;
        }
        return null;
    }

    public Element searchName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return null;
    }

    public void set(String string, String string2) {
        Class[] classArray = new Class[]{new String().getClass()};
        Object[] objectArray = new String[]{string2};
        try {
            string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
            Method method = this.getClass().getMethod(string, classArray);
            method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setActive(String string) {
        this.setActive(new Boolean(string));
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setAncestor() {
        for (int i = 0; i < this.data().size(); ++i) {
            try {
                this.addToAncestor((Element)this.data().get(i));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setAncestor(Vector vector) {
        this.ancestor = vector;
    }

    public void setArea(int n) {
        this.area = n;
    }

    public void setArea(String string) {
        try {
            this.setArea(new Integer(string));
        }
        catch (Exception exception) {
            this.setArea(3);
        }
    }

    public void setColor(Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color != null) {
            this.stroke = color;
        }
        if (color2 != null) {
            this.lighting = color2;
        }
        if (color3 != null) {
            this.fill = color3;
        }
        if (color4 != null) {
            this.label = color4;
        }
        if (color5 != null) {
            this.draftColor = color5;
        }
    }

    public void setComposition(boolean bl) {
        this.composition = bl;
    }

    public void setDash(int n) {
        this.dash = n;
    }

    public void setDash(String string) {
        try {
            this.setDash(new Integer(string));
        }
        catch (Exception exception) {
            this.setDash(0);
        }
    }

    public void setDataVector(Vector vector) {
        this.dataVector = vector;
    }

    public void setDraft(String string) {
        this.setDraft(new Boolean(string));
    }

    public void setDraft(boolean bl) {
        this.draft = bl;
    }

    public void setDraftColor(Color color) {
        this.draftColor = color;
    }

    public void setDraftcolor(String string) {
        Color color = new JBoardPane().parseColor(string);
        if (color == null) {
            color = new Color(200, 200, 200, 100);
        }
        this.setDraftColor(color);
    }

    public void setDrawName(DrawText drawText) {
        this.drawName = drawText;
    }

    public void setElementName(String string) {
        this.elementName = string;
    }

    public void setFill(Color color) {
        this.fill = color;
    }

    public void setFill(String string) {
        Color color = new JBoardPane().parseColor(string);
        if (color == null) {
            color = new Color(185, 219, 125, 100);
        }
        this.setFill(color);
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public void setLabel(Color color) {
        this.label = color;
    }

    public void setLabel(String string) {
        Color color = new JBoardPane().parseColor(string);
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        this.setLabel(color);
    }

    public void setLighting(Color color) {
        this.lighting = color;
    }

    public void setLighting(String string) {
        Color color = new JBoardPane().parseColor(string);
        if (color == null) {
            color = new Color(0, 255, 255);
        }
        this.setLighting(color);
    }

    public void setLoadID(String string) {
        this.loadID = string;
    }

    public void setMode(String string) {
        this.setMode(new Boolean(string));
    }

    public void setMode(boolean bl) {
        this.mode = bl;
    }

    public void setMoved(boolean bl) {
        this.moved = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void initNameText(JBoardPane jBoardPane) {
        this.nameText = new Text();
        this.nameText.setUser(this.getTextAnchor());
        this.nameText.setText(jBoardPane.changeChar(this.getName()));
        this.nameText.parseHTML(jBoardPane);
        this.nameText.evaluate(jBoardPane);
    }

    public void setNameDrawed(boolean bl) {
        this.nameDrawed = bl;
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public void setShowinfo(String string) {
        this.setShowInfo(new Boolean(string));
    }

    public void setShowInfo(boolean bl) {
        this.showInfo = bl;
    }

    public void setStroke(Color color) {
        this.stroke = color;
    }

    public void setStroke(String string) {
        Color color = new JBoardPane().parseColor(string);
        if (color == null) {
            color = new Color(0, 0, 255);
        }
        this.setStroke(color);
    }

    public void setStrokeWidth(int n) {
        this.strokeWidth = n;
    }

    public void setStrokewidth(String string) {
        try {
            this.setStrokeWidth(new Integer(string));
        }
        catch (Exception exception) {
            this.setStrokeWidth(2);
        }
    }

    public void setTextAnchor(Coordinates coordinates) {
        this.textAnchor = coordinates;
    }

    public void setTrace(String string) {
        this.setTrace(new Boolean(string));
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setTypeString(String string) {
        this.typeString = string;
    }

    public void setVisible(String string) {
        this.setVisible(new Boolean(string));
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public String svg() {
        return null;
    }

    public String[] tag(String string, String string2) {
        String string3 = string;
        if (string != "") {
            string = string3.toLowerCase();
            try {
                String[] stringArray = new String[2];
                String string4 = "<" + string2.toLowerCase() + ">";
                stringArray[0] = string3.substring(0, string.indexOf(string4));
                string3 = string3.substring(string.indexOf(string4) + string4.length());
                string = string.substring(string.indexOf(string4) + string4.length());
                string4 = "</" + string2.toLowerCase() + ">";
                stringArray[0] = stringArray[0] + string3.substring(string.indexOf(string4) + string4.length(), string3.length());
                string3 = string3.substring(0, string.indexOf(string4));
                string = string.substring(0, string.indexOf(string4));
                stringArray[1] = string3;
                return stringArray;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{string3, ""};
                return stringArray;
            }
        }
        String[] stringArray = new String[]{string3, ""};
        return stringArray;
    }

    public Vector vectorName() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getName());
        return vector;
    }

    public String write(String string) {
        String string2 = "";
        string2 = string2 + string + "<name>" + this.getName() + "</name>\n ";
        string2 = string2 + string + "<id>" + this.getId() + "</id>\n ";
        return string2;
    }

    public String writeData(String string) {
        String string2 = "";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + string + "<active>" + this.isActive() + "</active>\n";
        string2 = string2 + string + "<area>" + this.getArea() + "</area>\n";
        string2 = string2 + string + "<dash>" + this.getDash() + "</dash>\n";
        string2 = string2 + string + "<draft>" + this.isDraft() + "</draft>\n";
        string2 = string2 + string + "<info>" + this.getInfo() + "</info>\n";
        string2 = string2 + string + "<visible>" + this.isVisible() + "</visible>\n";
        string2 = string2 + string + "<trace>" + this.isTrace() + "</trace>\n";
        string2 = string2 + string + "<strokewidth>" + this.getStrokeWidth() + "</strokewidth>\n";
        string2 = string2 + string + "<color>\n";
        string2 = string2 + string + "\t<stroke>#" + this.getHexColor(this.getStroke()) + "</stroke>\n";
        string2 = string2 + string + "\t<lighting>#" + this.getHexColor(this.getLighting()) + "</lighting>\n";
        string2 = string2 + string + "\t<fill>#" + this.getHexColor(this.getFill()) + "</fill>\n";
        string2 = string2 + string + "\t<label>#" + this.getHexColor(this.getLabel()) + "</label>\n";
        string2 = string2 + string + "\t<draft>#" + this.getHexColor(this.getDraftColor()) + "</draft>\n";
        string2 = string2 + string + "</color>\n";
        string2 = string2 + string + "<showinfo>" + this.isShowInfo() + "</showinfo>\n";
        string2 = string2 + string + "<label>\n";
        string2 = string2 + string + "\t<x>...</x>\n";
        string2 = string2 + string + "\t<y>...</y>\n";
        string2 = string2 + string + "</label>\n";
        return string2;
    }

    public void calculateChanged(boolean bl) {
        if (bl) {
            this.setChanged(true);
        } else {
            if (this.isChanged()) {
                return;
            }
            Vector vector = this.data();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((Element)vector.get(i)).isChanged()) continue;
                this.setChanged(true);
                return;
            }
        }
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("element_short"));
    }

    public String getShortinfo() {
        return this.shortInfo();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public boolean isTextName() {
        return this.textName;
    }

    public void setNameText(Text text) {
        this.nameText = text;
    }

    public void setTextName(boolean bl) {
        this.textName = bl;
    }

    public void setTraceGEONExTElements(boolean bl) {
        SessionData.currentThreadSession().setTraceGEONExTElements(bl);
    }

    public int getElementKey() {
        return this.elementKey;
    }

    public void setElementKey(int n) {
        this.elementKey = n;
    }

    public boolean isEditVisible() {
        if (this.getParent() != null) {
            return this.getParent().isEditVisible();
        }
        return this.editVisible;
    }

    public void setEditVisible(boolean bl) {
        this.editVisible = bl;
    }
}

