/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import com.hartmath.lib.SessionData;
import geonext.Coordinates;
import geonext.Element;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

class CASPoint
extends Point {
    HObject hx;
    HObject hy;
    String sx;
    String sy;
    int errorCounter = 0;

    public CASPoint() {
        this.initCASPoint();
    }

    public CASPoint(String string, int n, String string2, String string3, int n2) {
        super(string, n, n2);
        this.sx = string2;
        this.sy = string3;
        this.initCASPoint();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            this.setUser();
        }
    }

    public Coordinates calculateCoord() {
        Coordinates coordinates = new Coordinates();
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        try {
            Scanner scanner;
            SessionData sessionData = SessionData.currentSessionData();
            sessionData.currentElement = this;
            if (this.hx == null) {
                scanner = new Scanner(this.sx);
                this.hx = scanner.start();
            }
            try {
                d = new Double(C.NEV(this.hx).toString());
            }
            catch (Exception exception) {
                bl = true;
            }
            if (this.hy == null) {
                scanner = new Scanner(this.sy);
                this.hy = scanner.start();
            }
            try {
                d2 = new Double(C.NEV(this.hy).toString());
            }
            catch (Exception exception) {
                bl = true;
            }
            sessionData.currentElement = null;
            if (!bl) {
                coordinates.setSize(d, d2);
                this.errorCounter = 0;
                this.setActive(true);
                if (new Double(d).isNaN() || new Double(d2).isNaN()) {
                    this.setActive(false);
                    coordinates.setSize(new Double(Double.NaN), new Double(Double.NaN));
                }
                return coordinates;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            ++this.errorCounter;
            this.setActive(false);
            coordinates.setSize(new Double(Double.NaN), new Double(Double.NaN));
        }
        return coordinates;
    }

    public Vector data() {
        return this.dataVector;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("caspoint_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        super.draw(graphics2D, jBoardPane);
    }

    public boolean exists() {
        for (int i = 0; i < this.data().size(); ++i) {
            if (((Element)this.data().get(i)).exists()) continue;
            return false;
        }
        this.calculateCoord();
        return this.isActive();
    }

    public String getSx() {
        return this.hx.toString();
    }

    public String getSy() {
        return this.hy.toString();
    }

    public Coordinates getUser() {
        if (this.user == null) {
            this.setUser();
        }
        return this.user;
    }

    public void initCASPoint() {
        this.user = null;
        this.dataVector = new Vector();
        this.stroke = Color.gray;
        this.lighting = Color.green;
        this.typeString = "cas";
        this.setElementName(Geonext.language.getString("caspoint_element_name"));
        this.movable = false;
        try {
            SessionData sessionData = SessionData.currentSessionData();
            sessionData.currentElement = this;
            Scanner scanner = new Scanner(this.sx, true);
            this.hx = scanner.start();
            scanner = new Scanner(this.sy, true);
            this.hy = scanner.start();
            this.setTraceGEONExTElements(true);
            C.GEV(this.hx);
            C.GEV(this.hy);
            this.setTraceGEONExTElements(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            String string4 = this.tag(string3, "x")[1];
            String string5 = this.tag(string3, "y")[1];
            if (string4.equals("") || string5.equals("")) {
                return false;
            }
            int n = jBoardPane.element.pointCounter;
            jBoardPane.createCASPoint(string4, string5, string2, false);
            if (n == jBoardPane.element.pointCounter) {
                return false;
            }
            Point point = (Point)jBoardPane.element.point.lastElement();
            string = point.parseProperties(jBoardPane, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSx(String string) {
        this.sx = string;
    }

    public void setSy(String string) {
        this.sy = string;
    }

    public void setUser() {
        this.user = this.calculateCoord();
        if (this.active) {
            this.user2sphere();
        }
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<xval>" + this.getUserX() + "</xval>\n ";
        string2 = string2 + string + "<yval>" + this.getUserY() + "</yval>\n ";
        string2 = string2 + string + "<x>" + this.getSx() + "</x>\n ";
        string2 = string2 + string + "<y>" + this.getSy() + "</y>\n ";
        return string2;
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        return this.generateShort(Geonext.language.getString("caspoint_short"));
    }
}

