/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.util.ComplexSquareMatrix;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.DoubleSquareMatrix;
import com.hartmath.util.DoubleTridiagonalMatrix;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.MaximumIterationsExceededException;

public final class LinearMath {
    private LinearMath() {
    }

    private static double[] applyPlaneRotation(double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{d3 * d + d4 * d2, -d4 * d + d3 * d2};
        return dArray;
    }

    public static double[] eigenSolveHermitian(ComplexSquareMatrix complexSquareMatrix, ComplexVector[] complexVectorArray) {
        int n;
        int n2;
        int n3 = complexSquareMatrix.rows();
        double[][] dArray = new double[2 * n3][2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = complexSquareMatrix.getElement(n2, n).real();
            }
            for (n = 0; n < n3; ++n) {
                dArray[n2][n3 + n] = -complexSquareMatrix.getElement(n2, n).imag();
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n3 + n2][n] = complexSquareMatrix.getElement(n2, n).imag();
            }
            for (n = 0; n < n3; ++n) {
                dArray[n3 + n2][n3 + n] = complexSquareMatrix.getElement(n2, n).real();
            }
        }
        double[] dArray2 = new double[2 * n3];
        double[] dArray3 = new double[2 * n3];
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n3 - 1);
        dArray3[n3 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray2, dArray3, dArray);
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray4[n2] = dArray2[n2];
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[n3];
            for (n = 0; n < n3; ++n) {
                hDoubleComplexArray[n] = new HDoubleComplex(dArray[n][n2], dArray[n + n3][n2]);
            }
            complexVectorArray[n2] = new ComplexVector(hDoubleComplexArray);
        }
        return dArray4;
    }

    public static double[] eigenSolveSymmetric(DoubleSquareMatrix doubleSquareMatrix, DoubleVector[] doubleVectorArray) {
        int n;
        int n2;
        int n3 = doubleSquareMatrix.rows();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray3[n2][n] = doubleSquareMatrix.getElement(n2, n);
            }
        }
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n3 - 1);
        dArray2[n3 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        for (n2 = 0; n2 < n3; ++n2) {
            doubleVectorArray[n2] = new DoubleVector(n3);
            for (n = 0; n < n3; ++n) {
                doubleVectorArray[n2].vector[n] = dArray3[n][n2];
            }
        }
        return dArray;
    }

    public static double[] eigenSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix, DoubleVector[] doubleVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2 = doubleTridiagonalMatrix.rows();
        int n3 = n2 - 1;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[n2][n2];
        for (n = 0; n < n3; ++n) {
            dArray3[n][n] = 1.0;
            dArray[n] = doubleTridiagonalMatrix.getElement(n, n);
            dArray2[n] = doubleTridiagonalMatrix.getElement(n, n + 1);
        }
        dArray3[n3][n3] = 1.0;
        dArray[n3] = doubleTridiagonalMatrix.getElement(n3, n3);
        dArray2[n3] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        for (n = 0; n < n2; ++n) {
            doubleVectorArray[n] = new DoubleVector(n2);
            for (int i = 0; i < n2; ++i) {
                doubleVectorArray[n].vector[i] = dArray3[i][n];
            }
        }
        return dArray;
    }

    private static void eigenSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2, double[][] dArray3) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = 0;
            do {
                for (n3 = i; n3 < n2; ++n3) {
                    double d = Math.abs(dArray[n3]) + Math.abs(dArray[n3 + 1]);
                    if (Math.abs(dArray2[n3]) + d == d) break;
                }
                if (n3 == i) continue;
                if (n4++ == 50) {
                    throw new MaximumIterationsExceededException("No convergence after 50 iterations.");
                }
                double d = (dArray[i + 1] - dArray[i]) / (2.0 * dArray2[i]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n3] - dArray[i] + dArray2[i] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                for (int j = n3 - 1; j >= i; --j) {
                    double d6 = d4 * dArray2[j];
                    double d7 = d3 * dArray2[j];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[j + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[j + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[j + 1] - d5;
                    d2 = (dArray[j] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[j + 1] = d + d5;
                    d = d3 * d2 - d7;
                    for (int k = 0; k < n; ++k) {
                        d6 = dArray3[k][j + 1];
                        dArray3[k][j + 1] = d4 * dArray3[k][j] + d3 * d6;
                        dArray3[k][j] = d3 * dArray3[k][j] - d4 * d6;
                    }
                }
                dArray[i] = dArray[i] - d5;
                dArray2[i] = d;
                dArray2[n3] = 0.0;
            } while (n3 != i);
        }
    }

    public static double[] eigenvalueSolveHermitian(ComplexSquareMatrix complexSquareMatrix) {
        int n;
        int n2;
        int n3 = complexSquareMatrix.rows();
        double[][] dArray = new double[2 * n3][2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = complexSquareMatrix.getElement(n2, n).real();
            }
            for (n = 0; n < n3; ++n) {
                dArray[n2][n3 + n] = -complexSquareMatrix.getElement(n2, n).imag();
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n3 + n2][n] = complexSquareMatrix.getElement(n2, n).imag();
            }
            for (n = 0; n < n3; ++n) {
                dArray[n3 + n2][n3 + n] = complexSquareMatrix.getElement(n2, n).real();
            }
        }
        double[] dArray2 = new double[2 * n3];
        double[] dArray3 = new double[2 * n3];
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n3 - 1);
        dArray3[n3 - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray2, dArray3);
        double[] dArray4 = new double[n3];
        System.arraycopy(dArray2, 0, dArray4, 0, n3);
        return dArray4;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleSquareMatrix doubleSquareMatrix) throws MaximumIterationsExceededException {
        int n = doubleSquareMatrix.rows();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = doubleSquareMatrix.getElement(i, j);
            }
        }
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n - 1);
        dArray2[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = doubleTridiagonalMatrix.rows();
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = doubleTridiagonalMatrix.getElement(i, i);
            dArray2[i] = doubleTridiagonalMatrix.getElement(i, i + 1);
        }
        dArray[n2] = doubleTridiagonalMatrix.getElement(n2, n2);
        dArray2[n2] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    private static void eigenvalueSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = 0;
            do {
                for (n3 = i; n3 < n2; ++n3) {
                    double d = Math.abs(dArray[n3]) + Math.abs(dArray[n3 + 1]);
                    if (Math.abs(dArray2[n3]) + d == d) break;
                }
                if (n3 == i) continue;
                if (n4++ == 50) {
                    throw new MaximumIterationsExceededException("No convergence after 50 iterations.");
                }
                double d = (dArray[i + 1] - dArray[i]) / (2.0 * dArray2[i]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n3] - dArray[i] + dArray2[i] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                for (int j = n3 - 1; j >= i; --j) {
                    double d6 = d4 * dArray2[j];
                    double d7 = d3 * dArray2[j];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[j + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[j + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[j + 1] - d5;
                    d2 = (dArray[j] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[j + 1] = d + d5;
                    d = d3 * d2 - d7;
                }
                dArray[i] = dArray[i] - d5;
                dArray2[i] = d;
                dArray2[n3] = 0.0;
            } while (n3 != i);
        }
    }

    private static double[] generatePlaneRotation(double d, double d2) {
        double[] dArray = new double[2];
        if (d2 == 0.0) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        } else if (Math.abs(d2) > Math.abs(d)) {
            double d3 = d / d2;
            dArray[1] = 1.0 / Math.sqrt(1.0 + d3 * d3);
            dArray[0] = d3 * dArray[1];
        } else {
            double d4 = d2 / d;
            dArray[0] = 1.0 / Math.sqrt(1.0 + d4 * d4);
            dArray[1] = d4 * dArray[0];
        }
        return dArray;
    }

    public static DoubleVector leastSquaresFit(int n, double[][] dArray) {
        int n2;
        double d;
        int n3;
        int n4 = n++;
        double[][] dArray2 = new double[n][n];
        double[] dArray3 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            double d2 = 0.0;
            d = 0.0;
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                double d3 = Math.pow(dArray[0][n2], n3);
                d += d3;
                d2 += d3 * dArray[1][n2];
            }
            dArray2[0][n3] = d;
            dArray3[n3] = d2;
        }
        for (n3 = 1; n3 < n; ++n3) {
            System.arraycopy(dArray2[n3 - 1], 1, dArray2[n3], 0, n4);
            d = 0.0;
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                d += Math.pow(dArray[0][n2], n4 + n3);
            }
            dArray2[n3][n4] = d;
        }
        return LinearMath.solve(new DoubleSquareMatrix(dArray2).choleskyDecompose(), new DoubleVector(dArray3));
    }

    private static void reduceSymmetric1_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2 = dArray2.length;
        for (n = n2 - 1; n > 0; --n) {
            int n3 = n - 1;
            double d = 0.0;
            double d2 = 0.0;
            if (n3 > 0) {
                int n4;
                for (n4 = 0; n4 <= n3; ++n4) {
                    d += Math.abs(dArray[n][n4]);
                }
                if (d == 0.0) {
                    dArray3[n] = dArray[n][n3];
                } else {
                    int n5;
                    for (n4 = 0; n4 <= n3; ++n4) {
                        double[] dArray4 = dArray[n];
                        int n6 = n4;
                        dArray4[n6] = dArray4[n6] / d;
                        d2 += dArray[n][n4] * dArray[n][n4];
                    }
                    double d3 = dArray[n][n3];
                    double d4 = d3 >= 0.0 ? -Math.sqrt(d2) : Math.sqrt(d2);
                    dArray3[n] = d * d4;
                    d2 -= d3 * d4;
                    dArray[n][n3] = d3 - d4;
                    d3 = 0.0;
                    for (n5 = 0; n5 <= n3; ++n5) {
                        d4 = 0.0;
                        for (n4 = 0; n4 <= n5; ++n4) {
                            d4 += dArray[n5][n4] * dArray[n][n4];
                        }
                        for (n4 = n5 + 1; n4 <= n3; ++n4) {
                            d4 += dArray[n4][n5] * dArray[n][n4];
                        }
                        dArray3[n5] = d4 / d2;
                        d3 += dArray3[n5] * dArray[n][n5];
                    }
                    double d5 = d3 / (d2 + d2);
                    for (n5 = 0; n5 <= n3; ++n5) {
                        d3 = dArray[n][n5];
                        dArray3[n5] = d4 = dArray3[n5] - d5 * d3;
                        for (n4 = 0; n4 <= n5; ++n4) {
                            double[] dArray5 = dArray[n5];
                            int n7 = n4;
                            dArray5[n7] = dArray5[n7] - (d3 * dArray3[n4] + d4 * dArray[n][n4]);
                        }
                    }
                }
            } else {
                dArray3[n] = dArray[n][n3];
            }
            dArray2[n] = d2;
        }
        dArray3[0] = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n][n];
        }
    }

    private static void reduceSymmetric2_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        int n5 = dArray2.length;
        for (n4 = n5 - 1; n4 > 0; --n4) {
            n3 = n4 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n3 > 0) {
                for (n2 = 0; n2 <= n3; ++n2) {
                    d2 += Math.abs(dArray[n4][n2]);
                }
                if (d2 == 0.0) {
                    dArray3[n4] = dArray[n4][n3];
                } else {
                    for (n2 = 0; n2 <= n3; ++n2) {
                        double[] dArray4 = dArray[n4];
                        int n6 = n2;
                        dArray4[n6] = dArray4[n6] / d2;
                        d3 += dArray[n4][n2] * dArray[n4][n2];
                    }
                    double d4 = dArray[n4][n3];
                    d = d4 >= 0.0 ? -Math.sqrt(d3) : Math.sqrt(d3);
                    dArray3[n4] = d2 * d;
                    d3 -= d4 * d;
                    dArray[n4][n3] = d4 - d;
                    d4 = 0.0;
                    for (n = 0; n <= n3; ++n) {
                        dArray[n][n4] = dArray[n4][n] / d3;
                        d = 0.0;
                        for (n2 = 0; n2 <= n; ++n2) {
                            d += dArray[n][n2] * dArray[n4][n2];
                        }
                        for (n2 = n + 1; n2 <= n3; ++n2) {
                            d += dArray[n2][n] * dArray[n4][n2];
                        }
                        dArray3[n] = d / d3;
                        d4 += dArray3[n] * dArray[n4][n];
                    }
                    double d5 = d4 / (d3 + d3);
                    for (n = 0; n <= n3; ++n) {
                        d4 = dArray[n4][n];
                        dArray3[n] = d = dArray3[n] - d5 * d4;
                        for (n2 = 0; n2 <= n; ++n2) {
                            double[] dArray5 = dArray[n];
                            int n7 = n2;
                            dArray5[n7] = dArray5[n7] - (d4 * dArray3[n2] + d * dArray[n4][n2]);
                        }
                    }
                }
            } else {
                dArray3[n4] = dArray[n4][n3];
            }
            dArray2[n4] = d3;
        }
        dArray3[0] = 0.0;
        dArray2[0] = 0.0;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n4 - 1;
            if (dArray2[n4] != 0.0) {
                for (n = 0; n <= n3; ++n) {
                    d = 0.0;
                    for (n2 = 0; n2 <= n3; ++n2) {
                        d += dArray[n4][n2] * dArray[n2][n];
                    }
                    for (n2 = 0; n2 <= n3; ++n2) {
                        double[] dArray6 = dArray[n2];
                        int n8 = n;
                        dArray6[n8] = dArray6[n8] - d * dArray[n2][n4];
                    }
                }
            }
            dArray2[n4] = dArray[n4][n4];
            dArray[n4][n4] = 1.0;
            for (n = 0; n <= n3; ++n) {
                dArray[n4][n] = 0.0;
                dArray[n][n4] = 0.0;
            }
        }
    }

    public static DoubleVector solve(DoubleSquareMatrix[] doubleSquareMatrixArray, DoubleVector doubleVector) {
        int n;
        double d;
        int n2;
        int n3 = doubleVector.dimension();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            d = doubleVector.getComponent(n2);
            for (n = 0; n < n2; ++n) {
                d -= doubleSquareMatrixArray[0].getElement(n2, n) * dArray[n];
            }
            dArray[n2] = d / doubleSquareMatrixArray[0].getElement(n2, n2);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= doubleSquareMatrixArray[1].getElement(n2, n) * dArray2[n];
            }
            dArray2[n2] = d / doubleSquareMatrixArray[1].getElement(n2, n2);
        }
        return new DoubleVector(dArray2);
    }

    public static DoubleVector solveGMRes(DoubleMatrix doubleMatrix, DoubleVector doubleVector, int n, double d) {
        double d2;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of allowed iterations must be a positive integer: " + n + " <= 0.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive or zero: " + d + " < 0.");
        }
        int n2 = doubleMatrix.rows();
        int n3 = 1;
        double[] dArray = new double[n2 + 1];
        double[][] dArray2 = new double[n2 + 1][2];
        double[] dArray3 = new double[2];
        DoubleVector doubleVector2 = new DoubleVector(doubleMatrix.rows());
        double d3 = doubleVector.norm();
        DoubleVector doubleVector3 = doubleVector.subtract(doubleMatrix.multiply(doubleVector2));
        double d4 = doubleVector3.norm();
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d5 = doubleVector3.norm() / d3;
        if (d2 <= d) {
            d = d5;
            n = 0;
            throw new IllegalArgumentException("There is a bug.");
        }
        DoubleVector[] doubleVectorArray = new DoubleVector[n2 + 1];
        DoubleMatrix doubleMatrix2 = new DoubleMatrix(n2 + 1, n2);
        while (n3 <= n) {
            double d6;
            int n4;
            doubleVectorArray[0] = doubleVector3.scalarMultiply(1.0 / d4);
            for (n4 = 0; n4 < n2 + 1; ++n4) {
                dArray[n4] = 0.0;
            }
            dArray[0] = d4;
            for (n4 = 0; n4 < n2 && n3 <= n; ++n4, ++n3) {
                double d7;
                int n5;
                DoubleVector doubleVector4 = doubleMatrix.multiply(doubleVectorArray[n4]);
                for (n5 = 0; n5 <= n4; ++n5) {
                    doubleMatrix2.matrix[n5][n4] = doubleVector4.scalarProduct(doubleVectorArray[n5]);
                    doubleVector4 = doubleVector4.subtract(doubleVectorArray[n5].scalarMultiply(doubleMatrix2.matrix[n5][n4]));
                }
                doubleMatrix2.matrix[n4 + 1][n4] = doubleVector4.norm();
                doubleVectorArray[n4 + 1] = doubleVector4.scalarMultiply(1.0 / doubleMatrix2.matrix[n4 + 1][n4]);
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray3 = LinearMath.applyPlaneRotation(doubleMatrix2.matrix[n5][n4], doubleMatrix2.matrix[n5 + 1][n4], dArray2[n5][0], dArray2[n5][1]);
                    doubleMatrix2.matrix[n5][n4] = dArray3[0];
                    doubleMatrix2.matrix[n5 + 1][n4] = dArray3[1];
                }
                dArray2[n4] = LinearMath.generatePlaneRotation(doubleMatrix2.matrix[n4][n4], doubleMatrix2.matrix[n4 + 1][n4]);
                dArray3 = LinearMath.applyPlaneRotation(doubleMatrix2.matrix[n4][n4], doubleMatrix2.matrix[n4 + 1][n4], dArray2[n4][0], dArray2[n4][1]);
                doubleMatrix2.matrix[n4][n4] = dArray3[0];
                doubleMatrix2.matrix[n4 + 1][n4] = dArray3[1];
                dArray3 = LinearMath.applyPlaneRotation(dArray[n4], dArray[n4 + 1], dArray2[n4][0], dArray2[n4][1]);
                dArray[n4] = dArray3[0];
                dArray[n4 + 1] = dArray3[1];
                d5 = Math.abs(dArray[n4 + 1]) / d3;
                if (!(d7 < d)) continue;
                doubleVector2 = LinearMath.update(doubleVector2, n4, doubleMatrix2, dArray, doubleVectorArray);
                d = d5;
                n = n3;
                return doubleVector2;
            }
            doubleVector2 = LinearMath.update(doubleVector2, n2 - 1, doubleMatrix2, dArray, doubleVectorArray);
            doubleVector3 = doubleVector.subtract(doubleMatrix.multiply(doubleVector2));
            d4 = doubleVector3.norm();
            d5 = d4 / d3;
            if (!(d6 < d)) continue;
            d = d5;
            n = n3;
            return doubleVector2;
        }
        d = d5;
        throw new MaximumIterationsExceededException("(tol) " + d + ". It doesn't converge in " + n + "iterations. Try raising the number of allowed iterations or raising the tolerance.");
    }

    private static DoubleVector update(DoubleVector doubleVector, int n, DoubleMatrix doubleMatrix, double[] dArray, DoubleVector[] doubleVectorArray) {
        int n2;
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        for (n2 = n; n2 >= 0; --n2) {
            doubleVector2.vector[n2] = doubleVector2.vector[n2] / doubleMatrix.matrix[n2][n2];
            for (int i = n2 - 1; i >= 0; --i) {
                doubleVector2.vector[i] = doubleVector2.vector[i] - doubleMatrix.matrix[i][n2] * doubleVector2.vector[n2];
            }
        }
        for (n2 = 0; n2 <= n; ++n2) {
            doubleVector = doubleVector.add(doubleVectorArray[n2].scalarMultiply(doubleVector2.vector[n2]));
        }
        return doubleVector;
    }
}

