/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.loadable.ApplyHeader;
import com.hartmath.mapping.E1Arg;
import java.util.Hashtable;

public class EMMLContent
extends E1Arg {
    public static Hashtable CV = new Hashtable(997);

    public static void convert(StringBuffer stringBuffer, HObject hObject) {
        int n = hObject.hierarchy();
        switch (n) {
            case 1: {
                EMMLContent.convertDouble(stringBuffer, (HDouble)hObject);
                break;
            }
            case 2: {
                EMMLContent.convertDoubleComplex(stringBuffer, (HDoubleComplex)hObject);
                break;
            }
            case 4: {
                EMMLContent.convertInteger(stringBuffer, (HInteger)hObject);
                break;
            }
            case 8: {
                EMMLContent.convertFraction(stringBuffer, (HFraction)hObject);
                break;
            }
            case 16: {
                EMMLContent.convertComplex(stringBuffer, (HComplex)hObject);
                break;
            }
            case 32: {
                EMMLContent.convertString(stringBuffer, (HString)hObject);
                break;
            }
            case 64: {
                EMMLContent.convertSymbol(stringBuffer, (HSymbol)hObject);
                break;
            }
            case 256: {
                EMMLContent.convertPattern(stringBuffer, (HPattern)hObject);
                break;
            }
            case 128: {
                HFunction hFunction = (HFunction)hObject;
                if (hFunction.head().equals(C.List)) {
                    stringBuffer.append(" <set>\n");
                    for (int i = 0; i < hFunction.size(); ++i) {
                        EMMLContent.convert(stringBuffer, hFunction.get(i));
                    }
                    stringBuffer.append(" </set>\n");
                    break;
                }
                ApplyHeader.convertFunction(stringBuffer, hFunction);
                break;
            }
            default: {
                stringBuffer.append(hObject.toString());
            }
        }
    }

    public static void convertComplex(StringBuffer stringBuffer, HComplex hComplex) {
        stringBuffer.append("  <cn type=\"complex\">");
        stringBuffer.append(hComplex.re().toString());
        stringBuffer.append("<sep/>");
        stringBuffer.append(hComplex.im().toString());
        stringBuffer.append("</cn>\n");
    }

    public static void convertDouble(StringBuffer stringBuffer, HDouble hDouble) {
        stringBuffer.append("  <cn>");
        stringBuffer.append(hDouble.toString());
        stringBuffer.append("</cn>\n");
    }

    public static void convertDoubleComplex(StringBuffer stringBuffer, HDoubleComplex hDoubleComplex) {
        stringBuffer.append("  <cn type=\"complex-cartesian\">");
        stringBuffer.append(String.valueOf(hDoubleComplex.real()));
        stringBuffer.append("<sep/>");
        stringBuffer.append(String.valueOf(hDoubleComplex.imag()));
        stringBuffer.append("</cn>\n");
    }

    public static void convertFraction(StringBuffer stringBuffer, HFraction hFraction) {
        stringBuffer.append("  <cn type=\"rational\">");
        stringBuffer.append(hFraction.numer().toString());
        stringBuffer.append("<sep/>");
        stringBuffer.append(hFraction.denom().toString());
        stringBuffer.append("</cn>\n");
    }

    public static void convertInteger(StringBuffer stringBuffer, HInteger hInteger) {
        stringBuffer.append("  <cn type=\"integer\">");
        stringBuffer.append(hInteger.toString());
        stringBuffer.append("</cn>\n");
    }

    public static void convertPattern(StringBuffer stringBuffer, HPattern hPattern) {
        stringBuffer.append("  <ci>");
        stringBuffer.append(hPattern.toString());
        stringBuffer.append("</ci>\n");
    }

    public static void convertString(StringBuffer stringBuffer, HString hString) {
        stringBuffer.append("  <ci>");
        stringBuffer.append(hString.toString());
        stringBuffer.append("</ci>\n");
    }

    public static void convertSymbol(StringBuffer stringBuffer, HSymbol hSymbol) {
        stringBuffer.append("  <ci>");
        stringBuffer.append(hSymbol.toString());
        stringBuffer.append("</ci>\n");
    }

    public HObject e1ObjArg(HObject hObject) {
        StringBuffer stringBuffer = new StringBuffer("<math>\n");
        EMMLContent.convert(stringBuffer, hObject);
        stringBuffer.append("</math>\n");
        return new HString(stringBuffer);
    }
}

