/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.initial;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HNumber;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSignedNumber;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import com.hartmath.mapping.E2Arg;
import com.hartmath.mapping.FunctionOpEvaluator;

class EPow
extends E2Arg
implements FunctionOpEvaluator {
    EPow() {
    }

    public HObject e2DblArg(HDouble hDouble, HDouble hDouble2) {
        HDouble hDouble3 = hDouble.pow(hDouble2);
        if (hDouble3.isNaN()) {
            return new HDoubleComplex(hDouble.doubleValue()).pow(new HDoubleComplex(hDouble2));
        }
        return hDouble3;
    }

    public HObject e2DblComArg(HDoubleComplex hDoubleComplex, HDoubleComplex hDoubleComplex2) {
        return hDoubleComplex.pow(hDoubleComplex2);
    }

    public HObject e2FraArg(HFraction hFraction, HFraction hFraction2) {
        if (hFraction.numer().equals(C.C0)) {
            return C.C0;
        }
        if (hFraction2.numer().equals(C.C0)) {
            return C.C1;
        }
        if (hFraction.denom().equals(C.C1) && hFraction2.numer().equals(C.C1)) {
            HInteger hInteger;
            boolean bl = false;
            HInteger hInteger2 = hFraction.numer();
            HInteger hInteger3 = hFraction2.denom();
            if (hInteger3.isNegative()) {
                return null;
            }
            int n = hInteger3.intValue();
            if (hInteger2.isNegative()) {
                if (hInteger3.isEven()) {
                    HInteger hInteger4 = (hInteger2 = hInteger2.negate()).root(n);
                    if (hInteger4.pow(n).equals(hInteger2) && n % 4 != 0) {
                        return C.EV(C.Multiply.f(C.CI, hInteger4));
                    }
                    return null;
                }
                bl = true;
                hInteger2 = hInteger2.negate();
            }
            if ((hInteger = hInteger2.root(n)).pow(n).equals(hInteger2)) {
                if (bl) {
                    return hInteger.negate();
                }
                return hInteger;
            }
            return null;
        }
        if (hFraction2.denom().unequals(C.C1)) {
            return null;
        }
        return hFraction.pow(hFraction2.numer().intValue());
    }

    public HObject e2IntArg(HInteger hInteger, HInteger hInteger2) {
        if (hInteger.equals(C.C0)) {
            return null;
        }
        if (hInteger2.less(C.C0)) {
            return new HFraction(C.C1, hInteger.pow(hInteger2.negate().intValue()));
        }
        return hInteger.pow(hInteger2.intValue());
    }

    public HObject e2ObjArg(HObject hObject, HObject hObject2) {
        HFunction hFunction;
        if (SessionData.getCurrentNumericFlag()) {
            if (hObject.equals(C.CD0)) {
                if (hObject2.equals(C.CD0)) {
                    throw new HThrowException(C.UndefinedError, C.Pow, new HString("0^0"));
                }
                if (hObject2 instanceof HSignedNumber && ((HSignedNumber)((Object)hObject2)).isNegative()) {
                    throw new HThrowException(C.ArithmeticError, C.Pow, new HString("division by zero"));
                }
                return C.CD0;
            }
            if (hObject2.equals(C.CD0)) {
                return C.CD1;
            }
            if (hObject2.equals(C.CD1)) {
                return hObject;
            }
            if (hObject.equals(C.CD1)) {
                return C.CD1;
            }
        }
        if (hObject.equals(C.C0)) {
            if (hObject2.equals(C.C0)) {
                throw new HThrowException(C.UndefinedError, C.Pow, new HString("0^0"));
            }
            if (hObject2 instanceof HSignedNumber && ((HSignedNumber)((Object)hObject2)).isNegative()) {
                throw new HThrowException(C.ArithmeticError, C.Pow, new HString("division by zero"));
            }
            return C.C0;
        }
        if (hObject2.equals(C.C0)) {
            return C.C1;
        }
        if (hObject2.equals(C.C1)) {
            return hObject;
        }
        if (hObject.equals(C.C1)) {
            return C.C1;
        }
        if (hObject2.isNumber() && hObject.head().equals(C.Pow) && (hFunction = (HFunction)hObject).size() == 2 && hFunction.get(1).isNumber()) {
            return C.Pow.f(hFunction.get(0), C.Multiply.f(hFunction.get(1), hObject2));
        }
        if (hObject.head().equals(C.Multiply) && hObject2.isNumber() && (hFunction = (HFunction)hObject).size() > 0 && hFunction.get(0).isNumber()) {
            SessionData sessionData = SessionData.currentThreadSession();
            if (((HNumber)((Object)hFunction.get(0))).compSignum() != -1) {
                return C.Multiply.f(C.Pow.f(hFunction.get(0), hObject2), C.Pow.f(new HFunction(hFunction, C.Multiply, 1, hFunction.size(), true), hObject2));
            }
            if (hObject2 instanceof HFraction) {
                if (new Double(((HFraction)hObject2).denom().intValue()) / 2.0 != (double)Math.round(new Double(((HFraction)hObject2).denom().intValue()) / 2.0)) {
                    return C.Multiply.f(C.Pow.f(hFunction.get(0), hObject2), C.Pow.f(new HFunction(hFunction, C.Multiply, 1, hFunction.size(), true), hObject2));
                }
            } else if (!(hObject2 instanceof HDouble)) {
                return C.Multiply.f(C.Pow.f(hFunction.get(0), hObject2), C.Pow.f(new HFunction(hFunction, C.Multiply, 1, hFunction.size(), true), hObject2));
            }
        }
        return null;
    }

    public HObject eComIntArg(HComplex hComplex, HInteger hInteger) {
        if (hComplex.isZero()) {
            return C.C0;
        }
        if (hInteger.isZero()) {
            return C.C1;
        }
        return hComplex.pow(hInteger.intValue());
    }

    public int precedence() {
        return 500;
    }

    public String toOpString(HFunction hFunction) {
        StringBuffer stringBuffer;
        block7: {
            block8: {
                HObject hObject;
                block10: {
                    block9: {
                        stringBuffer = new StringBuffer();
                        if (hFunction.size() <= 0) break block7;
                        if (hFunction.size() != 2 || !hFunction.get(1).equals(C.CN1) && !hFunction.get(1).equals(C.C1D2) && !hFunction.get(1).equals(C.CN1D2)) break block8;
                        hObject = hFunction.get(0);
                        if (!hFunction.get(1).equals(C.C1D2)) break block9;
                        stringBuffer.append("Sqrt(");
                        stringBuffer.append(hObject.toString());
                        stringBuffer.append(")");
                        break block7;
                    }
                    stringBuffer.append("1/");
                    if (!hFunction.get(1).equals(C.CN1D2)) break block10;
                    stringBuffer.append("Sqrt(");
                    stringBuffer.append(hObject.toString());
                    stringBuffer.append(")");
                    break block7;
                }
                if (hObject.precedence() < 450) {
                    stringBuffer.append('(');
                }
                stringBuffer.append(hObject.toString());
                if (hObject.precedence() >= 450) break block7;
                stringBuffer.append(')');
                break block7;
            }
            HObject hObject = hFunction.get(0);
            if (hObject.precedence() < 500) {
                stringBuffer.append('(');
            }
            stringBuffer.append(hObject.toString());
            if (hObject.precedence() < 500) {
                stringBuffer.append(')');
            }
            if (hFunction.size() > 1) {
                stringBuffer.append('^');
            }
            for (int i = 1; i < hFunction.size(); ++i) {
                hObject = hFunction.get(i);
                if (hObject.precedence() <= 500 | hObject instanceof HFraction) {
                    stringBuffer.append('(');
                }
                stringBuffer.append(hObject.toString());
                if (hObject.precedence() <= 500 | hObject instanceof HFraction) {
                    stringBuffer.append(')');
                }
                if (i == hFunction.size() - 1) continue;
                stringBuffer.append('^');
            }
        }
        return stringBuffer.toString();
    }
}

