/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbolData;
import com.hartmath.lib.C;
import com.hartmath.lib.ELoadClass;
import com.hartmath.lib.SessionData;
import com.hartmath.mapping.ConstantEvaluator;
import com.hartmath.mapping.ConstantNumericEvaluator;
import com.hartmath.mapping.EGeonextArg;
import com.hartmath.mapping.FunctionEvaluator;
import com.hartmath.mapping.FunctionOpEvaluator;
import com.hartmath.patternmatching.HRuleSet;
import org.kaffe.java.util.HashMap;

public class HSymbol
extends HString {
    public static int maxItems = 0;
    public static String[] choiceItems = new String[1000];
    public static HashMap HT = new HashMap();
    private HRuleSet rSet;
    public static final int NOATTRIBUTE = 0;
    public static final int ONEIDENTITY = 1;
    public static final int CONSTANT = 2;
    public static final int ORDERLESS = 4;
    public static final int FLAT = 8;
    public static final int HOLDALL = 16;
    public static final int HOLDFIRST = 32;
    public static final int HOLDREST = 64;
    public static final int LISTABLE = 128;
    public static final int BUILTINFIRST = 256;
    public static final int FASTCALL = 512;
    public static final int NUMERICFUNCTION = 1024;
    public static final int FLATORDERLESS = 12;
    public static final int OPERATOR = 4096;
    protected FunctionEvaluator functionEval;
    HSymbolData data;
    int hCode;
    boolean reload = false;

    public HSymbol(char[] cArray) {
        super(cArray);
        this.hCode = this.computeHashCode();
        this.functionEval = C.dummyFunction;
        this.init();
    }

    public HSymbol(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
        this.hCode = this.computeHashCode();
        this.functionEval = C.dummyFunction;
        this.init();
    }

    public HSymbol(String string) {
        super(string);
        this.hCode = this.computeHashCode();
        this.functionEval = C.dummyFunction;
        this.init();
    }

    public HSymbol(String string, int n) {
        super(string);
        this.hCode = this.computeHashCode();
        this.functionEval = C.dummyFunction;
        this.init();
        this.data.setAttributes(n);
    }

    public HSymbol(String string, FunctionEvaluator functionEvaluator) {
        super(string);
        this.hCode = this.computeHashCode();
        this.functionEval = functionEvaluator;
        this.init();
        HSymbol.choiceItems[HSymbol.maxItems++] = string;
    }

    public HSymbol(String string, FunctionEvaluator functionEvaluator, int n) {
        super(string);
        this.hCode = this.computeHashCode();
        this.functionEval = functionEvaluator;
        this.init();
        this.data.setAttributes(n);
        HSymbol.choiceItems[HSymbol.maxItems++] = string;
    }

    public HSymbol(String string, FunctionEvaluator functionEvaluator, int n, boolean bl) {
        super(string);
        this.reload = bl;
        this.hCode = this.computeHashCode();
        this.functionEval = functionEvaluator;
        this.init();
        this.data.setAttributes(n);
        HSymbol.choiceItems[HSymbol.maxItems++] = string;
    }

    public HSymbol(StringBuffer stringBuffer) {
        super(stringBuffer);
        this.hCode = this.computeHashCode();
        this.functionEval = C.dummyFunction;
        this.init();
    }

    public HSymbol(StringBuffer stringBuffer, FunctionEvaluator functionEvaluator) {
        super(stringBuffer);
        this.hCode = this.computeHashCode();
        this.functionEval = functionEvaluator;
        this.init();
    }

    public final HSymbol addSymbol() {
        HSymbol hSymbol = (HSymbol)HT.put(this, this);
        if (hSymbol == null) {
            return this;
        }
        HT.put(hSymbol, hSymbol);
        return hSymbol;
    }

    public HFunction body(HArrayList hArrayList) {
        return new HFunction(this, hArrayList);
    }

    public final boolean checkAttributes(int n) {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData == null) {
            return this.data.checkAttributes(n);
        }
        HSymbolData hSymbolData = sessionData.getSymbolData(this);
        if (hSymbolData == null) {
            return this.data.checkAttributes(n);
        }
        return hSymbolData.checkAttributes(n);
    }

    public void clear() {
        if (this.rSet != null) {
            this.rSet.clear();
        }
    }

    public final void clearAttributes(int n) {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData == null) {
            this.data.clearAttributes(n);
            return;
        }
        HSymbolData hSymbolData = sessionData.createSymbolData(this);
        hSymbolData.clearAttributes(n);
    }

    public void clearSymbolRule(HSymbol hSymbol) {
        if (this.rSet != null) {
            this.rSet.clearSymbolRule(hSymbol);
        }
    }

    public int compareTo(HSymbol hSymbol) {
        int n = this.hCode - hSymbol.hCode;
        if (n != 0) {
            return n;
        }
        return this.str.compareTo(hSymbol.str);
    }

    public int computeHashCode() {
        int n = 0;
        int n2 = this.str.length();
        if (n2 > 4) {
            for (int i = 0; i < 5; ++i) {
                char c = this.str.charAt(i);
                n = c >= '0' && c <= '9' ? (n << 5) + (c - 47) : (c >= 'A' && c <= 'Z' ? (n << 5) + (c - 54) : (c == '$' ? (n << 5) + 63 : (n << 5) + (c - 60)));
            }
        } else {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                char c = this.str.charAt(n3);
                n = c >= '0' && c <= '9' ? (n << 5) + (c - 47) : (c >= 'A' && c <= 'Z' ? (n << 5) + (c - 54) : (c == '$' ? (n << 5) + 63 : (n << 5) + (c - 60)));
            }
            for (n3 = 0; n3 < 5 - n2; ++n3) {
                n <<= 5;
            }
        }
        return n;
    }

    public final void createLocalVar(HObject hObject) {
        SessionData.createLocalVar(this, hObject);
    }

    public final HObject deleteLocalVar() {
        return SessionData.deleteLocalVar(this);
    }

    public boolean equals(Object object) {
        if (object instanceof HSymbol) {
            if (this.hCode != ((HSymbol)object).hCode) {
                return false;
            }
            if (this == object) {
                return true;
            }
            return this.str.equals(((HSymbol)object).str);
        }
        return false;
    }

    public HObject evaluate() {
        HObject hObject;
        if (!this.hasNoLocalVar()) {
            HObject hObject2 = this.getLocalVarValue();
            if (hObject2 == null || this.equals(hObject2)) {
                return null;
            }
            return hObject2;
        }
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData != null && (hObject = sessionData.getDownRule(this, this)) != null) {
            return hObject;
        }
        hObject = this.getDownRule(this);
        if (hObject != null) {
            return hObject;
        }
        if (this.functionEval instanceof ConstantNumericEvaluator) {
            if (SessionData.getCurrentNumericFlag()) {
                return ((ConstantNumericEvaluator)this.functionEval).getNumericValue();
            }
            if (this.functionEval instanceof ConstantEvaluator) {
                return ((ConstantEvaluator)this.functionEval).getSymbolicValue();
            }
        }
        return null;
    }

    public HObject evaluateFunction(HFunction hFunction) {
        int n;
        HObject hObject;
        HArrayList hArrayList;
        int n2;
        HObject hObject2 = null;
        SessionData sessionData = SessionData.currentThreadSession();
        if (this.reload && sessionData.getRuleSet(this) == null) {
            n2 = sessionData.isSymbolicFlag();
            boolean bl = sessionData.getNumericFlag();
            this.functionEval = C.loadClass;
            this.functionEval.evaluate(hFunction);
            sessionData.setSymbolicFlag(n2 != 0);
            sessionData.setNumericFlag(true);
        }
        if (this.data.checkAttributes(512)) {
            return this.functionEval.evaluate(hFunction);
        }
        hObject2 = C.ELoop(this);
        if (hObject2 != null) {
            return hFunction.apply(hObject2);
        }
        n2 = hFunction.size();
        hObject2 = hFunction.evaluateArgAttr();
        if (hObject2 != null) {
            return hObject2;
        }
        if (this.data.checkAttributes(256) && (hObject2 = this.functionEval.evaluate(hFunction)) != null) {
            return hObject2;
        }
        if (sessionData != null) {
            if (n2 > 0) {
                if (!this.data.checkAttributes(8)) {
                    HObject hObject3 = hFunction.get(0);
                    hObject2 = hObject3 instanceof HSymbol ? sessionData.getUpRule((HSymbol)hObject3, hFunction) : sessionData.getUpRule(hObject3.head(), hFunction);
                    if (hObject2 != null) {
                        return hObject2;
                    }
                } else {
                    hArrayList = new HArrayList();
                    HObject hObject4 = hFunction.get(0);
                    if (hObject4 instanceof HSymbol) {
                        hObject = hObject4;
                        if (!sessionData.isEmptyUpRule((HSymbol)hObject)) {
                            hArrayList.add(hObject);
                        }
                    } else {
                        hObject = hObject4.head();
                        if (!sessionData.isEmptyUpRule((HSymbol)hObject)) {
                            hArrayList.add(hObject);
                        }
                    }
                    for (n = 1; n < n2; ++n) {
                        hObject4 = hFunction.get(n);
                        if (hObject4 instanceof HSymbol) {
                            if (hObject4 == hObject || sessionData.isEmptyUpRule((HSymbol)(hObject = hObject4))) continue;
                            hArrayList.add(hObject);
                            continue;
                        }
                        if (hObject4.head() == hObject || sessionData.isEmptyUpRule((HSymbol)(hObject = hObject4.head()))) continue;
                        hArrayList.add(hObject);
                    }
                    hArrayList.sort();
                    if (hArrayList.size() > 0) {
                        hObject = hArrayList.get(0);
                        hObject2 = sessionData.getUpRule((HSymbol)hObject, hFunction);
                        if (hObject2 != null) {
                            return hObject2;
                        }
                        for (n = 1; n < hArrayList.size(); ++n) {
                            if (hArrayList.get(n).equals(hObject) || (hObject2 = sessionData.getUpRule((HSymbol)(hObject = hArrayList.get(n)), hFunction)) == null) continue;
                            return hObject2;
                        }
                    }
                }
            }
            if ((hObject2 = sessionData.getDownRule(this, hFunction)) != null) {
                return hObject2;
            }
        }
        if (n2 > 0) {
            if (!this.data.checkAttributes(8)) {
                HObject hObject5 = hFunction.get(0);
                hObject2 = hObject5 instanceof HSymbol ? ((HSymbol)hObject5).getUpRule(hFunction) : hObject5.head().getUpRule(hFunction);
                if (hObject2 != null) {
                    return hObject2;
                }
            } else {
                hArrayList = new HArrayList();
                HObject hObject6 = hFunction.get(0);
                if (hObject6 instanceof HSymbol) {
                    hObject = hObject6;
                    if (!((HSymbol)hObject).isEmptyUpRule()) {
                        hArrayList.add(hObject);
                    }
                } else {
                    hObject = hObject6.head();
                    if (!((HSymbol)hObject).isEmptyUpRule()) {
                        hArrayList.add(hObject);
                    }
                }
                for (n = 1; n < n2; ++n) {
                    hObject6 = hFunction.get(n);
                    if (hObject6 instanceof HSymbol) {
                        if (hObject6 == hObject || ((HSymbol)(hObject = hObject6)).isEmptyUpRule()) continue;
                        hArrayList.add(hObject);
                        continue;
                    }
                    if (hObject6.head() == hObject || ((HSymbol)(hObject = hObject6.head())).isEmptyUpRule()) continue;
                    hArrayList.add(hObject);
                }
                hArrayList.sort();
                if (hArrayList.size() > 0) {
                    hObject = hArrayList.get(0);
                    hObject2 = ((HSymbol)hObject).getUpRule(hFunction);
                    if (hObject2 != null) {
                        return hObject2;
                    }
                    for (n = 1; n < hArrayList.size(); ++n) {
                        if (hArrayList.get(n).equals(hObject) || (hObject2 = ((HSymbol)(hObject = hArrayList.get(n))).getUpRule(hFunction)) == null) continue;
                        return hObject2;
                    }
                }
            }
        }
        if ((hObject2 = this.getDownRule(hFunction)) != null) {
            return hObject2;
        }
        if (!this.data.checkAttributes(256)) {
            if (this.functionEval instanceof EGeonextArg) {
                sessionData.setGeoFunctionIncluded(true);
            }
            if ((hObject2 = this.functionEval.evaluate(hFunction)) == C.Null) {
                return null;
            }
            return hObject2;
        }
        return null;
    }

    public HFunction f() {
        return new HFunction(this);
    }

    public HFunction f(HObject hObject) {
        return new HFunction(this, hObject);
    }

    public HFunction f(HObject hObject, HObject hObject2) {
        return new HFunction(this, hObject, hObject2);
    }

    public HFunction f(HObject hObject, HObject hObject2, HObject hObject3) {
        return new HFunction(this, hObject, hObject2, hObject3);
    }

    public HFunction f(HObject hObject, HObject hObject2, HObject hObject3, HObject hObject4) {
        return new HFunction(this, hObject, hObject2, hObject3, hObject4);
    }

    public final int getAttributes() {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData == null) {
            return this.data.getAttributes();
        }
        HSymbolData hSymbolData = sessionData.getSymbolData(this);
        if (hSymbolData == null) {
            return this.data.getAttributes();
        }
        return hSymbolData.getAttributes();
    }

    public String getDefinition() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData != null && (object = sessionData.getSymbolData(this)) != null) {
            n = ((HSymbolData)object).getAttributes();
            stringBuffer.append("  // *** Session Attributes:\n");
            this.showAttributes(n, stringBuffer);
        }
        n = this.data.getAttributes();
        stringBuffer.append("  // *** System Attributes:\n");
        this.showAttributes(n, stringBuffer);
        if (sessionData != null && (object = sessionData.getRuleSet(this)) != null) {
            stringBuffer.append("  // *** Session Rules:\n");
            stringBuffer.append(((HRuleSet)object).getDefinition().toString());
        }
        if (this.rSet != null) {
            stringBuffer.append("  // *** System Rules:\n");
            return stringBuffer.toString() + this.rSet.getDefinition().toString();
        }
        return stringBuffer.toString();
    }

    public HObject getDownRule(HObject hObject) {
        return this.rSet == null ? null : this.rSet.getDownRule(hObject);
    }

    public FunctionEvaluator getEval() {
        return this.functionEval;
    }

    public final HObject getLocalVarValue() {
        return SessionData.getLocalVarValue(this);
    }

    public HObject getUpRule(HObject hObject) {
        return this.rSet == null ? null : this.rSet.getUpRule(hObject);
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return this.hCode;
    }

    public boolean hasNoLocalVar() {
        return SessionData.hasNoLocalVar(this);
    }

    public HSymbol head() {
        return C.Symbol;
    }

    public final int hierarchy() {
        return 64;
    }

    private void init() {
        this.data = new HSymbolData();
    }

    public boolean isEmptyUpRule() {
        return this.rSet == null ? true : this.rSet.isEmptyUpRule();
    }

    public boolean less(Object object) {
        if (object instanceof HSymbol) {
            if (this.hCode < ((HSymbol)object).hCode) {
                return true;
            }
            if (this.hCode > ((HSymbol)object).hCode) {
                return false;
            }
            return this.str.compareTo(((HSymbol)object).str) < 0;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public int precedence() {
        if (this.functionEval instanceof FunctionOpEvaluator) {
            return ((FunctionOpEvaluator)this.functionEval).precedence();
        }
        return 999999;
    }

    public void putDownRule(int n, HObject hObject, HObject hObject2) {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData != null) {
            sessionData.putDownRule(this, n, hObject, hObject2);
            return;
        }
        if (this.rSet == null) {
            this.rSet = new HRuleSet(this);
        }
        this.rSet.putDownRule(n, hObject, hObject2);
    }

    public boolean putSymbol() {
        if (HT.containsKey(this)) {
            HT.put(this, this);
            try {
                SessionData.appendCurrentErrorOut("Warning: Symbol " + this.toString() + " replaces old symbol in hashtable\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        HT.put(this, this);
        return true;
    }

    public void putUpRule(int n, HObject hObject, HObject hObject2) {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData != null) {
            sessionData.putUpRule(this, n, hObject, hObject2);
            return;
        }
        if (this.rSet == null) {
            this.rSet = new HRuleSet(this);
        }
        this.rSet.putUpRule(n, hObject, hObject2);
    }

    public final void setAttributes(int n) {
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData == null) {
            this.data.setAttributes(n);
            return;
        }
        HSymbolData hSymbolData = sessionData.createSymbolData(this);
        hSymbolData.setAttributes(n);
    }

    public void setEval(FunctionEvaluator functionEvaluator) {
        this.functionEval = functionEvaluator;
        HSymbol.choiceItems[HSymbol.maxItems++] = this.toString();
    }

    public void setNewEval(FunctionEvaluator functionEvaluator) {
        this.functionEval = functionEvaluator;
    }

    public void setStr(String string) {
        this.str = string;
    }

    private void showAttributes(int n, StringBuffer stringBuffer) {
        stringBuffer.append("Attributes( ");
        if ((n & 2) == 2) {
            stringBuffer.append("Constant ");
        }
        if ((n & 0x200) == 512) {
            stringBuffer.append("FastCall ");
        }
        if ((n & 8) == 8) {
            stringBuffer.append("Flat ");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append("HoldAll ");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append("HoldFirst ");
        }
        if ((n & 0x40) == 64) {
            stringBuffer.append("HoldRest ");
        }
        if ((n & 0x80) == 128) {
            stringBuffer.append("Listable ");
        }
        if ((n & 1) == 1) {
            stringBuffer.append("OneIdentity ");
        }
        if ((n & 4) == 4) {
            stringBuffer.append("Orderless ");
        }
        stringBuffer.append(")\n");
    }

    public static void sortFunctions() {
        boolean bl = false;
        if (maxItems > 1) {
            int n;
            int n2 = 1;
            int n3 = n = maxItems - 1;
            do {
                String string;
                String string2;
                int n4;
                for (n4 = n; n4 >= n2; --n4) {
                    string2 = choiceItems[n4];
                    string = choiceItems[n4 - 1];
                    if (string2.compareTo(string) >= 0) continue;
                    bl = true;
                    HSymbol.choiceItems[n4 - 1] = string2;
                    HSymbol.choiceItems[n4] = string;
                    n3 = n4;
                }
                for (n4 = n2 = n3 + 1; n4 <= n; ++n4) {
                    string2 = choiceItems[n4];
                    string = choiceItems[n4 - 1];
                    if (string2.compareTo(string) >= 0) continue;
                    bl = true;
                    HSymbol.choiceItems[n4 - 1] = string2;
                    HSymbol.choiceItems[n4] = string;
                    n3 = n4;
                }
            } while (n2 <= (n = n3 - 1));
        }
    }

    public HObject substitutePattern() {
        if (!SessionData.hasNoLocalPattern(this)) {
            return SessionData.getLocalPatternValue(this);
        }
        return this;
    }

    public final String toOpString(HFunction hFunction) {
        if (this.functionEval instanceof ELoadClass) {
            ELoadClass.loadClass(this);
        }
        if (this.functionEval instanceof FunctionOpEvaluator) {
            return ((FunctionOpEvaluator)this.functionEval).toOpString(hFunction);
        }
        return "op to string failed";
    }

    public String toString() {
        return this.str;
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }
}

