/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.structures.Coordinates;

public class Tracker
extends ObjectConstructor
implements TrackPainter {
    ConstructionObject PM;
    int PMax = 8;
    int PN;
    ConstructionObject P;
    ConstructionObject[] PO = new ConstructionObject[this.PMax];
    Vector V = new Vector();
    Vector[] VO = new Vector[this.PMax];
    double X;
    double Y;
    double DX;
    double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    boolean Started;
    boolean[] StartedO = new boolean[this.PMax];
    boolean Other;

    public Tracker(ConstructionObject p, ConstructionObject[] po) {
        this.P = p;
        this.PN = 0;
        for (int i = 0; i < po.length && i < this.PMax && po[i] != null; ++i) {
            this.PO[this.PN] = po[i];
            this.VO[i] = new Vector();
            ++this.PN;
        }
    }

    public Tracker() {
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        if (this.P == null) {
            this.P = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P == null) {
                this.P = zc.selectLine(e2.getX(), e2.getY());
            }
            if (this.P == null) {
                return;
            }
            this.P.setSelected(true);
            zc.repaint();
            this.Other = e2.isShiftDown();
            this.showStatus(zc);
        } else if (this.Other) {
            ConstructionObject P = zc.selectPoint(e2.getX(), e2.getY());
            if (P == null) {
                P = zc.selectLine(e2.getX(), e2.getY());
            }
            if (P != null) {
                P.setSelected(true);
                zc.repaint();
                this.PO[this.PN] = P;
                this.VO[this.PN] = new Vector();
                ++this.PN;
            }
            if (!e2.isShiftDown() || this.PN >= this.PMax) {
                this.Other = false;
            }
            this.showStatus(zc);
        } else {
            ConstructionObject pm;
            this.PM = pm = zc.selectMoveableObject(e2.getX(), e2.getY());
            if (this.PM != null) {
                zc.clearSelected();
                this.PM.setSelected(true);
                ((MoveableObject)((Object)this.PM)).startDrag(x, y);
                zc.repaint();
                this.showStatus(zc);
            }
            this.Started = false;
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (this.P == null || this.Other) {
            zc.indicatePointsOrLines(e2.getX(), e2.getY());
        } else if (this.PM == null) {
            zc.indicateMoveableObjects(e2.getX(), e2.getY());
        } else {
            zc.clearIndicated();
        }
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (this.PM == null) {
            return;
        }
        ((MoveableObject)((Object)this.PM)).dragTo(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.validate();
        this.track(zc);
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (this.PM == null) {
            return;
        }
        this.PM.setSelected(false);
        this.PM = null;
        zc.repaint();
        this.showStatus(zc);
    }

    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        this.PM = null;
        this.P = null;
        this.PN = 0;
        this.V = new Vector();
        this.showStatus(zc);
        zc.repaint();
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null || this.Other) {
            zc.showStatus(Zirkel.name("message.tracker.select"));
        } else if (this.PM == null) {
            zc.showStatus(Zirkel.name("message.tracker.selectpoint"));
        } else {
            zc.showStatus(Zirkel.name("message.tracker.move"));
        }
    }

    public void track(ZirkelCanvas zc) {
        PrimitiveLineObject L2;
        if (this.P == null) {
            return;
        }
        if (this.P instanceof PointObject) {
            PointObject p = (PointObject)this.P;
            if (p.valid()) {
                this.V.addElement(new Coordinates(p.getX(), p.getY()));
            }
        } else if (this.P instanceof PrimitiveLineObject && (L2 = (PrimitiveLineObject)this.P).valid()) {
            if (!this.Started) {
                this.X = L2.getX();
                this.Y = L2.getY();
                this.DX = L2.getDX();
                this.DY = L2.getDY();
                this.Started = true;
            } else {
                double dy;
                double x = L2.getX();
                double y = L2.getY();
                double dx = L2.getDX();
                double det = dx * this.DY - (dy = L2.getDY()) * this.DX;
                if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                    double a2 = (-(this.X - x) * this.DY + this.DX * (this.Y - y)) / -det;
                    this.V.addElement(new Coordinates(x + a2 * dx, y + a2 * dy));
                }
                this.X = x;
                this.Y = y;
                this.DX = dx;
                this.DY = dy;
            }
        }
        for (int i = 0; i < this.PN; ++i) {
            double dy;
            if (this.PO[i] == null || !this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                PointObject p = (PointObject)this.PO[i];
                this.VO[i].addElement(new Coordinates(p.getX(), p.getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            PrimitiveLineObject L3 = (PrimitiveLineObject)this.PO[i];
            if (!this.StartedO[i]) {
                this.XO[i] = L3.getX();
                this.YO[i] = L3.getY();
                this.DXO[i] = L3.getDX();
                this.DYO[i] = L3.getDY();
                this.StartedO[i] = true;
                continue;
            }
            double x = L3.getX();
            double y = L3.getY();
            double dx = L3.getDX();
            double det = dx * this.DYO[i] - (dy = L3.getDY()) * this.DXO[i];
            if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                double a3 = (-(this.XO[i] - x) * this.DYO[i] + this.DXO[i] * (this.YO[i] - y)) / -det;
                this.VO[i].addElement(new Coordinates(x + a3 * dx, y + a3 * dy));
            }
            this.XO[i] = x;
            this.YO[i] = y;
            this.DXO[i] = dx;
            this.DYO[i] = dy;
        }
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double r;
        double c2;
        double r0;
        double c0;
        Coordinates C;
        if (this.P == null) {
            return;
        }
        Enumeration e2 = this.V.elements();
        g.setColor(this.P);
        int maxd = zc.width() / 20;
        if (e2.hasMoreElements()) {
            C = (Coordinates)e2.nextElement();
            c0 = zc.col(C.X);
            r0 = zc.row(C.Y);
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c2 = zc.col(C.X);
                r = zc.row(C.Y);
                if (Math.abs(c0 - c2) < (double)maxd && Math.abs(r0 - r) < (double)maxd) {
                    g.drawLine(c0, r0, c2, r, this.P);
                } else {
                    g.drawLine(c0, r0, c0, r0, this.P);
                }
                c0 = c2;
                r0 = r;
            }
        }
        for (int i = 0; i < this.PN; ++i) {
            if (this.PO[i] == null) continue;
            g.setColor(this.PO[i]);
            e2 = this.VO[i].elements();
            if (!e2.hasMoreElements()) continue;
            C = (Coordinates)e2.nextElement();
            c0 = zc.col(C.X);
            r0 = zc.row(C.Y);
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c2 = zc.col(C.X);
                r = zc.row(C.Y);
                if (Math.abs(c0 - c2) < (double)maxd && Math.abs(r0 - r) < (double)maxd) {
                    g.drawLine(c0, r0, c2, r, this.PO[i]);
                } else {
                    g.drawLine(c0, r0, c0, r0, this.PO[i]);
                }
                c0 = c2;
                r0 = r;
            }
        }
    }

    public void validate(ZirkelCanvas zc) {
    }

    public void save(XmlWriter xml) {
        if (this.P == null) {
            return;
        }
        xml.startTagStart("Track");
        xml.printArg("track", this.P.getName());
        for (int i = 0; i < this.PN; ++i) {
            xml.printArg("track" + i, this.PO[i].getName());
        }
        if (this.PM != null) {
            xml.printArg("move", this.PM.getName());
        }
        xml.finishTagNewLine();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

