/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import eric.JLocusTrackObject;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.QuadricObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.structures.Coordinates;

public class ObjectTracker
extends ObjectConstructor
implements TrackPainter,
Runnable,
Selector {
    public PointObject PM;
    public ConstructionObject O;
    public ConstructionObject P;
    public int PMax = 16;
    public int PN;
    public ConstructionObject[] PO = new ConstructionObject[this.PMax];
    Vector V = new Vector();
    Vector VPM = new Vector();
    Vector[] VO = new Vector[this.PMax];
    boolean Animate;
    boolean Paint;
    public boolean Interactive = true;
    boolean Other = false;
    public ZirkelCanvas ZC;
    boolean Running = false;
    boolean Stopped = false;
    double da = 0.0;
    double oldx;
    double oldy;
    double X;
    double Y;
    double DX;
    double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    int Omit = 1;
    public double StepSize = 5.0;

    public ObjectTracker() {
    }

    public ObjectTracker(ConstructionObject p, PointObject pm, ConstructionObject o, ZirkelCanvas zc, boolean animate, boolean paint, ConstructionObject[] po) {
        this.P = p;
        this.PM = pm;
        this.O = o;
        if (this.P != null && this.O != null && (this.PM != null || this.O instanceof ExpressionObject)) {
            this.Animate = animate;
            this.Paint = paint;
            if (this.PM != null) {
                this.PM.project(this.O);
            }
            zc.validate();
            zc.repaint();
            this.showStatus(zc);
            this.PN = 0;
            for (int i = 0; i < po.length && i < this.PMax && po[i] != null; ++i) {
                this.PO[this.PN] = po[i];
                this.VO[i] = new Vector();
                ++this.PN;
            }
        }
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        if (this.O == null) {
            if (o instanceof ExpressionObject && ((ExpressionObject)o).isSlider()) {
                return true;
            }
            if (o instanceof PrimitiveLineObject) {
                return true;
            }
            if (o instanceof PrimitiveCircleObject) {
                return true;
            }
            return o instanceof PointObject && ((PointObject)o).isPointOn();
        }
        if (!(o instanceof PointObject)) {
            return false;
        }
        if (!((MoveableObject)((Object)o)).moveable()) {
            return false;
        }
        if (this.O instanceof CircleObject && ((CircleObject)this.O).getP2() == o) {
            return true;
        }
        if (zc.depends(this.O, o)) {
            return false;
        }
        ConstructionObject bound = ((PointObject)o).getBound();
        return bound == null || bound == this.O;
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        if (this.P == null) {
            this.P = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P == null) {
                this.P = zc.selectLine(e2.getX(), e2.getY());
            }
            if (this.P != null) {
                this.P.setSelected(true);
                zc.repaint();
            }
            if (e2.isShiftDown()) {
                this.Other = true;
                this.PN = 0;
            } else {
                this.Other = false;
            }
            this.showStatus(zc);
        } else if (this.Other) {
            ConstructionObject P = zc.selectPoint(e2.getX(), e2.getY());
            if (P == null) {
                P = zc.selectLine(e2.getX(), e2.getY());
            }
            if (P != null) {
                P.setSelected(true);
                zc.repaint();
                this.PO[this.PN] = P;
                this.VO[this.PN] = new Vector();
                ++this.PN;
            }
            if (!e2.isShiftDown() || this.PN >= this.PMax) {
                this.Other = false;
            }
            this.showStatus(zc);
        } else if (this.O == null) {
            this.O = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (this.O instanceof ExpressionObject) {
                zc.clearSelected();
                zc.clearIndicated();
                this.Animate = !e2.isShiftDown();
                this.Paint = true;
                this.compute(zc);
                this.ZC = zc;
                if (this.Animate) {
                    zc.validate();
                }
                zc.repaint();
            } else if (this.O instanceof PointObject && ((PointObject)this.O).isPointOn()) {
                this.PM = (PointObject)this.O;
                this.O = this.PM.getBound();
                zc.clearSelected();
                zc.clearIndicated();
                this.Animate = !e2.isShiftDown();
                this.Paint = true;
                this.compute(zc);
                this.ZC = zc;
                if (this.Animate) {
                    zc.validate();
                }
                zc.repaint();
            } else {
                if (this.O != null) {
                    this.O.setSelected(true);
                    zc.repaint();
                }
                this.showStatus(zc);
            }
        } else if (this.PM == null && !(this.O instanceof ExpressionObject)) {
            ConstructionObject pm = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (pm == null) {
                return;
            }
            this.PM = (PointObject)pm;
            zc.clearSelected();
            zc.clearIndicated();
            this.Animate = !e2.isShiftDown();
            this.Paint = true;
            this.compute(zc);
            this.ZC = zc;
            if (this.Animate) {
                zc.validate();
            }
            zc.repaint();
        } else if (!(e2.isControlDown() || e2.isShiftDown() || e2.isAltDown())) {
            if (!this.Running && this.Interactive && this.PM != null && this.PM.nearto(e2.getX(), e2.getY(), zc)) {
                this.Dragging = true;
                zc.getConstruction().shouldSwitch(true);
            } else if (this.Animate) {
                if (this.Paint) {
                    this.Paint = false;
                } else {
                    this.Animate = false;
                    this.Paint = true;
                    if (this.Running) {
                        this.stop();
                    }
                    this.showStatus(zc);
                }
            } else {
                if (this.Running) {
                    return;
                }
                this.Paint = true;
                this.Animate = true;
                this.compute(zc);
                zc.validate();
                zc.repaint();
                this.showStatus(zc);
            }
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (this.PM != null) {
            return;
        }
        if (this.P == null || this.Other) {
            zc.indicatePointsOrLines(e2.getX(), e2.getY());
        } else if (this.O == null) {
            zc.indicateWithSelector(e2.getX(), e2.getY(), this);
        } else {
            zc.indicateWithSelector(e2.getX(), e2.getY(), this);
        }
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging || this.PM == null) {
            return;
        }
        double oldx = this.PM.getX();
        double oldy = this.PM.getY();
        this.PM.move(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.dovalidate();
        if (this.P.valid()) {
            zc.repaint();
        }
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging || this.PM == null) {
            return;
        }
        zc.getConstruction().shouldSwitch(false);
        this.Dragging = false;
        zc.validate();
    }

    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        if (this.Running) {
            this.stop();
        }
        this.PM = null;
        this.O = null;
        this.P = null;
        this.V = new Vector();
        this.PN = 0;
        for (int i = 0; i < this.PMax; ++i) {
            this.VO[i] = null;
        }
        zc.repaint();
        this.showStatus(zc);
        this.Omit = 1;
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null || this.Other) {
            zc.showStatus(Zirkel.name("message.objecttracker.select"));
        } else if (this.O == null) {
            zc.showStatus(Zirkel.name("message.objecttracker.object"));
        } else if (this.PM == null && !(this.O instanceof ExpressionObject)) {
            zc.showStatus(Zirkel.name("message.objecttracker.selectpoint"));
        } else if (this.Running) {
            zc.showStatus(Zirkel.name("message.objecttracker.stop"));
        } else {
            zc.showStatus(Zirkel.name("message.objecttracker.start"));
        }
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double r;
        double c2;
        double r0;
        double c0;
        Coordinates C;
        if (!this.isComplete()) {
            return;
        }
        if (this.P == null || !this.Paint) {
            return;
        }
        Enumeration e2 = this.V.elements();
        g.setColor(this.P);
        PolygonDrawer pd = new PolygonDrawer(g, this.P);
        if (e2.hasMoreElements()) {
            C = (Coordinates)e2.nextElement();
            c0 = zc.col(C.X);
            r0 = zc.row(C.Y);
            pd.startPolygon(c0, r0);
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c2 = zc.col(C.X);
                r = zc.row(C.Y);
                if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                    pd.drawTo(c2, r);
                } else {
                    pd.finishPolygon();
                }
                c0 = c2;
                r0 = r;
            }
            pd.finishPolygon();
        }
        for (int i = 0; i < this.PN; ++i) {
            e2 = this.VO[i].elements();
            g.setColor(this.PO[i]);
            pd = new PolygonDrawer(g, this.PO[i]);
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c0 = zc.col(C.X);
                r0 = zc.row(C.Y);
                pd.startPolygon(c0, r0);
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    c2 = zc.col(C.X);
                    r = zc.row(C.Y);
                    if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                        pd.drawTo(c2, r);
                    } else {
                        pd.finishPolygon();
                    }
                    c0 = c2;
                    r0 = r;
                }
            }
            pd.finishPolygon();
        }
    }

    public void validate(ZirkelCanvas zc) {
        if (!this.isComplete()) {
            return;
        }
        if (this.O instanceof ExpressionObject && !((ExpressionObject)this.O).isSlider()) {
            return;
        }
        if (this.Running) {
            return;
        }
        if (this.PM != null) {
            this.PM.project(this.O);
            this.oldx = this.PM.getX();
            this.oldy = this.PM.getY();
        } else if (this.O instanceof ExpressionObject) {
            this.oldx = ((ExpressionObject)this.O).getSliderPosition();
        }
        this.compute(zc);
        if (this.Animate) {
            this.ZC = zc;
            new Thread(this).start();
        } else {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            }
            zc.dovalidate();
            zc.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(ZirkelCanvas zc) {
        if (!this.isComplete()) {
            return;
        }
        zc.getConstruction().clearSwitches();
        zc.getConstruction().shouldSwitch(true);
        Enumeration e2 = this.VPM.elements();
        Enumeration ev = this.V.elements();
        long time = System.currentTimeMillis();
        int i = 0;
        boolean start = false;
        Graphics ZCG = this.ZC.getGraphics();
        while (e2.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e2.nextElement();
            Coordinates cv = (Coordinates)ev.nextElement();
            if (this.PM == null && !(this.O instanceof ExpressionObject)) break;
            ZirkelCanvas zirkelCanvas = zc;
            synchronized (zirkelCanvas) {
                if (this.PM != null) {
                    this.PM.move(c2.X, c2.Y);
                } else if (this.O instanceof ExpressionObject) {
                    ((ExpressionObject)this.O).setSliderPosition(c2.X);
                }
                if (!start) {
                    zc.resetSum();
                    start = true;
                }
            }
            zc.dovalidate();
            if (++i < this.Omit) continue;
            i = 0;
            if (zc.isInside(cv.X, cv.Y)) {
                if (this.P != null && this.P.valid()) {
                    this.ZC.paint(ZCG);
                }
                try {
                    long t = System.currentTimeMillis();
                    int h = (int)(t - time);
                    if (h < 0) {
                        h = 0;
                    }
                    if (h > 50) {
                        h = 50;
                    }
                    Thread.sleep(50 - h);
                    time = System.currentTimeMillis();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!this.Stopped) continue;
            break;
        }
        ZCG.dispose();
        zc.getConstruction().shouldSwitch(false);
        zc.getConstruction().clearSwitches();
    }

    public ConstructionObject getObject() {
        return this.O;
    }

    double mod(double x) {
        if (x >= Math.PI) {
            return x - Math.PI * 2;
        }
        if (x < -Math.PI) {
            return x + Math.PI * 2;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.O instanceof ExpressionObject && !((ExpressionObject)this.O).isSlider()) {
            return;
        }
        if (this.V.size() == 0) {
            return;
        }
        if (!this.Animate) {
            return;
        }
        this.Running = true;
        this.Stopped = false;
        this.showStatus(this.ZC);
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.ZC.I == null);
        do {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            } else if (this.O instanceof ExpressionObject) {
                ((ExpressionObject)this.O).setSliderPosition(this.oldx);
            }
            this.animate(this.ZC);
        } while (!this.Stopped);
        if (this.PM != null && !(this.O instanceof ExpressionObject)) {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            } else if (this.O instanceof ExpressionObject) {
                ((ExpressionObject)this.O).setSliderPosition(this.oldx);
            }
            this.ZC.getConstruction().switchBack();
            this.ZC.dovalidate();
            this.ZC.repaint();
        }
        ObjectTracker objectTracker = this;
        synchronized (objectTracker) {
            this.notify();
        }
        this.Running = false;
        this.showStatus(this.ZC);
    }

    public void invalidate(ZirkelCanvas zc) {
        this.stop();
    }

    public void stop() {
        if (!this.Running) {
            return;
        }
        this.Stopped = true;
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ZC.repaint();
        this.showStatus(this.ZC);
    }

    public void save(XmlWriter xml) {
        if (this.P == null || this.O == null || this.PM == null && !(this.O instanceof ExpressionObject)) {
            return;
        }
        xml.startTagStart("Track");
        xml.printArg("track", this.P.getName());
        for (int i = 0; i < this.PN; ++i) {
            xml.printArg("track" + i, this.PO[i].getName());
        }
        xml.printArg("on", this.O.getName());
        if (this.PM != null) {
            xml.printArg("move", this.PM.getName());
        }
        if (this.Animate && this.Paint) {
            xml.printArg("animate", "true");
        } else if (this.Animate && !this.Paint) {
            xml.printArg("animate", "nopaint");
        }
        if (this.Omit > 1) {
            xml.printArg("omit", "" + (this.Omit - 1));
        }
        xml.finishTagNewLine();
    }

    public void pause(boolean flag) {
        if (flag && this.Running) {
            this.stop();
        }
    }

    public synchronized void compute(ZirkelCanvas zc) {
        if (!this.isComplete()) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        if (this.PM != null) {
            x = this.PM.getX();
            y = this.PM.getY();
        } else if (this.O instanceof ExpressionObject) {
            x = ((ExpressionObject)this.O).getSliderPosition();
        }
        zc.getConstruction().clearSwitches();
        zc.getConstruction().shouldSwitch(true);
        this.docompute(zc);
        zc.getConstruction().shouldSwitch(false);
        zc.getConstruction().clearSwitches();
        if (this.PM != null) {
            this.PM.move(x, y);
        } else if (this.O instanceof ExpressionObject) {
            ((ExpressionObject)this.O).setSliderPosition(x);
        }
        zc.dovalidate();
    }

    public synchronized void docompute(ZirkelCanvas zc) {
        block80: {
            boolean Break;
            block81: {
                boolean Break2;
                block79: {
                    boolean Break3;
                    this.V = new Vector();
                    for (int i = 0; i < this.PN; ++i) {
                        this.VO[i] = new Vector();
                    }
                    this.VPM = new Vector();
                    if (!(this.O instanceof PrimitiveCircleObject)) break block79;
                    zc.getConstruction().shouldSwitch(false);
                    PrimitiveCircleObject c2 = (PrimitiveCircleObject)this.O;
                    double x = c2.getX();
                    double y = c2.getY();
                    double r = c2.getR();
                    this.PM.project(c2);
                    double amin = 0.0;
                    double amax = 0.0;
                    double astart = 0.0;
                    double anull = 0.0;
                    double dmax = 0.5;
                    boolean range = false;
                    if (c2.hasRange()) {
                        double d2;
                        range = true;
                        double a1 = c2.getA1();
                        double a2 = c2.getA2();
                        for (d2 = a2 - a1; d2 < 0.0; d2 += Math.PI * 2) {
                        }
                        while (d2 >= Math.PI * 2) {
                            d2 -= Math.PI * 2;
                        }
                        amin = astart = -d2 / 2.0;
                        amax = d2 / 2.0;
                        anull = (a1 + a2) / 2.0;
                    } else {
                        astart = -3.141278494324434;
                        amin = -3.141278494324434;
                        amax = 3.141278494324434;
                    }
                    double a2 = astart;
                    this.PM.move(x + r * Math.cos(anull + a2), y + r * Math.sin(anull + a2));
                    this.PM.project(c2);
                    zc.getConstruction().validate(this.P, this.PM);
                    zc.resetSum();
                    double x1 = 0.0;
                    double y1 = 0.0;
                    boolean started = false;
                    if (this.P.valid()) {
                        zc.getConstruction().shouldSwitch(true);
                        if (this.P instanceof PointObject) {
                            PointObject p = (PointObject)this.P;
                            x1 = p.getX();
                            y1 = p.getY();
                            this.V.addElement(new Coordinates(x1, y1));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            started = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject L2 = (PrimitiveLineObject)this.P;
                            this.X = L2.getX();
                            this.Y = L2.getY();
                            this.DX = L2.getDX();
                            this.DY = L2.getDY();
                            started = true;
                        }
                    }
                    boolean[] startedO = new boolean[this.PMax];
                    for (int i = 0; i < this.PN; ++i) {
                        startedO[i] = false;
                    }
                    long time = System.currentTimeMillis();
                    this.addSecondary(startedO, zc);
                    double dmin = 0.001;
                    if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                        this.da = zc.dx(1) / 10.0;
                    }
                    double aold = a2;
                    double x2 = 0.0;
                    double y2 = 0.0;
                    do {
                        a2 += this.da;
                        Break3 = false;
                        if ((!started || range) && a2 >= amax) {
                            a2 = amax;
                            Break3 = true;
                        } else if ((!started || range) && a2 <= amin) {
                            a2 = amin;
                            Break3 = true;
                        } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a2 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                            Break3 = true;
                            a2 = astart;
                        }
                        aold = a2;
                        this.PM.move(x + r * Math.cos(anull + a2), y + r * Math.sin(anull + a2));
                        this.PM.project(c2);
                        zc.getConstruction().validate(this.P, this.PM);
                        if (this.P.valid()) {
                            boolean different;
                            if (!started) {
                                zc.getConstruction().shouldSwitch(true);
                                astart = a2;
                            }
                            boolean valid = false;
                            if (this.P instanceof PointObject) {
                                PointObject p = (PointObject)this.P;
                                x2 = p.getX();
                                y2 = p.getY();
                                valid = true;
                            } else if (this.P instanceof PrimitiveLineObject) {
                                PrimitiveLineObject L3 = (PrimitiveLineObject)this.P;
                                if (!started) {
                                    this.X = L3.getX();
                                    this.Y = L3.getY();
                                    this.DX = L3.getDX();
                                    this.DY = L3.getDY();
                                } else {
                                    double dy;
                                    double xx = L3.getX();
                                    double yy = L3.getY();
                                    double dx = L3.getDX();
                                    double det = dx * this.DY - (dy = L3.getDY()) * this.DX;
                                    if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                        double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                        x2 = xx + h * dx;
                                        y2 = yy + h * dy;
                                        valid = true;
                                    }
                                    this.X = xx;
                                    this.Y = yy;
                                    this.DX = dx;
                                    this.DY = dy;
                                }
                            }
                            double dist = zc.dCenter(x2, y2);
                            boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                            if (valid && different) {
                                this.V.addElement(new Coordinates(x2, y2));
                                this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            }
                            double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                            this.da = this.updateDA(this.da, valid, dist, dp, dmin, dmax, zc);
                            x1 = x2;
                            y1 = y2;
                            started = true;
                        } else if (started) {
                            this.V.addElement(new Coordinates(x2, y2));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            this.da = -this.da;
                        }
                        this.addSecondary(startedO, zc);
                    } while (!Break3 && System.currentTimeMillis() - time <= 5000L);
                    break block80;
                }
                if (!(this.O instanceof PrimitiveLineObject)) break block81;
                zc.getConstruction().shouldSwitch(false);
                PrimitiveLineObject l = (PrimitiveLineObject)this.O;
                this.PM.project(l);
                double lx = l.getX();
                double ly = l.getY();
                double ldx = l.getDX();
                double ldy = l.getDY();
                double amin = 0.0;
                double amax = 0.0;
                double astart = 0.0;
                double dmax = 0.5;
                boolean range = false;
                if (l instanceof RayObject) {
                    astart = 0.0;
                    amin = 0.0;
                    amax = 3.141278494324434;
                    range = true;
                } else if (l instanceof SegmentObject) {
                    astart = 0.0;
                    amin = 0.0;
                    double r = ((SegmentObject)l).getLength();
                    System.out.println(r);
                    dmax = r / 20.0;
                    amax = Math.atan(r) * 2.0;
                    range = true;
                } else {
                    astart = -3.1415612376632573;
                    amin = -3.1415612376632573;
                    amax = 3.141278494324434;
                }
                double a3 = astart;
                double hd = Math.tan(this.mod(a3) / 2.0);
                this.PM.move(lx + hd * ldx, ly + hd * ldy);
                this.PM.project(l);
                zc.getConstruction().validate(this.P, this.PM);
                zc.resetSum();
                double x1 = 0.0;
                double y1 = 0.0;
                boolean started = false;
                if (this.P.valid()) {
                    zc.getConstruction().shouldSwitch(true);
                    if (this.P instanceof PointObject) {
                        PointObject p = (PointObject)this.P;
                        x1 = p.getX();
                        y1 = p.getY();
                        this.V.addElement(new Coordinates(x1, y1));
                        this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        started = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject L4 = (PrimitiveLineObject)this.P;
                        this.X = L4.getX();
                        this.Y = L4.getY();
                        this.DX = L4.getDX();
                        this.DY = L4.getDY();
                        started = true;
                    }
                }
                boolean[] startedO = new boolean[this.PMax];
                for (int i = 0; i < this.PN; ++i) {
                    startedO[i] = false;
                }
                long time = System.currentTimeMillis();
                this.addSecondary(startedO, zc);
                double dmin = 0.001;
                if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                    this.da = zc.dx(1) / 10.0;
                }
                double aold = a3;
                double x2 = 0.0;
                double y2 = 0.0;
                do {
                    a3 += this.da;
                    Break2 = false;
                    if ((!started || range) && a3 >= amax) {
                        a3 = amax;
                        Break2 = true;
                    } else if ((!started || range) && a3 <= amin) {
                        a3 = amin;
                        Break2 = true;
                    } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a3 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                        Break2 = true;
                        a3 = astart;
                    }
                    aold = a3;
                    hd = Math.tan(this.mod(a3) / 2.0);
                    this.PM.move(lx + hd * ldx, ly + hd * ldy);
                    this.PM.project(l);
                    zc.getConstruction().validate(this.P, this.PM);
                    if (this.P.valid()) {
                        boolean different;
                        if (!started) {
                            zc.getConstruction().shouldSwitch(true);
                            astart = a3;
                        }
                        boolean valid = false;
                        if (this.P instanceof PointObject) {
                            PointObject p = (PointObject)this.P;
                            x2 = p.getX();
                            y2 = p.getY();
                            valid = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject L5 = (PrimitiveLineObject)this.P;
                            if (!started) {
                                this.X = L5.getX();
                                this.Y = L5.getY();
                                this.DX = L5.getDX();
                                this.DY = L5.getDY();
                            } else {
                                double dy;
                                double xx = L5.getX();
                                double yy = L5.getY();
                                double dx = L5.getDX();
                                double det = dx * this.DY - (dy = L5.getDY()) * this.DX;
                                if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                    double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                    x2 = xx + h * dx;
                                    y2 = yy + h * dy;
                                    valid = true;
                                }
                                this.X = xx;
                                this.Y = yy;
                                this.DX = dx;
                                this.DY = dy;
                            }
                        }
                        double dist = zc.dCenter(x2, y2);
                        boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                        if (valid && different) {
                            this.V.addElement(new Coordinates(x2, y2));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        }
                        double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                        this.da = this.updateDA(this.da, valid, dist, dp, dmin, dmax, zc);
                        x1 = x2;
                        y1 = y2;
                        started = true;
                    } else if (started) {
                        this.V.addElement(new Coordinates(x2, y2));
                        this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        this.da = -this.da;
                    }
                    this.addSecondary(startedO, zc);
                } while (!Break2 && System.currentTimeMillis() - time <= 5000L);
                break block80;
            }
            if (!(this.O instanceof ExpressionObject)) break block80;
            zc.getConstruction().shouldSwitch(false);
            ExpressionObject eo = (ExpressionObject)this.O;
            if (!eo.isSlider()) {
                return;
            }
            double amin = 0.0;
            double amax = 0.0;
            double astart = 0.0;
            double dmax = 0.5;
            boolean range = false;
            astart = 0.0;
            amin = 0.0;
            double r = 1.0;
            dmax = r / 20.0;
            amax = Math.atan(r) * 2.0;
            range = true;
            double a4 = astart;
            double hd = Math.tan(this.mod(a4) / 2.0);
            eo.setSliderPosition(0.0);
            zc.getConstruction().validate(this.P, null);
            zc.resetSum();
            double x1 = 0.0;
            double y1 = 0.0;
            boolean started = false;
            if (this.P.valid()) {
                zc.getConstruction().shouldSwitch(true);
                if (this.P instanceof PointObject) {
                    PointObject p = (PointObject)this.P;
                    x1 = p.getX();
                    y1 = p.getY();
                    this.V.addElement(new Coordinates(x1, y1));
                    this.VPM.addElement(new Coordinates(eo.getSliderPosition(), 0.0));
                    started = true;
                } else if (this.P instanceof PrimitiveLineObject) {
                    PrimitiveLineObject L6 = (PrimitiveLineObject)this.P;
                    this.X = L6.getX();
                    this.Y = L6.getY();
                    this.DX = L6.getDX();
                    this.DY = L6.getDY();
                    started = true;
                }
            }
            boolean[] startedO = new boolean[this.PMax];
            for (int i = 0; i < this.PN; ++i) {
                startedO[i] = false;
            }
            long time = System.currentTimeMillis();
            this.addSecondary(startedO, zc);
            double dmin = 0.001;
            if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                this.da = zc.dx(1) / 10.0;
            }
            double aold = a4;
            double x2 = 0.0;
            double y2 = 0.0;
            do {
                a4 += this.da;
                Break = false;
                if ((!started || range) && a4 >= amax) {
                    a4 = amax;
                    Break = true;
                } else if ((!started || range) && a4 <= amin) {
                    a4 = amin;
                    Break = true;
                } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a4 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                    Break = true;
                    a4 = astart;
                }
                aold = a4;
                hd = Math.tan(this.mod(a4) / 2.0);
                eo.setSliderPosition(hd);
                zc.getConstruction().validate(this.P, null);
                if (this.P.valid()) {
                    boolean different;
                    if (!started) {
                        zc.getConstruction().shouldSwitch(true);
                        astart = a4;
                    }
                    boolean valid = false;
                    if (this.P instanceof PointObject) {
                        PointObject p = (PointObject)this.P;
                        x2 = p.getX();
                        y2 = p.getY();
                        valid = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject L7 = (PrimitiveLineObject)this.P;
                        if (!started) {
                            this.X = L7.getX();
                            this.Y = L7.getY();
                            this.DX = L7.getDX();
                            this.DY = L7.getDY();
                        } else {
                            double dy;
                            double xx = L7.getX();
                            double yy = L7.getY();
                            double dx = L7.getDX();
                            double det = dx * this.DY - (dy = L7.getDY()) * this.DX;
                            if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                x2 = xx + h * dx;
                                y2 = yy + h * dy;
                                valid = true;
                            }
                            this.X = xx;
                            this.Y = yy;
                            this.DX = dx;
                            this.DY = dy;
                        }
                    }
                    double dist = zc.dCenter(x2, y2);
                    boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                    if (valid && different) {
                        this.V.addElement(new Coordinates(x2, y2));
                        this.VPM.addElement(new Coordinates(eo.getSliderPosition(), 0.0));
                    }
                    double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                    this.da = this.updateDA(this.da, valid, dist, dp, dmin, dmax, zc);
                    x1 = x2;
                    y1 = y2;
                    started = true;
                } else if (started) {
                    this.V.addElement(new Coordinates(x2, y2));
                    this.VPM.addElement(new Coordinates(eo.getSliderPosition(), 0.0));
                    this.da = -this.da;
                }
                this.addSecondary(startedO, zc);
            } while (!Break && System.currentTimeMillis() - time <= 5000L);
        }
    }

    public void addSecondary(boolean[] startedO, ZirkelCanvas zc) {
        for (int i = 0; i < this.PN; ++i) {
            double dy;
            if (this.PM != null) {
                zc.getConstruction().validate(this.PO[i], this.PM);
            } else {
                zc.getConstruction().validate(this.PO[i], this.O);
            }
            if (!this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                PointObject p = (PointObject)this.PO[i];
                this.VO[i].addElement(new Coordinates(p.getX(), p.getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            PrimitiveLineObject L2 = (PrimitiveLineObject)this.PO[i];
            if (!startedO[i]) {
                this.XO[i] = L2.getX();
                this.YO[i] = L2.getY();
                this.DXO[i] = L2.getDX();
                this.DYO[i] = L2.getDY();
                startedO[i] = true;
                continue;
            }
            double xx = L2.getX();
            double yy = L2.getY();
            double dx = L2.getDX();
            double det = dx * this.DYO[i] - (dy = L2.getDY()) * this.DXO[i];
            if (!(Math.sqrt(Math.abs(det)) > 1.0E-9)) continue;
            double h = (-(this.XO[i] - xx) * this.DYO[i] + this.DXO[i] * (this.YO[i] - yy)) / -det;
            this.XO[i] = xx;
            this.YO[i] = yy;
            this.DXO[i] = dx;
            this.DYO[i] = dy;
            this.VO[i].addElement(new Coordinates(xx + h * dx, yy + h * dy));
        }
    }

    public double updateDA(double da, boolean valid, double dist, double dp, double dmin, double dmax, ZirkelCanvas zc) {
        if (this.V.size() > 0 && valid) {
            if (dist < 1.2) {
                if (dp > zc.dx(this.StepSize)) {
                    da /= 2.0;
                } else if (dp < zc.dx(this.StepSize / 2.0)) {
                    da *= 2.0;
                }
                if (da > 0.0 && da < dmin) {
                    da = dmin;
                } else if (da < 0.0 && da > -dmin) {
                    da = -dmin;
                }
                if (da > dmax) {
                    da = dmax;
                } else if (da < -dmax) {
                    da = -dmax;
                }
            } else {
                if (dp > zc.dx(this.StepSize * 10.0)) {
                    da /= 2.0;
                } else if (dp < zc.dx(this.StepSize * 5.0)) {
                    da *= 2.0;
                }
                if (da > 0.0 && da < dmin) {
                    da = dmin;
                } else if (da < 0.0 && da > -dmin) {
                    da = -dmin;
                }
                if (da > dmax) {
                    da = dmax;
                } else if (da < -dmax) {
                    da = -dmax;
                }
            }
        }
        return da;
    }

    public void increaseOmit() {
        ++this.Omit;
    }

    public void decreaseOmit() {
        if (this.Omit > 1) {
            --this.Omit;
        }
    }

    public void setOmit(int f2) {
        this.Omit = f2 + 1;
    }

    public boolean isComplete() {
        return this.P != null && this.O != null && (this.PM != null || this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider());
    }

    public void keep(ZirkelCanvas zc) {
        if (!this.isComplete()) {
            return;
        }
        TrackObject t = new TrackObject(zc.getConstruction(), this.P, this.PO, this.PN, this.O, this.PM);
        zc.addObject(t);
        t.setDefaults();
        this.reset(zc);
        t.compute(zc);
        zc.validate();
    }

    public String getTag() {
        return "Track";
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Track")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("on") || !tag.hasParam("track")) {
            throw new ConstructionException("Track parameters missing!");
        }
        try {
            PointObject pm = null;
            try {
                pm = (PointObject)c2.find(tag.getValue("point"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ConstructionObject o = c2.find(tag.getValue("on"));
            if (pm == null && !(o instanceof ExpressionObject)) {
                throw new ConstructionException("");
            }
            ConstructionObject p = c2.find(tag.getValue("track"));
            ConstructionObject[] po = new ConstructionObject[this.PMax];
            int pn = 0;
            for (pn = 0; pn < this.PMax && tag.hasParam("track" + pn); ++pn) {
                po[pn] = c2.find(tag.getValue("track" + pn));
                if (po[pn] instanceof PointObject || po[pn] instanceof PrimitiveLineObject) continue;
                throw new ConstructionException("Track parameters wrong!");
            }
            if (p == null || o == null) {
                throw new ConstructionException("Track parameters wrong!");
            }
            if (!(p instanceof PointObject) && !(p instanceof PrimitiveLineObject)) {
                throw new ConstructionException("Track parameters wrong!");
            }
            if (!(o instanceof PrimitiveCircleObject || o instanceof PrimitiveLineObject || o instanceof QuadricObject || o instanceof AreaObject || o instanceof JLocusTrackObject || o instanceof ExpressionObject)) {
                throw new ConstructionException("Track parameters wrong!");
            }
            JLocusTrackObject tr = new JLocusTrackObject(c2, p, po, pn, o, pm);
            if (tag.hasParam("filled")) {
                tr.setFilled(true);
            }
            if (tag.hasParam("fixed")) {
                tr.setFixed(true);
            }
            if (tag.hasParam("dmin")) {
                try {
                    double db = new Double(tag.getValue("dmin"));
                    tr.setDMin(db);
                }
                catch (Exception e2) {
                    throw new ConstructionException("Track parameters wrong!");
                }
            }
            if (tag.hasTrueParam("discrete")) {
                tr.setDiscrete(true);
            }
            this.setType(tag, tr);
            this.setName(tag, tr);
            this.set(tree, tr);
            c2.add(tr);
            this.setConditionals(tree, c2, tr);
            return true;
        }
        catch (ConstructionException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new ConstructionException("Track Parameters wrong!");
        }
    }

    public void setType(XmlTag tag, TrackObject p) {
        if (tag.hasParam("shape")) {
            String s = tag.getValue("shape");
            if (s.equals("square")) {
                p.setType(0);
            }
            if (s.equals("diamond")) {
                p.setType(1);
            }
            if (s.equals("circle")) {
                p.setType(2);
            }
            if (s.equals("dot")) {
                p.setType(3);
            }
            if (s.equals("cross")) {
                p.setType(4);
            }
            if (s.equals("dcross")) {
                p.setType(5);
            }
        }
    }
}

