/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SegmentObject;

public class AnimatorTool
extends ObjectConstructor
implements Runnable,
Selector {
    PointObject P;
    Vector V;
    ZirkelCanvas ZC;
    boolean Running = false;
    boolean Interactive = true;
    boolean Complete = false;
    boolean Negative = false;
    boolean Original = false;
    double Delay = 50.0;
    boolean Stopped = false;

    public AnimatorTool() {
        this.V = new Vector();
        this.P = null;
    }

    public AnimatorTool(PointObject p, Vector v, ZirkelCanvas zc, boolean negative, boolean original, String delay) {
        this.P = p;
        if (!this.P.moveable()) {
            return;
        }
        this.V = new Vector();
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = zc.getConstruction().find((String)e2.nextElement());
            if (!(o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject)) {
                return;
            }
            this.V.addElement(o);
        }
        this.Stopped = false;
        this.ZC = zc;
        this.Complete = true;
        this.Negative = negative;
        this.Original = original;
        try {
            this.Delay = 50.0;
            this.Delay = new Double(delay);
        }
        catch (Exception ex) {
            // empty catch block
        }
        new Thread(this).start();
    }

    public void setInteractive(boolean flag) {
        this.Interactive = flag;
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        if (o instanceof CircleObject && ((CircleObject)o).getP2() == this.P) {
            return true;
        }
        return !zc.depends(o, this.P);
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        if (this.P == null) {
            this.P = zc.selectPoint(e2.getX(), e2.getY());
            this.Complete = false;
            if (this.P != null && this.P.moveable()) {
                this.P.setSelected(true);
                zc.repaint();
                this.showStatus(zc);
            }
        } else {
            if (!this.Complete && this.Interactive) {
                boolean Have;
                ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
                if (o == null) {
                    return;
                }
                boolean bl = Have = o == this.P;
                if (!Have) {
                    Enumeration en = this.V.elements();
                    while (en.hasMoreElements()) {
                        if (o != en.nextElement()) continue;
                        Have = true;
                        break;
                    }
                }
                if (!Have) {
                    if (!(o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject)) {
                        return;
                    }
                    o.setSelected(true);
                    this.V.addElement(o);
                    zc.repaint();
                    this.showStatus(zc);
                    return;
                }
            }
            if (!this.Running) {
                this.Stopped = false;
                this.ZC = zc;
                zc.clearSelected();
                this.Complete = true;
                zc.clearIndicated();
                this.showStatus(zc);
                new Thread(this).start();
            } else if (e2.isShiftDown()) {
                this.Negative = !this.Negative;
            } else {
                this.Stopped = true;
            }
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (this.Complete || !this.Interactive) {
            return;
        }
        if (this.P == null) {
            zc.indicatePointObjects(e2.getX(), e2.getY());
        } else {
            zc.indicateObjects(e2.getX(), e2.getY());
        }
    }

    public synchronized void reset(ZirkelCanvas zc) {
        this.Stopped = true;
        this.Complete = false;
        super.reset(zc);
        this.P = null;
        this.Delay = 50.0;
        this.V = new Vector();
        this.showStatus(zc);
        zc.repaint();
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null) {
            zc.showStatus(Zirkel.name("message.animator.point"));
        } else if (!this.Complete) {
            zc.showStatus(Zirkel.name("message.animator.segment"));
        } else {
            zc.showStatus(Zirkel.name("message.animator.running"));
        }
    }

    public void save(XmlWriter xml) {
        if (this.P == null) {
            return;
        }
        xml.startTagStart("Animate");
        xml.printArg("animate", this.P.getName());
        int k = 0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            String s = ((ConstructionObject)e2.nextElement()).getName();
            xml.printArg("via" + k, s);
            ++k;
        }
        if (this.Negative) {
            xml.printArg("negative", "true");
        }
        if (this.Delay != 50.0) {
            xml.printArg("delay", "" + this.Delay);
        }
        xml.finishTagNewLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long time;
        this.ZC.resetSum();
        if (this.Original) {
            this.ZC.getConstruction().setOriginalOrder(true);
        }
        this.Running = true;
        this.showStatus(this.ZC);
        Enumeration e2 = this.V.elements();
        double x = 0.001;
        boolean full = true;
        ConstructionObject o = null;
        long stoptime = time = System.currentTimeMillis();
        double end = Math.PI * 2;
        boolean back = false;
        while (!this.Stopped) {
            try {
                long t = System.currentTimeMillis();
                int h = (int)(t - time);
                if (h < 0) {
                    h = 0;
                }
                if ((double)h > this.Delay) {
                    h = (int)this.Delay;
                }
                Thread.sleep((int)(this.Delay - (double)h));
                time = System.currentTimeMillis();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.Stopped) break;
            if (this.ZC.I == null) continue;
            AnimatorTool animatorTool = this;
            synchronized (animatorTool) {
                PrimitiveCircleObject c2;
                if (full) {
                    if (!e2.hasMoreElements()) {
                        e2 = this.V.elements();
                    }
                    o = (ConstructionObject)e2.nextElement();
                    full = false;
                    x = 1.0E-4;
                    if (o instanceof SegmentObject) {
                        x = 0.001 * ((SegmentObject)o).getLength();
                    } else if (o instanceof PrimitiveCircleObject) {
                        c2 = (PrimitiveCircleObject)o;
                        if (c2.hasRange()) {
                            c2.computeA1A2();
                            x = c2.getA1();
                            end = c2.getA2();
                            if (end < x) {
                                end += Math.PI * 2;
                            }
                            back = false;
                        } else {
                            x = 1.0E-4 * c2.getR();
                        }
                    } else if (o instanceof PointObject) {
                        PointObject p = (PointObject)o;
                        ZirkelCanvas zirkelCanvas = this.ZC;
                        synchronized (zirkelCanvas) {
                            this.P.move(p.getX(), p.getY());
                            this.ZC.dovalidate();
                        }
                        this.ZC.repaint();
                        stoptime = System.currentTimeMillis();
                    }
                }
                if (o instanceof SegmentObject) {
                    SegmentObject s = (SegmentObject)o;
                    ZirkelCanvas zirkelCanvas = this.ZC;
                    synchronized (zirkelCanvas) {
                        if (back) {
                            this.P.move(s.getP1().getX() + (s.getLength() - x) * s.getDX(), s.getP1().getY() + (s.getLength() - x) * s.getDY());
                        } else {
                            this.P.move(s.getP1().getX() + x * s.getDX(), s.getP1().getY() + x * s.getDY());
                        }
                        this.ZC.dovalidate();
                    }
                    this.ZC.repaint();
                    x += this.ZC.dx(2);
                    if (x > 0.99 * s.getLength()) {
                        if (this.Negative && !back) {
                            x = 1.0E-5;
                            back = true;
                        } else {
                            back = false;
                            full = true;
                        }
                    }
                } else if (o instanceof PrimitiveCircleObject) {
                    c2 = (PrimitiveCircleObject)o;
                    if (c2.getR() < 1.0E-10) {
                        full = true;
                    } else {
                        ZirkelCanvas zirkelCanvas = this.ZC;
                        synchronized (zirkelCanvas) {
                            if (this.Negative && !c2.hasRange()) {
                                this.P.move(c2.getP1().getX() + Math.cos(x) * c2.getR(), c2.getP1().getY() - Math.sin(x) * c2.getR());
                            } else {
                                this.P.move(c2.getP1().getX() + Math.cos(x) * c2.getR(), c2.getP1().getY() + Math.sin(x) * c2.getR());
                            }
                            this.ZC.dovalidate();
                        }
                        this.ZC.repaint();
                        x = back ? (x -= this.ZC.dx(2) / c2.getR()) : (x += this.ZC.dx(2) / c2.getR());
                        if (x > end && !back) {
                            if (!this.Negative || back || !c2.hasRange()) {
                                full = true;
                                back = false;
                            } else {
                                back = true;
                                end = c2.getA1();
                            }
                        }
                        if (back && x < end) {
                            full = true;
                            back = false;
                        }
                    }
                } else if (o instanceof PointObject && System.currentTimeMillis() - stoptime > 5000L) {
                    full = true;
                }
            }
        }
        this.Running = false;
        if (this.Original) {
            this.ZC.getConstruction().setOriginalOrder(false);
        }
    }

    public synchronized void invalidate(ZirkelCanvas zc) {
        this.Stopped = true;
    }

    public boolean useSmartBoard() {
        return false;
    }

    public void increaseSpeed() {
        if (this.Delay > 1.0) {
            this.Delay /= 1.5;
        }
    }

    public void decreaseSpeed() {
        if (this.Delay < 500.0) {
            this.Delay *= 1.5;
        }
    }
}

