/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import eric.JGlobals;
import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.TwoPointLineObject;

public class SegmentObject
extends TwoPointLineObject {
    static Count N = new Count();
    protected boolean Fixed = false;
    Expression E;
    boolean ExpressionFailed;
    boolean Arrow = false;

    public SegmentObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, p1, p2);
        this.validate();
        this.updateText();
        this.Unit = Global.getParameter("unit.length", "");
    }

    public String getTag() {
        return "Segment";
    }

    public int getN() {
        return N.next();
    }

    public void setDefaults() {
        this.Arrow = this.Cn.Vectors;
        this.setShowName(Global.getParameter("options.segment.shownames", false));
        this.setShowValue(Global.getParameter("options.segment.showvalues", false));
        this.setColor(Global.getParameter("options.segment.color", 0));
        this.setColorType(Global.getParameter("options.segment.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(Global.getParameter("options.segment.large", false));
        this.setBold(Global.getParameter("options.segment.bold", false));
    }

    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.segment.shownames", false));
        this.setShowValue(Global.getParameter("options.segment.showvalues", false));
        this.setColor(Global.getParameter("options.segment.color", 0));
        this.setColorType(Global.getParameter("options.segment.colortype", 0));
        this.setLarge(Global.getParameter("options.segment.large", false));
        this.setBold(Global.getParameter("options.segment.bold", false));
    }

    public void updateText() {
        if (!this.Fixed) {
            this.setText(SegmentObject.text2(Zirkel.name("text.segment"), this.P1.getName(), this.P2.getName()));
        } else if (this.E == null) {
            this.setText(SegmentObject.text3(Zirkel.name("text.segment.fixed"), this.P1.getName(), this.P2.getName(), "" + this.round(this.R)));
        } else {
            this.setText(SegmentObject.text3(Zirkel.name("text.segment.fixed"), this.P1.getName(), this.P2.getName(), "\"" + this.E.toString() + "\""));
        }
    }

    public void validate() {
        this.ExpressionFailed = false;
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.Fixed && this.E != null) {
            try {
                ConstructionObject bound;
                double FixedR = this.E.getValue();
                if (FixedR < 1.0E-8) {
                    this.R = 0.0;
                    this.ExpressionFailed = true;
                    this.Valid = false;
                    return;
                }
                boolean movefirst = this.P1.moveableBy(this);
                boolean movesecond = this.P2.moveableBy(this);
                if (this.P2.getBound() != null) {
                    ConstructionObject bound2 = this.P2.getBound();
                    if (bound2 instanceof RayObject && ((RayObject)bound2).getP1() == this.P1) {
                        movesecond = true;
                    }
                } else if (this.P1.getBound() != null && (bound = this.P1.getBound()) instanceof RayObject && ((RayObject)bound).getP1() == this.P2) {
                    movefirst = true;
                    movesecond = false;
                }
                if (movesecond) {
                    if (this.R < 1.0E-10) {
                        this.P2.move(this.X1 + FixedR, this.Y1);
                    } else {
                        this.P2.move(this.X1 + FixedR * this.DX / this.R, this.Y1 + FixedR * this.DY / this.R);
                    }
                    this.P1.setUseAlpha(false);
                } else if (movefirst) {
                    if (this.R < 1.0E-10) {
                        this.P1.move(this.X2 - FixedR, this.Y2);
                    } else {
                        this.P1.move(this.X2 - FixedR * this.DX / this.R, this.Y2 - FixedR * this.DY / this.R);
                    }
                    this.P2.setUseAlpha(false);
                } else {
                    this.Fixed = false;
                }
                if (this.Fixed) {
                    this.X1 = this.P1.getX();
                    this.Y1 = this.P1.getY();
                    this.X2 = this.P2.getX();
                    this.Y2 = this.P2.getY();
                    this.DX = this.X2 - this.X1;
                    this.DY = this.Y2 - this.Y1;
                    this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
                    this.P2.movedBy(this);
                    this.P1.movedBy(this);
                }
            }
            catch (Exception e2) {
                this.ExpressionFailed = true;
                this.Valid = false;
                this.R = 0.0;
                return;
            }
        }
        if (this.R < 1.0E-10) {
            this.R = 0.0;
            this.DX = 1.0;
            this.DY = 0.0;
        } else {
            this.DX /= this.R;
            this.DY /= this.R;
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double c1 = zc.col(this.X1);
        double r1 = zc.row(this.Y1);
        double c2 = zc.col(this.X2);
        double r2 = zc.row(this.Y2);
        if (this.visible(zc)) {
            if (this.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(c1, r1, c2, r2);
            }
            g.setColor(this);
            g.drawLine(c1, r1, c2, r2, this);
            if (this.Arrow) {
                double a2 = 2.827433388230814;
                double r = zc.dx(zc.scale(Global.getParameter("arrowsize", 15)));
                double[] cols = new double[]{c2, zc.col(this.X2 + (this.DX * Math.cos(a2) + this.DY * Math.sin(a2)) * r), zc.col(this.X2 + (this.DX * Math.cos(-a2) + this.DY * Math.sin(-a2)) * r)};
                double[] rows = new double[]{r2, zc.row(this.Y2 + (-this.DX * Math.sin(a2) + this.DY * Math.cos(a2)) * r), zc.row(this.Y2 + (-this.DX * Math.sin(-a2) + this.DY * Math.cos(-a2)) * r)};
                g.fillPolygon(cols, rows, 3, true, false, this);
            }
        }
        if (!(s = this.getDisplayText()).equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double side = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(g, s, zc, this.X1 + this.XcOffset * (this.X2 - this.X1), this.Y1 + this.XcOffset * (this.Y2 - this.Y1), side * this.DX, side * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(g, s, zc, (this.X1 + this.X2) / 2.0, (this.Y1 + this.Y2) / 2.0, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = (x - this.X1) / this.R * this.DX + (y - this.Y1) / this.R * this.DY;
        this.YcOffset = (x - this.X1) / this.R * this.DY - (y - this.Y1) / this.R * this.DX;
    }

    public String getDisplayValue() {
        return "" + this.round(this.R, ZirkelCanvas.LengthsFactor);
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (this.ExpressionFailed && this.P1.valid()) {
            return this.P1.nearto(c2, r, zc);
        }
        if (this.ExpressionFailed && this.P2.valid()) {
            return this.P2.nearto(c2, r, zc);
        }
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        double o = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        double o1 = (this.X2 - this.X1) * this.DX + (this.Y2 - this.Y1) * this.DY;
        if (o1 > 0.0) {
            if (o > o1) {
                d2 = Math.sqrt((x - this.X2) * (x - this.X2) + (y - this.Y2) * (y - this.Y2));
            } else if (o < 0.0) {
                d2 = Math.sqrt((x - this.X1) * (x - this.X1) + (y - this.Y1) * (y - this.Y1));
            }
        } else if (o < o1) {
            d2 = Math.sqrt((x - this.X2) * (x - this.X2) + (y - this.Y2) * (y - this.Y2));
        } else if (o > 0.0) {
            d2 = Math.sqrt((x - this.X1) * (x - this.X1) + (y - this.Y1) * (y - this.Y1));
        }
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX())) * 0.9;
        return this.Value < zc.selectionSize();
    }

    public boolean onlynearto(int c2, int r, ZirkelCanvas zc) {
        return this.R < zc.dx(3 * (int)zc.pointSize());
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("from", this.P1.getName());
        xml.printArg("to", this.P2.getName());
        if (this.Fixed && this.E != null) {
            xml.printArg("fixed", this.E.toString());
        }
        if (this.Arrow) {
            xml.printArg("arrow", "true");
        }
        super.printArgs(xml);
    }

    public double getLength() {
        return this.R;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean flag, String s) throws ConstructionException {
        if (!flag || s.equals("")) {
            this.Fixed = false;
            this.E = null;
        } else {
            this.E = new Expression(s, this.getConstruction(), this);
            if (!this.E.isValid()) {
                throw new ConstructionException(this.E.getErrorText());
            }
            this.Fixed = true;
        }
        this.updateText();
    }

    public void round() {
        try {
            this.setFixed(true, this.getDisplayValue());
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canFix() {
        return this.P1.moveableBy(this) || this.P2.moveableBy(this);
    }

    public boolean contains(double x, double y) {
        double a2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        return !(a2 < -1.0E-9) && !(a2 > this.R + 1.0E-9);
    }

    public double project(double x, double y) {
        double h = super.project(x, y);
        if (h < 0.0) {
            return 0.0;
        }
        if (h > this.R) {
            return this.R;
        }
        return h;
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof SegmentObject) || !o.valid()) {
            return false;
        }
        SegmentObject l = (SegmentObject)o;
        return this.equals(this.X1, l.X1) && this.equals(this.X2, l.X2) && this.equals(this.Y1, l.Y1) && this.equals(this.Y2, l.Y2) || this.equals(this.X1, l.X2) && this.equals(this.Y1, l.Y2) && this.equals(this.X2, l.X1) && this.equals(this.Y2, l.Y1);
    }

    public void edit(ZirkelCanvas zc) {
        if (!Zirkel.IsApplet) {
            JGlobals.EditObject(this);
            return;
        }
        super.edit(zc);
        if (this.E != null && !this.E.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
    }

    public boolean isValidFix() {
        return this.E != null && this.E.isValid();
    }

    public String getStringLength() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "" + this.round(this.R);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public void translate() {
        super.translate();
        try {
            this.setFixed(this.Fixed, this.E.toString());
            this.E.translate();
        }
        catch (Exception e2) {
            this.Fixed = false;
        }
    }

    public Enumeration depending() {
        if (!this.Fixed || this.E == null) {
            return super.depending();
        }
        super.depending();
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public void setArrow(boolean arrow) {
        this.Arrow = arrow;
    }

    public boolean isArrow() {
        return this.Arrow;
    }

    public void project(PointObject P) {
        double h = this.project(P.getX(), P.getY());
        P.setXY(this.getX() + h * this.getDX(), this.getY() + h * this.getDY());
        P.setA(h / this.getLength());
    }

    public void project(PointObject P, double alpha) {
        double d2 = alpha * this.getLength();
        P.setXY(this.getX() + d2 * this.getDX(), this.getY() + d2 * this.getDY());
    }

    public boolean moveable() {
        return !this.Fixed && this.P1.moveable() && this.P2.moveable();
    }
}

