/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointonObject;

public class PointonObjectIntersectionObject
extends IntersectionObject {
    public double Eps = 1.0E-5;
    double x;
    double y;
    double x1;
    double y1;

    public PointonObjectIntersectionObject(Construction c2, ConstructionObject p1, ConstructionObject p2) {
        super(c2, p1, p2);
    }

    public void validate(double x, double y) {
        this.setXY(x, y);
        this.validate();
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("first", this.P1.getName());
        xml.printArg("second", this.P2.getName());
        xml.printArg("x", "" + this.getX());
        xml.printArg("y", "" + this.getY());
        if (this.getAway() != null) {
            if (this.StayAway) {
                xml.printArg("awayfrom", this.getAway().getName());
            } else {
                xml.printArg("closeto", this.getAway().getName());
            }
        }
        this.printType(xml);
        if (!this.Restricted) {
            xml.printArg("valid", "true");
        }
    }

    public void validate() {
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        double distold = this.projectOnce();
        if (!this.Valid) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            double dist1 = this.projectOnce();
            if (dist1 >= distold && dist1 < this.Eps) {
                return;
            }
            distold = dist1;
            double a2 = this.x1 - this.x;
            double b2 = this.y1 - this.y;
            double s = Math.max(Math.abs(a2), Math.abs(b2));
            if (Math.abs(s) > 1.0E-13) {
                a2 /= s;
            }
            b2 /= s;
            double c2 = this.X - this.x1;
            double d2 = this.Y - this.y1;
            s = Math.max(Math.abs(c2), Math.abs(d2));
            if (Math.abs(s) > 1.0E-13) {
                c2 /= s;
            }
            double e2 = a2 * this.x1 + b2 * this.y1;
            double f2 = c2 * this.X + (d2 /= s) * this.Y;
            double det = a2 * d2 - c2 * b2;
            if (!(Math.abs(det) > 1.0E-13)) continue;
            double xn = (e2 * d2 - f2 * b2) / det;
            double yn = (a2 * f2 - c2 * e2) / det;
            double xold = this.X;
            double yold = this.Y;
            this.X = xn;
            this.Y = yn;
            double dist2 = this.projectOnce();
            if (dist2 > dist1) {
                this.X = xold;
                this.Y = yold;
                continue;
            }
            distold = dist2;
        }
        this.Valid = false;
    }

    public double projectOnce() {
        this.x = this.X;
        this.y = this.Y;
        ((PointonObject)((Object)this.P1)).project(this);
        double dist = Math.max(Math.abs(this.X - this.x), Math.abs(this.Y - this.y));
        this.x1 = this.X;
        this.y1 = this.Y;
        ((PointonObject)((Object)this.P2)).project(this);
        double dist1 = Math.max(Math.abs(this.X - this.x1), Math.abs(this.Y - this.y1));
        return Math.max(dist, dist1);
    }

    public boolean moveable() {
        return true;
    }
}

