/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import eric.JGlobals;
import eric.JPointName;
import java.awt.Color;
import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointEditDialog;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.QuadricObject;

public class PointObject
extends ConstructionObject
implements MoveableObject {
    protected double X;
    protected double Y;
    protected boolean BarycentricCoordsInitialzed = false;
    protected double Gx = 0.0;
    protected double Gy = 0.0;
    protected double Alpha;
    protected boolean AlphaValid = false;
    protected boolean UseAlpha = false;
    protected boolean Moveable;
    protected boolean Fixed;
    private static JPointName PointLabel = new JPointName();
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    public static int MaxType = 3;
    protected Expression EX;
    protected Expression EY;
    private boolean Later;
    private String LaterBind = "";
    private boolean KeepInside;
    private boolean DontUpdate = false;
    private double Increment = 0.0;
    private ConstructionObject Bound = null;
    protected ConstructionObject MovedBy;
    protected int bid = 0;
    private double Delta;
    static double[] x = new double[4];
    static double[] y = new double[4];

    public PointObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.setShowName(false);
        this.updateText();
        this.Type = 0;
    }

    public PointObject(Construction c2, double x, double y, ConstructionObject bound) {
        this(c2, x, y);
        this.Bound = bound;
    }

    public PointObject(Construction c2, String name) {
        super(c2, name);
        this.X = 0.0;
        this.Y = 0.0;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Type = 0;
    }

    public static void setPointLabel(JPointName jpl) {
        PointLabel = jpl;
    }

    public void setName() {
        this.Name = !this.SuperHidden && !this.Hidden ? PointLabel.getBetterName(this.Cn, false) : JPointName.getGenericName(this.Cn);
    }

    public void setNameWithNumber(String n) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject o = this.Cn.find(n);
            if (o != null) {
                while (o != null && o != this) {
                    n = this.Name = JPointName.getGenericName(this.Cn);
                    this.Name = "";
                    o = this.Cn.find(n);
                }
                this.Name = n;
            } else {
                this.Name = n;
            }
        } else {
            this.Name = n;
        }
    }

    public String getTag() {
        if (this.Bound == null) {
            return "Point";
        }
        return "PointOn";
    }

    public int getN() {
        return N.next();
    }

    public void setDefaults() {
        this.setShowName(Global.getParameter("options.point.shownames", false));
        this.setShowValue(Global.getParameter("options.point.showvalues", false));
        this.setColor(Global.getParameter("options.point.color", 0));
        this.setColorType(Global.getParameter("options.point.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(Global.getParameter("options.point.large", false));
        this.setBold(Global.getParameter("options.point.bold", false));
        this.Type = this.Cn.DefaultType;
    }

    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.point.shownames", false));
        this.setShowValue(Global.getParameter("options.point.showvalues", false));
        this.setColor(Global.getParameter("options.point.color", 0));
        this.setColorType(Global.getParameter("options.point.colortype", 0));
        this.setLarge(Global.getParameter("options.point.large", false));
        this.setBold(Global.getParameter("options.point.bold", false));
        this.Type = this.Cn.DefaultType;
    }

    public double changedBy() {
        return this.Delta;
    }

    public void validate() {
        if (this.DontUpdate) {
            return;
        }
        this.MovedBy = null;
        this.Delta = 0.0;
        this.Valid = true;
        if (this.Bound != null && !this.Bound.isInConstruction()) {
            this.Bound = null;
        }
        if (this.Bound != null && !this.Bound.valid()) {
            this.Valid = false;
            return;
        }
        if (this.Increment > 1.0E-4) {
            this.X = Math.floor(this.X / this.Increment + 0.5) * this.Increment;
            this.Y = Math.floor(this.Y / this.Increment + 0.5) * this.Increment;
        }
        if (this.Bound != null) {
            double x = this.X;
            double y = this.Y;
            if (this.KeepInside && this.Bound instanceof InsideObject) {
                ((InsideObject)((Object)this.Bound)).keepInside(this);
            } else if (!this.KeepInside && this.Bound instanceof PointonObject) {
                if (!this.AlphaValid || !this.UseAlpha) {
                    this.project(this.Bound);
                } else {
                    this.project(this.Bound, this.Alpha);
                }
            }
            if (this.Later) {
                this.Delta = Math.sqrt((x - this.X) * (x - this.X) + (y - this.Y) * (y - this.Y));
            }
        }
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    public void updateText() {
        if (this.Bound != null) {
            this.setText(PointObject.text1(Zirkel.name("text.boundedpoint"), this.Bound.getName()));
        } else if (this.EX != null && this.EY != null) {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "\"" + this.EX + "\"", "\"" + this.EY + "\""));
        } else {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "" + this.round(this.X), "" + this.round(this.Y)));
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double size = PointObject.drawPoint(g, zc, this, this.X, this.Y, this.Type);
        String s = AngleObject.translateToUnicode(this.getDisplayText());
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.DisplaysText = true;
            this.setFont(g);
            double d2 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
            if (!this.KeepClose || d2 < 1.0E-10) {
                this.TX1 = zc.col(this.X + this.XcOffset) + 2.0 * size;
                this.TY1 = zc.row(this.Y + this.YcOffset) + 2.0 * size;
                this.drawLabel(g, s);
            } else {
                this.drawPointLabel(g, s, zc, this.X, this.Y, this.YcOffset / d2, -this.XcOffset / d2, 0.0, 0.0);
            }
        }
    }

    public static double drawPoint(MyGraphics g, ZirkelCanvas zc, ConstructionObject o, double X, double Y, int type) {
        double size = zc.pointSize();
        double r = zc.col(X);
        double c2 = zc.row(Y);
        if (size < 1.0) {
            size = 1.0;
        }
        if (o.visible(zc)) {
            if (o.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(r, c2, r, c2);
            }
            g.setColor(o);
            switch (type) {
                case 0: {
                    double sx = r - size - 1.0;
                    double sy = c2 - size - 1.0;
                    double sw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        g.fillRect(sx, sy, sw, sw, true, false, o);
                    } else {
                        g.fillRect(sx, sy, sw, sw, new Color(250, 250, 250));
                    }
                    g.setColor(o);
                    g.drawRect(sx, sy, sw, sw);
                    break;
                }
                case 1: {
                    double dx = r - size - 2.0;
                    double dy = c2 - size - 2.0;
                    double dw = 2.0 * size + 4.0;
                    g.drawDiamond(dx, dy, dw, o.getColorType() == 1, o);
                    break;
                }
                case 2: {
                    double cx = r - size - 1.0;
                    double cy = c2 - size - 1.0;
                    double cw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        g.fillOval(cx, cy, cw, cw, true, false, o);
                        break;
                    }
                    g.fillOval(cx, cy, cw, cw, new Color(250, 250, 250));
                    g.setColor(o);
                    g.drawOval(cx, cy, cw, cw);
                    break;
                }
                case 3: {
                    if (o.getColorType() == 1) {
                        g.fillRect(r, c2, 1.0, 1.0, true, false, o);
                        break;
                    }
                    g.drawLine(r, c2, r, c2);
                    break;
                }
                case 4: {
                    if (o.getColorType() == 1) {
                        g.drawThickLine(r - size, c2, r + size, c2);
                        g.drawThickLine(r, c2 - size, r, c2 + size);
                        break;
                    }
                    g.drawLine(r - size, c2, r + size, c2);
                    g.drawLine(r, c2 - size, r, c2 + size);
                    break;
                }
                case 5: {
                    double dcx = r - size - 1.0;
                    double dcy = c2 - size - 1.0;
                    double dcw = 2.0 * size + 1.0;
                    g.drawDcross(dcx, dcy, dcw, o.getColorType() == 1, o);
                }
            }
        }
        return size;
    }

    public String getDisplayValue() {
        return "(" + this.roundDisplay(this.X) + (Global.getParameter("options.germanpoints", false) ? "|" : ",") + this.roundDisplay(this.Y) + ")";
    }

    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double c2 = zc.col(this.X);
        double r = zc.row(this.Y);
        int size = (int)zc.selectionSize();
        this.Value = Math.abs((double)x - c2) + Math.abs((double)y - r);
        return this.Value <= (double)(size * 3 / 2);
    }

    public boolean nearto(PointObject p) {
        if (!this.Valid) {
            return false;
        }
        double dx = p.X - this.X;
        double dy = p.Y - this.Y;
        return Math.sqrt(dx * dx + dy * dy) < 1.0E-9;
    }

    public double distanceTo(int x, int y, ZirkelCanvas zc) {
        double dx = (double)x - zc.col(this.X);
        double dy = (double)y - zc.row(this.Y);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public boolean moveable() {
        boolean fixed = this.Fixed;
        if (this.dependsOnItselfOnly()) {
            fixed = false;
        }
        return this.Moveable && !fixed && !this.Keep;
    }

    public boolean dependsOnItselfOnly() {
        boolean res = false;
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() != this) continue;
            res = true;
            break;
        }
        e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() == this) continue;
            res = false;
            break;
        }
        return res;
    }

    public boolean dependsOnParametersOnly() {
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if (((ConstructionObject)e2.nextElement()).isParameter()) continue;
            return false;
        }
        return true;
    }

    public boolean moveableBy(ConstructionObject o) {
        if (this.Bound != null) {
            return false;
        }
        return this.moveable() && (this.MovedBy == null || this.MovedBy == o);
    }

    public boolean moveablePoint() {
        if (this.Bound != null) {
            return true;
        }
        return this.Moveable && !this.Keep;
    }

    public boolean setBound(String name) {
        block6: {
            if (name.equals("")) {
                this.Bound = null;
                this.setFixed(false);
                this.Later = false;
                return true;
            }
            try {
                this.Bound = null;
                ConstructionObject o = this.Cn.find(name);
                if (o instanceof PointonObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = false;
                    break block6;
                }
                if (o instanceof InsideObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = true;
                    break block6;
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        if (this.Cn.before(this, this.Bound)) {
            this.Cn.needsOrdering();
            this.Cn.dovalidate();
        }
        this.updateText();
        return true;
    }

    public void setBound(ConstructionObject bound) {
        this.Bound = bound;
    }

    public ConstructionObject getBound() {
        return this.Bound;
    }

    public void setMoveable(boolean flag) {
        this.Moveable = flag;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public void move(double x, double y) {
        this.X = x;
        this.Y = y;
        this.AlphaValid = false;
        this.computeBarycentricCoords();
    }

    public void setXY(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public void setA(double alpha) {
        this.Alpha = alpha;
    }

    public void project(ConstructionObject o) {
        if (!(o instanceof PointonObject)) {
            return;
        }
        ((PointonObject)((Object)o)).project(this);
        if (this.UseAlpha) {
            this.AlphaValid = true;
        }
    }

    public void project(ConstructionObject o, double alpha) {
        ((PointonObject)((Object)o)).project(this, alpha);
    }

    public void edit(ZirkelCanvas zc) {
        if (!Zirkel.IsApplet) {
            JGlobals.EditObject(this);
            return;
        }
        PointEditDialog d2 = new PointEditDialog(zc, this);
        d2.setVisible(true);
        zc.repaint();
        if (this.EX != null && !this.EX.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.EX.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        } else if (this.EY != null && !this.EY.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        this.updateText();
        if (this.Bound != null) {
            xml.printArg("on", this.Bound.getName());
            if (this.KeepInside) {
                xml.printArg("inside", "true");
            }
        }
        if (this.Fixed && this.EX != null) {
            xml.printArg("x", this.EX.toString());
            xml.printArg("actx", "" + this.X);
        } else {
            if (this.Bound != null && this.AlphaValid && this.UseAlpha) {
                xml.printArg("alpha", "" + this.Alpha);
            }
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null) {
            xml.printArg("y", this.EY.toString());
            xml.printArg("acty", "" + this.Y);
        } else {
            xml.printArg("y", "" + this.Y);
        }
        this.printType(xml);
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Increment > 1.0E-4) {
            xml.printArg("increment", "" + this.getIncrement());
        }
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int type) {
        this.Type = type;
    }

    public void movedBy(ConstructionObject o) {
        this.MovedBy = o;
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof PointObject) || !o.valid()) {
            return false;
        }
        PointObject p = (PointObject)o;
        return this.equals(this.X, p.X) && this.equals(this.Y, p.Y);
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public boolean isOn(ConstructionObject o) {
        if (this.Bound != null) {
            return o == this.Bound;
        }
        return o.contains(this);
    }

    public void translate() {
        if (this.Bound != null) {
            this.Bound = this.Bound.getTranslation();
        } else if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Enumeration depending() {
        super.depending();
        if (this.Bound != null) {
            DL.add(this.Bound);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
        this.updateText();
    }

    public void updateCircleDep() {
        if (this.Bound != null && this.Bound instanceof PrimitiveCircleObject) {
            ((PrimitiveCircleObject)this.Bound).addDep(this);
        }
        if (this.Bound != null && this.Bound instanceof PrimitiveLineObject) {
            ((PrimitiveLineObject)this.Bound).addDep(this);
        }
    }

    public boolean isPointOn() {
        return this.Bound != null;
    }

    public void setLaterBind(String s) {
        this.LaterBind = s;
    }

    public ConstructionObject copy(double x, double y) {
        ConstructionObject o = null;
        try {
            o = (ConstructionObject)this.clone();
            this.setTranslation(o);
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            if (this.KeepInside && this.Bound != null && this.Bound instanceof AreaObject) {
                o.move(x, y);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return o;
    }

    public void computeBarycentricCoords() {
        if (this.Bound != null && this.Bound instanceof QuadricObject) {
            QuadricObject quad = (QuadricObject)this.Bound;
            PointObject A = quad.P[0];
            PointObject B = quad.P[1];
            PointObject C = quad.P[2];
            double a2 = B.getX() - A.getX();
            double b2 = C.getX() - A.getX();
            double c2 = this.getX() - A.getX();
            double d2 = B.getY() - A.getY();
            double e2 = C.getY() - A.getY();
            double f2 = this.getY() - A.getY();
            double det = a2 * e2 - d2 * b2;
            if (det != 0.0) {
                this.Gx = (c2 * e2 - b2 * f2) / det;
                this.Gy = (a2 * f2 - c2 * d2) / det;
                this.BarycentricCoordsInitialzed = true;
            }
        } else if (this.KeepInside && this.Bound != null && this.Bound instanceof AreaObject) {
            AreaObject area = (AreaObject)this.Bound;
            if (area.V.size() > 2) {
                PointObject A = (PointObject)area.V.get(0);
                PointObject B = (PointObject)area.V.get(1);
                PointObject C = (PointObject)area.V.get(2);
                double a3 = B.getX() - A.getX();
                double b3 = C.getX() - A.getX();
                double c3 = this.getX() - A.getX();
                double d3 = B.getY() - A.getY();
                double e3 = C.getY() - A.getY();
                double f3 = this.getY() - A.getY();
                double det = a3 * e3 - d3 * b3;
                if (det != 0.0) {
                    this.Gx = (c3 * e3 - b3 * f3) / det;
                    this.Gy = (a3 * f3 - c3 * d3) / det;
                    this.BarycentricCoordsInitialzed = true;
                }
            }
        }
    }

    public void setInside(boolean flag) {
        this.KeepInside = flag;
        this.computeBarycentricCoords();
    }

    public boolean isInside() {
        return this.KeepInside;
    }

    public void laterBind(Construction c2) {
        if (this.LaterBind.equals("")) {
            return;
        }
        ConstructionObject o = c2.find(this.LaterBind);
        if (o != null && (o instanceof PointonObject || o instanceof InsideObject)) {
            this.Bound = o;
            this.updateText();
            this.validate();
        }
        this.LaterBind = "";
    }

    public void setAlpha(double alpha) {
        this.Alpha = alpha;
        this.AlphaValid = true;
    }

    public void setUseAlpha(boolean flag) {
        this.UseAlpha = flag;
    }

    public boolean useAlpha() {
        return this.UseAlpha;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X;
        this.YcOffset = y - this.Y;
    }

    public boolean canKeepClose() {
        return true;
    }

    public boolean dontUpdate() {
        return this.DontUpdate;
    }

    public void dontUpdate(boolean flag) {
        this.DontUpdate = flag;
    }

    public void startDrag(double x, double y) {
    }

    public void dragTo(double x, double y) {
        this.move(x, y);
    }

    public double getOldX() {
        return 0.0;
    }

    public double getOldY() {
        return 0.0;
    }

    public void setIncrement(double inc) {
        this.Increment = inc;
    }

    public double getIncrement() {
        return this.Increment;
    }
}

