/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;

class PointEditDialog
extends ObjectEditDialog {
    TextFieldAction X;
    TextFieldAction Y;
    MyTextField Away;
    MyTextField Bound;
    MyTextField Increment;
    Checkbox Fixed;
    Checkbox Close;
    Checkbox Restricted;
    Checkbox Alternate;
    Checkbox Inside;
    IconBar TypeIB;
    ZirkelCanvas ZC;
    Button BoundButton;

    public PointEditDialog(Frame f2, PointObject o) {
        super(f2, Zirkel.name("edit.point.title"), o);
    }

    public PointEditDialog(ZirkelCanvas zc, PointObject o) {
        this(zc.getFrame(), o);
        this.ZC = zc;
    }

    public void addFirst(Panel P) {
        PointObject p = (PointObject)this.O;
        this.X = new TextFieldAction(this, "X", "" + p.round(p.getX()), 30);
        P.add(new MyLabel(Zirkel.name("edit.point.x")));
        P.add(this.X);
        this.Y = new TextFieldAction(this, "Y", "" + p.round(p.getY()), 30);
        P.add(new MyLabel(Zirkel.name("edit.point.y")));
        P.add(this.Y);
        if (p.moveablePoint()) {
            this.Fixed = new Checkbox("");
            this.Fixed.setState(p.fixed());
            P.add(new MyLabel(Zirkel.name("edit.fixed")));
            P.add(this.Fixed);
            if (p.fixed()) {
                this.X.setText(p.getEX());
                this.Y.setText(p.getEY());
            }
            P.add(new MyLabel(Zirkel.name("edit.point.increment")));
            this.Increment = new MyTextField("" + p.round(p.getIncrement()));
            P.add(this.Increment);
        } else {
            this.X.setEditable(false);
            this.Y.setEditable(false);
        }
        if (p instanceof IntersectionObject && ((IntersectionObject)p).isSwitchable()) {
            this.Away = new MyTextField("", 5);
            this.Away.setText(((IntersectionObject)p).away());
            this.Close = new CheckboxAction(this, Zirkel.name("edit.point.close"));
            this.Close.setState(!((IntersectionObject)p).stayAway());
            P.add(new MyLabel(Zirkel.name("edit.point.intersection")));
            MyPanel ap = new MyPanel();
            ap.setLayout(new GridLayout(1, 2));
            ap.add(this.Away);
            ap.add(this.Close);
            P.add(ap);
        }
        if (p instanceof IntersectionObject) {
            P.add(new MyLabel(Zirkel.name("edit.plumb.restricted")));
            this.Restricted = new CheckboxAction(this, "", "Restricted");
            this.Restricted.setState(((IntersectionObject)p).isRestricted());
            P.add(this.Restricted);
            if (((IntersectionObject)p).canAlternate()) {
                P.add(new MyLabel(Zirkel.name("edit.intersection.alternate")));
                this.Alternate = new CheckboxAction(this, "", "Alternate");
                this.Alternate.setState(((IntersectionObject)p).isAlternate());
                P.add(this.Alternate);
            }
        }
        if (p.isPointOn()) {
            P.add(new MyLabel(Zirkel.name("edit.point.bound")));
            this.Bound = new MyTextField(p.getBound().getName());
            P.add(this.Bound);
            this.Bound.setEditable(false);
            if (p.getBound() instanceof InsideObject) {
                P.add(new MyLabel(Zirkel.name("edit.point.inside")));
                this.Inside = new CheckboxAction(this, "", "Inside");
                P.add(this.Inside);
                this.Inside.setState(p.isInside());
            }
            if (this.Fixed != null) {
                this.Fixed.setState(p.useAlpha());
            }
        }
    }

    public void addButton(Panel P) {
        PointObject p = (PointObject)this.O;
        if (p.moveablePoint()) {
            this.BoundButton = p.isPointOn() ? new ButtonAction(this, Zirkel.name("bound.release"), "Release") : new ButtonAction(this, Zirkel.name("bound.bind"), "Bind");
            P.add(this.BoundButton);
            P.add(new MyLabel(" "));
        } else if (p instanceof IntersectionObject && ((IntersectionObject)p).isSwitchable()) {
            P.add(new ButtonAction(this, Zirkel.name("edit.point.away"), "SetAway"));
            P.add(new ButtonAction(this, Zirkel.name("edit.point.close"), "SetClose"));
            if (!((IntersectionObject)p).away().equals("")) {
                P.add(new ButtonAction(this, Zirkel.name("edit.point.free"), "SetFree"));
            }
            P.add(new MyLabel(" "));
        }
    }

    public void addSecond(Panel P) {
        PointObject p = (PointObject)this.O;
        this.TypeIB = new IconBar(this.F);
        this.TypeIB.addToggleGroupLeft("type", 6);
        this.TypeIB.toggle("type", p.getType());
        P.add(new MyLabel(""));
        P.add(this.TypeIB);
    }

    public void doAction(String o) {
        if ((o.equals("Y") || o.equals("X")) && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else if (o.equals("Release")) {
            ((PointObject)this.O).setBound("");
            this.O.getConstruction().updateCircleDep();
            if (this.Fixed != null) {
                this.Fixed.setState(false);
            }
            super.doAction("OK");
        } else if (o.equals("Bind")) {
            this.ZC.bind((PointObject)this.O);
            super.doAction("OK");
        } else if (o.equals("SetAway")) {
            this.ZC.setAway((IntersectionObject)this.O, true);
            super.doAction("OK");
        } else if (o.equals("SetClose")) {
            this.ZC.setAway((IntersectionObject)this.O, false);
            super.doAction("OK");
        } else if (o.equals("SetFree")) {
            ((IntersectionObject)this.O).setAway("");
            this.Away = null;
            super.doAction("OK");
        } else if (o.equals("OK")) {
            if (this.Fixed != null && this.X.isChanged() || this.Y.isChanged()) {
                this.Fixed.setState(true);
            }
            super.doAction("OK");
        } else {
            super.doAction(o);
        }
    }

    public void setAction() {
        double y;
        double x;
        PointObject p = (PointObject)this.O;
        if ((this.X.isChanged() || this.Y.isChanged()) && p.isPointOn()) {
            try {
                x = new Expression(this.X.getText(), p.getConstruction(), p).getValue();
                y = new Expression(this.Y.getText(), p.getConstruction(), p).getValue();
                p.move(x, y);
                p.validate();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.Fixed != null && this.Fixed.getState()) {
            if (p.isPointOn()) {
                p.setUseAlpha(true);
            } else {
                p.setFixed(this.X.getText(), this.Y.getText());
            }
        } else {
            try {
                x = new Expression(this.X.getText(), p.getConstruction(), p).getValue();
                y = new Expression(this.Y.getText(), p.getConstruction(), p).getValue();
                if (p.moveable()) {
                    p.move(x, y);
                }
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        if (this.Fixed != null && !this.Fixed.getState()) {
            if (p.isPointOn()) {
                p.setUseAlpha(false);
            } else {
                p.setFixed(false);
            }
        }
        if (this.Away != null && !((IntersectionObject)p).setAway(this.Away.getText(), !this.Close.getState())) {
            Warning w = new Warning(this.F, Zirkel.name("bound.error"), Zirkel.name("warning"));
            w.center(this.F);
            w.setVisible(true);
        }
        if (this.Restricted != null) {
            ((IntersectionObject)p).setRestricted(this.Restricted.getState());
        }
        if (this.Alternate != null) {
            ((IntersectionObject)p).setAlternate(this.Alternate.getState());
        }
        if (this.Increment != null) {
            try {
                p.setIncrement(new Expression(this.Increment.getText(), p.getConstruction(), p).getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.setType(this.TypeIB.getToggleState("type"));
        if (this.Inside != null) {
            p.setInside(this.Inside.getState());
        }
    }

    public void focusGained(FocusEvent e2) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.X.requestFocus();
        } else {
            super.focusGained(e2);
        }
    }
}

