/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;

public class PlumbObject
extends PrimitiveLineObject
implements MoveableObject {
    PrimitiveLineObject L;
    static Count N = new Count();
    protected boolean Restricted = false;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public PlumbObject(Construction c2, PrimitiveLineObject l, PointObject p) {
        super(c2);
        this.P1 = p;
        this.L = l;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Plumb";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(PlumbObject.text2(Zirkel.name("text.plumb"), this.P1.getName(), this.L.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.L.valid()) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.X1 = this.P1.getX();
            this.Y1 = this.P1.getY();
            this.DX = -this.L.getDY();
            this.DY = this.L.getDX();
            if (this.L instanceof SegmentObject && ((SegmentObject)this.L).getLength() == 0.0) {
                this.Valid = false;
            }
            if (this.Restricted && !this.L.contains(this.X1, this.Y1)) {
                this.Valid = false;
            }
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("point", this.P1.getName());
        xml.printArg("line", this.L.getName());
        if (!this.Restricted) {
            xml.printArg("valid", "true");
        }
        super.printArgs(xml);
    }

    public boolean isRestricted() {
        return this.Restricted;
    }

    public void setRestricted(boolean flag) {
        this.Restricted = flag;
    }

    public boolean canRestrict() {
        return this.L instanceof SegmentObject || this.L instanceof RayObject;
    }

    public void setMainParameter() {
        this.MainParameter = true;
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.L);
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.L = (PrimitiveLineObject)this.L.getTranslation();
    }

    public boolean contains(PointObject p) {
        return p == this.P1;
    }

    public boolean hasUnit() {
        return false;
    }

    public void dragTo(double x, double y) {
        this.P1.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
    }

    public void move(double x, double y) {
    }

    public boolean moveable() {
        return this.P1.moveable();
    }

    public void startDrag(double x, double y) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x3 = x;
        this.y3 = y;
    }

    public double getOldX() {
        return 0.0;
    }

    public double getOldY() {
        return 0.0;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.P1.snap(zc);
        }
    }
}

