/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.QuadricObject;
import rene.zirkel.structures.Coordinates;

public class LineQuadricIntersectionObject
extends IntersectionObject {
    public LineQuadricIntersectionObject(Construction c2, PrimitiveLineObject P1, QuadricObject P2, boolean first) {
        super(c2, P1, P2);
        this.First = first;
        this.validate();
    }

    public void validate() {
        double Y1;
        double X1;
        boolean oldvalid = this.Valid;
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        Coordinates c2 = PrimitiveLineObject.intersect((PrimitiveLineObject)this.P1, (QuadricObject)this.P2);
        if (c2 == null) {
            if (oldvalid && this.getConstruction().shouldSwitch()) {
                this.doSwitch();
                if (!this.getConstruction().noteSwitch()) {
                    this.Switched = false;
                }
            } else if (oldvalid && this.Alternate && this.Away == null && this.getConstruction().canAlternate()) {
                this.First = !this.First;
            }
            this.Valid = false;
            return;
        }
        if (this.getAway() != null) {
            double r1;
            boolean flag;
            double y;
            double x = this.getAway().getX();
            double r = (x - c2.X) * (x - c2.X) + ((y = this.getAway().getY()) - c2.Y) * (y - c2.Y);
            boolean bl = flag = r > (r1 = (x - c2.X1) * (x - c2.X1) + (y - c2.Y1) * (y - c2.Y1));
            if (!this.StayAway) {
                boolean bl2 = flag = !flag;
            }
            if (flag) {
                this.X = c2.X;
                this.Y = c2.Y;
                X1 = c2.X1;
                Y1 = c2.Y1;
            } else {
                this.X = c2.X1;
                this.Y = c2.Y1;
                X1 = c2.X;
                Y1 = c2.Y;
            }
        } else if (this.First) {
            this.X = c2.X;
            this.Y = c2.Y;
            X1 = c2.X1;
            Y1 = c2.Y1;
        } else {
            this.X = c2.X1;
            this.Y = c2.Y1;
            X1 = c2.X;
            Y1 = c2.Y;
        }
        if (this.Restricted && !((PrimitiveLineObject)this.P1).contains(this.X, this.Y)) {
            if (!((PrimitiveLineObject)this.P1).contains(X1, Y1)) {
                this.Valid = false;
            } else {
                this.X = X1;
                this.Y = Y1;
            }
        }
    }

    public void printArgs(XmlWriter xml) {
        super.printArgs(xml);
        if (this.First) {
            xml.printArg("which", "first");
        } else {
            xml.printArg("which", "second");
        }
    }

    public boolean isSwitchable() {
        return true;
    }

    public boolean canAlternate() {
        return true;
    }
}

