/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.TwoPointLineObject;

public class LineObject
extends TwoPointLineObject {
    static Count N = new Count();

    public LineObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, p1, p2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Line";
    }

    public void updateText() {
        this.setText(LineObject.text2(Zirkel.name("text.line"), this.P1.getName(), this.P2.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.R < 1.0E-10) {
            this.Valid = false;
            return;
        }
        this.DX /= this.R;
        this.DY /= this.R;
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        if (!this.Partial || zc.showHidden()) {
            super.paint(g, zc);
            return;
        }
        double xm = (zc.minX() + zc.maxX()) / 2.0;
        double ym = (zc.minY() + zc.maxY()) / 2.0;
        double d2 = (xm - this.X1) * this.DY - (ym - this.Y1) * this.DX;
        double x = xm - d2 * this.DY;
        double y = ym + d2 * this.DX;
        double a2 = Math.max(zc.maxX() - zc.minX(), zc.maxY() - zc.minY());
        if (Math.abs(d2) > a2) {
            return;
        }
        double b2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.k1 = b2 - a2;
        this.k2 = b2 + a2;
        this.k12valid = true;
        double dd = (zc.maxX() - zc.minX()) / 20.0;
        double dmin = -dd;
        double dmax = this.R + dd;
        if (this.Dep != null) {
            for (int i = 0; i < this.NDep; ++i) {
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zc)) continue;
                double s = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                if (s - dd < dmin) {
                    dmin = s - dd;
                    continue;
                }
                if (!(s + dd > dmax)) continue;
                dmax = s + dd;
            }
        }
        if (this.k1 < dmin) {
            this.k1 = dmin;
        }
        if (this.k2 > dmax) {
            this.k2 = dmax;
        }
        double c1 = zc.col(this.X1 + this.k1 * this.DX);
        double c2 = zc.col(this.X1 + this.k2 * this.DX);
        double r1 = zc.row(this.Y1 + this.k1 * this.DY);
        double r2 = zc.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            ((MyGraphics13)g).drawMarkerLine(c1, r1, c2, r2);
        }
        g.setColor(this);
        g.drawLine(c1, r1, c2, r2, this);
        String s = this.getDisplayText();
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double side = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(g, s, zc, this.X1 + this.XcOffset * this.DX, this.Y1 + this.XcOffset * this.DY, side * this.DX, side * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(g, s, zc, this.X1 + this.k2 * this.DX / 2.0, this.Y1 + this.k2 * this.DY / 2.0, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("from", this.P1.getName());
        xml.printArg("to", this.P2.getName());
        super.printArgs(xml);
    }

    public void setDefaults() {
        super.setDefaults();
        this.setPartial(this.Cn.PartialLines);
    }

    public void toggleHidden() {
        if (this.Hidden) {
            this.Partial = false;
            this.Hidden = false;
        } else if (this.Partial) {
            this.Partial = false;
            this.Hidden = true;
        } else {
            this.Partial = true;
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        double y;
        if (!this.displays(zc)) {
            return false;
        }
        if (zc.showHidden() || !this.Partial || this.Dep == null || !this.k12valid) {
            return super.nearto(c2, r, zc);
        }
        double x = zc.x(c2);
        double s = this.project(x, y = zc.y(r));
        if (s < this.k1 || s > this.k2) {
            return false;
        }
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        return this.Value < zc.selectionSize() * 2.0;
    }
}

