/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.macro;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.lister.StringElement;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.CommentDialog;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.macro.MacroMenu;

public class MacroSelectDialog
extends HelpCloseDialog
implements ActionListener {
    Vector Chosen;
    Macro O = null;
    Lister L;
    Frame F;
    MacroMenu MM;
    boolean Multiple;
    TextArea Comment;

    public MacroSelectDialog(Frame f2, MacroMenu mm, boolean multiple) {
        super(f2, Zirkel.name("select.title", "Select Object"), true);
        MacroMenu mmf;
        this.MM = mm;
        if (!multiple && (mmf = this.MM.findWithFullName(Global.getParameter("select.olddir", ""))) != null) {
            this.MM = mmf;
        }
        this.F = f2;
        this.Multiple = multiple;
        this.L = new Lister();
        this.add("Center", this.L);
        this.list();
        this.L.setMode(multiple, multiple, true, false);
        this.L.addActionListener(this);
        MyPanel south = new MyPanel();
        south.setLayout(new BorderLayout());
        this.Comment = new TextArea("", 5, 40, 1);
        south.add("Center", this.Comment);
        this.Comment.setEditable(false);
        MyPanel p = new MyPanel();
        p.add(new ButtonAction(this, Zirkel.name("select.ok"), "OK"));
        if (multiple) {
            p.add(new ButtonAction(this, Zirkel.name("select.all"), "All"));
        }
        p.add(new ButtonAction(this, Zirkel.name("select.cancel"), "Close"));
        this.addHelp(p, "selectmacro");
        south.add("South", p);
        this.add("South", new Panel3D(south));
        this.pack();
        this.center(f2);
        this.Chosen = new Vector();
        this.setSize("macroselect");
    }

    public void actionPerformed(ActionEvent e2) {
        Object o;
        int i;
        int offset;
        int n = offset = this.MM.Father != null ? 1 : 0;
        if (e2.getSource() == this.L && ((ListerMouseEvent)e2).clickCount() == 2) {
            i = this.L.getSelectedIndex();
            if (i < 0) {
                return;
            }
            if (i < offset) {
                this.MM = this.MM.Father;
                this.list();
            } else {
                o = this.MM.getV().elementAt(i - offset);
                if (o instanceof MacroMenu) {
                    this.MM = (MacroMenu)o;
                    this.list();
                } else if (!this.Multiple) {
                    this.doAction("OK");
                }
            }
        }
        if (e2.getSource() == this.L && ((ListerMouseEvent)e2).clickCount() == 1) {
            i = this.L.getSelectedIndex();
            if (i < 0) {
                return;
            }
            if (i >= offset) {
                o = this.MM.getV().elementAt(i - offset);
                if (!(o instanceof MacroMenu)) {
                    MacroItem mi = (MacroItem)o;
                    this.Comment.setText(mi.M.getComment());
                } else {
                    this.Comment.setText("");
                }
            }
        } else {
            super.actionPerformed(e2);
        }
    }

    public void doAction(String o) {
        int offset;
        this.noteSize("macroselect");
        int n = offset = this.MM.Father != null ? 1 : 0;
        if (o.equals("OK")) {
            this.Chosen = new Vector();
            int[] s = this.L.getSelectedIndices();
            for (int i = 0; i < s.length; ++i) {
                if (s[i] < offset) continue;
                Object sel = this.MM.getV().elementAt(s[i] - offset);
                if (sel instanceof MacroItem) {
                    this.Chosen.addElement(sel);
                    continue;
                }
                this.add(this.Chosen, (MacroMenu)sel);
            }
            if (this.Chosen.size() > 0) {
                this.doclose();
                Global.setParameter("select.olddir", this.MM.getFullName());
            }
        } else if (o.equals("All")) {
            for (int i = 0; i < this.MM.getV().size(); ++i) {
                this.L.select(i + offset);
            }
        } else if (o.equals("Comment")) {
            int i = this.L.getSelectedIndex();
            if (i < offset) {
                return;
            }
            Object sel = this.MM.getV().elementAt(i - offset);
            if (sel instanceof MacroItem) {
                new CommentDialog(this.F, ((MacroItem)sel).M.getComment(), Zirkel.name("select.comment.title"), true);
            }
        } else {
            super.doAction(o);
        }
    }

    public Macro getMacro() {
        if (this.Chosen.size() > 0) {
            return ((MacroItem)this.Chosen.elementAt((int)0)).M;
        }
        return null;
    }

    public Vector getMacros() {
        return this.Chosen;
    }

    public void list() {
        this.L.clear();
        if (this.MM.Father != null) {
            this.L.addElement(new StringElement("..", Color.black));
        }
        Enumeration e2 = this.MM.getV().elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof MacroMenu) {
                MacroMenu mm = (MacroMenu)o;
                this.L.addElement(new StringElement("/" + mm.getName(), Color.blue.darker()));
                continue;
            }
            MacroItem mi = (MacroItem)o;
            if (mi.M.isProtected()) {
                this.L.addElement(new StringElement(mi.Name, Color.red.darker()));
                continue;
            }
            this.L.addElement(new StringElement(mi.Name, Color.green.darker()));
        }
        this.L.updateDisplay();
    }

    public void add(Vector v, MacroMenu mm) {
        Enumeration e2 = mm.getV().elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof MacroMenu) {
                this.add(v, (MacroMenu)o);
                continue;
            }
            v.addElement((MacroItem)o);
        }
    }
}

