/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PdfFontMetrics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphicsPDF
extends MyGraphics {
    PrintWriter Out;
    StringBuffer buf;
    StringBuffer xref;
    StringBuffer stream;
    int nxref = 1;
    String prefix = "";
    final int Normal = 0;
    final int Thin = 1;
    final int Thick = 2;
    int Stroke = 0;
    private PdfFontMetrics FM = new PdfFontMetrics(10);
    boolean Bold;
    double W;
    double H;
    double LineWidth;
    Color OldColor = null;
    Color OldFillColor = null;
    public static char[] Translation = new char[]{'a', '\u03b1', 'A', '\u0391', 'b', '\u03b2', 'B', '\u0392', 'c', '\u03b3', 'C', '\u0393', 'd', '\u03b4', 'D', '\u0394', 'e', '\u03b5', 'E', '\u0395', 'f', '\u03d5', 'F', '\u03a6', 'g', '\u03b3', 'G', '\u0393', 'h', '\u03b7', 'H', '\u0397', 'i', '\u03b9', 'I', '\u0399', 'k', '\u03ba', 'K', '\u039a', 'l', '\u03bb', 'L', '\u039b', 'm', '\u03bc', 'M', '\u039c', 'n', '\u03bd', 'N', '\u039d', 'o', '\u03bf', 'O', '\u03a9', 'p', '\u03c0', 'P', '\u03a0', 'q', '\u03c7', 'Q', '\u03a7', 'r', '\u03c1', 'R', '\u03a1', 's', '\u03c3', 'S', '\u03a3', 't', '\u03c4', 'T', '\u03a4', 'u', '\u03c5', 'U', '\u03a5', 'v', '\u03c8', 'V', '\u03a8', 'w', '\u03c9', 'W', '\u03a9', 'x', '\u03be', 'X', '\u039e', 'y', '\u03c7', 'Y', '\u03a7', 'z', '\u03b6', 'Z', '\u0396'};
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsPDF(PrintWriter out, double w, double h, double linewidth) {
        this.Out = out;
        this.LineWidth = linewidth;
        this.W = w;
        this.H = h;
        this.buf = new StringBuffer();
        this.xref = new StringBuffer();
        this.appendxref(0, 65535, false);
        this.appendln("%PDF-1.4");
        this.newObject();
        this.appendln("<< /Type /Catalog");
        this.appendln("   /Outlines 2 0 R");
        this.appendln("   /Pages 3 0 R");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Outlines");
        this.appendln("   /Count 0");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Pages");
        this.appendln("   /Kids [4 0 R]");
        this.appendln("   /Count 1");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Page");
        this.appendln("   /Parent 3 0 R");
        this.appendln("   /MediaBox [0 0 " + w + " " + h + "]");
        this.appendln("   /Contents 5 0 R");
        this.appendln("   /Resources << /ProcSet 6 0 R");
        this.appendln("                 /Font << /F1 7 0 R");
        this.appendln("                          /F2 7 0 R \t\t\t\t\t\t\t\t/F3 7 0 R >>");
        this.appendln("              >>");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.stream = new StringBuffer();
    }

    public void close() {
        this.appendln("<< /Length " + this.stream.length() + " >>");
        this.prefix = "";
        this.appendln("stream");
        this.buf.append(this.stream.toString());
        this.appendln("endstream");
        this.endObject();
        this.newObject();
        this.appendln("[/PDF]");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F1");
        this.appendln("   /BaseFont /Helvetica");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F2");
        this.appendln("   /BaseFont /Symbol");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F3");
        this.appendln("   /BaseFont /Helvetica-Bold");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.appendln("");
        this.appendln("xref");
        int xrefstart = this.buf.length();
        this.appendln("0 " + this.nxref);
        this.buf.append(this.xref.toString());
        this.appendln("");
        this.appendln("trailer");
        this.appendln("<< /Size " + this.nxref);
        this.appendln("   /Root 1 0 R");
        this.appendln(">>");
        this.appendln("");
        this.appendln("startxref");
        this.appendln("" + xrefstart);
        this.appendln("");
        this.appendln("%%EOF");
        this.Out.write(this.buf.toString());
    }

    public void appendln(String s) {
        this.buf.append(this.prefix + s);
        this.buf.append('\r');
        this.buf.append('\n');
    }

    public void streamln(String s) {
        this.stream.append(this.prefix + s);
        this.stream.append('\r');
        this.stream.append('\n');
    }

    public void appendxref(int offset, int number, boolean present) {
        this.xref.append(this.format(offset, 10) + " " + this.format(number, 5) + (present ? " n" : " f"));
        this.xref.append('\r');
        this.xref.append('\n');
    }

    public String format(int n, int size) {
        String s = "" + n;
        while (s.length() < size) {
            s = "0" + s;
        }
        return s;
    }

    public void newObject() {
        int n = this.buf.length();
        this.appendln("");
        this.appendln(this.nxref + " " + 0 + " obj");
        this.appendxref(n, 0, true);
        ++this.nxref;
        this.prefix = "  ";
    }

    public void endObject() {
        this.prefix = "";
        this.appendln("endobj");
    }

    public double r(double x) {
        return (double)Math.round(x * 100.0) / 100.0;
    }

    public double ry(double y) {
        return (double)Math.round((this.H - y) * 100.0) / 100.0;
    }

    public void setStroke(int stroke) {
        if (this.Stroke == stroke) {
            return;
        }
        this.Stroke = stroke;
        switch (this.Stroke) {
            case 0: {
                this.streamln(this.r(this.LineWidth) + " w");
                this.streamln("[] 0 d");
                break;
            }
            case 2: {
                this.streamln(this.r(3.0 * this.LineWidth) + " w");
                this.streamln("[] 0 d");
                break;
            }
            case 1: {
                this.streamln(this.LineWidth + " w");
                this.streamln("[" + this.r(3.0 * this.LineWidth) + " " + this.r(3.0 * this.LineWidth) + "] 0 d");
            }
        }
    }

    public void clearRect(int x, int y, int w, int h, Color c2) {
    }

    public void setColor(Color c2) {
        if (this.OldColor != null && c2.getRed() == this.OldColor.getRed() && c2.getGreen() == this.OldColor.getGreen() && c2.getBlue() == this.OldColor.getBlue()) {
            return;
        }
        this.streamln(this.r((double)c2.getRed() / 255.0) + " " + this.r((double)c2.getGreen() / 255.0) + " " + this.r((double)c2.getBlue() / 255.0) + " rg");
        this.OldColor = c2;
    }

    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.getColorType() == 2) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
        if (o.getColorType() == 2) {
            this.setStroke(1);
        } else if (o.getColorType() == 1) {
            this.setStroke(2);
        } else {
            this.setStroke(0);
        }
    }

    public void setFillColor(Color c2) {
        if (this.OldFillColor != null && c2.getRed() == this.OldFillColor.getRed() && c2.getGreen() == this.OldFillColor.getGreen() && c2.getBlue() == this.OldFillColor.getBlue()) {
            return;
        }
        this.streamln(this.r((double)c2.getRed() / 255.0) + " " + this.r((double)c2.getGreen() / 255.0) + " " + this.r((double)c2.getBlue() / 255.0) + " rg");
        this.OldFillColor = c2;
    }

    public void setFillColor(ConstructionObject o) {
        this.setStroke(0);
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o instanceof PointObject && o.indicated()) {
            this.setFillColor(ZirkelFrame.IndicateColor);
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setFillColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setFillColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setFillColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            int i = o.getColorIndex();
            this.setFillColor(ZirkelFrame.Colors[i]);
            o.setColorType(type);
        } else {
            int type = o.getColorType();
            o.setColorType(0);
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setFillColor(ZirkelFrame.Colors[i]);
            }
            o.setColorType(type);
        }
    }

    public void drawRect(double x, double y, double w, double h) {
        this.streamln(this.r(x) + " " + this.ry(y + h) + " " + this.r(w) + " " + this.r(h) + " " + "re");
        this.streamln("S");
    }

    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        this.streamln(this.r(x) + " " + this.ry(y) + " m");
        this.streamln(this.r(x1) + " " + this.ry(y1) + " l");
        this.streamln("S");
    }

    public void drawLine(double x, double y, double x1, double y1) {
        this.setStroke(0);
        this.streamln(this.r(x) + " " + this.ry(y) + " m");
        this.streamln(this.r(x1) + " " + this.ry(y1) + " l");
        this.streamln("S");
    }

    public void drawThickLine(double x, double y, double x1, double y1) {
        this.setStroke(2);
        this.streamln(this.r(x) + " " + this.ry(y) + " m");
        this.streamln(this.r(x1) + " " + this.ry(y1) + " l");
        this.streamln("S");
        this.setStroke(0);
    }

    public void drawArc(double x, double y, double r, double a2, double b2) {
        double f2 = r / Math.cos(b2 / 3.0);
        this.streamln(this.r(x + Math.cos(a2 + b2 / 3.0) * f2) + " " + this.ry(y - Math.sin(a2 + b2 / 3.0) * f2) + " " + this.r(x + Math.cos(a2 + 2.0 * b2 / 3.0) * f2) + " " + this.ry(y - Math.sin(a2 + 2.0 * b2 / 3.0) * f2) + " " + this.r(x + Math.cos(a2 + b2) * r) + " " + this.ry(y - Math.sin(a2 + b2) * r) + " c");
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        this.setStroke(0);
        double r = w / 2.0;
        x += r;
        y += r;
        a2 = a2 / 180.0 * Math.PI;
        b2 = b2 / 180.0 * Math.PI;
        int n = (int)(r * b2 / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(x + Math.cos(a2) * r) + " " + this.ry(y - Math.sin(a2) * r) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(x, y, r, a2 + (double)i * b2 / (double)n, b2 / (double)n);
        }
        this.streamln("S");
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        double r = w / 2.0;
        x += r;
        y += r;
        a2 = a2 / 180.0 * Math.PI;
        int n = (int)(r * (b2 = b2 / 180.0 * Math.PI) / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(x + Math.cos(a2) * r) + " " + this.ry(y + -Math.sin(a2) * r) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(x, y, r, a2 + (double)i * b2 / (double)n, b2 / (double)n);
        }
        this.streamln("S");
    }

    public void setFont(int size, boolean bold) {
        this.Bold = bold;
        this.FM = new PdfFontMetrics(size);
        this.streamln("/F1 " + size + " Tf");
    }

    public FontMetrics getFontMetrics() {
        if (this.FM == null) {
            this.FM = new PdfFontMetrics(20);
        }
        return this.FM;
    }

    public void drawString(String s, double x, double y) {
        if (s.length() == 1) {
            char c2 = s.charAt(0);
            for (int i = 0; i < Translation.length / 2; ++i) {
                if (Translation[2 * i + 1] != c2) continue;
                this.streamln("BT");
                this.streamln("/F2 " + this.FM.Size + " Tf");
                this.streamln(this.r(x) + " " + this.ry(y) + " Td");
                this.streamln("(" + Translation[2 * i] + ") Tj");
                this.streamln("ET");
                return;
            }
        }
        this.streamln("BT");
        if (this.Bold) {
            this.streamln("/F3 " + this.FM.Size + " Tf");
        } else {
            this.streamln("/F1 " + this.FM.Size + " Tf");
        }
        this.streamln(this.r(x) + " " + this.ry(y) + " Td");
        this.streamln("(" + s + ") Tj");
        this.streamln("ET");
    }

    public void drawOval(double x, double y, double w, double h) {
        this.drawArc(x, y, w, h, 0.0, 360.0);
    }

    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        this.drawArc(x, y, w, h, 0.0, 360.0, o);
    }

    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        if (outline) {
            this.setColor(o);
        }
        this.streamln(this.r(x) + " " + this.ry(y + h) + " " + this.r(w) + " " + this.r(h) + " " + "re");
        this.streamln(outline ? "b" : "f");
    }

    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.fillArc(x, y, w, h, 0.0, 360.0, outline, transparent, true, o);
    }

    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean tranparent, ConstructionObject o) {
        this.setFillColor(o);
        if (outline) {
            this.setColor(o);
        }
        this.streamln(this.r(x[0]) + " " + this.ry(y[0]) + " m");
        for (int i = 1; i < n; ++i) {
            this.streamln(this.r(x[i]) + " " + this.ry(y[i]) + " l");
        }
        this.streamln(outline ? "b*" : "f*");
    }

    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        this.setFillColor(o);
        if (outline) {
            this.setColor(o);
        }
        double r = w / 2.0;
        x += r;
        y += r;
        a2 = a2 * Math.PI / 180.0;
        int n = (int)(r * (b2 = b2 * Math.PI / 180.0) / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(x + Math.cos(a2) * r) + " " + this.ry(y - Math.sin(a2) * r) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(x, y, r, a2 + (double)i * b2 / (double)n, b2 / (double)n);
        }
        if (arc) {
            this.streamln(this.r(x) + " " + this.ry(y) + " l");
        }
        this.streamln(outline ? "b" : "f");
    }

    public void drawImage(Image i, int x, int y, ImageObserver o) {
    }

    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
    }

    public static void main(String[] args) {
        try {
            ConstructionObject o = new ConstructionObject(new Construction());
            PrintWriter out = new PrintWriter(new FileOutputStream("test.pdf"));
            MyGraphicsPDF pdf = new MyGraphicsPDF(out, 1000.0, 1000.0, 1.0);
            pdf.streamln("1 0 0 -1 0 1000 cm");
            pdf.drawRect(300.0, 300.0, 400.0, 400.0);
            for (int i = 0; i < 180; ++i) {
                double s = (double)i / 180.0 * Math.PI;
                double t = (double)(i + 1) / 180.0 * Math.PI;
                pdf.drawLine(500.0 + Math.cos(s) * 200.0, 500.0 + Math.sin(s) * 200.0, 500.0 + Math.cos(s) * 200.0, 500.0 + Math.sin(s) * 200.0);
            }
            pdf.setColor(Color.red);
            pdf.drawArc(-300.0, -300.0, 1000.0, 1000.0, 0.0, 360.0);
            pdf.close();
            out.close();
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(large, bold);
    }

    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }

    public void fillOval(double x, double y, double w, double h, Color WithColor) {
    }

    public void fillRect(double x, double y, double w, double h, Color WithColor) {
    }

    public void drawDiamond(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }

    public void drawDcross(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }
}

