/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.FontStruct;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphics11
extends MyGraphics {
    Graphics G;
    public static int MaxR = 1000000;
    static int[] px = new int[500];
    static int[] py = new int[500];
    int[] xx = new int[64];
    int[] yy = new int[64];
    FontStruct FS = new FontStruct();
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphics11(Graphics g) {
        this.G = g;
    }

    public void clearRect(int x, int y, int w, int h, Color c2) {
        this.G.setColor(c2);
        this.G.fillRect(x, y, w, h);
    }

    public void setColor(Color c2) {
        this.G.setColor(c2);
    }

    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.getColorType() == 2) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setFillColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o instanceof PointObject && o.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    public void drawRect(double x, double y, double w, double h) {
        this.G.drawRect((int)x, (int)y, (int)w, (int)h);
    }

    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickLine(x, y, x1, y1);
        } else {
            this.drawLine(x, y, x1, y1);
        }
    }

    public void drawLine(double x, double y, double x1, double y1) {
        this.G.drawLine((int)x, (int)y, (int)x1, (int)y1);
    }

    public void drawThickLine(double c1, double r1, double c2, double r2) {
        this.drawLine(c1 + 1.0, r1, c2 + 1.0, r2);
        this.drawLine(c1 - 1.0, r1, c2 - 1.0, r2);
        this.drawLine(c1, r1 + 1.0, c2, r2 + 1.0);
        this.drawLine(c1, r1 - 1.0, c2, r2 - 1.0);
        this.drawLine(c1, r1, c2, r2);
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        int aa = (int)a2;
        int bb = (int)(a2 + b2 + 1.0);
        if (w < (double)MaxR) {
            this.G.drawArc((int)x, (int)y, (int)w, (int)h, aa, bb - aa);
        } else if (b2 < 1.0) {
            double x1 = x + w / 2.0;
            double y1 = y + h / 2.0;
            double r = w / 2.0;
            double r2 = h / 2.0;
            int ia = (int)(x1 + Math.cos(a2 / 180.0 * Math.PI) * r);
            int ja = (int)(y1 - Math.sin(a2 / 180.0 * Math.PI) * r2);
            int ib = (int)(x1 + Math.cos((a2 + b2) / 180.0 * Math.PI) * r);
            int jb = (int)(y1 - Math.sin((a2 + b2) / 180.0 * Math.PI) * r2);
            this.drawLine(ia, ja, ib, jb);
        }
    }

    public void drawThickArc(double x, double y, double w, double h, double a2, double b2) {
        this.drawArc(x - 1.0, y - 1.0, w + 2.0, w + 2.0, a2, b2);
        this.drawArc(x + 1.0, y + 1.0, w - 2.0, w - 2.0, a2, b2);
        this.drawArc(x, y, w, h, a2, b2);
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickArc(x, y, w, h, a2, b2);
        } else {
            this.drawArc(x, y, w, h, a2, b2);
        }
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawString(String s, double x, double y) {
        this.G.drawString(s, (int)x, (int)y);
    }

    public void drawOval(double x, double y, double w, double h) {
        if (w < (double)MaxR) {
            this.G.drawOval((int)x, (int)y, (int)w, (int)h);
        }
    }

    public void drawThickOval(double x, double y, double w, double h) {
        this.drawOval(x, y, w, h);
        this.drawOval(x - 1.0, y - 1.0, w + 2.0, h + 2.0);
        this.drawOval(x + 1.0, y + 1.0, w - 2.0, h - 2.0);
    }

    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        this.setColor(o);
        if (o.getColorType() == 1) {
            this.drawThickOval(x, y, w, h);
        } else {
            this.drawOval(x, y, w, h);
        }
    }

    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        this.G.fillRect((int)x, (int)y, (int)w, (int)h);
        if (outline) {
            this.setColor(o);
            this.G.drawRect((int)x, (int)y, (int)w, (int)h);
        }
    }

    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        int aa = (int)a2;
        int bb = (int)(a2 + b2 + 1.0);
        if (w >= (double)MaxR) {
            return;
        }
        this.setFillColor(o);
        if (arc) {
            this.G.fillArc((int)x, (int)y, (int)(w + 1.0), (int)(h + 1.0), aa, bb - aa);
        } else {
            double t = a2 / 180.0 * Math.PI;
            double a1 = (a2 + b2) / 180.0 * Math.PI;
            MyGraphics11.px[0] = (int)((x += w / 2.0) + w / 2.0 * Math.cos(t));
            MyGraphics11.py[0] = (int)((y += w / 2.0) - h / 2.0 * Math.sin(t));
            int i = 1;
            while (t < a1) {
                MyGraphics11.px[i] = (int)(x + w / 2.0 * Math.cos(t += 0.01282282715750936));
                MyGraphics11.py[i] = (int)(y - h / 2.0 * Math.sin(t));
                if (++i < 499) continue;
            }
            MyGraphics11.px[i] = (int)(x + w / 2.0 * Math.cos((a2 + b2) / 180.0 * Math.PI));
            MyGraphics11.py[i] = (int)(y - h / 2.0 * Math.sin((a2 + b2) / 180.0 * Math.PI));
            this.G.fillPolygon(px, py, ++i);
            x -= w / 2.0;
            y -= w / 2.0;
        }
        if (outline) {
            this.setColor(o);
            this.G.drawArc((int)x, (int)y, (int)w, (int)h, aa, bb - aa);
        }
    }

    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        if (w >= (double)MaxR) {
            return;
        }
        if (o.getColorType() != 3) {
            this.setFillColor(o);
            this.G.fillOval((int)x, (int)y, (int)(w + 1.0), (int)(h + 1.0));
        }
        if (outline) {
            this.setColor(o);
            this.G.drawOval((int)x, (int)y, (int)w, (int)h);
        }
    }

    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        int i;
        this.setFillColor(o);
        for (i = 0; i < n; ++i) {
            this.xx[i] = (int)x[i];
        }
        for (i = 0; i < n; ++i) {
            this.yy[i] = (int)y[i];
        }
        if (o.getColorType() != 3) {
            this.G.fillPolygon(this.xx, this.yy, n);
        }
        if (outline) {
            this.setColor(o);
            this.G.drawPolygon(this.xx, this.yy, n);
        }
    }

    public void drawImage(Image i, int x, int y, ImageObserver o) {
        this.G.drawImage(i, x, y, o);
    }

    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
        this.G.drawImage(i, x, y, w, h, o);
    }

    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    public void setFont(int h, boolean bold) {
        Font f2 = this.FS.getFont(h, bold);
        if (f2 != null) {
            this.G.setFont(f2);
        } else {
            f2 = new Font(Global.getParameter("font.name", "dialog"), bold ? 1 : 0, h);
            this.FS.storeFont(h, bold, f2);
            this.G.setFont(f2);
        }
    }

    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(large, bold);
    }

    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    public Graphics getGraphics() {
        return this.G;
    }

    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String s) {
        return 0;
    }

    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public void fillOval(double x, double y, double w, double h, Color WithColor) {
    }

    public void fillRect(double x, double y, double w, double h, Color WithColor) {
    }

    public void drawDiamond(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }

    public void drawDcross(double x, double y, double w, boolean isThick, ConstructionObject o) {
    }
}

