/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.UserFunctionObject;

class UserFunctionExpression
extends BasicExpression {
    ConstructionObject F;
    BasicExpression[] E;
    double[] X;

    public UserFunctionExpression(ConstructionObject f2, BasicExpression[] e2) {
        this.F = f2;
        this.E = e2;
        this.X = new double[this.E.length];
    }

    public double getValue() throws ConstructionException {
        for (int i = 0; i < this.E.length; ++i) {
            this.X[i] = this.E[i].getValue();
        }
        if (this.F instanceof FunctionObject) {
            return ((FunctionObject)this.F).evaluateF(this.X);
        }
        return ((UserFunctionObject)this.F).evaluateF(this.X);
    }

    public void translate() {
        for (int i = 0; i < this.E.length; ++i) {
            this.E[i].translate();
        }
        this.F = this.F instanceof FunctionObject ? (FunctionObject)this.F.getTranslation() : (UserFunctionObject)this.F.getTranslation();
    }

    public void reset() {
        for (int i = 0; i < this.E.length; ++i) {
            this.E[i].reset();
        }
    }

    public String toString() {
        String ex = this.E[0].toString();
        for (int i = 1; i < this.E.length; ++i) {
            ex = ex + "," + this.E[i].toString();
        }
        return this.F.getName() + "(" + ex + ")";
    }
}

