/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.FunctionObject;

public class Secant {
    public static double compute(FunctionObject F, double a2, double b2, double eps) throws ConstructionException {
        double ay = F.evaluateF(a2);
        double by = F.evaluateF(b2);
        double c2 = (a2 + b2) / 2.0;
        if (ay * by > eps) {
            throw new ConstructionException("");
        }
        while (Math.abs(b2 - a2) > eps) {
            double d2;
            double cy = F.evaluateF(c2);
            if (Math.abs(cy) < eps) {
                return c2;
            }
            if (cy * ay > 0.0) {
                if (Math.abs(ay - cy) < eps) {
                    a2 = c2;
                    ay = cy;
                    c2 = (a2 + b2) / 2.0;
                    continue;
                }
                d2 = a2 - ay * (a2 - c2) / (ay - cy);
                if (d2 > b2 || d2 < a2) {
                    a2 = c2;
                    ay = cy;
                    c2 = (a2 + b2) / 2.0;
                    continue;
                }
                a2 = c2;
                ay = cy;
                c2 = d2;
                continue;
            }
            d2 = a2 - ay * (a2 - c2) / (ay - cy);
            b2 = c2;
            by = cy;
            c2 = d2;
        }
        return c2;
    }
}

