/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

public class Quartic {
    public static int solve(double[] c2, double[] sol) {
        int k;
        double sum = 0.0;
        for (k = 0; k < c2.length; ++k) {
            sum += Math.abs(c2[k]);
        }
        if (sum < 1.0E-15) {
            sol[0] = 0.0;
            return 1;
        }
        k = 0;
        while (k < c2.length) {
            int n = k++;
            c2[n] = c2[n] / sum;
        }
        int n = 4;
        while (Math.abs(c2[n]) < 1.0E-15) {
            --n;
        }
        if (n == 4) {
            double[] soli = new double[4];
            return Quartic.quartic(c2, sol, soli);
        }
        if (n == 3) {
            return Quartic.cubic(c2, sol);
        }
        if (n == 2) {
            double a2 = -c2[1] / (2.0 * c2[2]);
            double r = a2 * a2 - c2[0] / c2[2];
            if (r < -1.0E-10) {
                return 0;
            }
            if (Math.abs(r) < 1.0E-10) {
                sol[0] = a2;
                return 1;
            }
            sol[0] = a2 + Math.sqrt(r);
            sol[1] = a2 - Math.sqrt(r);
            return 2;
        }
        if (n == 1) {
            sol[0] = -c2[0] / c2[1];
            return 1;
        }
        if (Math.abs(c2[0]) < 1.0E-10) {
            sol[0] = 0.0;
            return 1;
        }
        return 0;
    }

    static int quartic(double[] dd, double[] sol, double[] soli) {
        int i;
        double[] AA = new double[4];
        double[] z = new double[3];
        int Nsol = 0;
        if (dd[4] == 0.0) {
            return 0;
        }
        double a2 = dd[4];
        double b2 = dd[3];
        double c2 = dd[2];
        double d2 = dd[1];
        double f2 = dd[0];
        double p = (-3.0 * Math.pow(b2, 2.0) + 8.0 * a2 * c2) / (8.0 * Math.pow(a2, 2.0));
        double q = (Math.pow(b2, 3.0) - 4.0 * a2 * b2 * c2 + 8.0 * d2 * Math.pow(a2, 2.0)) / (8.0 * Math.pow(a2, 3.0));
        double r = (-3.0 * Math.pow(b2, 4.0) + 16.0 * a2 * Math.pow(b2, 2.0) * c2 - 64.0 * Math.pow(a2, 2.0) * b2 * d2 + 256.0 * Math.pow(a2, 3.0) * f2) / (256.0 * Math.pow(a2, 4.0));
        AA[3] = 8.0;
        AA[2] = -4.0 * p;
        AA[1] = -8.0 * r;
        AA[0] = 4.0 * p * r - Math.pow(q, 2.0);
        int ncube = Quartic.cubic(AA, z);
        double zsol = -1.0E99;
        for (i = 0; i < ncube; ++i) {
            zsol = Math.max(zsol, z[i]);
        }
        z[0] = zsol;
        double xK2 = 2.0 * z[0] - p;
        double xK = Math.sqrt(xK2);
        double xL = q / (2.0 * xK);
        double sqp = xK2 - 4.0 * (z[0] + xL);
        double sqm = xK2 - 4.0 * (z[0] - xL);
        for (i = 0; i < 4; ++i) {
            soli[i] = 0.0;
        }
        if (sqp >= 0.0 && sqm >= 0.0) {
            sol[0] = 0.5 * (xK + Math.sqrt(sqp));
            sol[1] = 0.5 * (xK - Math.sqrt(sqp));
            sol[2] = 0.5 * (-xK + Math.sqrt(sqm));
            sol[3] = 0.5 * (-xK - Math.sqrt(sqm));
            Nsol = 4;
        } else if (sqp >= 0.0 && sqm < 0.0) {
            sol[0] = 0.5 * (xK + Math.sqrt(sqp));
            sol[1] = 0.5 * (xK - Math.sqrt(sqp));
            sol[2] = -0.5 * xK;
            sol[3] = -0.5 * xK;
            soli[2] = Math.sqrt(-0.25 * sqm);
            soli[3] = -Math.sqrt(-0.25 * sqm);
            Nsol = 2;
        } else if (sqp < 0.0 && sqm >= 0.0) {
            sol[0] = 0.5 * (-xK + Math.sqrt(sqm));
            sol[1] = 0.5 * (-xK - Math.sqrt(sqm));
            sol[2] = 0.5 * xK;
            sol[3] = 0.5 * xK;
            soli[2] = Math.sqrt(-0.25 * sqp);
            soli[3] = -Math.sqrt(-0.25 * sqp);
            Nsol = 2;
        } else if (sqp < 0.0 && sqm < 0.0) {
            sol[0] = -0.5 * xK;
            sol[1] = -0.5 * xK;
            soli[0] = Math.sqrt(-0.25 * sqm);
            soli[1] = -Math.sqrt(-0.25 * sqm);
            sol[2] = 0.5 * xK;
            sol[3] = 0.5 * xK;
            soli[2] = Math.sqrt(-0.25 * sqp);
            soli[3] = -Math.sqrt(-0.25 * sqp);
            Nsol = 0;
        }
        i = 0;
        while (i < 4) {
            int n = i++;
            sol[n] = sol[n] - b2 / (4.0 * a2);
        }
        return Nsol;
    }

    public static int cubic(double[] A, double[] X) {
        int L2;
        int i;
        double DIS;
        double P;
        double PI = Math.PI;
        double THIRD = 0.3333333333333333;
        double[] U = new double[3];
        if (A[3] != 0.0) {
            double W = A[2] / A[3] * 0.3333333333333333;
            P = Math.pow(A[1] / A[3] * 0.3333333333333333 - Math.pow(W, 2.0), 3.0);
            double Q = -0.5 * (2.0 * Math.pow(W, 3.0) - (A[1] * W - A[0]) / A[3]);
            DIS = Math.pow(Q, 2.0) + P;
            if (DIS < 0.0) {
                double PHI = Math.acos(Math.min(1.0, Math.max(-1.0, Q / Math.sqrt(-P))));
                P = 2.0 * Math.pow(-P, 0.16666666666666666);
                for (i = 0; i < 3; ++i) {
                    U[i] = P * Math.cos((PHI + 2.0 * (double)i * Math.PI) * 0.3333333333333333) - W;
                }
                X[0] = Math.min(U[0], Math.min(U[1], U[2]));
                X[1] = Math.max(Math.min(U[0], U[1]), Math.max(Math.min(U[0], U[2]), Math.min(U[1], U[2])));
                X[2] = Math.max(U[0], Math.max(U[1], U[2]));
                L2 = 3;
            } else {
                DIS = Math.sqrt(DIS);
                X[0] = Quartic.CBRT(Q + DIS) + Quartic.CBRT(Q - DIS) - W;
                L2 = 1;
            }
        } else if (A[2] != 0.0) {
            P = 0.5 * A[1] / A[2];
            DIS = Math.pow(P, 2.0) - A[0] / A[2];
            if (DIS > 0.0) {
                X[0] = -P - Math.sqrt(DIS);
                X[1] = -P + Math.sqrt(DIS);
                L2 = 2;
            } else {
                L2 = 0;
            }
        } else if (A[1] != 0.0) {
            X[0] = A[0] / A[1];
            L2 = 1;
        } else {
            L2 = 0;
        }
        for (i = 0; i < L2; ++i) {
            X[i] = X[i] - (A[0] + X[i] * (A[1] + X[i] * (A[2] + X[i] * A[3]))) / (A[1] + X[i] * (2.0 * A[2] + X[i] * 3.0 * A[3]));
        }
        return L2;
    }

    static double CBRT(double Z) {
        double THIRD = 0.3333333333333333;
        if (Z > 0.0) {
            return Math.pow(Z, 0.3333333333333333);
        }
        if (Z < 0.0) {
            return -Math.pow(Math.abs(Z), 0.3333333333333333);
        }
        return 0.0;
    }

    public static void main(String[] args) {
        double[] a2 = new double[]{0.0, 3.0, -3.0, -6.0, 5.0};
        double[] x = new double[5];
        double[] y = new double[5];
        int n = Quartic.quartic(a2, x, y);
        System.out.println(n + " solutions!");
        for (int i = 0; i < n; ++i) {
            System.out.println(x[i]);
        }
    }
}

