/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.NotExpression;

class AndExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public AndExpression(BasicExpression e1, BasicExpression e2) {
        this.E1 = e1;
        this.E2 = e2;
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        BasicExpression E1 = NotExpression.scan(t);
        if (t.next() == '&') {
            t.advance();
            if (t.next(true) == '&') {
                t.advance();
            }
            return AndExpression.scan(t, E1);
        }
        return E1;
    }

    public static BasicExpression scan(ExpressionText t, BasicExpression E) throws ConstructionException {
        BasicExpression E1 = NotExpression.scan(t);
        if (t.next() == '&') {
            t.advance();
            return AndExpression.scan(t, new AndExpression(E, E1));
        }
        return new AndExpression(E, E1);
    }

    public double getValue() throws ConstructionException {
        if (this.E1.getValue() != 0.0 && this.E2.getValue() != 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "&&" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }

    public boolean isLogical() {
        return true;
    }
}

