/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;

public class SizesDialog
extends HelpCloseDialog {
    ZirkelFrame ZF;
    TextField Pointsize;
    TextField Linewidth;
    TextField Arrowsize;
    TextField Selectionsize;
    TextField Fontsize;

    public SizesDialog(ZirkelFrame zf) {
        super(zf, Zirkel.name("sizesdialog.title"), true);
        this.ZF = zf;
        this.setLayout(new BorderLayout());
        MyPanel center = new MyPanel();
        center.setLayout(new GridLayout(0, 2));
        this.Pointsize = this.addfield(center, "minpointsize.prompt", "minpointsize", 3.0);
        this.Linewidth = this.addfield(center, "minlinesize.prompt", "minlinesize", 1.0);
        this.Fontsize = this.addfield(center, "minfontsize.prompt", "minfontsize", 12.0);
        this.Selectionsize = this.addfield(center, "selectionsize.prompt", "selectionsize", 1.5);
        this.Arrowsize = this.addfield(center, "arrowsize.prompt", "arrowsize", 15.0);
        this.add("Center", new Panel3D(center));
        MyPanel p = new MyPanel();
        ButtonAction b2 = new ButtonAction(this, Zirkel.name("edit.ok"), "OK");
        p.add(b2);
        b2 = new ButtonAction(this, Zirkel.name("edit.cancel"), "Close");
        p.add(b2);
        b2.addActionListener(this);
        this.addHelp(p, "sizes");
        this.add("South", new Panel3D(p));
        this.center();
        this.pack();
        this.setVisible(true);
    }

    public void doAction(String o) {
        if (o.equals("OK")) {
            this.set(this.Pointsize, "minpointsize", 0.5, 10.0);
            this.set(this.Linewidth, "minlinesize", 0.5, 3.0);
            this.set(this.Fontsize, "minfontsize", 2.0, 30.0);
            this.set(this.Arrowsize, "arrowsize", 5.0, 50.0);
            this.set(this.Selectionsize, "selectionsize", 0.5, 5.0);
            this.doclose();
        } else {
            super.doAction(o);
        }
    }

    public TextField addfield(Panel p, String tag, String deftag, double def) {
        p.add(new MyLabel(Global.name(tag)));
        MyTextField t = new MyTextField("" + Global.getParameter(deftag, def), 20);
        p.add(t);
        return t;
    }

    public void set(TextField t, String tag, double min, double max) {
        try {
            double x = new Double(t.getText());
            if (x < min) {
                x = min;
            }
            if (x > max) {
                x = max;
            }
            Global.setParameter(tag, x);
        }
        catch (Exception e2) {
            // empty catch block
        }
    }
}

