/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.Panel3D;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.TextObject;

public class Replay
extends CloseDialog
implements IconBarListener {
    ZirkelCanvas ZC;
    int Last;
    Construction C;
    Vector V;
    IconBar IB;
    boolean HaveBreaks;
    ConstructionObject O = null;

    public Replay(Frame f2, ZirkelCanvas zc) {
        super(f2, Global.name("replay.title"), true);
        this.ZC = zc;
        this.getContentPane().add(new ButtonAction(this, "Vor"));
        this.getContentPane().setLayout(new BorderLayout());
        this.IB = new IconBar(f2);
        this.IB.addLeft("allback");
        this.IB.addLeft("fastback");
        this.IB.addLeft("oneback");
        this.IB.addLeft("oneforward");
        this.IB.addLeft("fastforward");
        this.IB.addLeft("allforward");
        this.IB.addSeparatorLeft();
        this.IB.addLeft("nextbreak");
        this.IB.addToggleLeft("setbreak");
        this.IB.addSeparatorLeft();
        this.IB.addLeft("close");
        this.IB.setIconBarListener(this);
        this.getContentPane().add("Center", new Panel3D(this.IB));
        this.C = zc.getConstruction();
        this.V = new Vector();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.mustHide(this.ZC) && !o.isBreakHide() && (!(o instanceof TextObject) || !o.valid() || o.isSuperHidden())) continue;
            this.V.addElement(o);
        }
        this.HaveBreaks = this.haveBreaks();
        this.Last = 0;
        this.setLast();
        this.setEnabled(true);
        this.pack();
        Dimension d2 = f2.getSize();
        Dimension ds = this.getSize();
        Point l = f2.getLocation();
        this.setLocation(l.x + d2.width - ds.width - 5, l.y + d2.height / 5);
    }

    public void iconPressed(String o) {
        if (o.equals("close")) {
            this.doclose();
        } else if (o.equals("allback")) {
            this.Last = 0;
            this.setLast();
        } else if (o.equals("allforward")) {
            this.Last = this.V.size();
            this.setLast();
        } else if (o.equals("fastback")) {
            this.Last -= 10;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        } else if (o.equals("fastforward")) {
            this.Last += 10;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (o.equals("oneforward")) {
            ++this.Last;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (o.equals("nextbreak")) {
            do {
                ++this.Last;
                if (this.Last <= this.V.size()) continue;
                this.Last = this.V.size();
                break;
            } while (this.Last < this.V.size() && (this.Last <= 0 || !((ConstructionObject)this.V.elementAt(this.Last)).isBreak()));
            this.setLast();
        } else if (o.equals("setbreak")) {
            if (this.Last > 0) {
                ConstructionObject ob;
                ob.setBreak(!(ob = (ConstructionObject)this.V.elementAt(this.Last)).isBreak());
                this.IB.setState("setbreak", ob.isBreak());
                if (ob.isBreak() && this.IB.isShiftPressed()) {
                    ob.setHideBreak(true);
                }
            }
            this.HaveBreaks = this.haveBreaks();
            this.IB.setEnabled("nextbreak", this.HaveBreaks);
        } else if (o.equals("oneback")) {
            --this.Last;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        }
        this.start();
    }

    public void start() {
        if (this.Last == 0) {
            this.IB.setEnabled("allback", false);
            this.IB.setEnabled("fastback", false);
            this.IB.setEnabled("oneback", false);
        } else {
            this.IB.setEnabled("allback", true);
            this.IB.setEnabled("fastback", true);
            this.IB.setEnabled("oneback", true);
        }
        if (this.Last < this.V.size()) {
            this.IB.setEnabled("allforward", true);
            this.IB.setEnabled("fastforward", true);
            this.IB.setEnabled("oneforward", true);
        } else {
            this.IB.setEnabled("allforward", false);
            this.IB.setEnabled("fastforward", false);
            this.IB.setEnabled("oneforward", false);
        }
    }

    public void doclose() {
        this.ZC.paintUntil(null);
        this.ZC.showStatus();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof TextObject)) continue;
            ((TextObject)o).setDoShow(false);
        }
        this.ZC.repaint();
        super.doclose();
    }

    public void checkLast() {
        if (this.O != null) {
            ((TextObject)this.O).setDoShow(false);
        }
        this.O = null;
        if (this.Last > this.V.size() - 1) {
            return;
        }
        this.O = (ConstructionObject)this.V.elementAt(this.Last);
        if (this.O != null && this.O instanceof TextObject) {
            ((TextObject)this.O).setDoShow(true);
        } else {
            this.O = null;
        }
    }

    public void setLast() {
        ConstructionObject o;
        if (this.Last < this.V.size()) {
            o = (ConstructionObject)this.V.elementAt(this.Last);
            this.checkLast();
            this.ZC.paintUntil(o);
        } else {
            this.Last = this.V.size();
            this.checkLast();
            this.ZC.paintUntil(null);
        }
        if (this.Last >= 0 && this.Last < this.V.size()) {
            o = (ConstructionObject)this.V.elementAt(this.Last);
            this.ZC.showStatus(o.getName() + " : " + o.getText());
            this.IB.setState("setbreak", o.isBreak());
        } else {
            this.IB.setState("setbreak", false);
        }
        if (this.Last >= this.V.size() || this.Last == 0) {
            this.IB.setEnabled("setbreak", false);
        } else {
            this.IB.setEnabled("setbreak", true);
        }
        if (this.Last >= this.V.size() || !this.HaveBreaks) {
            this.IB.setEnabled("nextbreak", false);
        } else {
            this.IB.setEnabled("nextbreak", true);
        }
    }

    public boolean haveBreaks() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (!((ConstructionObject)e2.nextElement()).isBreak()) continue;
            return true;
        }
        return false;
    }
}

