/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;

public class EditRunDialog
extends HelpCloseDialog {
    String Filename;
    ZirkelFrame ZF;
    TextArea Text;

    public EditRunDialog(ZirkelFrame zf, String filename) {
        super(zf, Zirkel.name("editrun.title"), true);
        this.Filename = filename;
        this.ZF = zf;
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.add(new MyLabel(filename));
        this.add("North", new Panel3D(north));
        this.Text = new TextArea(30, 60);
        this.add("Center", new Panel3D(this.Text));
        if (Global.FixedFont != null) {
            this.Text.setFont(Global.FixedFont);
        }
        this.load(filename);
        MyPanel south = new MyPanel();
        south.add(new ButtonAction(this, Zirkel.name("editrun.run"), "Run"));
        south.add(new ButtonAction(this, Zirkel.name("editrun.load"), "Load"));
        south.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(south, "visual");
        this.add("South", new Panel3D(south));
        this.setSize("editrun");
        this.center(zf);
    }

    public void doAction(String s) {
        this.noteSize("editrun");
        if (s.equals("Run")) {
            this.doclose();
            try {
                this.save(this.Filename);
            }
            catch (Exception e2) {
                Warning w = new Warning((Frame)this.ZF, Zirkel.name("editrun.error"), Zirkel.name("warning"), true);
                w.center(this.ZF);
                w.setVisible(true);
                return;
            }
            this.ZF.loadRun(this.Filename);
        } else if (s.equals("Load")) {
            this.doclose();
            this.ZF.editRun("");
        } else {
            super.doAction(s);
        }
    }

    public void load(String filename) {
        this.Text.setText("");
        this.Text.setEnabled(false);
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            while ((line = in.readLine()) != null) {
                this.Text.append(line + "\n");
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Text.setEnabled(true);
        this.Text.repaint();
    }

    public void save(String filename) throws IOException {
        String text = this.Text.getText();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));
        out.print(text);
        out.close();
    }
}

