/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;

public class EditConditionals
extends HelpCloseDialog
implements ActionListener {
    TextField[] Colors = new TextField[ColorStrings.length];
    TextField[] ColorTypes = new TextField[ColorTypeStrings.length];
    TextField Hidden;
    TextField SuperHidden;
    TextField ShowName;
    TextField ShowValue;
    TextField Background;
    TextField Solid;
    TextField Z;
    ConstructionObject O;
    Vector V;
    Frame F;
    public static String[] ColorTypeStrings = new String[]{"normal", "thick", "thin", "invisible"};
    public static String[] ColorStrings = new String[]{"black", "green", "blue", "brown", "cyan", "red"};

    public EditConditionals(Frame f2, ConstructionObject o, Vector v) {
        super(f2, o == null ? Zirkel.name("editconditionals.title") : Zirkel.name("editconditionals.title") + " : " + o.getName(), true);
        Expression ex;
        int i;
        this.O = o;
        this.F = f2;
        if (this.O == null) {
            this.O = o = (ConstructionObject)v.elementAt(0);
        }
        if (v == null) {
            this.V = new Vector();
            this.V.addElement(o);
        } else {
            this.V = v;
        }
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new GridLayout(0, 2));
        for (i = 0; i < ColorStrings.length; ++i) {
            north.add(new MyLabel(Zirkel.name("colors." + ColorStrings[i])));
            this.Colors[i] = new MyTextField("", 32);
            ex = o.getConditional(ColorStrings[i]);
            if (ex != null) {
                this.Colors[i].setText(ex.toString());
            }
            north.add(this.Colors[i]);
        }
        for (i = 0; i < ColorTypeStrings.length; ++i) {
            north.add(new MyLabel(Zirkel.name("color.type." + ColorTypeStrings[i])));
            this.ColorTypes[i] = new MyTextField("", 32);
            ex = o.getConditional(ColorTypeStrings[i]);
            if (ex != null) {
                this.ColorTypes[i].setText(ex.toString());
            }
            north.add(this.ColorTypes[i]);
        }
        this.Hidden = this.addConditional(north, "hidden");
        this.SuperHidden = this.addConditional(north, "superhidden");
        this.ShowName = this.addConditional(north, "showname");
        this.ShowValue = this.addConditional(north, "showvalue");
        this.Background = this.addConditional(north, "background");
        this.Solid = this.addConditional(north, "solid");
        this.Z = this.addConditional(north, "z");
        this.add("North", new Panel3D(north));
        MyPanel south = new MyPanel();
        south.add(new ButtonAction(this, Zirkel.name("cancel"), "Close"));
        south.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        this.addHelp(south, "conditions");
        this.add("South", new Panel3D(south));
        this.pack();
        this.center(f2);
        this.setVisible(true);
    }

    public EditConditionals(Frame f2, Vector v) {
        this(f2, null, v);
    }

    public EditConditionals(Frame f2, ConstructionObject o) {
        this(f2, o, null);
    }

    public TextField addConditional(Panel north, String tag) {
        north.add(new MyLabel(Zirkel.name("editconditionals." + tag)));
        MyTextField H = new MyTextField("", 32);
        Expression ex = this.O.getConditional(tag);
        if (ex != null) {
            H.setText(ex.toString());
        }
        north.add(H);
        return H;
    }

    public void doAction(String o) {
        if (o.equals("OK")) {
            Enumeration en = this.V.elements();
            while (en.hasMoreElements()) {
                int i;
                this.O = (ConstructionObject)en.nextElement();
                this.O.clearConditionals();
                for (i = 0; i < ColorStrings.length; ++i) {
                    this.setConditional(ColorStrings[i], this.Colors[i]);
                }
                for (i = 0; i < ColorTypeStrings.length; ++i) {
                    this.setConditional(ColorTypeStrings[i], this.ColorTypes[i]);
                }
                this.setConditional("hidden", this.Hidden);
                this.setConditional("superhidden", this.SuperHidden);
                this.setConditional("showname", this.ShowName);
                this.setConditional("showvalue", this.ShowValue);
                this.setConditional("background", this.Background);
                this.setConditional("solid", this.Solid);
                this.setConditional("z", this.Z);
                try {
                    this.O.checkConditionals();
                }
                catch (ConstructionException e2) {
                    Warning w = new Warning(this.F, e2.getDescription(), Zirkel.name("warning"), true);
                    w.center(this.F);
                    w.setVisible(true);
                    return;
                }
            }
            this.doclose();
        } else {
            super.doAction(o);
        }
    }

    public void setConditional(String tag, TextField t) {
        if (!t.getText().trim().equals("")) {
            this.O.addConditional(tag, new Expression(t.getText().trim(), this.O.getConstruction(), this.O, null, false));
        }
    }
}

