/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;

public class DefineMacro
extends HelpCloseDialog {
    TextField Name;
    TextField PromptFor;
    TextArea Comment;
    ZirkelCanvas ZC;
    Vector V;
    boolean Aborted = true;
    Checkbox TargetsOnly;
    Checkbox Invisible;
    Checkbox HideDuplicates;

    public DefineMacro(Frame f2, ZirkelCanvas zc) {
        super(f2, Zirkel.name("definemacro.title"), true);
        MyPanel ph;
        this.ZC = zc;
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new GridLayout(0, 2));
        north.add(new MyLabel(Zirkel.name("definemacro.name")));
        this.Name = new TextFieldAction((DoActionListener)this, "", 20);
        north.add(this.Name);
        this.add("North", new Panel3D(north));
        MyPanel center = new MyPanel();
        center.setLayout(new BorderLayout());
        center.add("North", new MyLabel(Zirkel.name("definemacro.comment")));
        this.Comment = new TextArea("", 5, 40, 1);
        center.add("Center", this.Comment);
        if (Global.Background != null) {
            this.Comment.setBackground(Global.Background);
        }
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(0, 1));
        p.add(new MyLabel(Zirkel.name("definemacro.parameters")));
        Enumeration e2 = this.ZC.getConstruction().getParameters().elements();
        this.V = new Vector();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            TextFieldAction tf = new TextFieldAction((DoActionListener)this, "", o.getName());
            this.V.addElement(tf);
            p.add(tf);
        }
        if (zc.getConstruction().countTargets() > 0) {
            ph = new MyPanel();
            ph.setLayout(new GridLayout(1, 0));
            ph.add(new MyLabel(Zirkel.name("definemacro.targetsonly")));
            this.TargetsOnly = new CheckboxAction(this, "", "TargetsOnly");
            this.TargetsOnly.setState(true);
            ph.add(this.TargetsOnly);
            p.add(ph);
            ph = new MyPanel();
            ph.setLayout(new GridLayout(1, 0));
            ph.add(new MyLabel(Zirkel.name("definemacro.invisible")));
            this.Invisible = new CheckboxAction(this, "", "Invisible");
            this.Invisible.setState(false);
            ph.add(this.Invisible);
            p.add(ph);
        }
        ph = new MyPanel();
        ph.setLayout(new GridLayout(1, 0));
        ph.add(new MyLabel(Zirkel.name("menu.options.hideduplicates")));
        this.HideDuplicates = new CheckboxAction(this, "", "HideDuplicates");
        this.HideDuplicates.setState(true);
        ph.add(this.HideDuplicates);
        p.add(ph);
        MyPanel pp = new MyPanel();
        pp.setLayout(new GridLayout(1, 0));
        pp.add(new MyLabel(Zirkel.name("definemacro.promptfor")));
        this.PromptFor = new TextFieldAction((DoActionListener)this, "", "");
        pp.add(this.PromptFor);
        p.add(pp);
        center.add("South", p);
        this.add("Center", new Panel3D(center));
        MyPanel south = new MyPanel();
        south.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        south.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(south, "macro");
        this.add("South", new Panel3D(south));
        this.center(f2);
        this.pack();
    }

    public void doAction(String o) {
        if (o.equals("OK")) {
            this.Aborted = false;
            this.doclose();
        } else {
            super.doAction(o);
        }
    }

    public void windowOpened(WindowEvent e2) {
        this.Name.requestFocus();
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public String[] getParams() {
        String[] s = new String[this.V.size()];
        for (int i = 0; i < this.V.size(); ++i) {
            s[i] = ((TextField)this.V.elementAt(i)).getText();
        }
        return s;
    }

    public String getName() {
        return this.Name.getText();
    }

    public String getComment() {
        return this.Comment.getText();
    }

    public boolean targetsOnly() {
        if (this.TargetsOnly == null) {
            return false;
        }
        return this.TargetsOnly.getState();
    }

    public boolean invisible() {
        if (this.Invisible == null) {
            return false;
        }
        return this.Invisible.getState();
    }

    public boolean hideduplicates() {
        return this.HideDuplicates.getState();
    }

    public String[] getPromptFor() {
        StringTokenizer t = new StringTokenizer(this.PromptFor.getText(), ",");
        String[] s = new String[t.countTokens()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = t.nextToken();
        }
        return s;
    }
}

