/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class CircleEditDialog
extends ObjectEditDialog {
    TextField Length;
    TextField BoundA;
    TextField BoundB;
    Checkbox Fixed;
    Checkbox Arc;
    IconBar IC;
    ZirkelCanvas ZC;
    Button RangeButton;
    Button KillRangeButton;
    Button SetButton;
    static Color[] Colors = ZirkelFrame.Colors;
    static String[] ColorStrings = ZirkelFrame.ColorStrings;

    public CircleEditDialog(Frame f2, PrimitiveCircleObject o, ZirkelCanvas zc) {
        super(f2, Zirkel.name("edit.circle.title"), o, "circle");
        this.ZC = zc;
    }

    public void addFirst(Panel P) {
        PrimitiveCircleObject C = (PrimitiveCircleObject)this.O;
        if (C instanceof CircleObject) {
            if (((CircleObject)C).canFix()) {
                this.Fixed = new Checkbox("");
                this.Fixed.setState(((CircleObject)C).fixed());
            }
            this.Length = new TextFieldAction(this, "Length", ((CircleObject)this.O).getStringLength(), 30);
        } else if (C instanceof FixedCircleObject) {
            this.Fixed = new Checkbox("");
            this.Fixed.setState(!((FixedCircleObject)C).isDragable());
            this.Length = new TextFieldAction(this, "Length", ((FixedCircleObject)this.O).getStringLength(), 30);
        } else {
            this.Length = new MyTextField("" + C.round(C.getR()));
        }
        P.add(new MyLabel(Zirkel.name("edit.circle.length")));
        P.add(this.Length);
        if (this.Fixed != null) {
            P.add(new MyLabel(Zirkel.name("edit.fixed")));
            P.add(this.Fixed);
        } else {
            this.Length.setEditable(false);
        }
        P.add(new MyLabel(Zirkel.name("edit.circle.bounds")));
        MyPanel bounds = new MyPanel();
        bounds.setLayout(new GridLayout(1, 3));
        this.Arc = new Checkbox("");
        this.Arc.setState(C.hasRange());
        bounds.add(this.Arc);
        this.BoundA = new MyTextField(C.getStartString(), 5);
        this.BoundB = new MyTextField(C.getEndString(), 5);
        bounds.add(this.BoundA);
        bounds.add(this.BoundB);
        P.add(bounds);
    }

    public void addButton(Panel P) {
        this.RangeButton = new ButtonAction(this, Zirkel.name("edit.circle.range"), "Range");
        P.add(this.RangeButton);
        if (this.O instanceof FixedCircleObject) {
            this.SetButton = new ButtonAction(this, Zirkel.name("edit.fixedcircle.set"), "Set");
            P.add(this.SetButton);
        }
    }

    public void addSecond(Panel P) {
        PrimitiveCircleObject C = (PrimitiveCircleObject)this.O;
        this.IC = new IconBar(this.F);
        this.IC.setIconBarListener(this);
        this.IC.addOnOffLeft("partial");
        this.IC.setState("partial", C.isPartial());
        this.IC.addOnOffLeft("filled");
        this.IC.setState("filled", C.isFilled());
        this.IC.addOnOffLeft("obtuse");
        this.IC.setState("obtuse", C.getObtuse());
        this.IC.addOnOffLeft("chord");
        this.IC.setState("chord", !C.getArc());
        this.IC.setIconBarListener(this);
        P.add(new MyLabel(""));
        P.add(this.IC);
    }

    public void iconPressed(String o) {
        if (o.equals("filled")) {
            if (this.IC.getState("filled")) {
                this.IB.setState("isback", true);
                this.ThicknessIB.setEnabled("solid", true);
            } else {
                this.IB.setState("isback", false);
                this.ThicknessIB.setState("solid", false);
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        super.iconPressed(o);
    }

    public void doAction(String o) {
        if (o.equals("Length") && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else if (o.equals("Range")) {
            this.ZC.range((PrimitiveCircleObject)this.O);
            super.doAction("OK");
        } else if (o.equals("KillRange")) {
            ((PrimitiveCircleObject)this.O).clearRange();
            super.doAction("OK");
        } else if (o.equals("Set") && this.O instanceof FixedCircleObject) {
            this.ZC.set((FixedCircleObject)this.O);
            super.doAction("OK");
        } else {
            super.doAction(o);
        }
    }

    public void setAction() {
        if (this.O instanceof CircleObject) {
            try {
                ((CircleObject)this.O).setFixed(this.Fixed.getState(), this.Length.getText());
            }
            catch (Exception e2) {}
        } else if (this.O instanceof FixedCircleObject) {
            ((FixedCircleObject)this.O).setDragable(!this.Fixed.getState());
            try {
                ((FixedCircleObject)this.O).setFixed(this.Length.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((PrimitiveCircleObject)this.O).setPartial(this.IC.getState("partial"));
        ((PrimitiveCircleObject)this.O).setFilled(this.IC.getState("filled"));
        ((PrimitiveCircleObject)this.O).setArc(!this.IC.getState("chord"));
        this.O.setObtuse(this.IC.getState("obtuse"));
        if (!this.Arc.getState()) {
            ((PrimitiveCircleObject)this.O).clearRange();
        } else {
            ((PrimitiveCircleObject)this.O).setRange(this.BoundA.getText(), this.BoundB.getText());
        }
        Global.setParameter("unit.length", this.Unit.getText());
    }

    public void focusGained(FocusEvent e2) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.Length.requestFocus();
        } else {
            super.focusGained(e2);
        }
    }
}

