/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.RayObject;

public class RayConstructor
extends LineConstructor {
    public ConstructionObject create(Construction c2, PointObject p1, PointObject p2) {
        return new RayObject(c2, p1, p2);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.ray.first", "Ray: Set the root point!"));
        } else {
            zc.showStatus(Zirkel.name("message.ray.second", "Ray: Set the second point!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Ray")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("from") || !tag.hasParam("to")) {
            throw new ConstructionException("Ray points missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("from"));
            PointObject p2 = (PointObject)c2.find(tag.getValue("to"));
            RayObject o = new RayObject(c2, p1, p2);
            if (tag.hasParam("partial")) {
                o.setPartial(true);
            }
            this.setName(tag, o);
            this.set(tree, o);
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ConstructionException("Ray points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.ray");
    }

    public String getTag() {
        return "Ray";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + params[1]);
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + params[1]);
        }
        RayObject s = new RayObject(c2, (PointObject)P1, (PointObject)P2);
        c2.add(s);
        s.setDefaults();
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
    }
}

