/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class QuadricConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;
    static PointObject previewPoint = null;
    static QuadricObject previewQuadric = null;

    public static void deletePreview(ZirkelCanvas zc) {
        if (previewQuadric != null) {
            zc.delete(previewQuadric);
            previewPoint = null;
            previewQuadric = null;
            zc.reset();
        }
    }

    private void arrangeP() {
        if (this.NPoints < 5) {
            this.P[4] = previewPoint;
            for (int i = 3; i >= this.NPoints; --i) {
                this.P[i] = this.P[0];
            }
        }
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        if (previewPoint == null) {
            previewPoint = new PointObject(zc.getConstruction(), "PrevPoint");
        }
        if (previewQuadric != null) {
            previewQuadric.setHidden(true);
        }
        PointObject p = zc.selectCreatePoint(e2.getX(), e2.getY());
        if (previewQuadric != null) {
            previewQuadric.setHidden(false);
        }
        if (p != null) {
            this.P[this.NPoints++] = p;
            p.setSelected(true);
            this.arrangeP();
            if (previewQuadric == null) {
                previewQuadric = new QuadricObject(zc.getConstruction(), this.P);
                zc.addObject(previewQuadric);
            }
            previewQuadric.setDefaults();
            zc.repaint();
        }
        this.showStatus(zc);
        if (this.NPoints == 5) {
            previewQuadric.validate();
            previewPoint = null;
            previewQuadric = null;
            zc.reset();
            zc.repaint();
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (previewPoint != null) {
            previewQuadric.validate();
            previewPoint.move(zc.x(e2.getX()), zc.y(e2.getY()));
            zc.repaint();
        }
        super.mouseMoved(e2, zc, simple);
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.quadric") + " " + (this.NPoints + 1));
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P = new PointObject[5];
            this.NPoints = 0;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.quadric"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Quadric")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        for (int i = 0; i < 5; ++i) {
            if (tag.hasParam("point" + (i + 1))) continue;
            throw new ConstructionException("Quadric points missing!");
        }
        try {
            PointObject[] P = new PointObject[5];
            for (int i = 0; i < 5; ++i) {
                P[i] = (PointObject)c2.find(tag.getValue("point" + (i + 1)));
            }
            QuadricObject p = new QuadricObject(c2, P);
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Quadric points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.quadric");
    }

    public String getTag() {
        return "Quadric";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 5) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        PointObject[] P = new PointObject[5];
        for (int i = 0; i < 5; ++i) {
            P[i] = c2.find(params[i]);
            if (P[i] == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound") + " " + params[i]);
            }
            if (P[i] instanceof PointObject) continue;
            throw new ConstructionException(Zirkel.name("exception.type") + " " + params[i]);
        }
        QuadricObject s = new QuadricObject(c2, P);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

