/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.UserFunctionObject;

public class FunctionConstructor
extends ObjectConstructor {
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Function")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (tag.hasParam("f")) {
            if (!tag.hasParam("var")) {
                throw new ConstructionException("Function invalid!");
            }
            try {
                String y = tag.getValue("f");
                String var = tag.getValue("var");
                UserFunctionObject f2 = new UserFunctionObject(c2);
                f2.setDefaults();
                this.setName(tag, f2);
                this.set(tree, f2);
                c2.add(f2);
                try {
                    if (tag.hasParam("fixed")) {
                        f2.setFixed(tag.getValue("x"), tag.getValue("y"));
                    } else {
                        double xpos = new Expression(tag.getValue("x"), c2, f2).getValue();
                        double ypos = new Expression(tag.getValue("y"), c2, f2).getValue();
                        f2.move(xpos, ypos);
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (tag.hasParam("filled")) {
                    f2.setFilled(true);
                }
                f2.setExpressions(var, y);
                this.setConditionals(tree, c2, f2);
                f2.updateText();
                return true;
            }
            catch (Exception e3) {
                throw new ConstructionException("Function invalid!");
            }
        }
        if (!(tag.hasParam("min") || tag.hasParam("max") || tag.hasParam("d") || tag.hasParam("var") || tag.hasParam("x") || tag.hasParam("y"))) {
            throw new ConstructionException("Function invalid!");
        }
        try {
            String x = tag.getValue("x");
            String y = tag.getValue("y");
            String var = tag.getValue("var");
            String d2 = tag.getValue("d");
            String min = tag.getValue("min");
            String max = tag.getValue("max");
            FunctionObject f3 = new FunctionObject(c2);
            f3.setDefaults();
            FunctionConstructor.setType(tag, f3);
            this.setName(tag, f3);
            this.set(tree, f3);
            c2.add(f3);
            if (tag.hasParam("filled")) {
                f3.setFilled(true);
            }
            f3.setExpressions(var, x, y);
            f3.setRange(min, max, d2);
            f3.setSpecial(tag.hasTrueParam("special"));
            this.setConditionals(tree, c2, f3);
            if (tag.hasParam("center")) {
                f3.setCenter(tag.getValue("center"));
            }
            f3.updateText();
            return true;
        }
        catch (Exception e4) {
            throw new ConstructionException("Function invalid!");
        }
    }

    public static void setType(XmlTag tag, FunctionObject p) {
        if (tag.hasParam("shape")) {
            String s = tag.getValue("shape");
            if (s.equals("square")) {
                p.setType(0);
            }
            if (s.equals("diamond")) {
                p.setType(1);
            }
            if (s.equals("circle")) {
                p.setType(2);
            }
            if (s.equals("dot")) {
                p.setType(3);
            }
            if (s.equals("cross")) {
                p.setType(4);
            }
            if (s.equals("dcross")) {
                p.setType(5);
            }
        }
    }

    public String getTag() {
        return "Function";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 6) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        boolean added = false;
        try {
            FunctionObject F = new FunctionObject(c2);
            c2.add(F);
            added = true;
            if (!name.equals("")) {
                F.setNameCheck(name);
            }
            F.setRange(params[0], params[1], params[2]);
            F.setExpressions(params[3], params[4], params[5]);
            F.setDefaults();
        }
        catch (ConstructionException e2) {
            if (added) {
                c2.back();
            }
            throw e2;
        }
        catch (Exception e3) {
            if (added) {
                c2.back();
            }
            throw new ConstructionException("Function Invalid!");
        }
    }
}

