/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ExpressionObject;

public class ExpressionConstructor
extends ObjectConstructor {
    ExpressionObject O;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        ExpressionObject o = new ExpressionObject(zc.getConstruction(), x, y);
        zc.addObject(o);
        o.setShowName(false);
        o.setDefaults();
        zc.repaint();
        this.Dragging = true;
        this.O = o;
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.O.move(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.edit(zc);
    }

    public boolean waitForPoint() {
        return false;
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.expression", "Expression: Choose a place!"));
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Expression")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("x") || !tag.hasParam("y")) {
            throw new ConstructionException("Expression coordinates missing!");
        }
        if (!tag.hasParam("value")) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        ExpressionObject p = new ExpressionObject(c2, 0.0, 0.0);
        try {
            double x = new Expression(tag.getValue("x"), c2, p).getValue();
            double y = new Expression(tag.getValue("y"), c2, p).getValue();
            p.move(x, y);
        }
        catch (Exception e2) {
            // empty catch block
        }
        p.setDefaults();
        if (tag.hasParam("prompt")) {
            p.setPrompt(tag.getValue("prompt"));
        }
        if (tag.hasParam("fixed")) {
            p.setFixed(tag.getValue("x"), tag.getValue("y"));
        }
        p.setShowValue(tag.hasParam("showvalue"));
        this.setName(tag, p);
        this.set(tree, p);
        c2.add(p);
        try {
            p.setExpression(tag.getValue("value"), c2);
        }
        catch (Exception e3) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        this.setConditionals(tree, c2, p);
        if (tag.hasTrueParam("slider")) {
            try {
                p.setSlider(tag.getValue("min"), tag.getValue("max"));
            }
            catch (Exception e4) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
        }
        return true;
    }

    public String getTag() {
        return "Expression";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams == 1) {
            ExpressionObject o = new ExpressionObject(c2, c2.getX() + (Math.random() - 0.5) * c2.getW(), c2.getY() + (Math.random() - 0.5) * c2.getW());
            if (!name.equals("")) {
                o.setNameCheck(name);
            }
            c2.add(o);
            o.setDefaults();
            try {
                o.setExpression(params[0], c2);
            }
            catch (Exception e2) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
        } else {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

