/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import eric.JMacrosTools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxMenuItemAction;
import rene.gui.ChoiceAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.MenuItemAction;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.ObjectsEditDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ConstructionDisplayPanel
extends MyPanel
implements DoActionListener,
ActionListener,
ClipboardOwner {
    public Lister V;
    public Vector W;
    Construction C;
    ZirkelCanvas ZC;
    Choice Ch;
    CheckboxMenuItemAction Visible;
    boolean ShowVisible = true;
    CheckboxMenuItemAction Sort;
    CheckboxMenuItemAction Description;
    CheckboxMenuItemAction Size;
    CheckboxMenuItemAction Formula;
    public static String[] Choices = new String[]{"all", "points", "lines", "circles", "angles", "expressions", "other"};
    public int State = 0;
    PopupMenu PM;
    Button Menu;

    public ConstructionDisplayPanel(ZirkelCanvas zc) {
        this.ZC = zc;
        this.C = this.ZC.getConstruction();
        this.V = new Lister();
        this.V.setMode(true, false, true, true);
        this.V.addActionListener(this);
        if (Global.Background != null) {
            this.V.setBackground(Global.Background);
        }
        this.V.setFont(Global.FixedFont);
        this.State = Global.getParameter("constructiondisplay.state", 0);
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new BorderLayout());
        this.Ch = new ChoiceAction(this, "choices");
        for (int i = 0; i < Choices.length; ++i) {
            this.Ch.add(Zirkel.name("constructiondisplay." + Choices[i]));
        }
        north.add("Center", this.Ch);
        this.Ch.select(this.State);
        this.Menu = new ButtonAction(this, "?", "Menu");
        north.add("East", this.Menu);
        this.add("North", new Panel3D(north));
        this.setListerState();
        this.makePopup();
        this.add("Center", this.V);
    }

    public void reload() {
        this.V.clear();
        this.C = this.ZC.getConstruction();
        Enumeration e2 = null;
        e2 = Global.getParameter("constructiondisplay.sort", true) ? this.C.getSortedElements() : this.C.elements();
        this.W = new Vector();
        block9: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (JMacrosTools.CurrentJZF.restrictedSession && o.isSuperHidden() || this.ShowVisible && o.mustHide(this.ZC) || Global.getParameter("restricted", false) && o.isSuperHidden()) continue;
            switch (this.State) {
                case 0: {
                    break;
                }
                case 1: {
                    if (o instanceof PointObject) break;
                    continue block9;
                }
                case 2: {
                    if (o instanceof PrimitiveLineObject && !(o instanceof FixedAngleObject)) break;
                    continue block9;
                }
                case 3: {
                    if (o instanceof PrimitiveCircleObject) break;
                    continue block9;
                }
                case 4: {
                    if (o instanceof AngleObject || o instanceof FixedAngleObject) break;
                    continue block9;
                }
                case 5: {
                    if (o instanceof ExpressionObject || o instanceof FunctionObject) break;
                    continue block9;
                }
                case 6: {
                    if (!(o instanceof PointObject) && !(o instanceof PrimitiveLineObject) && !(o instanceof PrimitiveCircleObject) && !(o instanceof AngleObject) && !(o instanceof ExpressionObject) && !(o instanceof FunctionObject)) break;
                    continue block9;
                }
            }
            this.V.addElement(o);
            this.W.addElement(o);
        }
        this.V.showLast();
        this.updateDisplay();
    }

    public void updateDisplay() {
        this.V.updateDisplay();
    }

    public void doAction(String o) {
        if (o.equals("Edit")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            if (selected.length == 1) {
                ((ConstructionObject)this.W.elementAt(selected[0])).edit(this.ZC);
            } else {
                Vector v = new Vector();
                for (int i = 0; i < selected.length; ++i) {
                    v.addElement(this.W.elementAt(selected[i]));
                }
                ObjectsEditDialog d2 = new ObjectsEditDialog(this.ZC.getFrame(), v);
                d2.setVisible(true);
                this.ZC.validate();
            }
            this.ZC.repaint();
            this.reload();
        } else if (o.equals("EditConditions")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            if (selected.length == 1) {
                new EditConditionals(this.ZC.getFrame(), (ConstructionObject)this.W.elementAt(selected[0]));
            } else {
                Vector v = new Vector();
                for (int i = 0; i < selected.length; ++i) {
                    v.addElement(this.W.elementAt(selected[i]));
                }
                new EditConditionals(this.ZC.getFrame(), v);
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (o.equals("Copy")) {
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream(50000);
                PrintWriter po = new PrintWriter((Writer)new OutputStreamWriter(ba), true);
                this.V.save(po);
                po.close();
                String S = ba.toString();
                Clipboard clip = this.getToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(S);
                clip.setContents(sel, this);
            }
            catch (Exception e2) {}
        } else if (o.equals("Delete")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            Vector v = new Vector();
            for (int i = 0; i < selected.length; ++i) {
                v.addElement(this.W.elementAt(selected[i]));
            }
            this.ZC.delete(v);
            this.ZC.repaint();
            this.ZC.reset();
            this.reload();
        } else if (o.equals("Hide")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                ConstructionObject oc;
                oc.setHidden(!(oc = (ConstructionObject)this.W.elementAt(selected[i])).isHidden());
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (o.equals("SuperHide")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(selected[i]);
                oc.setSuperHidden(true);
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (o.equals("HighLight")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(selected[i]);
                oc.setStrongSelected(true);
            }
            Graphics g = this.ZC.getGraphics();
            if (g != null) {
                this.ZC.paint(g);
                g.dispose();
                try {
                    Thread.sleep(400L);
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            for (int i = 0; i < selected.length; ++i) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(selected[i]);
                oc.setStrongSelected(false);
            }
            this.ZC.repaint();
        } else if (o.equals("Menu")) {
            this.displayPopup(this.V.L, 10, 10);
        }
        this.ZC.requestFocus();
    }

    public void itemToggleAction(String o) {
        if (o.equals("Sort")) {
            this.Sort.setState(!this.Sort.getState());
            this.itemAction("Sort", this.Sort.getState());
        } else if (o.equals("Visible")) {
            this.Visible.setState(!this.Visible.getState());
            this.itemAction("Visible", this.Visible.getState());
        }
    }

    public void itemAction(String o, boolean flag) {
        if (o.equals("Sort")) {
            Global.setParameter("constructiondisplay.sort", this.Sort.getState());
            this.reload();
        } else if (o.equals("Visible")) {
            this.ShowVisible = this.Visible.getState();
            this.reload();
        } else if (o.equals("Description")) {
            Global.setParameter("constructiondisplay.listerstate", 0);
            this.setListerState();
            this.updateDisplay();
        } else if (o.equals("Size")) {
            Global.setParameter("constructiondisplay.listerstate", 2);
            this.setListerState();
            this.updateDisplay();
        } else if (o.equals("Formula")) {
            Global.setParameter("constructiondisplay.listerstate", 1);
            this.setListerState();
            this.updateDisplay();
        } else if (flag) {
            this.State = this.Ch.getSelectedIndex();
            Global.setParameter("constructiondisplay.state", this.State);
            this.reload();
        }
    }

    public void setListerState() {
        int state = Global.getParameter("constructiondisplay.listerstate", 2);
        this.V.setState(state);
        if (this.PM != null) {
            this.Description.setState(state == 0);
            this.Size.setState(state == 2);
            this.Formula.setState(state == 1);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(Global.getParameter("options.constructiondisplay.width", 200), 400);
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.V && e2 instanceof ListerMouseEvent) {
            ListerMouseEvent em = (ListerMouseEvent)e2;
            if (em.rightMouse()) {
                this.displayPopup(em.getEvent().getComponent(), em.getEvent().getX(), em.getEvent().getY());
            } else if (em.clickCount() >= 2) {
                this.doAction("Edit");
            } else {
                this.doAction("HighLight");
            }
        }
    }

    public void displayPopup(Component c2, int x, int y) {
        this.PM.show(c2, x, y);
    }

    public void makePopup() {
        this.PM = new PopupMenu();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.edit"), "Edit"));
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.editconditions"), "EditConditions"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.hide"), "Hide"));
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.superhide"), "SuperHide"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.delete"), "Delete"));
        this.PM.addSeparator();
        this.Description = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.description"), "Description");
        this.Description.setState(Global.getParameter("constructiondisplay.description", false));
        this.PM.add(this.Description);
        this.Size = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.size"), "Size");
        this.Description.setState(Global.getParameter("constructiondisplay.size", true));
        this.PM.add(this.Size);
        this.Formula = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.formula"), "Formula");
        this.Description.setState(Global.getParameter("constructiondisplay.formula", false));
        this.PM.add(this.Formula);
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.copy"), "Copy"));
        this.V.L.add(this.PM);
        this.PM.addSeparator();
        this.Visible = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.visible"), "Visible");
        this.Visible.setState(true);
        this.PM.add(this.Visible);
        this.Sort = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.sorted"), "Sort");
        this.Sort.setState(Global.getParameter("constructiondisplay.sort", true));
        this.PM.add(this.Sort);
        this.setListerState();
    }

    public void showLast() {
        this.V.showLast();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setListingBackground(Color c2) {
        this.V.setListingBackground(c2);
    }
}

