/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.ChoiceAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ConstructionDisplay
extends HelpCloseDialog
implements ClipboardOwner {
    Lister V;
    Vector W;
    Construction C;
    ZirkelCanvas ZC;
    Choice Ch;
    Checkbox Sort;
    public static String[] Choices = new String[]{"all", "visible", "expressions", "points", "lines", "circles", "angles", "other", "invalid"};
    int State = 0;

    public ConstructionDisplay(Frame f2, ZirkelCanvas zc) {
        super(f2, Zirkel.name("constructiondisplay.title", "Construction"), true);
        this.C = zc.getConstruction();
        this.ZC = zc;
        this.V = new Lister(){

            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }
        };
        this.V.setMode(true, false, false, false);
        if (Global.Background != null) {
            this.V.setBackground(Global.Background);
        }
        this.V.setFont(Global.FixedFont);
        this.State = Global.getParameter("constructiondisplay.state", 1);
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new GridLayout(0, 2));
        north.add(new MyLabel(Zirkel.name("constructiondisplay.select")));
        this.Ch = new ChoiceAction(this, "choices");
        for (int i = 0; i < Choices.length; ++i) {
            this.Ch.add(Zirkel.name("constructiondisplay." + Choices[i]));
        }
        north.add(this.Ch);
        this.Ch.select(this.State);
        north.add(new MyLabel(Zirkel.name("constructiondisplay.sorted")));
        this.Sort = new CheckboxAction(this, "", "Sort");
        this.Sort.setState(Global.getParameter("constructiondisplay.sort", true));
        north.add(this.Sort);
        this.add("North", new Panel3D(north));
        this.add("Center", this.V);
        MyPanel p = new MyPanel();
        p.add(new ButtonAction(this, Zirkel.name("constructiondisplay.copy"), "Copy"));
        p.add(new ButtonAction(this, Zirkel.name("constructiondisplay.edit"), "Edit"));
        p.add(new ButtonAction(this, Zirkel.name("close", "Close"), "Close"));
        this.addHelp(p, "construction");
        this.add("South", p);
        this.pack();
        this.setSize("constructiondialog");
        this.center(f2);
        this.reload();
        this.setVisible(true);
    }

    public void reload() {
        this.V.clear();
        Enumeration e2 = null;
        e2 = this.Sort.getState() ? this.C.getSortedElements() : this.C.elements();
        this.W = new Vector();
        block10: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            switch (this.State) {
                case 1: {
                    if (!o.mustHide(this.ZC)) break;
                    continue block10;
                }
                case 2: {
                    if (!o.mustHide(this.ZC) && (o instanceof ExpressionObject || o instanceof FunctionObject)) break;
                    continue block10;
                }
                case 3: {
                    if (!o.mustHide(this.ZC) && o instanceof PointObject) break;
                    continue block10;
                }
                case 4: {
                    if (!o.mustHide(this.ZC) && o instanceof PrimitiveLineObject && !(o instanceof FixedAngleObject)) break;
                    continue block10;
                }
                case 5: {
                    if (!o.mustHide(this.ZC) && o instanceof PrimitiveCircleObject) break;
                    continue block10;
                }
                case 6: {
                    if (!o.mustHide(this.ZC) && (o instanceof AngleObject || o instanceof FixedAngleObject)) break;
                    continue block10;
                }
                case 7: {
                    if (!o.mustHide(this.ZC) && !(o instanceof PointObject) && !(o instanceof PrimitiveLineObject) && !(o instanceof PrimitiveCircleObject) && !(o instanceof AngleObject) && !(o instanceof ExpressionObject) && !(o instanceof FunctionObject)) break;
                    continue block10;
                }
                case 8: {
                    if (!o.valid()) break;
                    continue block10;
                }
            }
            this.V.addElement(o);
            this.W.addElement(o);
        }
        this.V.showLast();
        this.V.updateDisplay();
    }

    public void doAction(String o) {
        this.noteSize("constructiondialog");
        Global.setParameter("constructiondisplay.sort", this.Sort.getState());
        if (o.equals("Edit")) {
            super.doAction("Close");
            int selected = this.V.getSelectedIndex();
            if (selected >= 0) {
                Enumeration e2 = this.W.elements();
                int i = 0;
                while (e2.hasMoreElements()) {
                    ConstructionObject O = (ConstructionObject)e2.nextElement();
                    if (i == selected) {
                        O.edit(this.ZC);
                        return;
                    }
                    ++i;
                }
            }
        } else if (o.equals("Copy")) {
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream(50000);
                PrintWriter po = new PrintWriter((Writer)new OutputStreamWriter(ba), true);
                this.V.save(po);
                po.close();
                String S = ba.toString();
                Clipboard clip = this.getToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(S);
                clip.setContents(sel, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.doAction(o);
    }

    public void itemAction(String o, boolean flag) {
        if (o.equals("Sort")) {
            this.reload();
        } else if (flag) {
            this.State = this.Ch.getSelectedIndex();
            Global.setParameter("constructiondisplay.state", this.State);
            this.reload();
        }
    }

    public void lostOwnership(Clipboard b2, Transferable s) {
    }
}

