/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import eric.JGlobals;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.util.MyVector;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.ChangedListener;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Interpreter;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.BoundedPointConstructor;
import rene.zirkel.constructors.Circle3Constructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.FunctionConstructor;
import rene.zirkel.constructors.ImageConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.constructors.TextConstructor;
import rene.zirkel.expression.Translator;
import rene.zirkel.listener.AddEventListener;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.tools.ObjectTracker;

public class Construction {
    static final long serialVersionUID = 110L;
    public Vector V;
    public Vector Parameters;
    public Vector Targets;
    public String Comment = "";
    public String JobComment = "";
    public Vector PromptFor = new Vector();
    public Vector Prompts;
    private double X = 0.0;
    private double Y = 0.0;
    private double W = 8.0;
    private double H = 8.0;
    public boolean Partial = Global.getParameter("options.partial", false);
    public boolean Restricted = Global.getParameter("options.restricted", true);
    public boolean PartialLines = Global.getParameter("options.plines", false);
    public boolean Vectors = Global.getParameter("options.arrow", false);
    public boolean ShowNames = Global.getParameter("options.shownames", false);
    public boolean ShowValues = Global.getParameter("options.showvalues", false);
    public boolean LongNames = Global.getParameter("options.longnames", false);
    public boolean LargeFont = Global.getParameter("options.largefont", false);
    public boolean BoldFont = Global.getParameter("options.boldfont", false);
    public boolean Hidden = false;
    public boolean Obtuse = Global.getParameter("options.obtuse", false);
    public boolean Solid = Global.getParameter("options.solid", false);
    public boolean Animate = false;
    public boolean Paint = false;
    public boolean ShowAll = false;
    public boolean SuperHide = false;
    public int DefaultColor = Global.getParameter("options.color", 0);
    public int DefaultType = Global.getParameter("options.type", 0);
    public int DefaultColorType = Global.getParameter("options.colortype", 0);
    public boolean Changed = false;
    int Count = 0;
    public Construction TranslateInto;
    public boolean BlockSimulation = false;
    public boolean DontAlternateIntersections = false;
    ObjectConstructor[] ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new LineConstructor(), new SegmentConstructor(), new RayConstructor(), new CircleConstructor(), new IntersectionConstructor(), new ParallelConstructor(), new PlumbConstructor(), new Circle3Constructor(), new MidpointConstructor(), new AngleConstructor(), new BoundedPointConstructor(), new ExpressionConstructor(), new AreaConstructor(), new TextConstructor(), new QuadricConstructor(), new ImageConstructor(), new ObjectTracker(), new FunctionConstructor()};
    private AddEventListener AEL = null;
    Vector Undo = new Vector();
    public String TrackP = null;
    public String TrackPM = null;
    public String TrackO = null;
    public String AnimateP = null;
    public Vector TrackPO;
    public Vector AnimateV = null;
    public int Omit = 0;
    public boolean AnimateNegative = false;
    public boolean AnimateOriginal = false;
    public String AnimateDelay = null;
    public String Icons = "";
    public boolean AnimateBreakpoints = false;
    public long AnimateTime = 1000L;
    public boolean AnimateLoop = false;
    public boolean ResizeBackground = false;
    public String BackgroundFile = null;
    boolean NeedsOrdering = false;
    Interpreter Int = new Interpreter(this);
    boolean IntersectionBecameInvalid;
    boolean ShouldSwitch = false;
    boolean NoteSwitch = false;
    public ChangedListener CL = null;
    public MyVector TranslatorList = new MyVector();
    Vector VOld = null;
    public boolean Loading = false;
    Vector Errors = new Vector();
    double Pixel = 100.0;

    public Construction() {
        this.clear();
        this.Changed = false;
    }

    public void addAddEventListener(AddEventListener ael) {
        this.AEL = ael;
    }

    public void removeAddEventListener(AddEventListener ael) {
        this.AEL = null;
    }

    public void add(ConstructionObject o) {
        if (!o.isGotNCount()) {
            o.setNCount(this.Count++);
        } else {
            o.setGotNCount(false);
        }
        this.V.addElement(o);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        o.setConstruction(this);
        if (this.AEL != null) {
            this.AEL.added(this, o);
        }
        this.haveChanged();
    }

    public void addNoCheck(ConstructionObject o) {
        if (!o.isGotNCount()) {
            o.setNCount(this.Count++);
        } else {
            o.setGotNCount(false);
        }
        this.V.addElement(o);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        o.setConstruction(this);
        this.haveChanged();
    }

    public void added(ConstructionObject o) {
        if (this.AEL != null) {
            this.AEL.added(this, o);
        }
    }

    public synchronized void clear() {
        this.V = new Vector();
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        this.Comment = "";
        this.JobComment = "";
        this.clearParameters();
        this.clearTargets();
        this.Prompts = new Vector();
        this.X = 0.0;
        this.Y = 0.0;
        this.W = 8.0;
        this.Changed = false;
        this.Count = 0;
    }

    public void back() {
        ConstructionObject o = this.last();
        if (o == null) {
            return;
        }
        o.setInConstruction(false);
        this.Undo.addElement(o);
        if (this.V.size() > 0) {
            this.V.removeElementAt(this.V.size() - 1);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete(boolean clearUndo) {
        if (clearUndo && !this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        for (int i = this.V.size() - 1; i >= 0; --i) {
            ConstructionObject o = (ConstructionObject)this.V.elementAt(i);
            if (!o.isFlag() || o.isJobTarget()) continue;
            o.setInConstruction(false);
            this.Undo.addElement(o);
            this.V.removeElementAt(i);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete() {
        this.delete(true);
    }

    public void undo() {
        if (this.Undo.isEmpty()) {
            return;
        }
        Object[] o = new ConstructionObject[this.Undo.size()];
        this.Undo.copyInto(o);
        for (int i = o.length - 1; i >= 0; --i) {
            this.V.addElement(o[i]);
            ((ConstructionObject)o[i]).setConstruction(this);
        }
        this.Undo.removeAllElements();
        this.haveChanged();
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public Enumeration getSortedElements() {
        Object[] o = new ConstructionObject[this.V.size()];
        this.V.copyInto(o);
        for (int i = 0; i < o.length; ++i) {
            ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).getNCount();
        }
        Sorter.sort((SortObject[])o);
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < o.length; ++i) {
            v.addElement(o[i]);
        }
        return v.elements();
    }

    public ConstructionObject last() {
        if (this.V.size() > 0) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 1);
        }
        return null;
    }

    public ConstructionObject lastByNumber() {
        ConstructionObject o = null;
        int maxCount = -1;
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject co = (ConstructionObject)e2.nextElement();
            if (co.getNCount() <= maxCount) continue;
            maxCount = co.getNCount();
            o = co;
        }
        return o;
    }

    public ConstructionObject lastButOne() {
        if (this.V.size() > 1) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 2);
        }
        return null;
    }

    public void clearAfter(ConstructionObject after) {
        ConstructionObject o;
        while ((o = this.last()) != null && o != after) {
            o.setInConstruction(false);
            this.V.removeElementAt(this.V.size() - 1);
            this.haveChanged();
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String s) {
        if (s.length() <= 2) {
            s = "";
        }
        this.Comment = s;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getW() {
        return this.W;
    }

    public double getH() {
        return this.H;
    }

    public void setH(double h) {
        this.H = h;
    }

    public void setXYW(double x, double y, double w) {
        this.X = x;
        this.Y = y;
        this.W = w;
    }

    public void save(XmlWriter xml) {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).save(xml);
        }
        this.Changed = false;
    }

    public synchronized void load(XmlTree tree, ZirkelCanvas zc) throws ConstructionException, InterruptedException {
        Vector CTRLtags = new Vector();
        Enumeration root = tree.getContent();
        this.TrackP = null;
        this.TrackPO = new Vector();
        this.AnimateP = null;
        this.AnimateNegative = false;
        this.AnimateOriginal = false;
        this.AnimateBreakpoints = false;
        this.AnimateLoop = false;
        this.AnimateTime = 1000L;
        this.Icons = "";
        this.BackgroundFile = null;
        this.ResizeBackground = false;
        zc.clearDrawings();
        while (root.hasMoreElements()) {
            tree = (XmlTree)root.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("Comment")) {
                try {
                    this.setComment(tree.parseComment());
                    continue;
                }
                catch (Exception e2) {
                    throw new ConstructionException("Illegal Comment");
                }
            }
            if (tag.name().equals("Assignment")) {
                try {
                    this.setJobComment(tree.parseComment());
                    continue;
                }
                catch (Exception e3) {
                    throw new ConstructionException("Illegal Assignment");
                }
            }
            if (tag.name().equals("Track")) {
                if (!tag.hasParam("track")) {
                    throw new ConstructionException(Zirkel.name("exception.track"));
                }
                this.TrackP = tag.getValue("track");
                this.TrackPO = new Vector();
                int i = 0;
                while (tag.hasParam("track" + i)) {
                    this.TrackPO.addElement(tag.getValue("track" + i));
                    ++i;
                }
                this.TrackPM = tag.hasParam("move") ? tag.getValue("move") : null;
                this.TrackO = tag.hasParam("on") ? tag.getValue("on") : null;
                this.Animate = false;
                this.Paint = true;
                if (tag.hasParam("animate")) {
                    if (tag.getValue("animate").equals("nopaint")) {
                        this.Paint = false;
                    }
                    this.Animate = true;
                }
                this.Omit = 0;
                if (!tag.hasParam("omit")) continue;
                try {
                    this.Omit = Integer.parseInt(tag.getValue("omit"));
                }
                catch (Exception e4) {}
                continue;
            }
            if (tag.name().equals("Animate")) {
                if (!tag.hasParam("animate") || !tag.hasParam("via0")) {
                    throw new ConstructionException(Zirkel.name("exception.animate"));
                }
                this.AnimateP = tag.getValue("animate");
                int k = 0;
                this.AnimateV = new Vector();
                while (tag.hasParam("via" + k)) {
                    this.AnimateV.addElement(tag.getValue("via" + k));
                    ++k;
                }
                this.AnimateNegative = false;
                if (tag.hasParam("negative") && tag.getValue("negative").equals("true")) {
                    this.AnimateNegative = true;
                }
                if (tag.hasParam("original") && tag.getValue("original").equals("true")) {
                    this.AnimateOriginal = true;
                }
                this.AnimateDelay = null;
                if (!tag.hasParam("delay")) continue;
                this.AnimateDelay = tag.getValue("delay");
                continue;
            }
            if (tag.name().equals("AnimateBreakpoints")) {
                this.AnimateBreakpoints = true;
                try {
                    if (tag.hasParam("time")) {
                        this.AnimateTime = new Long(tag.getValue("time"));
                    }
                    if (!tag.hasParam("loop")) continue;
                    this.AnimateLoop = true;
                    continue;
                }
                catch (Exception e5) {
                    throw new ConstructionException("exception.animate");
                }
            }
            if (tag.name().equals("Window")) {
                try {
                    if (tag.hasParam("x")) {
                        this.X = new Double(tag.getValue("x"));
                    }
                    if (tag.hasParam("y")) {
                        this.Y = new Double(tag.getValue("y"));
                    }
                    if (tag.hasParam("w")) {
                        this.W = new Double(tag.getValue("w"));
                    }
                    zc.ShowGrid = tag.hasTrueParam("showgrid");
                    continue;
                }
                catch (Exception e6) {
                    throw new ConstructionException("Illegal Window Parameters");
                }
            }
            if (tag.name().equals("Grid")) {
                try {
                    int n;
                    if (tag.hasParam("color") && (n = new Integer(tag.getValue("color")).intValue()) >= 0 && n < ZirkelFrame.Colors.length) {
                        zc.GridColor = n;
                    }
                    if (tag.hasParam("thickness") && (n = new Integer(tag.getValue("thickness")).intValue()) >= 0 && n < 4) {
                        zc.GridThickness = n;
                    }
                    zc.GridLabels = !tag.hasTrueParam("nolables");
                    zc.GridLarge = tag.hasTrueParam("large");
                    zc.GridBold = tag.hasTrueParam("bold");
                    zc.AxesOnly = tag.hasTrueParam("axesonly");
                    continue;
                }
                catch (Exception e7) {
                    throw new ConstructionException("Illegal Grid Parameters");
                }
            }
            if (tag.name().equals("Background")) {
                try {
                    if (tag.hasTrueParam("resize")) {
                        this.ResizeBackground = true;
                    }
                    this.BackgroundFile = tag.getValue("file");
                    if (this.BackgroundFile != null) continue;
                    throw new ConstructionException("Illegal Background Parameters");
                }
                catch (Exception e8) {
                    throw new ConstructionException("Illegal Background Parameters");
                }
            }
            if (tag.name().equals("Draw")) {
                zc.loadDrawings(tree);
                continue;
            }
            if (tag.name().equals("Objects")) {
                this.readConstruction(tree);
                this.updateCount();
                this.computeNeedsOrdering();
                this.doOrder();
                break;
            }
            if (tag.name().equals("Restrict")) {
                if (!tag.hasParam("icons")) {
                    throw new ConstructionException("Illegal Window Parameters");
                }
                this.Icons = tag.getValue("icons");
                continue;
            }
            JGlobals.XmlTagReader(tag);
            zc.JCM.collectXmlTag(tag);
        }
        zc.setBackground(Global.getParameter("colorbackground", new Color(230, 230, 230)));
        zc.updateDigits();
        zc.resetGraphics();
        zc.repaint();
    }

    public void translateOffsets(ZirkelCanvas zc) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).translateOffset(zc);
        }
    }

    public synchronized void readConstruction(XmlTree tree) throws ConstructionException {
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            int i;
            tree = (XmlTree)e2.nextElement();
            int n = this.ObjectConstructors.length;
            for (i = 0; i < n; ++i) {
                try {
                    if (!this.ObjectConstructors[i].construct(tree, this)) continue;
                    break;
                }
                catch (ConstructionException ex) {
                    if (tree.getTag().hasParam("name")) {
                        String name = tree.getTag().getValue("name");
                        throw new ConstructionException(ex.getDescription() + " (in " + name + ")");
                    }
                    throw ex;
                }
            }
            if (i < n) continue;
            throw new ConstructionException(tree.getTag().name() + " unknown!");
        }
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).laterBind(this);
        }
        this.dovalidate();
        this.updateCircleDep();
        this.Changed = false;
    }

    public ConstructionObject find(String name) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!c2.getName().equals(name)) continue;
            return c2;
        }
        return null;
    }

    public ConstructionObject find(String name, ConstructionObject until) {
        ConstructionObject c2;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements() && (c2 = (ConstructionObject)e2.nextElement()) != until) {
            if (!c2.getName().equals(name)) continue;
            return c2;
        }
        return null;
    }

    public ConstructionObject findInclusive(String name, ConstructionObject until) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (c2.getName().equals(name)) {
                return c2;
            }
            if (c2 != until) continue;
            break;
        }
        return null;
    }

    public boolean before(ConstructionObject first, ConstructionObject second) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (c2 == first) {
                return true;
            }
            if (c2 != second) continue;
            break;
        }
        return false;
    }

    public boolean dependsDirectlyOn(ConstructionObject o, ConstructionObject on) {
        Enumeration e2 = o.depending();
        while (e2.hasMoreElements()) {
            if (on != e2.nextElement()) continue;
            return true;
        }
        return false;
    }

    public void clearRekFlags() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setRekFlag(false);
        }
    }

    public boolean dependsOn(ConstructionObject o, ConstructionObject on) {
        this.clearRekFlags();
        boolean res = this.dependsOnRek(o, on);
        return res;
    }

    public boolean dependsOnRek(ConstructionObject o, ConstructionObject on) {
        o.setRekFlag(true);
        if (o == on) {
            return true;
        }
        ConstructionObject[] o1 = o.getDepArray();
        for (int i = 0; i < o1.length; ++i) {
            if (o1[i] == o || o1[i].isRekFlag() || !this.dependsOnRek(o1[i], on)) continue;
            return true;
        }
        return false;
    }

    public void reorderConstruction() {
        int i;
        Object[] o = new ConstructionObject[this.V.size()];
        this.V.copyInto(o);
        int n = o.length;
        if (n == 0) {
            return;
        }
        for (i = 0; i < n; ++i) {
            ((ConstructionObject)o[i]).Scratch = 0;
            ((ConstructionObject)o[i]).Flag = false;
        }
        for (i = 0; i < n; ++i) {
            this.countTail((ConstructionObject)o[i]);
        }
        if (n < 500) {
            for (i = 1; i < n; ++i) {
                int j;
                int k = ((ConstructionObject)o[i]).Scratch;
                for (j = i; j > 0 && ((ConstructionObject)o[j - 1]).Scratch > k; --j) {
                }
                if (j >= i) continue;
                Object oh = o[i];
                for (int h = i; h > j; --h) {
                    o[h] = o[h - 1];
                }
                o[j] = oh;
            }
        } else {
            for (i = 0; i < o.length; ++i) {
                ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).Scratch;
            }
            Sorter.sort((SortObject[])o);
        }
        this.V = new Vector();
        for (i = 0; i < n; ++i) {
            this.V.addElement(o[i]);
        }
    }

    public int countTail(ConstructionObject o) {
        if (o.Flag) {
            return o.Scratch;
        }
        o.Flag = true;
        int max = 0;
        ConstructionObject[] oc = o.getDepArray();
        if (oc.length == 0) {
            o.Scratch = 0;
        } else {
            for (int i = 0; i < oc.length; ++i) {
                int k;
                if (oc[i] == o || (k = this.countTail(oc[i])) <= max) continue;
                max = k;
            }
            o.Scratch = max + 1;
        }
        return o.Scratch;
    }

    public void needsOrdering() {
        this.NeedsOrdering = true;
    }

    public void doOrder() {
        if (!this.NeedsOrdering) {
            return;
        }
        this.reorderConstruction();
        this.NeedsOrdering = false;
    }

    public void computeNeedsOrdering() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).Flag = false;
        }
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Enumeration ec = ((ConstructionObject)e2.nextElement()).depending();
            while (ec.hasMoreElements()) {
                if (((ConstructionObject)ec.nextElement()).Flag) continue;
                this.NeedsOrdering = true;
                return;
            }
        }
        this.NeedsOrdering = false;
    }

    public int indexOf(ConstructionObject o) {
        return this.V.indexOf(o);
    }

    public ConstructionObject lastDep(ConstructionObject o) {
        int res = -1;
        ConstructionObject ores = null;
        Enumeration e2 = o.depending();
        while (e2.hasMoreElements()) {
            ConstructionObject u = (ConstructionObject)e2.nextElement();
            int i = this.indexOf(u);
            if (i <= res) continue;
            res = i;
            ores = u;
        }
        return ores;
    }

    public boolean reorder(ConstructionObject o1, ConstructionObject o2) {
        int n = -1;
        if (o2 != null) {
            n = o2.getNCount();
        }
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.getNCount() <= n) continue;
            o.setNCount(o.getNCount() + 1);
        }
        o1.setNCount(n + 1);
        this.haveChanged();
        return true;
    }

    public void updateTexts(ConstructionObject o, String oldname) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject u = (ConstructionObject)e2.nextElement();
            if (!this.dependsDirectlyOn(u, o)) continue;
            u.updateText();
        }
    }

    public String getJobComment() {
        return this.JobComment;
    }

    public void setJobComment(String s) {
        this.JobComment = s;
    }

    public void updateCircleDep() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).clearCircleDep();
        }
        e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).updateCircleDep();
        }
    }

    public Vector getParameters() {
        return this.Parameters;
    }

    public int countParameters() {
        if (this.Parameters == null) {
            return 0;
        }
        return this.Parameters.size();
    }

    public Vector getTargets() {
        return this.Targets;
    }

    public int countTargets() {
        if (this.Targets == null) {
            return 0;
        }
        return this.Targets.size();
    }

    public void addParameter(ConstructionObject o) {
        this.Parameters.addElement(o);
    }

    public void addTarget(ConstructionObject o) {
        this.Targets.addElement(o);
    }

    public void clearParameters() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setSpecialParameter(false);
        }
        this.Parameters = new Vector();
    }

    public void clearTargets() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setTarget(false);
        }
        this.Targets = new Vector();
    }

    public void testParameter(ConstructionObject o) throws ConstructionException {
        throw new ConstructionException(Zirkel.name("exception.null"));
    }

    public void interpret(ZirkelCanvas zc, String s, String comment) throws ConstructionException {
        this.Int.interpret(zc, s, comment);
    }

    public void interpret(ZirkelCanvas zc, String s) throws ConstructionException {
        this.Int.interpret(zc, s, "");
    }

    public void dovalidate() {
        boolean stop;
        this.doOrder();
        do {
            Enumeration e2 = this.elements();
            stop = true;
            this.IntersectionBecameInvalid = false;
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                boolean valid = o.valid();
                o.validate();
                if (o instanceof IntersectionObject && valid && !o.valid()) {
                    this.IntersectionBecameInvalid = true;
                }
                if (!(o.changedBy() > 1.0E-6)) continue;
                stop = false;
            }
        } while (!stop);
    }

    public boolean intersectionBecameInvalid() {
        return this.IntersectionBecameInvalid;
    }

    public void dovalidateDebug() {
        boolean stop;
        this.doOrder();
        System.out.println("--- Time validate() ---");
        do {
            Enumeration e2 = this.elements();
            stop = true;
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                long time = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    o.validate();
                }
                time = System.currentTimeMillis() - time;
                if (time > 0L) {
                    System.out.println(o.getName() + " - " + (double)time / 100.0 + " msec");
                }
                if (!(o.changedBy() > 1.0E-6)) continue;
                stop = false;
            }
        } while (!stop);
    }

    public void validate(ConstructionObject o, ConstructionObject avoid) {
        ConstructionObject oc;
        if (o.RekValidating) {
            return;
        }
        o.RekValidating = true;
        if (o.VRek == null) {
            o.VRek = new MyVector();
        } else {
            o.VRek.removeAllElements();
        }
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setRekFlag(false);
        }
        this.recursiveValidate(o, avoid);
        e2 = this.elements();
        while (e2.hasMoreElements()) {
            oc = (ConstructionObject)e2.nextElement();
            if (!oc.isRekFlag()) continue;
            o.VRek.addElement(oc);
        }
        e2 = o.VRek.elements();
        while (e2.hasMoreElements()) {
            oc = (ConstructionObject)e2.nextElement();
            oc.validate();
        }
        o.RekValidating = false;
    }

    public void recursiveValidate(ConstructionObject o, ConstructionObject avoid) {
        if (o.isRekFlag() || o == avoid) {
            return;
        }
        o.setRekFlag(true);
        ConstructionObject[] d2 = o.getDepArray();
        for (int i = 0; i < d2.length; ++i) {
            this.recursiveValidate(d2[i], avoid);
        }
    }

    public void computeTracks(ZirkelCanvas zc) {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof TrackObject)) continue;
            ((TrackObject)o).compute(zc);
        }
    }

    public void clearTranslations() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setTranslation(null);
        }
    }

    public void determineConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            boolean constructable;
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) {
                o.setFlag(true);
                continue;
            }
            Enumeration ee = o.depending();
            boolean bl = constructable = o instanceof ExpressionObject || o instanceof FunctionObject;
            while (ee.hasMoreElements()) {
                ConstructionObject oo = (ConstructionObject)ee.nextElement();
                if (o == oo) continue;
                if (oo.isFlag()) {
                    constructable = true;
                    continue;
                }
                constructable = false;
                break;
            }
            o.setFlag(constructable);
        }
    }

    public boolean determineConstructables(ConstructionObject o) {
        if (o.isFlag()) {
            return true;
        }
        ConstructionObject[] dep = o.getDepArray();
        boolean constructable = o instanceof ExpressionObject || o instanceof FunctionObject;
        for (int i = 0; i < dep.length; ++i) {
            if (dep[i] == null) {
                return false;
            }
            if (dep[i] == o) continue;
            if (!this.determineConstructables(dep[i])) {
                return false;
            }
            constructable = true;
        }
        o.setFlag(constructable);
        return true;
    }

    public void clearConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setFlag(false);
        }
    }

    public void determineChildren() {
        Enumeration e2 = this.elements();
        block0: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isFlag()) continue;
            Enumeration ee = o.depending();
            while (ee.hasMoreElements()) {
                ConstructionObject oo = (ConstructionObject)ee.nextElement();
                if (!oo.isFlag()) continue;
                o.setFlag(true);
                continue block0;
            }
        }
    }

    public void setParameterAsConstructables() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isParameter() && !o.isMainParameter()) continue;
            o.setFlag(true);
        }
    }

    public String[] getPromptFor() {
        Object[] s = new String[this.PromptFor.size()];
        this.PromptFor.copyInto(s);
        return s;
    }

    public boolean shouldSwitch() {
        return this.ShouldSwitch;
    }

    public boolean noteSwitch() {
        return this.NoteSwitch;
    }

    public void shouldSwitch(boolean flag, boolean note) {
        this.ShouldSwitch = flag;
        this.NoteSwitch = note;
    }

    public void shouldSwitch(boolean flag) {
        this.ShouldSwitch = flag;
        this.NoteSwitch = true;
    }

    public void switchBack() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject)) continue;
            ((IntersectionObject)o).switchBack();
        }
    }

    public void clearSwitches() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject)) continue;
            ((IntersectionObject)o).switchBack();
        }
    }

    public boolean haveSwitched() {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof IntersectionObject) || !((IntersectionObject)o).isSwitched()) continue;
            return true;
        }
        return false;
    }

    public boolean changed() {
        return this.Changed;
    }

    public void haveChanged() {
        this.changed(true);
        if (this.CL != null) {
            this.CL.notifyChanged();
        }
    }

    public void changed(boolean flag) {
        this.Changed = flag;
    }

    public void addTranslator(Translator t) {
        this.TranslatorList.addElement(t);
    }

    public void runTranslators(Construction from) {
        Enumeration e2 = this.TranslatorList.elements();
        while (e2.hasMoreElements()) {
            Translator t = (Translator)e2.nextElement();
            t.laterTranslate(from);
        }
    }

    public void clearTranslators() {
        this.TranslatorList.removeAllElements();
    }

    public void updateCount() {
        int max = 0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            int n = ((ConstructionObject)e2.nextElement()).getNCount();
            if (n <= max) continue;
            max = n;
        }
        this.Count = max + 1;
    }

    public void setOriginalOrder(boolean flag) {
        if (this.V == null) {
            return;
        }
        if (flag) {
            Object[] o = new ConstructionObject[this.V.size()];
            this.V.copyInto(o);
            for (int i = 0; i < o.length; ++i) {
                ((ConstructionObject)o[i]).Value = ((ConstructionObject)o[i]).getNCount();
            }
            Sorter.sort((SortObject[])o);
            Vector<Object> W = new Vector<Object>();
            for (int i = 0; i < o.length; ++i) {
                W.addElement(o[i]);
            }
            this.VOld = this.V;
            this.V = W;
        } else if (this.VOld != null) {
            this.V = this.VOld;
            this.VOld = null;
        }
    }

    public Construction getTranslation() {
        return this.TranslateInto;
    }

    public void setTranslation(Construction C) {
        this.TranslateInto = C;
    }

    public boolean loading() {
        return this.Loading;
    }

    public void addError(String s) {
        this.Errors.addElement(s);
    }

    public Enumeration getErrors() {
        return this.Errors.elements();
    }

    public void clearErrors() {
        this.Errors.removeAllElements();
    }

    public void dontAlternate(boolean flag) {
        this.DontAlternateIntersections = flag;
    }

    public boolean canAlternate() {
        return !this.DontAlternateIntersections;
    }

    public void setPixel(double pixel) {
        this.Pixel = pixel;
    }

    public double getPixel() {
        return this.Pixel;
    }
}

