/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import eric.JGlobals;
import eric.JLocusObjectTracker;
import eric.JMacrosTools;
import eric.JPanel3D;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.swing.JApplet;
import rene.dialogs.Warning;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.util.FileName;
import rene.util.parser.StringParser;
import rene.zirkel.DemoRunner;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelCanvasInterface;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.BoundedPointConstructor;
import rene.zirkel.constructors.Circle3Constructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.ImageConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.constructors.TextConstructor;
import rene.zirkel.dialogs.CommentDialog;
import rene.zirkel.dialogs.Replay;
import rene.zirkel.listener.DoneListener;
import rene.zirkel.listener.StatusListener;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroBar;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TextObject;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.BreakpointAnimator;
import rene.zirkel.tools.DeleteTool;
import rene.zirkel.tools.DrawerTool;
import rene.zirkel.tools.EditTool;
import rene.zirkel.tools.HiderTool;
import rene.zirkel.tools.MoverTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.RenamerTool;
import rene.zirkel.tools.ReorderTool;
import rene.zirkel.tools.SaveJob;
import rene.zirkel.tools.SetParameterTool;
import rene.zirkel.tools.SetTargetsTool;
import rene.zirkel.tools.Tracker;
import rene.zirkel.tools.ZoomerTool;

public class ZirkelApplet
extends JApplet
implements IconBarListener,
StatusListener,
KeyListener,
DoneListener,
DoActionListener,
ZirkelCanvasInterface {
    ZirkelCanvas ZC;
    IconBar IA;
    IconBar IB;
    IconBar IC;
    MacroBar IM;
    String filename = "test.zir";
    Label Status;
    Color C;
    Color CC;
    Frame F;
    String FirstConstructor = "point";
    String Tools = "all";
    String Options = "";
    int CurrentTool = 0;
    HistoryTextField Input;
    ConstructionObject Last = null;
    boolean edit;
    boolean jumptostart;
    public static final String DefaultIcons = " point line segment ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression area text quadric runmacro animate ";
    public static final String DefaultOptions = " back undo delete color type thickness hidden showcolor macro grid  draw twolines indicate ";
    DemoRunner DR = null;
    Replay RD = null;
    public ObjectConstructor[] ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new BoundedPointConstructor(), new IntersectionConstructor(), new LineConstructor(), new RayConstructor(), new SegmentConstructor(), new SegmentConstructor(true), new CircleConstructor(), new Circle3Constructor(), new CircleConstructor(true), new ParallelConstructor(), new PlumbConstructor(), new MidpointConstructor(), new AngleConstructor(), new AngleConstructor(true), new MoverTool(), new Tracker(), new ObjectTracker(), new AnimatorTool(), new ExpressionConstructor(), new AreaConstructor(), new QuadricConstructor(), new ImageConstructor(), new TextConstructor(), new HiderTool(), new JLocusObjectTracker(), new MacroRunner(), new EditTool(), new SetParameterTool(), new SetTargetsTool(), new SaveJob(), new DeleteTool(), new ReorderTool(), new DrawerTool(), new RenamerTool(), new ZoomerTool(), new BreakpointAnimator()};
    String OldMacro = null;
    AnimatorTool A = null;

    public String JScontrol() {
        String exp = "";
        try {
            exp = String.valueOf(this.ZC.getConstruction().find("jscode").getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exp;
    }

    public void paint(Graphics gc) {
        super.paint(gc);
        this.ZC.JCM.readXmlTags();
        this.ZC.dovalidate();
        this.ZC.repaint();
    }

    public void init() {
        if (this.getParameter("language") != null) {
            try {
                Locale.setDefault(new Locale(this.getParameter("language"), ""));
            }
            catch (RuntimeException e2) {
                // empty catch block
            }
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        Count.resetAll();
        this.CC = this.C = Global.Background;
        this.initLightColors();
        this.initObjectKeys();
        Dimension dscreen = this.getToolkit().getScreenSize();
        this.F = new Frame();
        this.F.setSize(dscreen);
        if (this.getParameter("oldicons") == null) {
            Global.setParameter("iconpath", "/eric/icons/palette/");
            Global.setParameter("iconsize", this.getParameter("smallicons") == null ? 32 : 24);
            Global.setParameter("icontype", "png");
        } else {
            Global.setParameter("iconpath", "//eric/icons/palette/");
            Global.setParameter("iconsize", 20);
        }
        String color = this.getParameter("color");
        if (color != null) {
            StringParser p = new StringParser(this.getParameter("color"));
            p.replace(',', ' ');
            int red = p.parseint();
            int green = p.parseint();
            int blue = p.parseint();
            Global.Background = this.C = new Color(red, green, blue);
            Global.ControlBackground = this.C;
            this.CC = this.C;
        }
        if ((color = this.getParameter("colorbackground")) != null) {
            Global.setParameter("colorbackground", color);
        } else {
            Global.removeParameter("colorbackground");
        }
        color = this.getParameter("colorselect");
        if (color != null) {
            Global.setParameter("colorselect", color);
        } else {
            Global.removeParameter("colorselect");
        }
        ZirkelFrame.SelectColor = Global.getParameter("colorselect", Color.red);
        color = this.getParameter("colortarget");
        if (color != null) {
            Global.setParameter("colortarget", color);
        } else {
            Global.removeParameter("colortarget");
        }
        ZirkelFrame.TargetColor = Global.getParameter("colorselect", Color.pink);
        ZirkelFrame.initLightColors(Color.white);
        String font = this.getParameter("font");
        if (font != null) {
            if (font.indexOf("bold") >= 0) {
                Global.setParameter("font.bold", true);
            }
            if (font.indexOf("large") >= 0) {
                Global.setParameter("font.large", true);
            }
        }
        if (this.getParameter("demo") != null) {
            this.initDemo();
            return;
        }
        String style = this.getParameter("style");
        if (style == null) {
            style = this.getParameter("tools") != null || this.getParameter("options") != null ? "icons" : "plain";
        }
        boolean simple = style.equals("plain") || style.equals("3D") || style.equals("breaks");
        this.edit = !simple;
        boolean status = style.equals("full") || style.equals("status");
        boolean icons = style.equals("full") || style.equals("nonvisual") || style.equals("icons");
        boolean breaks = style.equals("breaks");
        if (this.getParameter("edit") != null) {
            this.edit = true;
        }
        for (int i = 0; i < ZirkelFrame.Colors.length; ++i) {
            color = this.getParameter("color" + i);
            if (color != null) {
                Global.setParameter("color" + i, color);
                continue;
            }
            Global.removeParameter("color" + i);
        }
        ZirkelFrame.initLightColors(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.Tools = this.getParameter("tools");
        if (this.Tools == null || this.Tools.equals("defaults")) {
            this.Tools = DefaultIcons;
        }
        this.Options = this.getParameter("options");
        if (this.Options == null || this.Options.equals("defaults")) {
            this.Options = DefaultOptions;
        }
        Global.setParameter("macrobar", this.Options.indexOf("macrobar") >= 0);
        if (icons) {
            Panel north;
            this.IB = new IconBar(this.F);
            this.IB.setBackground(this.CC);
            this.IB.setIconBarListener(this);
            StringTokenizer t = new StringTokenizer(this.Tools);
            int count = 0;
            while (t.hasMoreTokens()) {
                t.nextToken();
                ++count;
            }
            String[] a2 = new String[count];
            t = new StringTokenizer(this.Tools);
            count = 0;
            while (t.hasMoreTokens()) {
                a2[count++] = t.nextToken();
            }
            if (count > 0) {
                this.FirstConstructor = a2[0];
            }
            this.IB.addToggleGroupLeft(a2);
            if (this.Options.indexOf("twolines") >= 0 || this.Options.indexOf("defaults") >= 0) {
                this.IA = new IconBar(this.F);
                this.IA.setBackground(this.CC);
                this.IA.setIconBarListener(this);
                this.setIA(this.IA, this.Options);
                north = new Panel();
                north.setBackground(this.CC);
                north.setLayout(new GridLayout(0, 1));
                north.add(this.IA);
                north.add(this.IB);
                if (this.IM != null) {
                    north.add(this.IM);
                }
                this.getContentPane().add("North", new JPanel3D(north, this.CC));
            } else {
                this.IA = this.IB;
                this.setIA(this.IB, this.Options);
                if (this.IM != null) {
                    north = new Panel();
                    north.setBackground(this.CC);
                    north.setLayout(new GridLayout(0, 1));
                    north.add(this.IA);
                    if (this.IM != null) {
                        north.add(this.IM);
                    }
                    this.getContentPane().add("North", new JPanel3D(north, this.CC));
                } else {
                    this.getContentPane().add("North", new JPanel3D(this.IB, this.CC));
                }
            }
        } else {
            this.IB = null;
            this.IA = null;
        }
        Zirkel.IsApplet = true;
        Global.setParameter("options.choice", true);
        Global.setParameter("options.indicate", true);
        Global.setParameter("options.indicate.simple", false);
        Global.setParameter("options.intersection", false);
        Global.setParameter("options.pointon", false);
        JMacrosTools.initObjectsProperties();
        if (this.getParameter("selectionsize") != null) {
            try {
                double x = new Double(this.getParameter("selectionsize"));
                Global.setParameter("selectionsize", x);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        this.ZC = new ZirkelCanvas(!this.edit, !breaks, !breaks);
        this.ZC.addMouseListener(this.ZC);
        this.ZC.addMouseMotionListener(this.ZC);
        this.ZC.setBackground(Global.getParameter("colorbackground", this.C));
        this.ZC.setFrame(this.F);
        this.ZC.setZirkelCanvasListener(this);
        if (this.getParameter("showhidden") != null) {
            this.ZC.setShowHidden(true);
        }
        if (style.equals("plain")) {
            this.getContentPane().add("Center", this.ZC);
        } else {
            this.getContentPane().add("Center", new JPanel3D(this.ZC, this.ZC.getBackground()));
        }
        this.ZC.addStatusListener(this);
        this.ZC.addKeyListener(this);
        this.setShowNames(false);
        if (status) {
            this.Status = new Label("");
            this.Status.setBackground(this.CC);
            this.getContentPane().add("South", new JPanel3D(this.Status, this.Status.getBackground()));
        } else if (style.equals("nonvisual")) {
            this.Input = new HistoryTextField(this, "Input");
            this.ZC.setTextField(this.Input);
            this.ZC.Visual = false;
            this.setShowNames(true);
            this.getContentPane().add("South", new JPanel3D(this.Input));
        }
        try {
            Global.setParameter("digits.edit", Integer.parseInt(this.getParameter("editdigits")));
        }
        catch (Exception e4) {
            // empty catch block
        }
        try {
            Global.setParameter("digits.lengths", Integer.parseInt(this.getParameter("displaydigits")));
        }
        catch (Exception e5) {
            // empty catch block
        }
        try {
            Global.setParameter("digits.angles", Integer.parseInt(this.getParameter("angledigits")));
        }
        catch (Exception e6) {
            // empty catch block
        }
        this.setOption("movename");
        this.setOption("movefixname");
        this.ZC.updateDigits();
        this.setOption("nopopupmenu");
        this.setOption("nomousezoom");
        try {
            Global.setParameter("minpointsize", new Double(this.getParameter("minpointsize")));
        }
        catch (Exception e7) {
            // empty catch block
        }
        try {
            Global.setParameter("minlinesize", new Double(this.getParameter("minlinesize")));
        }
        catch (Exception e8) {
            // empty catch block
        }
        try {
            Global.setParameter("minfontsize", new Double(this.getParameter("minfontsize")));
        }
        catch (Exception e9) {
            // empty catch block
        }
        try {
            Global.setParameter("arrowsize", new Double(this.getParameter("arrowsize")));
        }
        catch (Exception e10) {
            // empty catch block
        }
        try {
            String grid = this.getParameter("grid");
            this.ZC.ShowGrid = !grid.equals("none");
            Global.setParameter("grid.fine", grid.equals("coordinates"));
            if (this.getParameter("snap").equals("left")) {
                Global.setParameter("grid.leftsnap", true);
            }
        }
        catch (Exception e11) {
            // empty catch block
        }
        if (this.getParameter("interactive") != null && this.getParameter("interactive").equals("false")) {
            this.ZC.setInteractive(false);
        }
        boolean job = false;
        this.ZC.IW = this.getSize().width;
        this.ZC.IH = this.getSize().height;
        if (this.getParameter("germanpoints") != null && this.getParameter("germanpoints").equals("true")) {
            Global.setParameter("options.germanpoints", true);
        }
        try {
            InputStream o = this.getClass().getResourceAsStream("/builtin.mcr");
            this.ZC.ProtectMacros = true;
            this.ZC.load(o, false, true);
            this.ZC.ProtectMacros = false;
            o.close();
            this.ZC.PM.removeAll();
        }
        catch (Exception e12) {
            // empty catch block
        }
        this.filename = this.getParameter("file");
        if (this.filename == null) {
            this.filename = this.getParameter("job");
            job = true;
        }
        if (this.filename != null) {
            boolean firsttry = true;
            while (true) {
                try {
                    URL url = this.filename.toUpperCase().startsWith("HTTP") ? new URL(firsttry ? FileName.toURL(this.filename) : this.filename) : new URL(this.getCodeBase(), firsttry ? FileName.toURL(this.filename) : this.filename);
                    this.ZC.clear();
                    InputStream in = url.openStream();
                    if (ZirkelFrame.isCompressed(this.filename)) {
                        in = new GZIPInputStream(in);
                    }
                    this.showStatus(Global.name("loading"));
                    this.ZC.load(in);
                    this.toggleGrid(this.ZC.ShowGrid);
                    if (job) {
                        this.ZC.displayJob(true);
                        this.ZC.setDoneListener(this);
                    }
                    if (icons) {
                        this.iconPressed(this.FirstConstructor);
                    }
                    in.close();
                    if (this.getParameter("background") != null) {
                        Image i = this.getToolkit().getImage(new URL(this.getCodeBase(), this.getParameter("background")));
                        MediaTracker mt = new MediaTracker(this);
                        mt.addImage(i, 0);
                        mt.waitForID(0);
                        if (mt.checkID(0) && !mt.isErrorAny()) {
                            this.ZC.setBackground(i);
                        }
                    }
                    this.ZC.repaint();
                }
                catch (Exception e13) {
                    if (firsttry) {
                        firsttry = false;
                        continue;
                    }
                    Warning w = new Warning(this.F, FileName.chop(32, "" + e13, 64), Zirkel.name("message"), true);
                    w.center(this.F);
                    w.setVisible(true);
                    this.showStatus("" + e13);
                    e13.printStackTrace();
                    System.out.println(e13);
                }
                break;
            }
        }
        if (breaks) {
            this.IC = new IconBar(this.F);
            this.IC.setBackground(this.CC);
            this.IC.setIconBarListener(this);
            this.IC.addLeft("allback");
            if (this.haveBreaks()) {
                this.IC.addLeft("nextbreak");
            } else {
                this.IC.addLeft("oneforward");
            }
            this.IC.addLeft("allforward");
            JPanel3D pic = new JPanel3D(this.IC);
            this.getContentPane().add("South", pic);
            this.IC.setEnabled("nextbreak", false);
            this.IC.setEnabled("oneforward", false);
            this.IC.setEnabled("allforward", false);
            this.ZC.getConstruction().setOriginalOrder(true);
            boolean bl = this.jumptostart = this.getParameter("jumptostart") != null;
        }
        if (this.getParameter("restrictedmove") != null) {
            Global.setParameter("restrictedmove", true);
        }
        if (this.getParameter("noconfirmation") != null) {
            Global.setParameter("confirmation", false);
        }
        if (this.IA != null) {
            this.settype(2);
        }
        this.ZC.setMacroBar(this.IM);
        this.ZC.updateMacroBar();
        this.ZC.recompute();
        this.ZC.setSize(this.ZC.getSize().width + 1, this.ZC.getSize().height + 1);
        this.ZC.setSize(this.ZC.getSize().width - 1, this.ZC.getSize().height - 1);
        this.ZC.JCM.hideHandles(null);
    }

    public void setOption(String option) {
        try {
            Global.setParameter("options." + option, this.getParameter(option).equals("true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initDemo() {
        this.getContentPane().setLayout(new BorderLayout());
        this.ZC = new ZirkelCanvas(false, false, false);
        this.ZC.setBackground(Global.getParameter("colorbackground", this.C));
        this.ZC.setFrame(this.F);
        this.ZC.setZirkelCanvasListener(this);
        if (this.getParameter("showhidden") != null) {
            this.ZC.setShowHidden(true);
        }
        this.getContentPane().add("Center", new JPanel3D(this.ZC, this.ZC.getBackground()));
        this.Status = new Label("", 1);
        this.Status.setBackground(this.C);
        this.getContentPane().add("South", new JPanel3D(this.Status, this.Status.getBackground()));
    }

    void setIA(IconBar IA, String set) {
        if (set.indexOf("rename") >= 0) {
            IA.addToggleLeft("rename");
        }
        if (set.indexOf("back") >= 0) {
            IA.addLeft("back");
        }
        if (set.indexOf("delete") >= 0) {
            IA.addToggleLeft("delete");
        }
        if (set.indexOf("undo") >= 0) {
            IA.addLeft("undo");
        }
        if (set.indexOf("hidden") >= 0) {
            IA.addOnOffLeft("hidden");
        }
        if (set.indexOf("showcolor") >= 0) {
            IA.addMultipleIconLeft("showcolor", ZirkelFrame.Colors.length);
        }
        if (set.indexOf("color") >= 0) {
            IA.addMultipleIconLeft("color", 6);
        }
        if (set.indexOf("type") >= 0) {
            IA.addMultipleIconLeft("type", 6);
        }
        if (set.indexOf("thickness") >= 0) {
            IA.addMultipleIconLeft("thickness", 3);
        }
        if (set.indexOf("partial") >= 0) {
            IA.addOnOffLeft("partial");
        }
        if (set.indexOf("plines") >= 0) {
            IA.addOnOffLeft("plines");
        }
        if (set.indexOf("arrow") >= 0) {
            IA.addOnOffLeft("arrow");
        }
        if (set.indexOf("showname") >= 0) {
            IA.addOnOffLeft("showname");
        }
        if (set.indexOf("showvalue") >= 0) {
            IA.addOnOffLeft("showvalue");
        }
        if (set.indexOf("edit") >= 0) {
            IA.addToggleLeft("edit");
        }
        if (set.indexOf("obtuse") >= 0) {
            IA.addOnOffLeft("obtuse");
        }
        if (set.indexOf("solid") >= 0) {
            IA.addOnOffLeft("solid");
        }
        if (set.indexOf("grid") >= 0) {
            IA.addOnOffLeft("grid");
        }
        if (set.indexOf("macro") >= 0) {
            IA.addMultipleToggleIconLeft("macro", 3);
        }
        if (set.indexOf("replay") >= 0) {
            IA.addLeft("replay");
        }
        if (set.indexOf("zoom") >= 0) {
            IA.addToggleLeft("zoom");
        }
        if (set.indexOf("comment") >= 0) {
            IA.addLeft("comment");
        }
        if (set.indexOf("function") >= 0) {
            IA.addLeft("function");
        }
        if (set.indexOf("draw") >= 0) {
            IA.addToggleLeft("draw");
        }
    }

    public void makeMacroBar() {
        if (Global.getParameter("macrobar", true)) {
            this.IM = new MacroBar(this.F);
            this.IM.addKeyListener(this);
            this.IM.setIconBarListener(this);
            this.IM.setBackground(this.CC);
        }
    }

    public void updateMacroBar() {
        this.ZC.updateMacroBar();
    }

    public void iconPressed(String o) {
        int n;
        Macro m;
        if (this.RD != null) {
            this.RD.doclose();
        }
        this.ZC.requestFocus();
        if (this.IA != null && this.IA.isControlPressed()) {
            if (o.equals("edit")) {
                if (this.CurrentTool != 27) {
                    this.IA.setState("edit", false);
                }
                this.ZC.editLast();
                this.ZC.repaint();
            }
            this.IA.clearShiftControl();
            return;
        }
        for (int i = 0; i < ZirkelFrame.ObjectStrings.length; ++i) {
            if (!o.equals(ZirkelFrame.ObjectStrings[i])) continue;
            if (i == 26) {
                this.runmacro(this.IB.isShiftPressed());
            } else {
                this.settool(i);
            }
            return;
        }
        if (this.IM != null && (m = this.IM.find(o)) != null) {
            this.runMacro(m);
            return;
        }
        if (o.equals("hidden")) {
            this.ZC.setShowHidden(this.IA.getState("hidden"));
        } else if (o.equals("partial")) {
            this.ZC.setPartial(this.IA.getState("partial"));
        } else if (o.equals("plines")) {
            this.ZC.setPartialLines(this.IA.getState("plines"));
        } else if (o.equals("arrow")) {
            this.ZC.setVectors(this.IA.getState("arrow"));
        } else if (o.equals("color")) {
            n = this.IA.getMultipleState("color");
            if (n >= 0) {
                this.setcolor(n);
            }
        } else if (o.equals("showcolor")) {
            n = this.IA.getMultipleState("showcolor");
            if (n >= 0) {
                this.showcolor(n);
            }
        } else if (o.equals("showname")) {
            this.setShowNames(this.IA.getState("showname"));
        } else if (o.equals("obtuse")) {
            this.setObtuse(this.IA.getState("obtuse"));
        } else if (o.equals("solid")) {
            this.setSolid(this.IA.getState("solid"));
        } else if (o.equals("showvalue")) {
            this.setShowValues(this.IA.getState("showvalue"));
        } else if (o.equals("longnames")) {
            this.setLongNames(this.IA.getState("longnames"));
        } else if (o.equals("grid")) {
            this.toggleGrid(this.IA.getState("grid"));
        } else if (o.equals("comment")) {
            this.showcomment();
        } else if (o.equals("function")) {
            if (this.IA.isControlPressed()) {
                this.ZC.createFunction();
            } else {
                this.ZC.createCurve();
            }
        } else if (o.equals("type")) {
            n = this.IA.getMultipleState("type");
            if (n >= 0) {
                this.settype(n);
            }
        } else if (o.equals("thickness")) {
            n = this.IA.getMultipleState("thickness");
            if (n >= 0) {
                this.setcolortype(n);
            }
        } else if (o.equals("edit")) {
            this.settool(27);
        } else if (o.equals("back")) {
            this.ZC.back();
            this.ZC.repaint();
        } else if (o.equals("undo")) {
            this.ZC.undo();
            this.ZC.repaint();
        } else if (o.equals("replay")) {
            this.replay();
        } else if (o.equals("macro")) {
            n = this.IA.getMultipleState("macro");
            switch (n) {
                case 1: {
                    this.settool(28);
                    break;
                }
                case 2: {
                    this.settool(29);
                    break;
                }
                case 0: {
                    this.definemacro();
                }
            }
            this.IA.setState("macro", true);
        } else if (o.equals("allback")) {
            Enumeration e2;
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            if ((e2 = this.ZC.getConstruction().elements()).hasMoreElements()) {
                this.Last = (ConstructionObject)e2.nextElement();
                this.ZC.paintUntil(this.Last);
                if (this.Last instanceof TextObject && this.Last.valid() && !this.Last.isSuperHidden()) {
                    ((TextObject)this.Last).setDoShow(true);
                }
            }
            this.IC.setEnabled("allforward", true);
            this.IC.setEnabled("nextbreak", true);
            this.IC.setEnabled("oneforward", true);
            this.IC.setEnabled("allback", false);
            if (this.haveBreaks() && !this.Last.isBreak()) {
                this.iconPressed("nextbreak");
            }
        } else if (o.equals("allforward")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            this.ZC.paintUntil(null);
            this.Last = null;
            this.IC.setEnabled("allforward", false);
            this.IC.setEnabled("nextbreak", false);
            this.IC.setEnabled("oneforward", false);
            this.IC.setEnabled("allback", true);
        } else if (o.equals("nextbreak")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            Enumeration e3 = this.ZC.getConstruction().elements();
            block6: while (e3.hasMoreElements()) {
                ConstructionObject next = (ConstructionObject)e3.nextElement();
                if (next != this.Last) continue;
                while (e3.hasMoreElements()) {
                    this.Last = (ConstructionObject)e3.nextElement();
                    if (this.Last != null && !this.Last.isBreak()) continue;
                    break block6;
                }
            }
            this.IC.setEnabled("allback", true);
            if (this.Last instanceof TextObject && this.Last.valid() && !this.Last.isSuperHidden()) {
                ((TextObject)this.Last).setDoShow(true);
            }
            this.ZC.paintUntil(this.Last);
            this.IC.setEnabled("allback", true);
            this.IC.setEnabled("nextbreak", e3.hasMoreElements());
            this.IC.setEnabled("allforward", e3.hasMoreElements());
        } else if (o.equals("oneforward")) {
            if (this.Last != null && this.Last instanceof TextObject) {
                ((TextObject)this.Last).setDoShow(false);
            }
            Enumeration e4 = this.ZC.getConstruction().elements();
            block8: while (e4.hasMoreElements()) {
                ConstructionObject next = (ConstructionObject)e4.nextElement();
                if (next != this.Last) continue;
                while (e4.hasMoreElements()) {
                    this.Last = (ConstructionObject)e4.nextElement();
                    if (this.Last == null || !this.Last.isHidden()) break block8;
                    if (!(this.Last instanceof TextObject) || !this.Last.valid() || this.Last.isSuperHidden()) continue;
                    ((TextObject)this.Last).setDoShow(true);
                    break block8;
                }
            }
            this.IC.setEnabled("allback", true);
            this.ZC.paintUntil(this.Last);
            if (!e4.hasMoreElements()) {
                this.ZC.paintUntil(null);
                this.IC.setEnabled("allforward", false);
                this.IC.setEnabled("oneforward", false);
                this.IC.setEnabled("allback", true);
            }
        } else if (o.startsWith("bi_")) {
            JGlobals.runmacro(this.ZC, this, "@builtin@/" + o.substring(3));
        }
        this.IA.clearShiftControl();
        this.IB.clearShiftControl();
    }

    public void settool(int i) {
        if (this.IM != null) {
            this.IM.deselectAll();
        }
        this.ZC.setTool(this.ObjectConstructors[i]);
        this.CurrentTool = i;
        if (i < 27 && this.IB.have(ZirkelFrame.ObjectStrings[i])) {
            this.IB.toggle(ZirkelFrame.ObjectStrings[i]);
        } else {
            this.IB.unselect(this.FirstConstructor);
        }
        this.ObjectConstructors[i].resetFirstTime(this.ZC);
        if (i == 29) {
            this.IA.setMultipleState("macro", 2);
        } else if (i == 28) {
            this.IA.setMultipleState("macro", 1);
        } else {
            this.IA.setMultipleState("macro", 0);
            this.IA.setState("macro", false);
        }
        this.IA.setState("delete", i == 31);
        this.IA.setState("edit", i == 27);
        this.IA.setState("draw", i == 33);
        this.IA.setState("rename", i == 34);
        this.IA.setState("zoom", i == 35);
    }

    public void setcolor(int c2) {
        this.IA.setMultipleState("color", c2);
        this.ZC.setDefaultColor(c2);
    }

    public void settype(int c2) {
        this.IA.setMultipleState("type", c2);
        this.ZC.setDefaultType(c2);
    }

    public void setcolortype(int c2) {
        this.IA.setMultipleState("thickness", c2);
        this.ZC.setDefaultColorType(c2);
    }

    public void showStatus(String s) {
        super.showStatus(s);
        if (this.Status != null) {
            this.Status.setText(s);
        }
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        int code = e2.getKeyCode();
        boolean Shift = e2.isShiftDown();
        boolean Control2 = e2.isControlDown();
        boolean Alt = e2.isAltDown();
        if (Control2) {
            int i;
            if (this.Options.indexOf("type") > 0) {
                for (i = 0; i < ZirkelFrame.PointKeys.length; ++i) {
                    if (ZirkelFrame.PointKeys[i] != code) continue;
                    this.settype(i);
                    return;
                }
            }
            if (this.Options.indexOf("color") > 0) {
                for (i = 0; i < ZirkelFrame.ColorKeys.length; ++i) {
                    if (ZirkelFrame.ColorKeys[i] != code) continue;
                    this.setcolor(i);
                    return;
                }
            }
        } else if (Alt) {
            int i;
            if (this.Options.indexOf("showcolor") > 0) {
                for (i = 0; i < ZirkelFrame.ColorKeys.length; ++i) {
                    if (ZirkelFrame.ColorKeys[i] != code) continue;
                    this.showcolor(i);
                    return;
                }
            }
            if (this.Options.indexOf("thickness") > 0) {
                for (i = 0; i < ZirkelFrame.ColorTypeKeys.length; ++i) {
                    if (ZirkelFrame.ColorTypeKeys[i] != code) continue;
                    this.setcolortype(i);
                    return;
                }
            }
        } else {
            switch (code) {
                case 27: {
                    if (this.ZC.getCurrentTool() instanceof DrawerTool) {
                        this.ZC.clearDrawings();
                        break;
                    }
                    this.ZC.reset();
                }
            }
        }
        if (!e2.isActionKey()) {
            return;
        }
        switch (code) {
            case 112: {
                this.showVersion();
                break;
            }
            case 118: {
                if (!Shift && !Control2) break;
                this.setShowNames(!this.IA.getState("showname"));
                break;
            }
            case 119: {
                if (!Shift && !Control2) break;
                this.setLongNames(!this.IA.getState("longnames"));
                break;
            }
            case 120: {
                if (Shift || Control2) {
                    this.IA.setState("partial", !this.IA.getState("partial"));
                    this.ZC.setPartial(this.IA.getState("partial"));
                    break;
                }
                if (this.Options.indexOf("hidden") < 0) break;
                this.IA.setState("hidden", !this.IA.getState("hidden"));
                this.ZC.setShowHidden(this.IA.getState("hidden"));
                break;
            }
            case 121: {
                if (Shift || Control2) {
                    this.IA.setState("plines", !this.IA.getState("plines"));
                    this.ZC.setPartial(this.IA.getState("plines"));
                    break;
                }
                this.showcomment();
                break;
            }
            case 122: {
                if (Shift || Control2) {
                    this.IA.setState("arrow", !this.IA.getState("arrow"));
                    this.ZC.setPartial(this.IA.getState("arrow"));
                    break;
                }
                this.showconstruction();
                break;
            }
            case 123: {
                if (Shift || Control2) {
                    this.IA.setState("obtuse", !this.IA.getState("obtuse"));
                    this.ZC.setObtuse(this.IA.getState("obtuse"));
                    break;
                }
                this.toggleGrid();
                break;
            }
            case 37: {
                if (Shift && this.ZC.getCurrentTool() instanceof ObjectTracker) {
                    ((ObjectTracker)this.ZC.getCurrentTool()).increaseOmit();
                    break;
                }
                if (Shift && this.ZC.getCurrentTool() instanceof BreakpointAnimator) {
                    ((BreakpointAnimator)this.ZC.getCurrentTool()).decreaseSpeed();
                    break;
                }
                if (Shift && this.ZC.getCurrentTool() instanceof AnimatorTool) {
                    ((AnimatorTool)this.ZC.getCurrentTool()).decreaseSpeed();
                    break;
                }
                this.ZC.shift(-0.2, 0.0);
                break;
            }
            case 39: {
                if (Shift && this.ZC.getCurrentTool() instanceof ObjectTracker) {
                    ((ObjectTracker)this.ZC.getCurrentTool()).decreaseOmit();
                    break;
                }
                if (Shift && this.ZC.getCurrentTool() instanceof BreakpointAnimator) {
                    ((BreakpointAnimator)this.ZC.getCurrentTool()).increaseSpeed();
                    break;
                }
                if (Shift && this.ZC.getCurrentTool() instanceof AnimatorTool) {
                    ((AnimatorTool)this.ZC.getCurrentTool()).increaseSpeed();
                    break;
                }
                this.ZC.shift(0.2, 0.0);
                break;
            }
            case 38: {
                this.ZC.shift(0.0, 0.2);
                break;
            }
            case 40: {
                this.ZC.shift(0.0, -0.2);
            }
        }
    }

    public void keyTyped(KeyEvent e2) {
        char c2 = e2.getKeyChar();
        if (e2.isControlDown() || e2.isAltDown()) {
            return;
        }
        for (int i = 0; i < ZirkelFrame.ObjectKeys.length; ++i) {
            if (c2 != ZirkelFrame.ObjectKeys[i]) continue;
            if (this.Tools.indexOf(ZirkelFrame.ObjectStrings[i]) >= 0) {
                this.settool(i);
            }
            return;
        }
        switch (c2) {
            case '\b': {
                this.ZC.undo();
                this.ZC.repaint();
                return;
            }
            case '+': {
                this.ZC.magnify(1.0 / Math.sqrt(Math.sqrt(2.0)));
                break;
            }
            case '-': {
                this.ZC.magnify(Math.sqrt(Math.sqrt(2.0)));
            }
        }
    }

    public void initLightColors() {
        int n = ZirkelFrame.Colors.length;
        ZirkelFrame.LightColors = new Color[n];
        Color back = this.C;
        int red = back.getRed();
        int green = back.getGreen();
        int blue = back.getBlue();
        double lambda = 0.4;
        for (int i = 0; i < n; ++i) {
            int r = (int)((double)red * (1.0 - lambda) + (double)ZirkelFrame.Colors[i].getRed() * lambda);
            int g = (int)((double)green * (1.0 - lambda) + (double)ZirkelFrame.Colors[i].getGreen() * lambda);
            int b2 = (int)((double)blue * (1.0 - lambda) + (double)ZirkelFrame.Colors[i].getBlue() * lambda);
            ZirkelFrame.LightColors[i] = new Color(r, g, b2);
        }
    }

    public void initObjectKeys() {
        ZirkelFrame.ObjectKeys = new char[ZirkelFrame.ObjectStrings.length];
        for (int i = 0; i < ZirkelFrame.ObjectStrings.length; ++i) {
            String shortcut = Zirkel.name("shortcuts." + ZirkelFrame.ObjectStrings[i]);
            if (shortcut.length() <= 0) continue;
            ZirkelFrame.ObjectKeys[i] = shortcut.charAt(0);
        }
    }

    public void notifyDone() {
        String sol;
        this.repaint();
        try {
            Thread.sleep(500L);
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (Global.getParameter("confirmation", true)) {
            Warning w = new Warning(this.F, Zirkel.name("done"), Zirkel.name("message"), true);
            w.center(this.F);
            w.setVisible(true);
        }
        if ((sol = this.getParameter("solution")) != null) {
            try {
                AppletContext ac = this.getAppletContext();
                ac.showDocument(new URL(this.getCodeBase(), FileName.toURL(sol)));
            }
            catch (Exception e3) {
                System.out.println(e3);
                e3.printStackTrace();
            }
        }
    }

    public void showcolor(int c2) {
        this.ZC.setShowColor(c2);
    }

    public void showcomment() {
        if (this.F == null) {
            return;
        }
        CommentDialog d2 = new CommentDialog(this.F, this.ZC.getComment(), Zirkel.name("comment.title"), this.ZC.displayJob());
        this.ZC.setComment(d2.getText());
    }

    public void showconstruction() {
        if (this.F == null) {
            return;
        }
    }

    public void toggleGrid() {
        this.ZC.toggleShowGrid();
    }

    void definemacro() {
        if (!this.ZC.defineMacro()) {
            return;
        }
        if (this.ZC.getOC() instanceof SetTargetsTool) {
            this.settool(28);
        } else {
            this.ZC.getOC().reset(this.ZC);
        }
    }

    public void runmacro(boolean shift) {
        Macro m = null;
        if (this.OldMacro == null && this.ZC.getMacros().size() == 1) {
            m = ((MacroItem)this.ZC.getMacros().elementAt((int)0)).M;
        } else {
            m = this.ZC.chooseMacro(this.OldMacro);
            if (!shift || m == null) {
                m = this.ZC.chooseMacro();
            }
        }
        if (m == null) {
            this.settool(this.CurrentTool);
            return;
        }
        this.runMacro(m);
    }

    public void runMacro(Macro m) {
        ((MacroRunner)this.ObjectConstructors[26]).setMacro(m, this.ZC);
        this.settool(26);
        if (this.IM != null) {
            this.IM.select(m);
        }
        this.IB.setMultipleState("macro", 0);
        this.OldMacro = m.getName();
    }

    public void setShowNames(boolean flag) {
        if (this.IA != null) {
            this.IA.setState("showname", flag);
        }
        Global.setParameter("options.point.shownames", flag);
        this.ZC.setShowNames(flag);
    }

    public void setObtuse(boolean flag) {
        this.IA.setState("obtuse", flag);
        Global.setParameter("options.obtuse", flag);
        this.ZC.setObtuse(flag);
    }

    public void setSolid(boolean flag) {
        this.IA.setState("solid", flag);
        Global.setParameter("options.solid", flag);
        this.ZC.setSolid(flag);
    }

    public void setShowValues(boolean flag) {
        this.IA.setState("showvalue", flag);
        Global.setParameter("options.showvalue", flag);
        this.ZC.setShowValues(flag);
    }

    public void setLongNames(boolean flag) {
        this.IA.setState("longnames", flag);
        Global.setParameter("options.longnames", flag);
        this.ZC.setLongNames(flag);
    }

    public void toggleGrid(boolean grid) {
        this.ZC.setShowGrid(grid);
        if (this.IA != null) {
            this.IA.setState("grid", grid);
        }
    }

    public void loadsettings() {
        this.setcolor(this.ZC.getDefaultColor());
        this.settype(this.ZC.getDefaultType());
        this.setcolortype(this.ZC.getDefaultColorType());
        this.IA.setState("partial", this.ZC.getPartial());
        this.IA.setState("plines", this.ZC.getPartialLines());
        this.IA.setState("arrow", this.ZC.getVectors());
        this.ZC.setHidden(false);
    }

    public void doAction(String o) {
        if (o.equals("Input")) {
            try {
                this.ZC.getConstruction().interpret(this.ZC, this.Input.getText(), "");
                this.Input.remember();
                this.Input.setText("");
                this.loadsettings();
                this.ZC.validate();
                this.ZC.getConstruction().updateCircleDep();
            }
            catch (ConstructionException e2) {
                this.ZC.warning(e2.getDescription());
            }
        }
    }

    public void itemAction(String o, boolean flag) {
    }

    public void start() {
        block24: {
            if (this.getParameter("demo") != null) {
                this.DR = new DemoRunner(this.ZC, this, this.getParameter("demo"), this.Status);
                return;
            }
            Construction C = this.ZC.getConstruction();
            this.ZC.paint(this.ZC.getGraphics());
            this.ZC.allowRightMouse(true);
            if (C.TrackP != null) {
                try {
                    ConstructionObject P = C.find(C.TrackP);
                    if (!(P instanceof PointObject) && !(P instanceof PrimitiveLineObject)) {
                        throw new ConstructionException("");
                    }
                    ConstructionObject[] po = new ConstructionObject[C.TrackPO.size()];
                    for (int i = 0; i < po.length; ++i) {
                        ConstructionObject o = C.find((String)C.TrackPO.elementAt(i));
                        if (o == null || !(o instanceof PointObject) && !(o instanceof PrimitiveLineObject)) {
                            throw new ConstructionException("");
                        }
                        po[i] = o;
                    }
                    PointObject PM = null;
                    if (C.TrackPM != null) {
                        PM = (PointObject)C.find(C.TrackPM);
                    }
                    if (C.TrackO != null) {
                        ConstructionObject O = C.find(C.TrackO);
                        if (P == null || PM == null && O instanceof ExpressionObject || O == null) {
                            throw new ConstructionException("");
                        }
                        ObjectTracker ot = new ObjectTracker(P, PM, O, this.ZC, C.Animate, C.Paint, po);
                        if (C.Animate) {
                            ot.Interactive = false;
                        }
                        ot.setOmit(C.Omit);
                        this.ZC.setTool(ot);
                        if (!this.edit) {
                            this.ZC.allowRightMouse(false);
                        }
                        this.ZC.validate();
                        this.ZC.repaint();
                        break block24;
                    }
                    if (P == null) {
                        throw new ConstructionException("");
                    }
                    this.ZC.setTool(new Tracker(P, po));
                    if (PM != null) {
                        PM.setSelected(true);
                    }
                    this.ZC.validate();
                    this.ZC.repaint();
                }
                catch (Exception e2) {}
            } else if (C.AnimateP != null) {
                try {
                    PointObject P = (PointObject)C.find(C.AnimateP);
                    if (P == null || !P.moveable()) {
                        throw new ConstructionException("");
                    }
                    Enumeration e3 = C.AnimateV.elements();
                    while (e3.hasMoreElements()) {
                        String s = (String)e3.nextElement();
                        ConstructionObject o = C.find(s);
                        if (o != null && (o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject)) continue;
                        throw new ConstructionException("");
                    }
                    this.A = new AnimatorTool(P, C.AnimateV, this.ZC, C.AnimateNegative, C.AnimateOriginal, C.AnimateDelay);
                    this.ZC.setTool(this.A);
                    this.ZC.allowRightMouse(false);
                    this.A.setInteractive(false);
                }
                catch (Exception e4) {}
            } else if (C.AnimateBreakpoints) {
                BreakpointAnimator bp = new BreakpointAnimator();
                bp.setLoop(C.AnimateLoop);
                bp.setSpeed(C.AnimateTime);
                this.ZC.allowRightMouse(false);
                this.ZC.setTool(bp);
                bp.reset(this.ZC);
            } else if (this.jumptostart) {
                System.out.println("here");
                this.iconPressed("allback");
            }
        }
    }

    public void showVersion() {
        this.showStatus(Zirkel.name("program.name") + " " + Zirkel.name("program.version") + " " + Zirkel.name("program.date"));
    }

    public void stop() {
        this.ZC.invalidate();
        if (this.DR != null) {
            this.DR.stop();
        }
    }

    public void destroy() {
        this.ZC.invalidate();
        if (this.DR != null) {
            this.DR.stop();
        }
    }

    public void replay() {
        if (this.RD != null) {
            return;
        }
        this.RD = new Replay(this.F, this.ZC){

            public void doclose() {
                ZirkelApplet.this.RD = null;
                super.doclose();
            }
        };
        Dimension d2 = this.getToolkit().getScreenSize();
        this.RD.setLocation(d2.width - 100 - this.RD.getSize().width, 100);
        this.ZC.OC.invalidate(this.ZC);
        this.RD.setVisible(true);
    }

    public void replayChosen() {
        this.replay();
    }

    public boolean enabled(String function) {
        if (this.Tools.indexOf("all") >= 0) {
            return true;
        }
        return this.Tools.indexOf(function) >= 0;
    }

    public boolean haveBreaks() {
        Enumeration e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            if (!((ConstructionObject)e2.nextElement()).isBreak()) continue;
            return true;
        }
        return false;
    }

    public String loadImage() {
        return null;
    }

    public Image doLoadImage(String filename) {
        try {
            Image i = this.getToolkit().getImage(new URL(this.getCodeBase(), filename));
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(i, 0);
            mt.waitForID(0);
            if (mt.checkID(0) && !mt.isErrorAny()) {
                return i;
            }
        }
        catch (Exception e2) {
            this.showStatus(e2.toString());
        }
        return null;
    }

    public boolean interpret(String s) {
        try {
            this.ZC.getConstruction().interpret(this.ZC, s);
            this.ZC.repaint();
            return true;
        }
        catch (ConstructionException e2) {
            return false;
        }
    }

    public String getConstruction() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.ZC.save(out, true, true, false, this.ZC.getMacros(), "");
            return out.toString("utf-8");
        }
        catch (Exception e2) {
            return "Error";
        }
    }

    public boolean putConstruction(String s) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)bout, "utf-8"));
            out.print(s);
            out.close();
            byte[] b2 = bout.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(b2);
            this.ZC.load(in, true, true);
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }
}

